/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements a standard plane vehicle movement

-------------------------------------------------------------------------
History:
- 30:05:2005: Created by Michael Rauh

*************************************************************************/
#ifndef __VEHICLEMOVEMENTSTDBOAT_H__
#define __VEHICLEMOVEMENTSTDBOAT_H__


#include "AIMovementCommon.h"
#include "VehicleMovementBase.h"

class CVehicleMovementStdBoat
  : public CVehicleMovementBase
{
public:

  CVehicleMovementStdBoat();
  virtual ~CVehicleMovementStdBoat();

  // IVehicleMovement
  virtual bool Init(IVehicle* pVehicle, const SmartScriptTable &table);
  virtual void Reset();
  virtual void Release();
	virtual void Physicalize();
  
	virtual bool SetParams(const SmartScriptTable &table);
	virtual bool SetSounds(const SmartScriptTable &table) { return true; }

	virtual void ProcessMovement(const float deltaTime);
	virtual bool RequestMovement(CMovementRequest& movementRequest);

	virtual void Serialize(TSerialize ser, unsigned aspects) {};
  // ~IVehicleMovement

protected:
  // driving
  float m_velMax;
  float m_accel;
  float m_accelCoeff;
  Vec3  m_pushOffset;
  float m_pushTilt;
  
  // steering
  float m_turnRateMax;
  float m_turnAccel;
  float m_turnAccelCoeff;  
  float m_cornerForceCoeff;
  Vec3  m_cornerOffset;
  float m_cornerTilt;
  float m_turnDamping;
  
  Vec3 m_Inertia;
  float m_gravity;
  Vec3 m_massOffset;

  //------------------------------------------------------------------------------
  // AI related
  // PID controller for speed control.  
  float	m_direction;
  SPID	m_dirPID;
  float	m_steering;
  float m_prevAngle;
};

#endif
