/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements movement type for tracked vehicles

-------------------------------------------------------------------------
History:
- 13:06:2005: Created by MichaelR

*************************************************************************/
#ifndef __VEHICLEMOVEMENTTANK_H__
#define __VEHICLEMOVEMENTTANK_H__

#include "VehicleMovementStdWheeled.h"

class CVehicleMovementTank
  :   public CVehicleMovementStdWheeled
{
public:

  CVehicleMovementTank();
  virtual ~CVehicleMovementTank();

  // overrides from StdWheeled
  virtual bool Init(IVehicle* pVehicle, const SmartScriptTable &table);  
  	
	virtual void ProcessMovement(const float deltaTime);
	virtual bool RequestMovement(CMovementRequest& movementRequest);
	
	virtual void Serialize(TSerialize ser, unsigned aspects) {};

  virtual void Update(const float deltaTime);
  virtual void StopEngine();
  virtual void UpdateSounds(const float deltaTime);
  // ~StdWheeled

protected:
  
  float GetEnginePedal(){ return m_currPedal; }

  float m_pedalSpeed;
  float m_pedalThreshold;
  float m_steerSpeed;
  float m_steerLimit;
  float m_minFriction;
  float m_maxFriction;
  float m_innerFrictionMod;
  float m_outerFrictionMod;
  float m_prevInnerFric, m_prevOuterFric;
  int m_numWheels;

  float m_currPedal;
  float m_currSteer;

  float m_trackUVMaxRate;
  int m_trackUVSlices;
  
  // AI specific
  float m_bWideSteerThreshold;
  
};

#endif
