/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements a vtol vehicle movement

-------------------------------------------------------------------------
History:
- 13:03:2006: Created by Mathieu Pinard

*************************************************************************/
#ifndef __VEHICLEMOVEMENTVTOL_H__
#define __VEHICLEMOVEMENTVTOL_H__

#include "VehicleMovementBase.h"
#include "AIMovementCommon.h"

class CVehicleMovementVTOL
	: public CVehicleMovementBase
{
public:

	CVehicleMovementVTOL() {}
	virtual ~CVehicleMovementVTOL() {}

	// IVehicleMovement
	virtual bool Init(IVehicle* pVehicle, const SmartScriptTable &table);
	virtual void Reset();
	virtual void Release();

	virtual bool StartEngine(EntityId driverId);
	virtual void StopEngine();

	virtual void OnEvent(EVehicleMovementEvent event, float value);
	virtual void OnAction(const char *actionName, int activationMode, float value);

	virtual void ProcessMovement(const float deltaTime);
	virtual void ProcessActions(const float deltaTime);
	virtual void ProcessAI(const float deltaTime);

	virtual void Update(const float deltaTime);

	virtual bool RequestMovement(CMovementRequest& movementRequest);

	virtual void Serialize(TSerialize ser, unsigned aspects) {}
	virtual void SetChannelId(uint16 id) {};
	virtual void SetAuthority(bool auth) { };
	// ~IVehicleMovement

	// CVehicleMovementBase
	virtual void OnEngineCompletelyStopped() {}
	// ~CVehicleMovementBase

	void UpdateSounds(const float deltaTime);

protected:

	void ResetActions();

	// movement settings (shouldn't be changed outside Init())
	float m_liftForce;
	float m_forwardForce;
	float m_strafeForce;
	float m_afterburnerForce;

	float m_pitchSpeed;
	float m_rollSpeed;
	float m_yawSpeed;

	float m_dampInertia;
	float m_dampRotation;

	// movement actions (to be modified by AI and player actions)
	float m_liftAction;
	float m_forwardAction;
	float m_strafeAction;
	float m_afterburnerAction;

	float m_pitchAction;
	float m_rollAction;
	float m_yawAction;

	// ai
	CMovementRequest m_aiRequest;

	// movement state (no one should touch these)
	bool m_isInVerticalMode;
	float m_pitchActionMul; // used only to inver mouse controls

	SPID m_powerPID;
};

#endif
