/*************************************************************************
	Crytek Source File.
	Copyright (C), Crytek Studios, 2001-2004.
	-------------------------------------------------------------------------
	$Id$
	$DateTime$

	-------------------------------------------------------------------------
	History:
	- 15:2:2006   12:50 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Weapon.h"
#include "Actor.h"


//------------------------------------------------------------------------
int CWeapon::NetGetCurrentFireMode() const
{
	return m_fmId;
}

//------------------------------------------------------------------------
void CWeapon::NetSetCurrentFireMode(int id)
{
	SetCurrentFireMode(id);
}

//------------------------------------------------------------------------
void CWeapon::NetShoot(const Vec3 &hit)
{
	if (m_fm)
		m_fm->NetShoot(hit);
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CWeapon, SvRequestShoot)
{
	bool ok=true;
	IActor *pClientActor = m_pGameFramework->GetIActorSystem()->GetActor(params.shooterId);
	if (!pClientActor || pClientActor->GetHealth()<=0)
		ok=false;

	if (ok)
		GetGameObject()->InvokeRMI(CWeapon::ClShoot(), params, eRMI_ToOtherClients, pClientActor->GetChannelId());

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CWeapon, ClShoot)
{
	NetShoot(params.hit);

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CWeapon, SvRequestFireMode)
{
	SetCurrentFireMode(params.id);

	return true;
}
