/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 9:12:2005   10:50 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Game.h"
#include "Weapon.h"
#include "Actor.h"


#include <IActorSystem.h>
#include <IAISystem.h>
#include <IAgent.h>

#define BROADCAST_WEAPON_EVENT(event, params)	\
	TEventListenerVector listeners(m_listeners); \
	for (TEventListenerVector::const_iterator it=listeners.begin(); it!=listeners.end(); ++it)	\
		(*it)->event params; \

//------------------------------------------------------------------------
void CWeapon::OnShoot(EntityId shooterId, EntityId ammoId, const char *ammoType, const Vec3 &pos, const Vec3 &dir, const Vec3&vel)
{
	BROADCAST_WEAPON_EVENT(OnShoot, (this, shooterId, ammoId, ammoType, pos, dir, vel));

	//FIXME:quick temporary solution
	IActor *pActor = g_pGame->GetIGameFramework()->GetIActorSystem()->GetActor(shooterId);
	if (pActor)
		pActor->HandleEvent(SGameObjectEvent("OnShoot",eGOEF_ToExtensions));

	if (m_pGameFramework->GetClientActor() && m_pGameFramework->GetClientActor()->GetEntityId() == shooterId)
	{
		m_pGameFramework->GetISystem()->GetAISystem()->SendSignal(SIGNALFILTER_LEADER, 1, "OnEnableFire",
			m_pGameFramework->GetClientActor()->GetEntity()->GetAI(), 0);
	}
}

//------------------------------------------------------------------------
void CWeapon::OnStartFire(EntityId shooterId)
{
	BROADCAST_WEAPON_EVENT(OnStartFire, (this, shooterId));
}

//------------------------------------------------------------------------
void CWeapon::OnStopFire(EntityId shooterId)
{
	BROADCAST_WEAPON_EVENT(OnStopFire, (this, shooterId));
}

//------------------------------------------------------------------------
void CWeapon::OnStartReload(EntityId shooterId, const char *ammoType)
{
	BROADCAST_WEAPON_EVENT(OnStartReload, (this, shooterId, ammoType));

	CActor *pActor = GetOwnerActor();
	if (pActor)
		GetISystem()->GetAISystem()->SendSignal( SIGNALFILTER_SENDER, 1, "OnReload", pActor->GetEntity()->GetAI());
}

//------------------------------------------------------------------------
void CWeapon::OnEndReload(EntityId shooterId, const char *ammoType)
{
	BROADCAST_WEAPON_EVENT(OnEndReload, (this, shooterId, ammoType));

	CActor *pActor = GetOwnerActor();
	if (pActor)
		GetISystem()->GetAISystem()->SendSignal( SIGNALFILTER_SENDER, 1, "OnReloadDone", pActor->GetEntity()->GetAI());
}

//------------------------------------------------------------------------
void CWeapon::OnOutOfAmmo(const char *ammoType)
{
	BROADCAST_WEAPON_EVENT(OnOutOfAmmo, (this, ammoType));
}

//------------------------------------------------------------------------
void CWeapon::OnReadyToFire()
{
	BROADCAST_WEAPON_EVENT(OnReadyToFire, (this));
}
