#!/usr/bin/env python

import sys, os, os.path

def list(path, out):
  l = os.listdir(path)
  l.sort()
  n = len(l)
  s = 0
  for name in l: s += len(name) + 1
  out.write('%i,%i\n' % (n, s))
  for name in l:
    if os.path.isdir(path + '/' + name):
      out.write(name + '/\n')
      list(path + '/' + name, out)
    else:
      out.write(name + '\n')

def main():
  list('.', sys.stdout)

if __name__ == '__main__': main()

