/***************************************************************************
 *
 *  CRI Middleware
 *
 *  Copyright (c) 2001-2007 CRI-MW
 *
 *  Library : ADX Library (CRI ADX for PC)
 *  Module  : Functions for PC
 *  File    : adx_pc.h
 *
 ***************************************************************************/
/* Prevention of redefinition */
#ifndef _ADXPC_H_INCLUDED
#define _ADXPC_H_INCLUDED

/***************************************************************************
 *       o[W
 *       Version
 ***************************************************************************/
#define ADXPC_VER					"1.46"

/***************************************************************************
 *      CN[ht@C
 *      Include file
 ***************************************************************************/

/* Disable VC++ warning 
 *   In some cases, including windows.h, dsound.h causes the following warning:
 *       rpcasync.h(45) : warning C4115: '_RPC_ASYNC_STATE' : ...
 */
#if defined(_MSC_VER) && ((_MSC_VER >= 1200) && (_MSC_VER < 1300))
	#pragma warning(disable : 4115)
#endif

#include <windows.h>
#include <dsound.h>
#include "cri_xpt.h"
#include "cri_adxt.h"

/***************************************************************************
 *      萔}N
 *      MACRO CONSTANT
 ***************************************************************************/
/* ftHgvCIeB */
/* Default thread priority */
#define ADXM_PRIO_VSYNC				(THREAD_PRIORITY_HIGHEST)		/* VsyncXbh */
#define ADXM_PRIO_FS				(THREAD_PRIORITY_ABOVE_NORMAL)	/* t@CXbh */
#define ADXM_PRIO_MWIDLE			(THREAD_PRIORITY_IDLE)			/* AChXbh */

/* X^bNTCY */
/* Thread stack size */
#define	ADXM_STACK_SIZE_VSYNC		(1024 * 1024)
#define	ADXM_STACK_SIZE_FS			(1024 * 1024)
#define	ADXM_STACK_SIZE_MWIDLE		(1024 * 1024)

/* fBNgT[h		*/
/* Mode of directory look-up	*/
#define ADXFIC_MODE_ALLDIR			(-1)
#define ADXFIC_MODE_CURRENT			(0)

/* ADXFICnhXe[^X	 */
/* Status of ADXFIC handle */
#define ADXFIC_STAT_STOP			(0)
#define ADXFIC_STAT_CACHING			(1)
#define ADXFIC_STAT_CACHEEND		(2)
#define ADXFIC_STAT_ERROR			(3)

/* ftHggx100					*/
/* Default of virtual vsync frequency x100	*/
#define ADXPC_DEF_VHZ100			(6000)

/***************************************************************************
 *      }N
 *      MACRO FUNCTIONS
 ***************************************************************************/
/* [N̈őTCYvZ}N */
/* Macro that calculates maximum work area size */
#define ADXFIC_CALC_WORK_SIZE(nfiles, max_flen) \
	((nfiles + 1) * (16 + maxflen) + 32)

/***************************************************************************
 *      f[^^錾
 *      Data type declaration
 ***************************************************************************/
/*--------------------------------------------------------------------------
 * t[[NʁiPCj
 * Type of framework
 *-------------------------------------------------------------------------*/
typedef enum {
	ADXM_FRAMEWORK_DEFAULT			= 0,
	ADXM_FRAMEWORK_PC_SINGLE_THREAD	= 1,
	ADXM_FRAMEWORK_PC_MULTI_THREAD	= 2,
} AdxmFramework;

/*--------------------------------------------------------------------------
 * XbhZbgAbvp[^iPCj
 * Thread setup parameter for PC
 *-------------------------------------------------------------------------*/
typedef struct {
	/* vCIeB */
	Sint32			priority_vsync;		/* VsyncXbh */
	Sint32 			priority_fs;		/* t@CXbh */
	Sint32 			priority_mwidle;	/* AChXbh */
} AdxmThreadSprm;

/* Xbh̃ZbgAbvsۂ̒ӓ_									*/
/* (a) ZbgAbvp[^́At[[NƂ						*/
/* @@ADXM_FRAMEWORK_Pc_MULTI_THREADI񂾏ꍇ̂ݗLłB				*/
/* (b) ZbgAbvp[^́AADXM_SetupFramework֐Ɉprm			*/
/* @@ēn܂BNULLw肷ƃftHgݒ肪gp܂B			*/
/* Notes when setup of thread												*/
/* (a) If you need to apply custom framework setting, set the setup			*/
/*     parameter to ADXM_SetupFramework function as argument "prm".			*/
/*     When NULL is passed, the default setting is used.	 				*/
/* (b) The setup parameter is effective only when you chose 				*/
/*     ADXM_FRAMEWORK_PC_MULTI_THREAD as framework.							*/

/*--------------------------------------------------------------------------
 * t@CVXẽZbgAbvp[^\
 * Parameter structure for file system setup function
 *-------------------------------------------------------------------------*/
typedef struct {
	Char8	*rtdir;				/* [gfBNg	*/
								/* Root directory		*/
} AdxpcSprmFs;

/*--------------------------------------------------------------------------
 * t@CLbVnhiADXFICnhj
 * File information cache handle (ADXFIC handle)
 *-------------------------------------------------------------------------*/
typedef void *ADXFIC;

/*--------------------------------------------------------------------------
 * obt@쐬̔zuʒu
 * n[hEFAANZ[V̗LɊ֌W
 * Locate mode of the DirectSoundBuffer
 * Influences the use of hardware acceleration
 *-------------------------------------------------------------------------*/
typedef enum {
	ADXPC_LOCMODE_SOFTWAREONLY = 0x00,	
		/* Softwareobt@^~LVÔݎgpiftHgj	*/
		/* Only software buffer/mixing will be used(Default)	*/
	ADXPC_LOCMODE_HARDWAREONLY = 0x01,
		/* Hardwareobt@^~LVÔݎgp					*/
		/* Only hardware buffer/mixing will be used				*/
	ADXPC_LOCMODE_HARDWARE = 0x02,
		/* \ȂHardwaregp								*/
		/* Hardware buffer/mixing will be used if available		*/
	ADXPC_LOCMODE_DEFER = 0x03,
		/* obt@mۂĐ܂ŒxA\ȂHardwaregp	*/
		/* The buffer can be assigned to a hardware or software	*/
		/* resource at play time								*/
} ADXPC_LOCMODE;

/*--------------------------------------------------------------------------
 * VVXepIuWFNg̎
 * Kind of the object for Vsync system
 *-------------------------------------------------------------------------*/
typedef enum {
	ADXPC_VIDEO_NONE = 0x00,
	ADXPC_VIDEO_DDRAW7 = 0x01,		// DirectDraw7
	ADXPC_VIDEO_D3D8 = 0x02,		// Direct3D8
} ADXPC_VIDEO;

/***************************************************************************
 *      ϐ錾
 *      Prototype Function 
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Function 
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

/***
*			t[[Nݒ֐
*			Framework setting function
***/

/* CRI~hEFÃt[[NZbgAbv */
/* Setup the framework */
Bool CRIAPI ADXM_SetupFramework(AdxmFramework framework, void *prm);

/* CRI~hEFÃt[[N̏I */
/* Shutdown the framework */
Bool CRIAPI ADXM_ShutdownFramework(void);

/***
 *          Xbh֌W
 *          Thread
 ***/
 
/* ADXT[o֐(Xbhp)							*/
/* ADX server function(for using ADX without thread)	*/
void CRIAPI ADXPC_ExecServer(void);

/* ADXT[o֐(Xbhp)						*/
/* ADX server function(for using ADX with thread)	*/
Bool CRIAPI ADXPC_ExecServerEx(void *obj);

/***
 *          t@C֌W
 *          File proseccing
 ***/

/* t@CVXẽZbgAbv	*/
/* Set up the file system			*/
void CRIAPI ADXPC_SetupFileSystem(AdxpcSprmFs *sprmd);

/* t@CVXẽVbg_E	*/
/* Shut down the file system		*/
void CRIAPI ADXPC_ShutdownFileSystem(void);

/***
 *          TEh֌W
 *          Sound
 ***/

/* TEh̃ZbgAbv	*/
/* Set up the sound	system	*/
void CRIAPI ADXPC_SetupSound(LPDIRECTSOUND8 ds);

/* TEh̃Vbg_E		*/
/* Shut down the sound system	*/
void CRIAPI ADXPC_ShutdownSound(void);

/* DirectSoundBuffer8IuWFNg̎擾	*/
/* Get the DirectSoundBuffer8 object	*/
LPDIRECTSOUNDBUFFER8 CRIAPI ADXPC_GetDirectSoundBuffer8(ADXT adxt);

/* XeIo̓XCb`̐ݒ */
/* Enable force stereo output mode */
void CRIAPI ADXPC_SetOutputStereo(Bool flag);

/* DirectSoundBuffer̔zuʒu̐ݒ			*/
/* Set the locate mode of the DirectSoundBuffer	*/
void CRIAPI ADXPC_SetDsbCapsLocMode(Sint32 loc_mode);

/* DirectSoundBuffer̔zuʒu̎擾			*/
/* Get the locate mode of the DirectSoundBuffer	*/
Sint32 CRIAPI ADXPC_GetDsbCapsLocMode(void);

/* O[otH[JXDirectSoundBuffer쐬邩ǂݒ	*/
/* Set the DirectSoundBuffer to have global focus						*/
void CRIAPI ADXPC_SetDsbCapsGlobalFocus(Bool flag);

/* O[otH[JXDirectSoundBuffer쐬邩ǂ擾	*/
/* Get whether the DirectSoundBuffer is having global focus				*/
Bool CRIAPI ADXPC_GetDsbCapsGlobalFocus(void);

/* 3DRg[@\DirectSoundBuffer쐬邩ǂݒ	*/
/* Set the DirectSoundBuffer to support 3D control						*/
void CRIAPI ADXPC_SetDsbCapsCtrl3D(Bool flag);

/* 3DRg[@\DirectSoundBuffer쐬邩ǂ擾	*/
/* Get whether the DirectSoundBuffer is supporting 3D control			*/
Bool CRIAPI ADXPC_GetDsbCapsCtrl3D(void);

/* GtFNg@\DirectSoundBuffer쐬邩ǂݒ		*/
/* Set the DirectSoundBuffer to support effects processing				*/
void CRIAPI ADXPC_SetDsbCapsCtrlFx(Bool flag);

/* GtFNg@\DirectSoundBuffer쐬邩ǂ擾		*/
/* Get whether the DirectSoundBuffer is supporting effects processing	*/
Bool CRIAPI ADXPC_GetDsbCapsCtrlFx(void);

/* GtFNgݒ肷			*/
/* Enable effects on a buffer	*/
Bool CRIAPI ADXPC_SetDsFx(
	ADXT adxt, Sint32 count, LPDSEFFECTDESC effect, Uint32 *result);

/***
 *          V֌W
 *          V-Sync system
 ***/

/* VVXeZbgAbv	*/
/* Set up the V-Sync system		*/
Sint32 CRIAPI ADXPC_SetupVsync(void *video_obj, Sint32 mode);

/* VVXeVbg_E	*/
/* Shut down the V-Sync system		*/
Bool CRIAPI ADXPC_ShutdownVsync(void);

/* VVXeĐݒ	*/
/* Reset the V-Sync system	*/
Sint32 CRIAPI ADXPC_ResetVsync(void);

/* ADXT[o[VBlankǂꂾ炷ݒ	*/
/* Set ADX server offset from VBlank				*/
void CRIAPI ADXPC_SetSvrOffset(Sint32 offset_msec);

/* zVg̐ݒi1/100HzPʁA60HzȂ6000j				*/
/* Set virtual Vsync frequency	(in unit of 1/100Hz, 60Hz=6000)	*/
void CRIAPI ADXPC_SetVirtualVhz(Uint32 vhz100);

/* zVg̎擾			*/
/* Get virtual Vsync frequency	*/
Uint32 CRIAPI ADXPC_GetVirtualVhz(void);

/* Present^C~O̒ʒm */
void CRIAPI ADXPC_NotifyPresentTiming(void);

/* Present^C~O}[W̐ݒ [%] */
void CRIAPI ADXPC_SetPresentTimingMargin(Sint32 margin);

/***
 *          t@CLbVOp֐
 *          Functions for file information cache
 ***/

/* FIC̏	*/
/* Initialize FIC	*/
void CRIAPI ADXFIC_Init(void);

/* I		*/
/* Finish FIC	*/
void CRIAPI ADXFIC_Finish(void);

/* Ɨ̈TCY̎擾		*/
/* Get size of work area	*/
Sint32 CRIAPI ADXFIC_GetWorkSize(const Char8 *dname, Sint32 mode);

/* ADXFICnh̍쐬	*/
/* Create ADXFIC handle	*/
ADXFIC CRIAPI ADXFIC_Create(const Char8 *dname, Sint32 mode, void *work, Sint32 wksize);

/* ADXFICnh̏		*/
/* Destroy ADXFIC handle	*/
void CRIAPI ADXFIC_Destroy(ADXFIC fic);

/* LbVOꂽt@C̎擾	*/
/* Get number of cached files			*/
Sint32 CRIAPI ADXFIC_GetNumFiles(ADXFIC fic);

/* pĂƗ̈TCY̎擾	*/
/* Get size of used work area			*/
Sint32 CRIAPI ADXFIC_GetUsedWkSize(ADXFIC fic);

/* t@CTsfBNg̎擾 */
/* Get directory name for look-up			*/
Char8 * CRIAPI ADXFIC_GetDirName(ADXFIC fic);

/* LbVOꂽt@C̃TCY擾iZN^Pʁj	*/
/* Get size of cached file (sector)							*/
Sint32 CRIAPI ADXFIC_GetFsizeSct(ADXFIC fic, const Char8 *fname);

/* LbVOꂽt@C̃TCY擾ioCgPʁj	*/
/* Get size of cached file (Byte)							*/
Sint64 CRIAPI ADXFIC_GetFileSize(ADXFIC fic, const Char8 *fname);

/* t@CLbVĂ邩ǂ̃`FbN */
/* Check whether the file is cached					*/
Bool CRIAPI ADXFIC_IsFileCached(const Char8 *fname);

/* wt@C̃LbV		*/
/* Disable caching of specified file	*/
void CRIAPI ADXFIC_DisableFile(ADXFIC fic, const Char8 *fname);

/* wt@C̃LbVL		*/
/* Enable chaching of specified file	*/
void CRIAPI ADXFIC_EnableFile(ADXFIC fic, const Char8 *fname);

/* Xe[^X̎擾	*/
/* Get state		*/
Sint32 CRIAPI ADXFIC_GetStat(ADXFIC fic);


/***
 *          ̑
 *          Others
 ***/

/* o[W̎擾	*/
/* Get version string		*/
Char8 * CRIAPI ADXPC_GetVersion(void);


/***
 *          fobOp
 *          For debugging
 ***/

#ifdef _DEBUG

/* t@C̃fobOo	*/
/* Print cached file names	*/
void CRIAPI ADXFIC_DebugPrintFlist(ADXFIC fic);

/* SẴt@C̃fobOo */
/* Print all cached file names	*/
void CRIAPI ADXFIC_DebugPrintFlistAll(void);

#endif	// #ifdef _DEBUG


#ifdef __cplusplus
}
#endif	// __cplusplus

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
#define ADXPC_SetupThrd(tprm)			ADXM_SetupThrd(tprm)
#define ADXPC_SetupThread(tprm)			ADXM_SetupThrd(tprm)
#define ADXPC_ShutdownThread()			ADXM_ShutdownThrd()
#define ADXPC_Setup3DSound()			ADXPC_SetDsbCapsCtrl3D(TRUE)
#define ADXPC_Shutdown3DSound()			ADXPC_SetDsbCapsCtrl3D(FALSE)
#define ADXPC_GetDsb(adxt, dsb)	\
	(*dsb) = (void *)ADXPC_GetDirectSoundBuffer8(adxt);
#define ADXPC_GetDirectSoundBuffer(adxt, dsb)	\
	(*dsb) = (void *)ADXPC_GetDirectSoundBuffer8(adxt);
#define ADXPC_SetSndBufGlobalFocus(mode)	\
	ADXPC_SetDsbCapsFocusMode(mode)
#define ADXPC_GetSndBufGlobalFocus()	ADXPC_GetDsbCapsFocusMode()
#define ADXPC_SetLocMode(mode)			ADXPC_SetDsbCapsLocMode(mode)
#define ADXPC_GetLocMode()				ADXPC_GetDsbCapsLocMode()
#define ADXPC_SPRM_DVD					AdxpcSprmFs
#define ADXPC_SPRM_WINFS				AdxpcSprmFs
#define ADXPC_SPRM_ANSI					AdxpcSprmFs
#define ADXPC_SetupWinFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_SetupDvdFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_SPRM_WINFS				AdxpcSprmFs
#define ADXPC_SPRM_DVD					AdxpcSprmFs
#define ADXPC_SPRM_ANSI					AdxpcSprmFs
#define ADXPC_SetupWinFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_SetupDvdFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_SetupAnsiFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_ShutdownWinFs()			ADXPC_ShutdownFileSystem()
#define ADXPC_ShutdownDvdFs()			ADXPC_ShutdownFileSystem()
#define ADXPC_ShutdownAnsiFs()			ADXPC_ShutdownFileSystem()
#define ADXPC_SPEAKER_FRONT_LEFT		ADXT_SPEAKER_FRONT_LEFT
#define ADXPC_SPEAKER_FRONT_RIGHT		ADXT_SPEAKER_FRONT_RIGHT
#define ADXPC_SPEAKER_FRONT_CENTER		ADXT_SPEAKER_FRONT_CENTER
#define ADXPC_SPEAKER_LOW_FREQUENCY		ADXT_SPEAKER_LOW_FREQUENCY
#define ADXPC_SPEAKER_BACK_LEFT 		ADXT_SPEAKER_BACK_LEFT
#define ADXPC_SPEAKER_BACK_RIGHT		ADXT_SPEAKER_BACK_RIGHT
#define ADXPC_GetSendSpeakerLevel		ADXT_GetSendSpeakerLevel
#define ADXPC_SetSendSpeakerLevel		ADXT_SetSendSpeakerLevel

#endif	// #ifndef _ADXPC_H_INCLUDED

/* end of file */
