#ifndef	_CRI_ADXF_H_INCLUDED
#define	_CRI_ADXF_H_INCLUDED
/****************************************************************************/
/*																			*/
/*			$title$ `cwt@CVXe Cu						*/
/*				ADXF (ADX File System) Library								*/
/*																			*/
/*				1998.7.3		written by S.Hosaka							*/
/*																			*/
/****************************************************************************/

/****************************************************************************/
/*      CN[ht@C												*/
/*      Include file														*/
/****************************************************************************/

#include "cri_xpt.h"
#include "sj.h"

/****************************************************************************/
/*		萔}N															*/
/*		MACRO CONSTANT														*/
/****************************************************************************/

/*	Version number of ADX File System	*/
#define	ADXF_VER				"7.65"

/*	t@C̕				*/
/*	Maximum number of file name strings	*/
#define ADXF_FNAME_MAX    		(256)

/*	őp[eBV				*/
/*	Maximum number of partition			*/
#define	ADXF_PART_MAX			(256)

/*	őt@C						*/
/*	Maximum number of file				*/
#define	ADXF_FILE_MAX			(65536)

/*	ADXFnhIuWFNǧ		*/
/*	Maximum number of ADXF handle		*/
#define	ADXF_OBJ_MAX			(16)

/*	nh̏						*/
/*	Status of handle					*/
#define	ADXF_STAT_STOP			(1)			/*	~						*/
											/*	During standstill			*/
#define ADXF_STAT_READING		(2)			/*	f[^ǂݍݒ			*/
											/*	During data read-in			*/
#define ADXF_STAT_READEND		(3)			/*	f[^ǂݍݏI			*/
											/*	Data read-in end			*/
#define ADXF_STAT_ERROR			(4)			/*	ǂݍ݃G[			*/
											/*	Read-in error outbreak state*/

/*	V[N^Cv						*/
/*	Type of seek						*/
#define	ADXF_SEEK_SET			(0)			/*	t@C̐擪				*/
											/*	The beginning of file		*/
#define ADXF_SEEK_CUR			(1)			/*	݂̈ʒu					*/
											/*	The current position		*/
#define ADXF_SEEK_END			(2)			/*	t@C̏I[				*/
											/*	The end of file				*/

/*	G[R[h						*/
/*	Error code							*/
#define	ADXF_ERR_OK				(0)			/*	I					*/
											/*	Successful					*/
#define	ADXF_ERR_FATAL			(-1)		/*	ÕG[				*/
											/*	Fatal error					*/
#define	ADXF_ERR_INTERNAL		(-2)		/*	̃G[				*/
											/*	Internal error				*/
#define	ADXF_ERR_PRM			(-3)		/*	sȃp[^			*/
											/*	Illegal parameter			*/
#define	ADXF_ERR_AFS_FILE		(-4)		/*	sAFSt@C			*/
											/*	Illegal AFS file			*/
#define ADXF_ERR_FSIZE			(-5)		/*	t@CTCY擾		*/
											/*	Cannot get file size yet	*/

/*	l								*/
/*	Default value						*/
#define	ADXF_DEF_SCT_SIZE		(2048)		/*	CD-ROM̃ZN^TCY		*/
											/*	Sector size in CD-ROM		*/
#ifdef __EE__
#define	ADXF_DEF_DMA_ALIGN		(64)		/*	DMÃACg			*/
											/*	Alignment of DMA transfer	*/
#else
#define	ADXF_DEF_DMA_ALIGN		(32)		/*	DMÃACg			*/
											/*	Alignment of DMA transfer	*/
#endif

#define	ADXF_DEF_REQ_RD_SCT		(512)		/*	[hNGXgTCY		*/
											/*	read request size			*/

/*	fobOp	*/
/*	for Debug	*/
//#define	ADXF_CMD_HSTRY_MAX		(256)		/*	R}ȟ			*/
#define	ADXF_CMD_HSTRY_MAX		(16)		/*	R}ȟ			*/
											/*	Number of command history	*/

#define	ADXF_CMD_OPEN			(1)			/*	ADXF_Open					*/
#define	ADXF_CMD_OPEN_AFS		(2)			/*	ADXF_OpenAfs				*/
#define	ADXF_CMD_CLOSE			(3)			/*	ADXF_Close					*/
#define	ADXF_CMD_READ_NW32		(4)			/*	ADXF_ReadNw32				*/
#define	ADXF_CMD_STOP			(5)			/*	ADXF_Stop					*/
#define	ADXF_CMD_SEEK			(6)			/*	ADXF_Seek					*/
#define	ADXF_CMD_STOP_NW		(7)			/*	ADXF_StopNw					*/

#define	ADXF_CMD_NUM_MAX		(16)

#define	ADXF_FMG_TYPE_SHORT		(0)
#define	ADXF_FMG_TYPE_LONG		(1)

/* o[WƂ̌݊p */
/* For compatibility with old version */
#define ADXF_GetPtStatEx		ADXF_GetPtStat
/****************************************************************************/
/*		񋓒萔															*/
/*		Enumarate Constants													*/
/****************************************************************************/

/****************************************************************************/
/*		}N															*/
/*		Process MACRO														*/
/****************************************************************************/

/*	p[eBVɕKvȗ̈̌vZ						*/
/*	Calculation of necessary area for partition information		*/
//	"6"́Aadxf_ptinfõo[(adxf_ptinfo+size+nfile+nentry+type+rev+curdir+ofst)
#define	ADXF_PTIF_CMN_SZ				((6*sizeof(Sint32))+(ADXF_FNAME_MAX*sizeof(Sint8)))
//	ۂ̃t@CǗ̈TCY
#define	ADXF_CALC_PTINFO_REAL_SIZE(n)	(ADXF_PTIF_CMN_SZ+(((n)+1)*sizeof(Sint16)))
//	SoCgACgɒ
#define	ADXF_CALC_PTINFO_SIZE(n)		((ADXF_CALC_PTINFO_REAL_SIZE(n)+sizeof(Sint16))/4*4)

//	t@CǗ̈TCYύX(Pt@CQoCgSoCg)
//	R̈TCY͋
//	ۂ̃t@CǗ̈TCY
#define	ADXF_CALC_PTINFO_FMGL_REAL_SIZE(n)	(ADXF_PTIF_CMN_SZ+(((n)+1)*sizeof(Sint32)))
//	SoCgACgɒ
#define	ADXF_CALC_PTINFO_FMGL_SIZE(n)		((ADXF_CALC_PTINFO_FMGL_REAL_SIZE(n)+sizeof(Sint32))/4*4)

#define	ADXF_CALC_ADD_PTINFO_SIZE(n)	(ADXF_PTIF_CMN_SZ+((n)*(2*sizeof(Sint16)+sizeof(Sint32))))

/*	[hp[eBVpe|obt@̃TCYvZ	*/
/*	Calculation of temporary buffer size for load-partition	*/
#define	ADXF_CALC_TMPBUF_SIZE(n)	((((n+1)*8)+(ADXF_DEF_SCT_SIZE-1))/ADXF_DEF_SCT_SIZE*ADXF_DEF_SCT_SIZE)


/****************************************************************************/
/*		f[^^															*/
/*      Data type declaration												*/
/****************************************************************************/

#ifndef ADXSTM_DEFINED
#define ADXSTM_DEFINED
typedef void *ADXSTM;
#endif

/*	ADXFnh		*/
/*	ADXF handle			*/
#ifndef ADXF_DEFINED
#define	ADXF_DEFINED
typedef	struct _adx_fs {
	Sint8	used;					/*	gpۂ						*/
	Sint8	stat;					/*	nh̏						*/
	Sint8	sjflag;					/*	Oݒ肳ꂽSJۂ			*/
	Sint8	stopnw_flg;				/*	~vtO						*/
	ADXSTM	stm;					/*	ADXSTMnh						*/
	SJ		sj;						/*	Xg[WCg				*/
	Sint32	fnsct;					/*	t@CTCY(ZN^)				*/
	Sint32	skpos;					/*	ANZX|C^̈ʒu				*/
	Sint32	rdstpos;				/*	ǂݍ݊Jnʒu					*/
	Sint32	rqsct;					/*	ǂݍݗvf[^(ZN^)		*/
	Sint32	rdsct;					/*	ǂݍ񂾃f[^(ZN^)			*/
	Sint8	*buf;					/*	obt@̃AhX(oCg)			*/
	Sint32	bsize;					/*	obt@̃TCY(oCg)			*/
	Sint32	rqrdsct;				/*	ۂɓǂݍݗv(ZN^)	*/
	/*	ADXSTM_OpenRange -> ADXSTM_OpenFileRange(1999.8.19)	*/
	Sint32	ofst;					/*	ǂݍ݃t@Cւ̃ItZbg		*/
	void	*dir;
} ADX_FS;
typedef	ADX_FS	*ADXF;
#endif

/*	p[eBV		*/
/*	Partition information	*/
#ifndef ADXF_PTINFO_DEFINED
#define ADXF_PTINFO_DEFINED
typedef struct _adxf_ptinfo {
	struct _adxf_ptinfo	*next;		/*	̃p[eBV(NULL:IWi)	*/
	Sint32				size;		/*	p[eBV̈TCY		*/
	Sint32				nfile;		/*	p[eBṼt@C		*/
	Uint16				nentry;		/*	p[eBV̓o^t@C	*/
	Sint8				type;		/*	IWiǋL̃tO			*/
//	2002.11.05	S.H.	t@CǗ̈TCYSoCgΉ
//	Sint8				rev;		/*	\̈							*/
	Sint8				fmg_type;	/*	t@CǗTCY(0=2byte,1=4byte)	*/
	/*	ADXSTM_OpenRange -> ADXSTM_OpenFileRange(1999.8.19)	*/
	Sint8				fname[ADXF_FNAME_MAX];	/*	AFSt@C			*/
	void				*curdir;	/*	JgfBNg(NULL:wȂ)	*/
	Sint32				ofst;		/*	qAFSt@Cp					*/
	Sint32				top;		/*	t@C̐擪					*/
} ADXF_PTINFO;
#endif

/*	ǋLt@C̏				*/
/*	Information of postscript file	*/
#ifndef ADXF_ADD_DEFINED
#define ADXF_ADD_DEFINED
typedef struct _adxf_add_info {
	Uint16	flid;			/*	t@CID							*/
	Uint16	fnsct;			/*	t@CTCY						*/
	Sint32	ofst;			/*	ItZbg							*/
} ADXF_ADD_INFO;
#endif

#ifndef ADXF_CMD_HSTRY_DEFINED
#define ADXF_CMD_HSTRY_DEFINED
typedef struct _adxf_cmd_hstry {
	Uint8	cmdid;			/*	R}h(֐)ID					*/
	Uint8	fg;				/*	֐̓otO	*/
	Uint16	ncall;			/*	R}ȟĂяo				*/
	Sint32	prm[3];					/*	R}hp[^					*/
} ADXF_CMD_HSTRY;
#endif

/****************************************************************************/
/*		ϐ錾															*/
/*		Variable Declaration												*/
/****************************************************************************/

/****************************************************************************/
/*		֐̐錾															*/
/*      Function Declaration												*/
/****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*==========================================================================
		CȕƏI
 		Initialize and Finalize of Library
  ==========================================================================*/

/*  Cȕ
 * [@] void ADXF_Init( void );
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] CuB
 *  Initialization of library
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Initializes library.
 */
void CRIAPI ADXF_Init(void);

/* CȕI
 * [@] void ADXF_Finish(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] CȕIB
 *  Termination of library
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Finalizes library.
 */
void CRIAPI ADXF_Finish(void);

/*  A^p[eBṼ[h
 * [@] Sint32 ADXF_LoadPartitionNw(Sint32 ptid, const Char8 *fname, 
 * 													void *dir, void *ptinfo);
 * [@] ptid	:p[eBVID
 *			fname	:AFSt@C̖O
 *			dir		:fBNg (GDFS:GDFS_DIRREC)
 *			ptinfo	:p[eBVǂݍݗ̈
 * [o@] Ȃ
 * [֐l] G[R[h
 * [@@\] AFSt@CǂݍŁAp[eBVIDɐݒ肷B
 *  Load of the partition(No wait)
 * [Inputs  ] ptid   :Partition ID
 *			  fname  :Name of AFS file
 *            dir	 :Directory information (GDFS:GDFS_DIRREC)
 *            ptinfo :Area of partition information
 * [Outputs ] None
 * [Return  ] Error code
 * [Function] Loads AFS file and sets partition ID.
 */
Sint32 CRIAPI ADXF_LoadPartitionNw(Sint32 ptid, const Char8 *fname, void *dir, void *ptinfo);
Sint32 CRIAPI ADXF_LoadPartitionFmgLongNw(Sint32 ptid, const Char8 *fname, void *dir, void *ptinfo);

/*  A^p[eBṼ[hi͈͎wj
 * [@] Sint32 ADXF_LoadPartitionRangeNw(Sint32 ptid, const Char8 *fname, void *dir,
 * 				Sint32 offset_sct, Sint32 range_sct, void *ptinfo);
 * [@] ptid		:p[eBVID
 *			fname		:AFSt@C̖O
 *			dir			:fBNg (GDFS:GDFS_DIRREC)
 *			offset_sct	: t@C̃ItZbgiZN^Pʁj
 *			range_sct	: ͈́iZN^Pʁj
 *			ptinfo		:p[eBVǂݍݗ̈
 * [o@] Ȃ
 * [֐l] G[R[h
 * [@@\] AFSt@CǂݍŁAp[eBVIDɐݒ肷B
 *  Load of the partition(No wait)
 * [Inputs  ] ptid   :Partition ID
 *			  fname  :Name of AFS file
 *            dir	 :Directory information (GDFS:GDFS_DIRREC)
 *            ptinfo :Area of partition information
 * [Outputs ] None
 * [Return  ] Error code
 * [Function] Loads AFS file and sets partition ID.
 */
Sint32 CRIAPI ADXF_LoadPartitionRangeNw(Sint32 ptid, const Char8 *fname, void *dir, Sint32 offset_sct, Sint32 range_sct, void *ptinfo);

/*  A^p[eBṼ[h(qAFSt@C)
 * [@] Sint32 ADXF_LoadPartitionFromPtNw(Sint32 set_ptid, Sint32 rd_ptid, 
 *											Sint32 rd_flid, void *ptinfo);
 * [@] set_ptid	:[hAFSt@Cɑ΂Đݒ肷p[eBVID
 *			rd_ptid		:ǂݍAFSt@C̃p[eBVID
 *			rd_flid		:ǂݍAFSt@C̃t@CID
 *			ptinfo		:p[eBVǂݍݗ̈
 * [o@] Ȃ
 * [֐l] G[R[h
 * [@@\] AFSt@CAFSt@CǂݍŁAp[eBVIDɐݒ肷B
 *  Load of the partition(No wait)(nested AFS file)
 * [Inputs  ] set_ptid   :Partition ID for loading and setting
 *			  rd_ptid 	 :Partition ID reading AFS file
 *            rd_flid	 :File ID reading AFS file
 *            ptinfo :Area of partition information
 * [Outputs ] None
 * [Return  ] Error code
 * [Function] Loads AFS file in AFS file and sets partition ID.
 */
Sint32 CRIAPI ADXF_LoadPartitionFromAfsNw(Sint32 set_ptid, Sint32 rd_ptid, Sint32 rd_flid, void *ptinfo);
Sint32 CRIAPI ADXF_LoadPartitionFromAfsFmgLongNw(Sint32 set_ptid, Sint32 rd_ptid, Sint32 rd_flid, void *ptinfo);

/*  A^p[eBṼ[h(ǂݍ݃obt@w肷)
 * [@] Sint32 ADXF_LoadPtNwEx(Sint32 ptid, const Char8 *fname, void *dir, void *ptinfo, 
 *									void *tmpbuf, Sint32 tbsize);
 * [@] ptid	:p[eBVID
 *			fname	:AFSt@C̖O
 *			dir		:fBNg (GDFS:GDFS_DIRREC)
 *			ptinfo	:p[eBVǂݍݗ̈
 *			tmpbuf	:AFSt@Cwb_ǂݍ݃obt@
 *			tbsize	:AFSt@Cwb_ǂݍ݃obt@TCY
 * [o@] Ȃ
 * [֐l] G[R[h
 * [@@\] AFSt@CǂݍŁAp[eBVIDɐݒ肷B
 *  Load of the partition(No wait)(specify reading buffer)
 * [Inputs  ] ptid		:Partition ID
 *			  fname		:Name of AFS file
 *            dir	 	:Directory information (GDFS:GDFS_DIRREC)
 *            ptinfo	:Area of partition information
 *			  tmpbuf	:Buffer reading AFS file
 *			  tbsize	:Size of buffer reading AFS file
 * [Outputs ] None
 * [Return  ] Error code
 * [Function] Loads AFS file and sets partition ID.
 */
Sint32 CRIAPI ADXF_LoadPtNwEx(Sint32 ptid, const Char8 *fname, void *dir, void *ptinfo, 
						void *tmpbuf, Sint32 tbsize);
Sint32 CRIAPI ADXF_LoadPtFmgLongNwEx(Sint32 ptid, const Char8 *fname, void *dir, 
						void *ptinfo, void *tmpbuf, Sint32 tbsize);

/*  A^p[eBṼ[h(qAFSt@C)(ǂݍ݃obt@w肷ꍇ)
 * [@] Sint32 ADXF_LoadPtFromPtNwEx(Sint32 set_ptid, Sint32 rd_ptid, Sint32 rd_flid, 
 *										void *ptinfo, void *tmpbuf, Sint32 tbsize);
 * [@] set_ptid	:[hAFSt@Cɑ΂Đݒ肷p[eBVID
 *			rd_ptid		:ǂݍAFSt@C̃p[eBVID
 *			rd_flid		:ǂݍAFSt@C̃t@CID
 *			ptinfo		:p[eBVǂݍݗ̈
 *			tmpbuf		:AFSt@Cwb_ǂݍ݃obt@
 *			tbsize		:AFSt@Cwb_ǂݍ݃obt@TCY
 * [o@] Ȃ
 * [֐l] G[R[h
 * [@@\] AFSt@CǂݍŁAp[eBVIDɐݒ肷B
 *  Load of the partition(No wait)(nested AFS file)(specify reading buffer)
 * [Inputs  ] set_ptid	:Partition ID for loading and setting
 *			  rd_ptid	:Partition ID reading AFS file
 *            rd_flid	:File ID reading AFS file
 *            ptinfo	:Area of partition information
 *			  tmpbuf	:Buffer reading AFS file
 *			  tbsize	:Size of buffer reading AFS file
 * [Outputs ] None
 * [Return  ] Error code
 * [Function] Loads AFS file and sets partition ID.
 */
Sint32 CRIAPI ADXF_LoadPtFromAfsNwEx(Sint32 set_ptid, Sint32 rd_ptid, Sint32 rd_flid, 
						void *ptinfo, void *tmpbuf, Sint32 tbsize);
Sint32 CRIAPI ADXF_LoadPtFromAfsFmgLongNwEx(Sint32 set_ptid, Sint32 rd_ptid, Sint32 rd_flid, 
						void *ptinfo, void *tmpbuf, Sint32 tbsize);

/*  p[eBV̓ǂݍݏԂ̎擾
 * [@] Sint32 ADXF_GetPtStat(Sint32 ptid);
 * [@] ptid	:p[eBVID
 * [o@] Ȃ
 * [֐l] p[eBV̓ǂݍݏ
 * [@@\] AFSt@CǂݍŁAp[eBVIDɐݒ肷B
 *  Get partition loading state
 * [Inputs  ] ptid   :Partition ID
 * [Outputs ] None
 * [Return  ] Partition loading state
 * [Function] Gets partition loading state.
 */
Sint32 CRIAPI ADXF_GetPtStat(Sint32 ptid);

/*  p[eBVǂݍ݂̒~
 * [@] void ADXF_StopPtLd(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] p[eBV̓ǂݍ݂𒆎~B
 *  Stop to load partition information
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Stops to load partition information.
 */
void CRIAPI ADXF_StopPtLd(void);

/*  p[eBVTCY̎擾
 * [@] Sint32 ADXF_GetPtinfoSize(Sint32 ptid);
 * [@] ptid	:p[eBVID
 * [o@] Ȃ
 * [֐l] p[eBVTCY(PʁFoCg)
 * [@@\] p[eBV̈̃TCY擾B
 *  Get size of partition information
 * [Inputs  ] ptid   :Partition ID
 * [Outputs ] None
 * [Return  ] Size of the partition information(byte)
 * [Function] Gets size of the partition information.
 */
Sint32 CRIAPI ADXF_GetPtinfoSize(Sint32 ptid);

/* p[eBV̎擾 */
Char8 * CRIAPI ADXF_GetFnameFromPt(Sint32 ptid);

/* p[eBṼt@C̎擾 */
Sint32 CRIAPI ADXF_GetNumFilesFromPt(Sint32 ptid);

/* p[eBṼt@CTCY̎擾 */
Sint32 CRIAPI ADXF_GetFileSizeFromPt(Sint32 ptid, Sint32 fid);

/* AFSt@C̃t@C̎擾(AFSt@C̓ǂݍ݂̓Avōs) */
Sint32 CRIAPI ADXF_GetNumFilesFromAfs(void *buf);

/*==========================================================================
		t@C̓ǂݍ
		Read file
  ==========================================================================*/

/*	t@C̃I[v
 * [@] ADXF ADXF_Open(const Char8 *fname, void *atr);
 * [@] fname	: t@C
 *			atr		: t@C̑
 * [o@] Ȃ
 * [֐l] ADXFnhAG[̏ꍇNULL
 * [@@\] w̃t@CI[vAADXFnhԂB
 *  Open file
 * [Inputs  ] fname  : File name
 *			  atr    : File attribute
 * [Outputs ] None
 * [Return  ] ADXF handle
 *			  (If the operation was unsuccessful, this function returns NULL.)
 * [Function] Opens a file.
 */
ADXF CRIAPI ADXF_Open(const Char8 *fname, void *atr);

/*	t@C̃I[vi񓯊j
 * [@] ADXF ADXF_OpenNw(const Char8 *fname, void *atr);
 * [@] fname	: t@C
 *			atr		: t@C̑
 * [o@] Ȃ
 * [֐l] ADXFnhAG[̏ꍇNULL
 * [@@\] wt@C̃I[vJnAADXFnhԂB
 *  Begins the file open
 * [Inputs  ] fname  : File name
 *			  atr    : File attribute
 * [Outputs ] None
 * [Return  ] ADXF handle
 *			  (If the operation was unsuccessful, this function returns NULL.)
 * [Function] Begins the file open.
 */
ADXF CRIAPI ADXF_OpenNw(const Char8 *fname, void *atr);

/*	t@C̃I[vԂ`FbN
 * [@] Bool ADXF_IsOpened(ADXF adxf);
 * [@] adxf : ADXFnh
 * [o@] Ȃ
 * [֐l] I[vԁiTRUE = Iv[vĂAFALSE = I[vj
 * [@@\] t@CI[vĂ邩ǂ`FbNB
 *  Checks the open status
 * [Inputs  ] adxf : ADXF handle
 * [Outputs ] None
 * [Return  ] Open status (TRUE = opened, FALSE = not opened)
 * [Function] Checks whether the file was opened.
 */
Bool CRIAPI ADXF_IsOpened(ADXF adxf);

/*	t@C̃I[viZN^͈͎wtj
 * [@] ADXF ADXF_OpenRange(const Char8 *fname, void *atr, Sint32 offset_sct, Sint32 range_sct);
 * [@] fname		: t@C
 *			atr			: t@C̑
 *			offset_sct	: t@C̃ItZbgiZN^Pʁj
 *			range_sct	: ͈́iZN^Pʁj
 * [o@] Ȃ
 * [֐l] ADXFnhAG[̏ꍇNULL
 * [@@\] w̃t@CI[vAADXFnhԂB
 *  Open file with internal range
 * [Inputs  ] fname  		: File name
 *			  atr    		: File attribute
 *			  offset_sct	: File offset from top of the file as a sector
 *			  range_sct		: File range as a sector
 * [Outputs ] None
 * [Return  ] ADXF handle
 *			  (If the operation was unsuccessful, this function returns NULL.)
 * [Function] Opens a file with internal range.
 */
ADXF CRIAPI ADXF_OpenRange(const Char8 *fname, void *atr, Sint32 offset_sct, Sint32 range_sct);

/*	t@C̃I[v(AFStH[}bg)
 * [@] ADXF ADXF_OpenAfs(Sint32 ptid, Sint32 flid);
 * [@] ptid	: p[eBVID
 *			flid	: t@CID
 * [o@] Ȃ
 * [֐l] ADXFnhAG[̏ꍇNULL
 * [@@\] p[eBVIDƃt@CIDŎw肳ꂽAFSt@CI[vA
 *			ADXFnhԂB
 *  Open file(AFS format)
 * [Inputs  ] ptid   : Partition ID
 *			  flid   : File ID
 * [Outputs ] None
 * [Return  ] ADXF handle
 *			  (If the operation was unsuccessful, this function returns NULL.)
 * [Function] Opens a file of AFS format.
 */
ADXF CRIAPI ADXF_OpenAfs(Sint32 ptid, Sint32 flid);

/*	t@C̃I[viAFStH[}bgA񓯊j
 * [@] ADXF ADXF_OpenAfsNw(Sint32 ptid, Sint32 flid);
 * [@] ptid	: p[eBVID
 *			flid	: t@CID
 * [o@] Ȃ
 * [֐l] ADXFnhAG[̏ꍇNULL
 * [@@\] p[eBVIDƃt@CIDŎw肳ꂽAFSt@C̃I[vJnB
 *  Begins the file open (AFS format)
 * [Inputs  ] ptid   : Partition ID
 *			  flid   : File ID
 * [Outputs ] None
 * [Return  ] ADXF handle
 *			  (If the operation was unsuccessful, this function returns NULL.)
 * [Function] Begins the AFS file open.
 */
ADXF CRIAPI ADXF_OpenAfsNw(Sint32 ptid, Sint32 flid);

/* t@C̃N[Y
 * [@] void ADXF_Close(ADXF adxf);
 * [@] adxf	: ADXFnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] w肳ꂽADXFnh̃t@CN[YB
 *  Close file
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Closes a file of specific ADXF handle.
 */
void CRIAPI ADXF_Close(ADXF adxf);

/* SẴt@CN[Y
 * [@] void ADXF_CloseAll(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ADXFnh̃t@CSăN[YB
 *  Close file
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Closes all file of ADXF handle.
 */
void CRIAPI ADXF_CloseAll(void);

/*  SJւ̃f[^ǂݍ݊Jn
 * [@] void ADXF_ReadSj(ADXF adxf, Sint32 nsct, SJ sj);
 * [@] adxf	: ADXFnh
 *			nsct	: ǂݍ݃f[^̗(PʁFZN^)
 *			SJ		: Xg[WCg
 * [o@] Ȃ
 * [֐l] ǂݍ݃f[^(PʁFZN^)
 * [@@\] Xg[WCgɃf[^ǂݍ݂̃NGXg𔭍sB
 *			Xg[WCg̃obt@TCÝAZN^̐{łȂ
 *			ȂȂB
 *			Xg[WCg烆[Uf[^ǂݏoƁAIɃXg[
 *			WCgɃf[^ǂݍ܂B
 *			NGXgANZX삪ƁAANZX|C^
 *			nsctZN^iށB
 *  Read-in start to Stream Joint
 * [Inputs  ] adxf   : ADXF handle
 *			  nsct   : Number of read-in sectors to request
 *			  SJ     : Stream Joint
 * [Outputs ] None
 * [Return  ] Number of sectors to read
 * [Function] Requests data read-in to Stream Joint.
 *			  Buffer size of Stream Joint must be multiples of integer.
 *			  If you read data from Stream Joint, data are read into Stream 
 *			  Joint automatically.
 *			  The access pointer moves 'nsct' sector minute when the request 
 *			  was completed.
 */
Sint32 CRIAPI ADXF_ReadSj(ADXF adxf, Sint32 nsct, SJ sj);

/* f[^̓ǂݍ݊Jn
 * [@] void ADXF_ReadNw(ADXF adxf, Sint32 nsct, void *buf);
 * [@] adxf	: ADXFnh
 *			nsct	: ǂݍ݃f[^̗(PʁFZN^)
 *			buf		: ǂݍݗ̈
 * [o@] Ȃ
 * [֐l] ǂݍ݃f[^(PʁFZN^)
 * [@@\] f[^ǂݍ݂̃NGXg𔭍sB
 *			NGXgANZX삪ƁAANZX|C^
 *			nsctZN^iށB
 *  Read-in start
 * [Inputs  ] adxf   : ADXF handle
 *			  nsct   : Number of read-in sectors to request
 *			  buf    : Pointer to buffer into which the data is read
 * [Outputs ] None
 * [Return  ] Number of sectors to read
 * [Function] Requests data read-in to Stream Joint.
 *			  The access pointer moves 'nsct' sector minute when the request 
 *			  was completed.
 */
Sint32 CRIAPI ADXF_ReadNw(ADXF adxf, Sint32 nsct, void *buf);

/* f[^̓ǂݍݒ~
 * [@] Sint32 ADXF_Stop(ADXF adxf);
 * [@] adxf	: ADXFnh
 * [o@] Ȃ
 * [֐l] ~_ł̃ANZX|C^̈ʒu
 * [@@\] f[^̓ǂݍ݂𒆎~B
 *  Read-in stop
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] None
 * [Return  ] The location of access pointer when you stop to read
 * [Function] Stops to read data.
 */
Sint32 CRIAPI ADXF_Stop(ADXF adxf);

/* f[^̓ǂݍݒ~ (A)
 * [@] Sint32 ADXF_Stop(ADXF adxf);
 * [@] adxf	: ADXFnh
 * [o@] Ȃ
 * [֐l] ~NGXg_ł̃ANZX|C^̈ʒu
 * [@@\] f[^̓ǂݍ݂𒆎~NGXgB
 *			Ԃ͂ɂ͕ς炸Aǂݍ݂~ƂSTOPɕω
 *  Read-in stop
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] None
 * [Return  ] The location of access pointer when you request to stop
 * [Function] Request to Stop.
 */
Sint32 CRIAPI ADXF_StopNw(ADXF adxf);

/* T[o֐
 * [@] void ADXF_ExecServer(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ԂXVB
 *  Server function
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Update the inside status of library.
 */
void CRIAPI ADXF_ExecServer(void);

/*==========================================================================
		ANZX|C^̐
		Control access pointer
  ==========================================================================*/

/*  ANZX|C^̈ړ
 * [@] Sint32 ADXF_Seek(ADXF adxf, Sint32 pos, Sint32 type);
 * [@] adxf	: ADXFnh
 *			pos		: ANZX|C^̈ړ(PʁFZN^)
 *			type	: ړ(V[N^CvFADXF_SEEK_`)
 * [o@] Ȃ
 * [֐l] ANZX|C^̈ʒuA̒l̓G[R[h
 * [@@\] ANZX|C^typeposZN^ꂽʒuɈړB
 *  Move access pointer
 * [Inputs  ] adxf   : ADXF handle
 *			  pos    : Offset relative to 'type'
 *			  type   : Specified the origin for the offset
 * [Outputs ] None
 * [Return  ] Location containing new seek pointer
 * [Function] Changes the seek pointer to a new location relative to the 
 *			  beginning of the file, to the end of the file, or to the current 
 *			  seek pointer.
 */
Sint32 CRIAPI ADXF_Seek(ADXF adxf, Sint32 pos, Sint32 type);

/*  ANZX|C^̎擾
 * [@] Sint32 ADXF_Tell(ADXF adxf);
 * [@] adxf	: ADXFnh
 * [o@] Ȃ
 * [֐l] ANZX|C^̈ʒu
 * [@@\] ANZX|C^̈ʒu擾B
 *  Get the access pointer
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] None
 * [Return  ] Access pointer
 * [Function] Gets the access pointer.
 */
Sint32 CRIAPI ADXF_Tell(ADXF adxf);

/*==========================================================================
		̎擾
		Get information
  ==========================================================================*/

/*  t@CTCY̎擾
 * [@] Sint32 ADXF_GetFsizeSct(ADXF adxf);
 * [@] adxf	: ADXFnh
 * [o@] Ȃ
 * [֐l] t@CTCY(PʁFZN^)
 * [@@\] w肳ꂽt@C̃TCYZN^PʂŎ擾B
 *  Get file size
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] None
 * [Return  ] File size(sector)
 * [Function] Obtains the size of the specified file.
 */
Sint32 CRIAPI ADXF_GetFsizeSct(ADXF adxf);

/*  t@CTCY̎擾
 * [@] Sint32 ADXF_GetFsizeByte(ADXF adxf);
 * [@] adxf	: ADXFnh
 * [o@] Ȃ
 * [֐l] t@CTCY(PʁFoCg)
 * [@@\] w肳ꂽt@C̃TCYoCgPʂŎ擾B
 *  Get file size
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] None
 * [Return  ] File size(byte)
 * [Function] Obtains the size of the specified file.
 */
Sint32 CRIAPI ADXF_GetFsizeByte(ADXF adxf);
Sint64 CRIAPI ADXF_GetFsizeByte64(ADXF adxf);

/*  ǂݍݗv̎擾
 * [@] Sint32 ADXF_GetNumReqSct(ADXF adxf, Sint32 *seekpos);
 * [@] adxf	: ADXFnh
 * [o@] seekpos	: ǂݍ݈ʒu
 * [֐l] vǂݍ݃f[^(PʁFZN^)
 * [@@\] vǂݍ݈ʒuƃf[^ʂ擾B
 *  Get request information
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] seekpos: location of start to read
 * [Return  ] Request data size(sector)
 * [Function] Obtains read-in start position and the read-in size that 
 *			  demanded.
 */
Sint32 CRIAPI ADXF_GetNumReqSct(ADXF adxf, Sint32 *seekpos);

/*  ۂɓǂݍ񂾃ZN^̎擾
 * [@] Sint32 ADXF_GetNumReadSct(ADXF adxf);
 * [@] adxf	: ADXFnh
 * [o@] Ȃ
 * [֐l] ǂݍ񂾃f[^(PʁFZN^)
 * [@@\] ۂɓǂݍ񂾃f[^ʂ擾B
 *  Get the number of sectors read
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] None
 * [Return  ] Size of read data(sector)
 * [Function] Obtains the size of data that read actually.
 */
Sint32 CRIAPI ADXF_GetNumReadSct(ADXF adxf);

/*  nh̏Ԃ̎擾
 * [@] Sint32 ADXF_GetStat(ADXF adxf);
 * [@] adxf	: ADXFnh
 * [o@] Ȃ
 * [֐l] ADXFnh̓(ԁFADXF_STAT_`)
 * [@@\] ADXFnh̓Ԃ擾B
 *  Get status of handle
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] None
 * [Return  ] Status of handle
 * [Function] Gets status of handle.
 */
Sint32 CRIAPI ADXF_GetStat(ADXF adxf);

Sint32 CRIAPI ADXF_GetFnameRange(Sint32 ptid, Sint32 flid, 
	Char8 *fname, Sint32 *ofst, Sint32 *fnsct);

Sint32 CRIAPI ADXF_GetFnameRangeEx(Sint32 ptid, Sint32 flid, 
	Char8 *fname, void **dir, Sint32 *ofst, Sint32 *fnsct);

/*@[hNGXg̃TCY̐ݒ
 * [@] void ADXF_SetReqRdSct(ADXF adxf, Sint32 nsct);
 * [@] adxf    ; ADXFnh
 *			nsct    ; ZN^
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ɓǂݍރTCYݒ肵܂B
 *  Set size of read request
 * [Inputs  ] adxf   : ADXF handle
 *			  nsct   : size(sector)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets size of read request(one time).
 */
void CRIAPI ADXF_SetReqRdSct(ADXF adxf, Sint32 nsct);

/*	t@Cǂݍ݃Xe[^X̎擾
 * [@] Sint32 ADXT_GetStatRead(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] 1=ǂݍݒA0=ǂݍݒ~
 * [@@\] ǂݍݏԂ擾
 *  Get status of data reading
 * [Inputs  ] adxf   : ADXF handle
 * [Outputs ] None
 * [Return  ] 1=Data reading in progress,  0=Data reading stopped
 * [Function] Gets status of data reading
 */
Sint32 CRIAPI ADXF_GetStatRead(ADXF adxf);

/*	t@C̗L̊mF
 * [  ] Bool ADXF_IsExistFile(const Char8 *fname);
 * [  ] fname:t@C
 * [o  ] Ȃ
 * [߂l] 1=t@C݂A0=t@C݂Ȃ
 * [  ] w肳ꂽt@C݂邩ǂmF
 * [  ] t@CȂꍇłG[R[obN͔Ȃ
 *	Check of file existence
 * [Input   ] fname:file name
 * [Output  ] None
 * [Return  ] 1=file exist, 0=otherwise
 * [Function] Checks whether file exist
 * [Remarks ] This function does not return error callback even if file does not exist
 */
Bool CRIAPI ADXF_IsExistFile(const Char8 *fname);

/*	t@CTCY̎擾
 * [  ] Sint32 ADXF_GetFileSize(const Char *fname);
 * [  ] fname:t@C
 * [o  ] Ȃ
 * [߂l] t@CTCY(PʁFoCg)
 * [  ] w肳ꂽt@C̃t@CTCYoCgPʂŎ擾܂B
 *  Get file size
 * [Input   ] fname:file name
 * [Output  ] None
 * [Return  ] file size (unit : byte)
 * [Function] Gets file size specified file name
 */
Sint32 CRIAPI ADXF_GetFileSize(const Char8 *fname);
Sint64 CRIAPI ADXF_GetFileSize64(const Char8 *fname);

/*==========================================================================
		ROFSp
		for ROFS
  ==========================================================================*/
#if 0

/* ő啶 */
#define ADXF_ROFS_VOLNAME_LEN		(8)		/* {[̕ */
#define ADXF_ROFS_VOLNAME_SIZ		(ADXF_ROFS_VOLNAME_LEN + 1)	/* TCY */
#define ADXF_ROFS_FNAME_LEN			(31)	/* t@C̕ */
#define ADXF_ROFS_FNAME_SIZ			(ADXF_ROFS_FNAME_LEN + 1)	/* TCY */
#define ADXF_ROFS_DIRNAME_LEN		(31)	/* fBNg̕ */
#define ADXF_RPFS_DIRNAME_SIZ		(ADXF_ROFS_DIRNAME_LEN+1)	/* TCY */

/* CuƗ̈TCY */
#define ADXF_CALC_LIBWORK_SIZ(max_open,max_volume,max_dirent) (sizeof(ADXF_ROFS_WK)+((max_open)+1)*sizeof(ADXF_ROFS_OBJ)+(ADXF_CALC_DIRREC_SIZ(max_dirent)+sizeof(ADXF_ROFS_VOL))*((max_volume)+1))

/* fBNgR[ḧTCY */
#define ADXF_CALC_DIRREC_SIZ(n_dirent) (sizeof(ADXF_ROFS_DIRREC)-sizeof(ADXF_ROFS_DIRRECENT)+(n_dirent)*sizeof(ADXF_ROFS_DIRRECENT))

/* [N̈ */
typedef struct ADXF_ROFS_STWK		ADXF_ROFS_WK;

/* v~eBu֐ */
typedef struct ADXF_ROFS_PFSIFTBL	ADXF_ROFS_PFSTBL;

/* foCXRg[֐ */
typedef struct ADXF_ROFS_DEVIFTBLE	ADXF_ROFS_DEVTBL;

/* CuC^[tF[X */
typedef struct ADXF_ROFS_LIBIFTBLE	ADXF_ROFS_LIFTBL;

/* fBNgR[hGg */
typedef struct {
	Sint32	fad;						/* fad */
	Sint32	fsize;						/* file size */
	Uint8	flag;						/* file attribute */
	Uint8	sid;						/* filename search id */
	Char8	fname[ADXF_ROFS_FNAME_SIZ];		/* filename */
	Uint8	pad[6];
} ADXF_ROFS_DIRRECENT;						/* 48 bytes */

/* fBNgR[h */
typedef struct {
	Sint32	dir_num;					/* number of record */
	Sint32	max_ent;					/* max entry of directory record */
	Sint32	dir_fad;					/* fad of directory record */
	Char8	volname[ADXF_ROFS_FNAME_SIZ];	/* volume name */
	Sint32	pad;						/* padding */
	ADXF_ROFS_DIRRECENT	dirrec_tbl[1];		/* record table */
} ADXF_ROFS_DIRREC;
typedef ADXF_ROFS_DIRREC	*ADXF_ROFS_DIRRECBUF;

/* {[Ǘ\ */
typedef struct {
	Char8	volname[ADXF_ROFS_VOLNAME_SIZ];	/* {[ */
	void	*img_hn;					/* C[Wt@C̃t@Cnh */
	Sint32	zisb;						/* ZONE0C[Wf[^Jnʒu */
	Sint32	ptbl_cba;					/* cba of path table */
	Sint32	ptbl_size;					/* size of path table */
	ADXF_ROFS_DIRRECBUF	curdir;				/* current directory handle */
} ADXF_ROFS_VOL;

/* ROFS File Handle */
typedef struct {
	ADXF_ROFS_WK	*wk;					/* pointer of lib work */
	Sint32		fid;					/* file id */
	Sint32		fad;					/* fad */
	Sint32		ofs;					/* offset */
	Sint32		fsize;					/* file size */
	Sint32		fsctsize;				/* sctor size of the file */
	ADXF_ROFS_VOL	*vol;					/* image file volume */
	Sint32		rsize;					/* reading size */
	Sint32		trns_seg;				/* ]σubNP */
	Sint32		trns_ofs;				/* ]σoCgP */
	Sint32		trns_unit;				/* ]P(ubN) */
	Uint8		*rdadr;					/* ǂݍ݃AhX */
	Sint16		used;					/* used flag */
	Sint16		act;					/* handle act */
	Sint16		stat;					/* handle status(ADXF_Stat) */
	Sint16		err;					/* error status */
} ADXF_ROFS_OBJ;
typedef ADXF_ROFS_OBJ	*ADXF_ROFS;

/* ROFS Work Area */
struct ADXF_ROFS_STWK {
	Bool			f_init;				/* tO */
	Sint32			max_open;			/* max open files */
	Sint32			max_volume;
	Sint32			max_dirent;
	Uint32			exec_server_cnt;	/* counter */
	ADXF_ROFS			syshdl;				/* handle for system command */
	ADXF_ROFS			hndtbl;				/* handle */
	ADXF_ROFS_VOL		*vollist;			/* {[񃊃Xg */
	ADXF_ROFS_VOL		*curvol;			/* Jg{[ */
	ADXF_ROFS_DIRRECBUF	dirbuf;				/* fBNgR[h̊Jnʒu */
	ADXF_ROFS_PFSTBL		*pfs;				/* v~eBu֐ */
	ADXF_ROFS_DEVTBL		*dev;				/* foCXRg[֐ */
	ADXF_ROFS_LIFTBL			*liftbl;			/* CuC^[tF[X */
	void	(*g_errcb)(void *, Char8 *, Sint32);	/* error callback */
	void			*g_errcb_1st;		/* error callback 1st arg. */
	Uint32	sctbuf[(ADXF_DEF_SCT_SIZE*2+64)/4];	/* sector buffer */
	ADXF_ROFS_OBJ		hndlist[1];			/* handle table */
}; /* 64 + 4160 + handles */


/* ROFSZbgAbv\  */
#ifndef ADXF_SPRM_ROFS_DEFINED
#define ADXF_SPRM_ROFS_DEFINED
typedef struct {
	Sint32	max_open;				/* ɃI[vłőt@C */
	Sint32	max_volume;				/* ɓo^łő{[ */
	Sint32	max_dirent;				/* fBNgɊi[őt@C */
	void	*rofs_work;				/* CuƗ̈̐擪AhX */
} ADXF_SPRM_ROFS;
#endif

#endif

/* ROFS̃ZbgAbv	*/
/* Setup ROFS			*/
void CRIAPI ADXF_SetupRofs(void *sprmr);

/* ROFS̃Vbg_E */
/* Shutdown ROFS		*/
void CRIAPI ADXF_ShutdownRofs(void);

/* ROFS{[̒ǉ(XNuL[Ή)	*/
/* Addition of ROFS volume(with Scramble key)	*/
/* ̊֐̎dl͕ύX܂								*/
/* XNuL[gp̏ꍇscrkeyNULLw肵Ă	*/ 
Sint32 CRIAPI ADXF_AddRofsVol(Char8 *volname, Char8 *imgname, Char8 *scrkey);

/* ROFS{[̍폜 */
/* Delete ROFS volume	*/
void CRIAPI ADXF_DelRofsVol(Char8 *volname);

/* ROFS{[ł邩ۂ */
/* Check ROFS volume name		*/
Bool CRIAPI ADXF_IsRofsVol(Char8 *volname);

/* ftHgfoCX̐ݒ */
/* Setting default device	*/
void CRIAPI ADXF_SetDefDev(Char8 *volname);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* _CRI_ADXF_H_INCLUDED */
