/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 1998-2005 CRI-MW
 *
 * Library  : CRI Middleware Library
 * Module   : CRI Common Header for Windows, Xbox and Xbox360
 * File     : cri_xpts_win.h
 * Date     : 2005-08-09
 * Version  : 1.43
 *
 ****************************************************************************/

#if !defined(CRI_XPTS_H)
#define CRI_XPTS_H

#if !defined(SEGA_XPT_H)

/*****************************************************************************
 * 萔}N
 *****************************************************************************/

/* NULL |C^^ */
#if !defined(NULL)
#ifdef __cplusplus
#define NULL	(0)
#else
#define NULL	((void *)0)
#endif
#endif

/* _萔PiUA^j */
#if !defined(FALSE)
#define FALSE	(0)
#endif
#if !defined(TRUE)
#define TRUE	(1)
#endif

/* _萔QiXCb`j */
#if !defined(OFF)
#define OFF		(0)
#endif
#if !defined(ON)
#define ON		(1)
#endif

/* ʔ̒萔iAsj */
#if !defined(OK)
#define OK		(0)			/*  */
#endif
#if !defined(NG)
#define NG		(-1)		/* s */
#endif

/*****************************************************************************
 * {f[^^錾
 *****************************************************************************/

#if !defined(_TYPEDEF_Uint8)
#define _TYPEDEF_Uint8
typedef unsigned char			Uint8;		/* ȂPoCg */
#endif

#if !defined(_TYPEDEF_Sint8)
#define _TYPEDEF_Sint8
typedef signed char				Sint8;		/* PoCg */
#endif

#if !defined(_TYPEDEF_Uint16)
#define _TYPEDEF_Uint16
typedef unsigned short			Uint16;		/* ȂQoCg */
#endif

#if !defined(_TYPEDEF_Sint16)
#define _TYPEDEF_Sint16
typedef signed short			Sint16;		/* QoCg */
#endif

#if !defined(_TYPEDEF_Uint32)
#define _TYPEDEF_Uint32
typedef unsigned long			Uint32;		/* ȂSoCg */
#endif

#if !defined(_TYPEDEF_Sint32)
#define _TYPEDEF_Sint32
typedef signed long				Sint32;		/* SoCg */
#endif

#if !defined(_TYPEDEF_Uint64)
#define _TYPEDEF_Uint64
typedef unsigned __int64		Uint64;		/* ȂWoCg */
#endif

#if !defined(_TYPEDEF_Sint64)
#define _TYPEDEF_Sint64
typedef signed __int64			Sint64;		/* WoCg */
#endif

#if !defined(_TYPEDEF_Uint128)
#define _TYPEDEF_Uint128
typedef struct {							/* Ȃ16oCg */
	Uint64	h;								/* 64rbg */
	Uint64	l;								/* 64rbg */
} Uint128;
#endif

#if !defined(_TYPEDEF_Sint128)
#define _TYPEDEF_Sint128
typedef struct {							/* 16oCg */
	Sint64	h;								/* 64rbg */
	Uint64	l;								/* 64rbg */
} Sint128;
#endif

#if !defined(_TYPEDEF_Float16)
#define _TYPEDEF_Float16
typedef signed short			Float16;	/* QoCg */
#endif

#if !defined(_TYPEDEF_Float32)
#define _TYPEDEF_Float32
typedef float					Float32;	/* SoCg */
#endif

#if !defined(_TYPEDEF_Float64)
#define _TYPEDEF_Float64
typedef double					Float64;	/* WoCg */
#endif

#if !defined(_TYPEDEF_Fixed32)
#define _TYPEDEF_Fixed32
typedef signed long				Fixed32;	/* Œ菬_32rbg */
#endif

#if !defined(_TYPEDEF_Bool)
#define _TYPEDEF_Bool
typedef Sint32					Bool;		/* _^i_萔lɂƂj */
#endif

#if !defined(_TYPEDEF_Char8)
#define _TYPEDEF_Char8
typedef char					Char8;		/* ^ */
#endif

/*****************************************************************************
 * |C^ϐ
 *****************************************************************************/

#if defined(_WIN64)

#if !defined(_TYPEDEF_SintPtr)
#define _TYPEDEF_SintPtr
typedef signed __int64			SintPtr;
#endif

#if !defined(_TYPEDEF_UintPtr)
#define _TYPEDEF_UintPtr
typedef unsigned __int64		UintPtr;
#endif

#else

#if defined(_MSC_VER) && (_MSC_VER >= 1300)

#if !defined(_TYPEDEF_SintPtr)
#define _TYPEDEF_SintPtr
typedef __w64 signed int		SintPtr;
#endif

#if !defined(_TYPEDEF_UintPtr)
#define _TYPEDEF_UintPtr
typedef __w64 unsigned int		UintPtr;
#endif

#else

#if !defined(_TYPEDEF_SintPtr)
#define _TYPEDEF_SintPtr
typedef Sint32					SintPtr;
#endif

#if !defined(_TYPEDEF_UintPtr)
#define _TYPEDEF_UintPtr
typedef Uint32					UintPtr;
#endif

#endif

#endif	/* end of _WIN64 */

/*****************************************************************************
 * ĂяoK
 *****************************************************************************/

#if !defined(CRIAPI)
#define CRIAPI	__cdecl
#endif

#endif

#endif	/* CRI_XPTS_H */

/* end of file */
