/*
Copyright (c) 2006, Intel Corporation.

This Intel Laptop Gaming TDK ("Software") is furnished under license and may 
only be used or copied in accordance with the terms of that license. No license, 
express or implied, by estoppel or otherwise, to any intellectual property rights 
is granted by this document. The Software is subject to change without notice, 
and should not be construed as a commitment by Intel Corporation to market, 
license, sell or support any product or technology. Unless otherwise provided 
for in the license under which this Software is provided, the Software is 
provided AS IS, with no warranties of any kind, express or implied. 
Except as expressly permitted by the Software license, neither Intel Corporation 
nor its suppliers assumes any responsibility or liability for any errors or 
inaccuracies that may appear herein. Except as expressly permitted by the 
Software license, no part of the Software may be reproduced, stored in a 
retrieval system, transmitted in any form, or distributed by any means 
without the express written consent of Intel Corporation.
*/

/**
* This class implements abstract base class 'Observer' for client app
* to derive and provide custom functionality to invoke when event is 
* fired
*/

#ifndef NOTIFY_H
#define NOTIFY_H

#include "stdafx.h"
//#include <iostream>
//#include <string>
#include <conio.h>

//using namespace std;

class Notifiable 
{
public:
	virtual void notify(int event, long value = 0) = 0;
};

class CallbackImpl
{
public:
	CallbackImpl(Notifiable *who): callee(who) {}
	void GotEvent(int event)
	{
		callee->notify(event);
	}
private:
	Notifiable *callee;
};

#endif NOTIFY_H