#ifndef __ASETokens_h__
#define __ASETokens_h__
#pragma once

// Top level category ID's
#define ASE_SCENE				_T("*SCENE")
#define ASE_GEOMETRY		_T("*GEOMOBJECT") 
#define ASE_SHAPE				_T("*SHAPEOBJECT") 
#define ASE_CAMERA			_T("*CAMERAOBJECT") 
#define ASE_LIGHT				_T("*LIGHTOBJECT") 
#define ASE_HELPER				_T("*HELPEROBJECT")
#define ASE_MATERIAL_LIST		_T("*MATERIAL_LIST")

// Hierarchy
#define ASE_GROUP				_T("*GROUP")

// Node related ID's
#define ASE_NODE_TM				_T("*NODE_TM")
#define ASE_NODE_NAME			_T("*NODE_NAME") 
#define ASE_NODE_PARENT			_T("*NODE_PARENT")

// Object (node) properties
#define ASE_PROP_MOTIONBLUR		_T("*PROP_MOTIONBLUR")
#define ASE_PROP_CASTSHADOW		_T("*PROP_CASTSHADOW")
#define ASE_PROP_RECVSHADOW		_T("*PROP_RECVSHADOW")

// Mesh related ID's
#define ASE_MESH					_T("*MESH")
#define ASE_MESH_NORMALS			_T("*MESH_NORMALS") 
#define ASE_MESH_NUMVERTEX		_T("*MESH_NUMVERTEX") 
#define ASE_MESH_NUMFACES		_T("*MESH_NUMFACES") 
#define ASE_MESH_VERTEX_LIST		_T("*MESH_VERTEX_LIST") 
#define ASE_MESH_VERTEX			_T("*MESH_VERTEX")
#define ASE_MESH_FACE_LIST		_T("*MESH_FACE_LIST") 
#define ASE_MESH_FACE			_T("*MESH_FACE")
#define ASE_MESH_SMOOTHING		_T("*MESH_SMOOTHING") 
#define ASE_MESH_MTLID			_T("*MESH_MTLID")

#define ASE_MESH_NUMTVERTEX		_T("*MESH_NUMTVERTEX") 
#define ASE_MESH_NUMTVFACES		_T("*MESH_NUMTVFACES") 
#define ASE_MESH_TVERTLIST		_T("*MESH_TVERTLIST") 
#define ASE_MESH_TVERT			_T("*MESH_TVERT") 
#define ASE_MESH_TFACELIST		_T("*MESH_TFACELIST") 
#define ASE_MESH_TFACE			_T("*MESH_TFACE")

#define ASE_MESH_NUMCVERTEX		_T("*MESH_NUMCVERTEX")
#define ASE_MESH_NUMCVFACES		_T("*MESH_NUMCVFACES") 
#define ASE_MESH_CVERTLIST		_T("*MESH_CVERTLIST")
#define ASE_MESH_VERTCOL			_T("*MESH_VERTCOL")
#define ASE_MESH_CFACELIST		_T("*MESH_CFACELIST")
#define ASE_MESH_CFACE			_T("*MESH_CFACE")

// New for R3 - indicates a block with new map channel information
#define ASE_MESH_MAPPINGCHANNEL	_T("*MESH_MAPPINGCHANNEL")
// End new

#define ASE_MESH_FACEMAPLIST		_T("*MESH_FACEMAPLIST") 
#define ASE_MESH_FACEMAP			_T("*MESH_FACEMAP") 
#define ASE_MESH_FACEVERT		_T("*MESH_FACEMAPVERT")

#define ASE_MESH_FACENORMAL		_T("*MESH_FACENORMAL") 
#define ASE_MESH_VERTEXNORMAL	_T("*MESH_VERTEXNORMAL")

#define ASE_MESH_ANIMATION		_T("*MESH_ANIMATION")

// Shape ID's
#define ASE_SHAPE_LINECOUNT		_T("*SHAPE_LINECOUNT") 
#define ASE_SHAPE_LINE			_T("*SHAPE_LINE")
#define ASE_SHAPE_VERTEX_KNOT	_T("*SHAPE_VERTEX_KNOT") 
#define ASE_SHAPE_VERTEX_INTERP	_T("*SHAPE_VERTEX_INTERP") 
#define ASE_SHAPE_VERTEXCOUNT	_T("*SHAPE_VERTEXCOUNT") 
#define ASE_SHAPE_CLOSED			_T("*SHAPE_CLOSED")

// Light ID's
#define ASE_LIGHT_SETTINGS		_T("*LIGHT_SETTINGS") 
#define ASE_LIGHT_TYPE			_T("*LIGHT_TYPE") 
#define ASE_LIGHT_COLOR			_T("*LIGHT_COLOR") 
#define ASE_LIGHT_INTENS			_T("*LIGHT_INTENS") 
#define ASE_LIGHT_HOTSPOT		_T("*LIGHT_HOTSPOT") 
#define ASE_LIGHT_FALLOFF		_T("*LIGHT_FALLOFF") 
#define ASE_LIGHT_ATTNSTART		_T("*LIGHT_ATTNSTART") 
#define ASE_LIGHT_ATTNEND		_T("*LIGHT_ATTNEND")
#define ASE_LIGHT_ASPECT			_T("*LIGHT_ASPECT")
#define ASE_LIGHT_SHADOWS		_T("*LIGHT_SHADOWS")
#define ASE_LIGHT_USELIGHT		_T("*LIGHT_USELIGHT")
#define ASE_LIGHT_SPOTSHAPE		_T("*LIGHT_SPOTSHAPE")
#define ASE_LIGHT_TDIST			_T("*LIGHT_TDIST")
#define ASE_LIGHT_MAPBIAS		_T("*LIGHT_MAPBIAS")
#define ASE_LIGHT_MAPRANGE		_T("*LIGHT_MAPRANGE")
#define ASE_LIGHT_MAPSIZE		_T("*LIGHT_MAPSIZE")
#define ASE_LIGHT_RAYBIAS		_T("*LIGHT_RAYBIAS")
#define ASE_LIGHT_USEGLOBAL		_T("*LIGHT_USEGLOBAL")
#define ASE_LIGHT_ABSMAPBIAS		_T("*LIGHT_ABSMAPBIAS")
#define ASE_LIGHT_OVERSHOOT		_T("*LIGHT_OVERSHOOT")
#define ASE_LIGHT_EXCLUSIONLIST	_T("*LIGHT_EXCLUDELIST")
#define ASE_LIGHT_NUMEXCLUDED	_T("*LIGHT_NUMEXCLUDED")
#define ASE_LIGHT_EXCLUDED		_T("*LIGHT_EXCLUDED")
#define ASE_LIGHT_EXCLINCLUDE	_T("*LIGHT_EXCLUDED_INCLUDE")
#define ASE_LIGHT_EXCL_AFFECT_ILLUM	_T("*LIGHT_EXCLUDED_AFFECT_ILLUM")
#define ASE_LIGHT_EXCL_AFFECT_SHAD	_T("*LIGHT_EXCLUDED_AFFECT_SHADOW")
#define ASE_LIGHT_ANIMATION		_T("*LIGHT_ANIMATION")

#define ASE_LIGHT_TYPE_OMNI		_T("Omni")
#define ASE_LIGHT_TYPE_TARG		_T("Target")
#define ASE_LIGHT_TYPE_DIR		_T("Directional")
#define ASE_LIGHT_TYPE_FREE		_T("Free")

#define ASE_LIGHT_SHAD_OFF		_T("Off")
#define ASE_LIGHT_SHAD_MAP		_T("Mapped")
#define ASE_LIGHT_SHAD_RAY		_T("Raytraced")

#define ASE_LIGHT_SHAPE_CIRC		_T("Circle")
#define ASE_LIGHT_SHAPE_RECT		_T("Rect")

// Camera ID's
#define ASE_CAMERA_SETTINGS		_T("*CAMERA_SETTINGS")
#define ASE_CAMERA_HITHER		_T("*CAMERA_HITHER") 
#define ASE_CAMERA_YON			_T("*CAMERA_YON") 
#define ASE_CAMERA_NEAR			_T("*CAMERA_NEAR") 
#define ASE_CAMERA_FAR			_T("*CAMERA_FAR") 
#define ASE_CAMERA_FOV			_T("*CAMERA_FOV") 
#define ASE_CAMERA_TDIST			_T("*CAMERA_TDIST")
#define ASE_CAMERA_ANIMATION		_T("*CAMERA_ANIMATION")

#define ASE_CAMERA_TYPE			_T("*CAMERA_TYPE")
#define ASE_CAMERATYPE_TARGET	_T("Target")
#define ASE_CAMERATYPE_FREE		_T("Free")

// Helper objects
#define ASE_HELPER_CLASS			_T("*HELPER_CLASS")

// Controller ID's
#define ASE_CONTROL_POINT3_TCB		_T("*CONTROL_POINT3_TCB") 
#define ASE_CONTROL_POINT3_BEZIER	_T("*CONTROL_POINT3_BEZIER") 
#define ASE_CONTROL_COLOR_BEZIER		_T("*CONTROL_COLOR_BEZIER") 
#define ASE_CONTROL_POINT3_SAMPLE	_T("*CONTROL_POINT3_SAMPLE")

#define ASE_CONTROL_FLOAT_TCB	_T("*CONTROL_FLOAT_TCB") 
#define ASE_CONTROL_FLOAT_BEZIER	_T("*CONTROL_FLOAT_BEZIER") 
#define ASE_CONTROL_FLOAT_LINEAR	_T("*CONTROL_FLOAT_LINEAR") 
#define ASE_CONTROL_FLOAT_SAMPLE	_T("*CONTROL_FLOAT_SAMPLE")

// "Track" is the identification of a sampled controller
#define ASE_POS_TRACK			_T("*CONTROL_POS_TRACK")
#define ASE_ROT_TRACK			_T("*CONTROL_ROT_TRACK") 
#define ASE_SCALE_TRACK			_T("*CONTROL_SCALE_TRACK")

// Sampled keys
#define ASE_POS_SAMPLE			_T("*CONTROL_POS_SAMPLE")
#define ASE_ROT_SAMPLE			_T("*CONTROL_ROT_SAMPLE") 
#define ASE_SCALE_SAMPLE			_T("*CONTROL_SCALE_SAMPLE")

// Specific controller keys
#define ASE_POS_KEY				_T("*CONTROL_POS_KEY")
#define ASE_ROT_KEY				_T("*CONTROL_ROT_KEY") 
#define ASE_SCALE_KEY			_T("*CONTROL_SCALE_KEY")
#define ASE_POINT3_KEY			_T("*CONTROL_POINT3_KEY")
#define ASE_FLOAT_KEY			_T("*CONTROL_FLOAT_KEY")

// TCB Keys have Tens, cont, bias, easeIn, easeOut
#define ASE_TCB_POINT3_KEY		_T("*CONTROL_TCB_POINT3_KEY")
#define ASE_TCB_FLOAT_KEY		_T("*CONTROL_TCB_FLOAT_KEY")
#define ASE_TCB_POS_KEY			_T("*CONTROL_TCB_POS_KEY")
#define ASE_TCB_ROT_KEY			_T("*CONTROL_TCB_ROT_KEY") 
#define ASE_TCB_SCALE_KEY		_T("*CONTROL_TCB_SCALE_KEY")

// Bezier keys have inTan, outTan
#define ASE_BEZIER_FLOAT_KEY		_T("*CONTROL_BEZIER_FLOAT_KEY")
#define ASE_BEZIER_POINT3_KEY	_T("*CONTROL_BEZIER_POINT3_KEY")
#define ASE_BEZIER_POS_KEY		_T("*CONTROL_BEZIER_POS_KEY")
#define ASE_BEZIER_SCALE_KEY		_T("*CONTROL_BEZIER_SCALE_KEY")


#define ASE_CONTROL_POS_LINEAR	_T("*CONTROL_POS_LINEAR")
#define ASE_CONTROL_POS_TCB		_T("*CONTROL_POS_TCB")
#define ASE_CONTROL_POS_BEZIER	_T("*CONTROL_POS_BEZIER")
#define ASE_CONTROL_ROT_LINEAR	_T("*CONTROL_ROT_LINEAR")
#define ASE_CONTROL_ROT_TCB		_T("*CONTROL_ROT_TCB")
#define ASE_CONTROL_ROT_BEZIER	_T("*CONTROL_ROT_BEZIER")
#define ASE_CONTROL_SCALE_LINEAR _T("*CONTROL_SCALE_LINEAR")
#define ASE_CONTROL_SCALE_TCB	_T("*CONTROL_SCALE_TCB")
#define ASE_CONTROL_SCALE_BEZIER	_T("*CONTROL_SCALE_BEZIER")


// IK Node Info
#define ASE_IKTERMINATOR			_T("*IK_TERMINATOR")
#define ASE_IKROT_PINNED			_T("*IK_ROT_PINNED")
#define ASE_IKPOS_PINNED			_T("*IK_POS_PINNED")

// IK Joints
#define ASE_IKJOINT				_T("*IK_JOINT")
#define ASE_IKTYPE				_T("*IK_TYPE")
#define ASE_IKDOF				_T("*IK_DOF")
#define ASE_IKXACTIVE			_T("*IK_XACTIVE")
#define ASE_IKYACTIVE			_T("*IK_YACTIVE")
#define ASE_IKZACTIVE			_T("*IK_ZACTIVE")
#define ASE_IKXLIMITED			_T("*IK_XLIMITED")
#define ASE_IKYLIMITED			_T("*IK_YLIMITED")
#define ASE_IKZLIMITED			_T("*IK_ZLIMITED")
#define ASE_IKXEASE				_T("*IK_XEASE")
#define ASE_IKYEASE				_T("*IK_YEASE")
#define ASE_IKZEASE				_T("*IK_ZEASE")
#define ASE_IKLIMITEXACT			_T("*IK_LIMITEXACT")
#define ASE_IKJOINTINFO			_T("*IK_JOINTINFO")
#define ASE_IKTYPEPOS			_T("Position")
#define ASE_IKTYPEROT			_T("Rotation")

// Material / Texture related ID's
#define ASE_WIRECOLOR			_T("*WIREFRAME_COLOR") 
#define ASE_MATERIAL				_T("*MATERIAL") 
#define ASE_MATERIAL_COUNT		_T("*MATERIAL_COUNT") 
#define ASE_MATERIAL_REF			_T("*MATERIAL_REF")
#define ASE_NUMSUBMTLS			_T("*NUMSUBMTLS") 
#define ASE_SUBMATERIAL			_T("*SUBMATERIAL") 
#define ASE_MATNAME				_T("*MATERIAL_NAME") 
#define ASE_MATCLASS				_T("*MATERIAL_CLASS")

#define ASE_MAT_SHADE_CONST		_T("Constant")
#define ASE_MAT_SHADE_PHONG		_T("Phong")
#define ASE_MAT_SHADE_METAL		_T("Metal")
#define ASE_MAT_SHADE_BLINN		_T("Blinn")
#define ASE_MAT_SHADE_OTHER		_T("Other")

#define ASE_MAP_XPTYPE_FLT		_T("Filter")
#define ASE_MAP_XPTYPE_SUB		_T("Subtractive")
#define ASE_MAP_XPTYPE_ADD		_T("Additive")
#define ASE_MAP_XPTYPE_OTH		_T("Other")

#define ASE_BMP_FILT_PYR			_T("Pyramidal")
#define ASE_BMP_FILT_SAT			_T("SAT")
#define ASE_BMP_FILT_NONE		_T("None")

#define ASE_FALLOFF_OUT			_T("Out")
#define ASE_FALLOFF_IN			_T("In")
								
#define ASE_MAPTYPE_EXP			_T("Explicit")
#define ASE_MAPTYPE_SPH			_T("Spherical")
#define ASE_MAPTYPE_CYL			_T("Cylindrical")
#define ASE_MAPTYPE_SHR			_T("Shrinkwrap")
#define ASE_MAPTYPE_SCR			_T("Screen")
								
#define ASE_AMBIENT				_T("*MATERIAL_AMBIENT") 
#define ASE_DIFFUSE				_T("*MATERIAL_DIFFUSE") 
#define ASE_SPECULAR				_T("*MATERIAL_SPECULAR") 
#define ASE_SHINE				_T("*MATERIAL_SHINE")
#define ASE_SHINE_STRENGTH		_T("*MATERIAL_SHINESTRENGTH") 
#define ASE_TRANSPARENCY			_T("*MATERIAL_TRANSPARENCY") 
#define ASE_WIRESIZE				_T("*MATERIAL_WIRESIZE")
								
#define ASE_SHADING				_T("*MATERIAL_SHADING") 
#define ASE_XP_FALLOFF			_T("*MATERIAL_XP_FALLOFF") 
#define ASE_SELFILLUM			_T("*MATERIAL_SELFILLUM") 
#define ASE_TWOSIDED				_T("*MATERIAL_TWOSIDED") 
#define ASE_WIRE					_T("*MATERIAL_WIRE")
#define ASE_WIREUNITS			_T("*MATERIAL_WIREUNITS") 
#define ASE_FALLOFF				_T("*MATERIAL_FALLOFF") 
#define ASE_FACEMAP				_T("*MATERIAL_FACEMAP") 
#define ASE_SOFTEN				_T("*MATERIAL_SOFTEN") 
#define ASE_XP_TYPE				_T("*MATERIAL_XP_TYPE")
								
#define ASE_TEXNAME				_T("*MAP_NAME") 
#define ASE_TEXCLASS				_T("*MAP_CLASS") 
#define ASE_TEXSUBNO				_T("*MAP_SUBNO") 
#define ASE_TEXAMOUNT			_T("*MAP_AMOUNT")
								
#define ASE_BITMAP				_T("*BITMAP")
#define ASE_TEX_INVERT			_T("*BITMAP_INVERT") 
#define ASE_BMP_FILTER			_T("*BITMAP_FILTER")
								
#define ASE_MAPTYPE				_T("*MAP_TYPE") 
#define ASE_U_OFFSET				_T("*UVW_U_OFFSET") 
#define ASE_V_OFFSET				_T("*UVW_V_OFFSET") 
#define ASE_U_TILING				_T("*UVW_U_TILING") 
#define ASE_V_TILING				_T("*UVW_V_TILING") 
#define ASE_ANGLE				_T("*UVW_ANGLE") 
#define ASE_BLUR					_T("*UVW_BLUR")
#define ASE_BLUR_OFFSET			_T("*UVW_BLUR_OFFSET") 
#define ASE_NOISE_AMT			_T("*UVW_NOUSE_AMT") 
#define ASE_NOISE_SIZE			_T("*UVW_NOISE_SIZE") 
#define ASE_NOISE_LEVEL			_T("*UVW_NOISE_LEVEL") 
#define ASE_NOISE_PHASE			_T("*UVW_NOISE_PHASE")
								
// Sub texture types			
#define ASE_MAP_GENERIC			_T("*MAP_GENERIC") 
#define ASE_MAP_AMBIENT			_T("*MAP_AMBIENT") 
#define ASE_MAP_DIFFUSE			_T("*MAP_DIFFUSE") 
#define ASE_MAP_SPECULAR			_T("*MAP_SPECULAR") 
#define ASE_MAP_SHINE			_T("*MAP_SHINE")
#define ASE_MAP_SHINESTRENGTH	_T("*MAP_SHINESTRENGTH") 
#define ASE_MAP_SELFILLUM		_T("*MAP_SELFILLUM") 
#define ASE_MAP_OPACITY			_T("*MAP_OPACITY")
#define ASE_MAP_FILTERCOLOR		_T("*MAP_FILTERCOLOR") 
#define ASE_MAP_BUMP				_T("*MAP_BUMP")
#define ASE_MAP_REFLECT			_T("*MAP_REFLECT") 
#define ASE_MAP_REFRACT			_T("*MAP_REFRACT")
								
// TM related ID's				
#define ASE_TM_ROW0				_T("*TM_ROW0") 
#define ASE_TM_ROW1				_T("*TM_ROW1") 
#define ASE_TM_ROW2				_T("*TM_ROW2") 
#define ASE_TM_ROW3				_T("*TM_ROW3") 
#define ASE_TM_POS				_T("*TM_POS")
#define ASE_TM_ROTAXIS			_T("*TM_ROTAXIS") 
#define ASE_TM_ROTANGLE			_T("*TM_ROTANGLE") 
#define ASE_TM_SCALE				_T("*TM_SCALE") 
#define ASE_TM_SCALEAXIS			_T("*TM_SCALEAXIS")
#define ASE_TM_SCALEAXISANG		_T("*TM_SCALEAXISANG") 
#define ASE_TM_ANIMATION			_T("*TM_ANIMATION")

// TM Inheritance flags
#define ASE_INHERIT_POS			_T("*INHERIT_POS")
#define ASE_INHERIT_ROT			_T("*INHERIT_ROT")
#define ASE_INHERIT_SCL			_T("*INHERIT_SCL")

// Scene related ID's			
#define ASE_FILENAME				_T("*SCENE_FILENAME") 
#define ASE_FIRSTFRAME			_T("*SCENE_FIRSTFRAME") 
#define ASE_LASTFRAME			_T("*SCENE_LASTFRAME") 
#define ASE_FRAMESPEED			_T("*SCENE_FRAMESPEED") 
#define ASE_TICKSPERFRAME		_T("*SCENE_TICKSPERFRAME") 
#define ASE_ENVMAP				_T("*SCENE_ENVMAP")
#define ASE_STATICBGCOLOR		_T("*SCENE_BACKGROUND_STATIC") 
#define ASE_ANIMBGCOLOR			_T("*SCENE_BACKGROUND_ANIM") 
#define ASE_STATICAMBIENT		_T("*SCENE_AMBIENT_STATIC") 
#define ASE_ANIMAMBIENT			_T("*SCENE_AMBIENT_ANIM")

#define ASE_VISIBILITY_TRACK		_T("*NODE_VISIBILITY_TRACK")

// Generic ID's that can show up here and there 
#define ASE_TIMEVALUE			_T("*TIMEVALUE")
#define ASE_COMMENT				_T("*COMMENT")
#define ASE_FILEID				_T("*3DSMAX_ASCIIEXPORT")
#define ASE_BOUNDINGBOX_MIN		_T("*BOUNDINGBOX_MIN")
#define ASE_BOUNDINGBOX_MAX		_T("*BOUNDINGBOX_MAX")

#endif // __ASETokens_h__