#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Solution makefile for CryEngine.

Cry3DEngine_CODE := CryEngine/Cry3DEngine
CryAction_CODE := CryEngine/CryAction
CryAISystem_CODE := CryEngine/CryAISystem
CryAnimation_CODE := CryEngine/CryAnimation
CryCommon_CODE := CryEngine/CryCommon
CryEntitySystem_CODE := CryEngine/CryEntitySystem
CryFont_CODE := CryEngine/CryFont
CryInput_CODE := CryEngine/CryInput
CryMovie_CODE := CryEngine/CryMovie
CryNetwork_CODE := CryEngine/CryNetwork
CryPhysics_CODE := CryEngine/CryPhysics
CryScriptSystem_CODE := CryEngine/CryScriptSystem
CrySoundSystem_CODE := CryEngine/CrySoundSystem
CrySystem_CODE := CryEngine/CrySystem
XRenderD3D10_CODE := CryEngine/RenderDll/XRenderD3D9
XRenderNULL_CODE := CryEngine/RenderDll/XRenderNULL

GameDll_CODE := Game02/GameDll

Editor_CODE := Sandbox/Editor

Launcher_CODE := Game02/Launcher
LinuxLauncher_CODE := Game02/LinuxLauncher
PS3Launcher_CODE := Game02/PS3Launcher
XenonLauncher_CODE := Game02/XenonLauncher

PROJECTS_CryEngine := \
	CryAction \
	Cry3DEngine \
	CryAISystem \
	CryAnimation \
	CryCommon \
	CryEntitySystem \
	CryFont \
	CryInput \
	CryMovie \
	CryNetwork \
	CryPhysics \
	CryScriptSystem \
	CrySoundSystem \
	CrySystem

ifeq ($(OPTION_DEDICATED),1)
 PROJECTS_Renderer := XRenderNULL
else # OPTION_DEDICATED
 ifeq ($(ARCH_OS),Linux)
  PROJECTS_Renderer := XRenderNULL XRenderD3D10
 endif
 ifeq ($(ARCH_OS),PS3)
  #PROJECTS_Renderer := XRenderNULL
  PROJECTS_Renderer := XRenderD3D10
 endif
endif # OPTION_DEDICATED else

ifdef OPTION_RENDERER
 ifneq ($(OPTION_RENDERER),)
  PROJECTS_Renderer := $(OPTION_RENDERER)
 endif
endif

ifeq ($(ARCH_OS),Win32)
 PROJECTS_Launcher := Launcher
 OPTION_EDITOR ?= 1
endif
ifeq ($(ARCH_OS),Win64)
 PROJECTS_Launcher := Launcher
 OPTION_EDITOR ?= 1
endif
ifeq ($(ARCH_OS),Linux)
 PROJECTS_Launcher := LinuxLauncher
 OPTION_EDITOR := 0
endif
ifeq ($(ARCH_OS),PS3)
 PROJECTS_Launcher := PS3Launcher
 OPTION_EDITOR := 0
endif

ifeq ($(OPTION_EDITOR),1)
 PROJECTS_Editor := Editor
else
 PROJECTS_Editor :=
endif

ifeq ($(ARCH_OS),PS3)
 PROJECTS_Launcher := PS3Launcher
 SOLUTION_CPPFLAGS += -DPS3_CRYENGINE
endif

PROJECTS_Game := GameDll

PROJECTS := \
	$(PROJECTS_CryEngine) \
	$(PROJECTS_Editor) \
	$(PROJECTS_Game) \
	$(PROJECTS_Launcher) \
	$(PROJECTS_Renderer)

define launcher_DEPS
$(1)_DEPS := $(PROJECTS_CryEngine) $(PROJECTS_Game) $(PROJECTS_Renderer)
endef
$(foreach launcher,$(PROJECTS_Launcher),\
	$(eval $(call launcher_DEPS,$(launcher))))

DEFAULT_PROJECT := $(PROJECTS_Launcher)

ifeq ($(ARCH),PS3-cell)
 # PRX setup.
 ifeq ($(OPTION_PS3_PRX),1)
  export OPTION_PS3_PRX_CryAction := 1
  export OPTION_PS3_PRX_Cry3DEngine := 1
  export OPTION_PS3_PRX_CryAISystem := 1
  export OPTION_PS3_PRX_CryAnimation := 1
  export OPTION_PS3_PRX_CryEntitySystem := 1
  export OPTION_PS3_PRX_CryFont := 1
  export OPTION_PS3_PRX_CryInput := 1
  export OPTION_PS3_PRX_CryMovie := 1
  export OPTION_PS3_PRX_CryNetwork := 1
  export OPTION_PS3_PRX_CryPhysics := 1
  export OPTION_PS3_PRX_CryScriptSystem := 1
  export OPTION_PS3_PRX_CrySoundSystem := 1
  export OPTION_PS3_PRX_CrySystem := 1
  export OPTION_PS3_PRX_XRenderD3D10 := 1
  export OPTION_PS3_PRX_GameDll := 1
  export OPTION_PS3_PRX_PS3Launcher := 1
 endif # OPTION_PS3_PRX == 1
endif # ARCH == PS3-cell

# Test project for saschad.
ifeq ($(OPTION_USER),saschad)
 PRXTest_CODE := Game02/PRXTest
 PRXTest_DEPS := CrySystem CryAction CryAISystem GameDll
 PROJECTS += PRXTest
 ifeq ($(OPTION_PS3_PRX),1)
  export OPTION_PS3_PRX_PRXTest := 1
 endif # OPTION_PS3_PRX == 1
endif

# CryEngine.mk
# vim:ts=8:sw=8

