// AssManDirSync.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "Shlwapi.h"
#include <string.h>
#include <io.h>
#include <conio.h>
#include <string>
#include <set>

#pragma comment(lib, "Shlwapi.lib")
void SyncFolders(_bstr_t sDatabase,_bstr_t sProjPath,_bstr_t sLocalDir);
void SyncItem(IVSSItem *pItem, _bstr_t sFolder);
bool FillFileMap(std::string sPath);

typedef std::set<std::string> FileMap;
typedef FileMap::iterator FileMapItor;

FileMap g_mapFiles;

int _tmain(int argc, _TCHAR* argv[])
{
	::CoInitialize(NULL);
	try
	{
		FillFileMap("D:/TEST");
		SyncFolders(_T("\\\\server2\\XISLE\\ArtworkVss\\srcsafe.ini"),_T("$/MasterCD"),_T("D:/TEST"));
		SyncFolders(_T("\\\\server1\\VSS\\srcsafe.ini"),_T("$/MasterCD_Programmers"),_T("D:/TEST"));
		FileMapItor itor;
		itor=g_mapFiles.begin();
		while(itor!=g_mapFiles.end())
		{
			const std::string &s=(*itor);
			if(std::string::npos==s.find(".scc"))
			{
				printf("REMOVING %s",s.c_str());
				::DeleteFile(s.c_str());
			}
			++itor;
		}
		//_getch();
	}
	catch(_com_error &e)
	{
		
		printf("ERROR %s",(TCHAR *)e.Description());
	}
	::CoUninitialize();
	return 0;
}

bool FillFileMap(std::string sPath)
{
	struct _finddata_t c_file;
	std::string sSearchPattern=sPath+"/*.*";
	std::string sFilePath;
	long hFile;
	if( (hFile = _findfirst(sSearchPattern.c_str(), &c_file )) == -1L )
	{
		return true;
	}
	else
	{
		do{
			if(!((!strncmp(c_file.name,".",1)) &&  (c_file.attrib &_A_SUBDIR)))
			{
				if(c_file.attrib & _A_SUBDIR)
				{
					FillFileMap(sPath+"/"+std::string(c_file.name));
				}
				else
				{
					int i=0;
					sFilePath=_strlwr((char *)std::string(sPath+std::string("/")+c_file.name).c_str());
					g_mapFiles.insert(sFilePath.c_str());
				//	printf("inserting %s\n",sFilePath.c_str());
				}
			}
		}while(_findnext( hFile, &c_file ) == 0);
	}
	return true;
}

void SyncFolders(_bstr_t sDatabase,_bstr_t sProjPath,_bstr_t sLocalDir)
{
	IVSSDatabasePtr pDatabase;
	IVSSItemPtr pIRootItem;
	pDatabase.CreateInstance(_T("SourceSafe"));
	pDatabase->Open(sDatabase, _T(""), _T(""));
	pIRootItem = pDatabase->GetVSSItem(sProjPath, VARIANT_FALSE);
	pIRootItem->PutLocalSpec(sLocalDir);
	SyncItem(pIRootItem,sLocalDir);
}

void SyncItem(IVSSItem *pItem, _bstr_t sFolder)
{
	IVSSItemsPtr pItemColl;
	pItemColl = pItem->GetItems(VARIANT_FALSE);
	LONG nCount;
	nCount = pItemColl->Count;
	static nItemsGot=0;
	if (nCount)
	{
		_bstr_t sPath;
		IVSSItemPtr item;
		FileMapItor itor;
		for (LONG n = 1; n <= nCount; n++)
		{
			item = pItemColl->GetItem(n);
			switch (item->GetType())
			{
			case VSSITEM_FILE:
				{
					bool bGet=false;
					_bstr_t sFileName=sFolder+_bstr_t("/")+item->GetName();
					itor=g_mapFiles.find(_strlwr((TCHAR*)sFileName));
					if(itor!=g_mapFiles.end())
					{
						if(item->GetIsDifferent(sPath)==VARIANT_TRUE)
						{
							bGet=true;
						}
						g_mapFiles.erase(itor);
					}
					else
					{
						bGet=true;
					}

					if(bGet)
					{
						item->Get(NULL, VSSFLAG_REPREPLACE | VSSFLAG_TIMEMOD | VSSFLAG_RECURSYES | VSSFLAG_FORCEDIRNO);
						printf("\nGOT>>>%s[%05d]", (TCHAR *)sFileName,++nItemsGot);
					}
					else
					{
						printf(".", (TCHAR *)sFileName,++nItemsGot);
					}
				}
				break;
			case VSSITEM_PROJECT:
				{
	/////////////////////////////////////////
				_bstr_t sTempFolder;
				sTempFolder = sFolder + _bstr_t("/") + item->GetName();
				item->PutLocalSpec(sTempFolder);
				SyncItem(item, sTempFolder);
				}
				break;
			default:
				break;
			}
		}
	}
}
