// Sync.cpp : Implementation of CSync

#include "stdafx.h"
#include "Sync.h"
#include "Shlwapi.h"
#include <set>
#include <string>
#include <string.h>
#include <io.h>

#include "_AssmanX_i.c"


//const IID IID_ISync = __uuidof (ISync);

// CSync
HRESULT _ERROR(  const CLSID& clsid,
   LPCSTR lpszDesc,
   const IID& iid = GUID_NULL){
		 	 printf("ERROR %s\n",lpszDesc);
		 return AtlReportError (clsid, lpszDesc,iid);
	 }

STDMETHODIMP CSync::SetWorkingDir(BSTR localpath)
{
	m_sWorkingFolder=localpath;
	if(PathFileExists((TCHAR*)m_sWorkingFolder)==0)
	{
		_bstr_t errorstring=_bstr_t("the folder ")+localpath+_bstr_t("does not exists");
		return _ERROR (GetObjectCLSID(), (TCHAR*)errorstring,IID_ISync);
	}
	
	m_lstProjectList.clear();
	//chack if the folder exists
	return S_OK;
}

STDMETHODIMP CSync::AddProject(BSTR dbpath, BSTR projpath)
{
	_bstr_t db=dbpath;
	_bstr_t pj=projpath;
	m_lstProjectList.push_back(ProjectListItor::value_type((TCHAR*)db,(TCHAR*)pj));
	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CSync::DoIt()
{
	m_setFileMap.clear();
	if(m_sWorkingFolder==_bstr_t(""))
		return _ERROR (GetObjectCLSID(), "Error you must set a working folder",IID_ISync);

	if(m_lstProjectList.empty())
		return _ERROR (GetObjectCLSID(), "Error you must set a least 1 project",IID_ISync);

	try{
		printf("filling file map\n");
		FillFileMap((TCHAR*)m_sWorkingFolder);
		/////////////////////////////////////////////////////
		ProjectListItor itor=m_lstProjectList.begin();
		printf("Sync folders\n");
		while(itor!=m_lstProjectList.end())
		{
			printf("Sync %s %s [%s]\n",(const char*)itor->first,(const char*)itor->second,(TCHAR *)m_sWorkingFolder);
			SyncFolders( (const char*)itor->first,(const char*)itor->second,m_sWorkingFolder);
			++itor;
		}
	}
	catch(_com_error &e)
	{
		return _ERROR (GetObjectCLSID(), (TCHAR*)e.Description( ),IID_ISync);
	}

	//////////////////////////////////////////////////////////////////////////
	// Delete non existing files.
	//////////////////////////////////////////////////////////////////////////
	/*
	/////////////////////////////////////////////////////
	FileMapItor itor;
	itor=m_setFileMap.begin();
	while(itor!=m_setFileMap.end())
	{
		const CString &s=(*itor);
		if(std::string::npos==s.find(".scc"))
		{
			printf("REMOVING %s\n",s);
			::SetFileAttributes(s,FILE_ATTRIBUTE_NORMAL);
			if(::DeleteFile(s)==0)
			{
				int n=::GetLastError();
				int g=n;
			}
		}
		++itor;
	}
	*/

	return S_OK;
}

void CSync::FillFileMap( const CString &sPath )
{
	struct _finddata_t c_file;
	CString sSearchPattern=sPath+"/*.*";
	CString sFilePath;
	long hFile;
	if( (hFile = _findfirst(sSearchPattern, &c_file )) == -1L )
	{
		return;
	}
	else
	{
		do{
			if(!((!strncmp(c_file.name,".",1)) &&  ((c_file.attrib &_A_SUBDIR) && (strncmp(c_file.name,"_",1)))))
			{
				if(c_file.attrib & _A_SUBDIR)
				{
					FillFileMap(sPath+"/"+CString(c_file.name));
				}
				else
				{
					int i=0;
					sFilePath = sPath + CString("/") + c_file.name;
					sFilePath.MakeLower();
					m_setFileMap.insert(sFilePath);
				//	printf("inserting %s\n",sFilePath);
				}
			}
		}while(_findnext( hFile, &c_file ) == 0);
	}
	return;
}

void CSync::SyncFolders(_bstr_t sDatabase,_bstr_t sProjPath,_bstr_t sLocalDir)
{
	IVSSDatabasePtr pDatabase;
	IVSSItemPtr pIRootItem;
	pDatabase.CreateInstance(_T("SourceSafe"));
	pDatabase->Open(sDatabase, _T(""), _T(""));
	pIRootItem = pDatabase->GetVSSItem(sProjPath, VARIANT_FALSE);
	pIRootItem->PutLocalSpec(sLocalDir);
	SyncItem(pIRootItem,sLocalDir);
}

void CSync::SyncItem(IVSSItem *pItem, _bstr_t sFolder)
{
	IVSSItemsPtr pItemColl;
	pItemColl = pItem->GetItems(VARIANT_FALSE);
	LONG nCount;
	nCount = pItemColl->Count;
	static nItemsGot=0;
	if (nCount)
	{
		IVSSItemPtr item;
		FileMapItor itor;
		for (LONG n = 1; n <= nCount; n++)
		{
			item = pItemColl->GetItem(n);
			switch (item->GetType())
			{
			case VSSITEM_FILE:
				{
					//printf("." );
					bool bGet=false;
					_bstr_t sFileName=sFolder+_bstr_t("/")+item->GetName();
					if(FilePass((TCHAR *)sFileName))
					{
						itor=m_setFileMap.find(_strlwr((TCHAR*)sFileName));
						if(itor!=m_setFileMap.end())
						{
							_bstr_t sPath;
							if(item->GetIsDifferent(sPath)==VARIANT_TRUE)
							{
								bGet=true;
							}
							m_setFileMap.erase(itor);
						}
						else
						{
							bGet=true;
						}
					}
					if(bGet)
					{
						printf("\nGETTING>>>%s[%05d] ", (TCHAR *)sFileName,++nItemsGot);
						item->Get(NULL, VSSFLAG_REPREPLACE | VSSFLAG_TIMEMOD | VSSFLAG_RECURSYES | VSSFLAG_FORCEDIRNO);
						printf(" OK!" );
					}
					else
					{
						//printf(".", (TCHAR *)sFileName,++nItemsGot);
					}
				}
				break;
			case VSSITEM_PROJECT:
				{
	/////////////////////////////////////////
					_bstr_t sTempFolder=item->GetName();
					if(((TCHAR*)sTempFolder)[0]!=_T('_'))
					{
						sTempFolder = sFolder + _bstr_t("/") + item->GetName();
						item->PutLocalSpec(sTempFolder);
						SyncItem(item, sTempFolder);
						//printf("\nSync Dir: %s\n",(const char*)sTempFolder );
					}
				}
				break;
			default:
				break;
			}
		}
	}
}

STDMETHODIMP CSync::AddFileFilter(BSTR extension)
{
	_bstr_t t=extension;
	m_setFilters.insert((TCHAR *)t);

	return S_OK;
}

bool CSync::FilePass( const CString &filename )
{
	const TCHAR *s=filename;
	size_t len=filename.GetLength();
	if(len<=4)return true;
	FileMapItor itor=m_setFilters.begin();
	while(itor!=m_setFilters.end())
	{
		if((*itor)==((TCHAR *)&s[len-itor->GetLength()])) return false;
		++itor;
	}
	return true;
}