//																			Automated compiling system
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// This script will compile the code and report errors 
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//+++++++++++++++++++++++++|START|  *Globals for every project*  |START|+++++++++++++++++++++++++++++++++++++++++++++++++++++
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

try
{
// This will disable all important actions(update&processing of files) 
// in the build which allows to debug the script locally
var DEBUG = false;

// Create Shell objects.
var WSHSHELL = WScript.CreateObject("WScript.Shell");
var FSO = WScript.CreateObject("Scripting.FileSystemObject");
var WSHNETWORK = WScript.CreateObject("WScript.Network");
var WSHSYSENV = WSHSHELL.Environment("PROCESS");

var forReading = 1, forWriting = 2, forAppending = 8;
var tristateUseDefault = -2, tristateTrue = -1, tristateFalse = 0;

NoGUIApplication();

// Specify here your mail if you want to get error mails
var adminMail = "Denis@Crytek.de";
var admin2Mail ="Timur@crytek.de";
var admin3Mail ="Douglas@crytek.de";

// Script and System Folders
var systemDrive = WSHSYSENV("SYSTEMDRIVE");
var programFilesPath = systemDrive + "\\Program Files";
var programFilesPathx86on64bitOS = systemDrive + "\\Program Files (x86)";
var computerName = WSHNETWORK.ComputerName.toLowerCase();
var startedInPath = WSHSHELL.CurrentDirectory ;
var workingScriptPath = WScript.ScriptFullName;
var scriptName = "";
var scriptLocation = "";
var projectExt = "";
var regExp = /(.+)\\(.+)\..+$/i;
if(workingScriptPath.search(regExp) != "-1")
{
	scriptLocation = RegExp.$1;
	scriptName = RegExp.$2;
}
else
{
	ErrorExitWithMail("Could not get the directory or script name of the working script.");
}



	//-------------------------------------------------------------------------------------------------------------------------
	//-------------------|START|   *Process Command-Line parameters*   |START|-------------------------------------------------
	//-------------------------------------------------------------------------------------------------------------------------
	
	// Variables for catched Arguments
	var project = "Game02";
	var nameExtension = "";
	var exitIfNocodeChanges = true;
	var emailAdditions = "";
	var rc_Image_Arguments = "";
	var rc_Geometry_Arguments = "";
	var p4Label = "";
	// Defining the default type of Build
	var buildType = "Full";
	var buildCode = true;
	var buildArt  = true;
	// Options for the Build
	var useIncrediBuild = true;
	var buildConfigEditor = "Release64";
	var buildConfigEngine = "Profile";
	var fastBuild = true;
	var exitOnCompilingerror = true;
	var isBranchBuild = false;
	var autoTest = false;
	var vs_Version = 2005;
	var rebuildCode = false;
	var PS3 = false;
	var X360 = false;
	
	
	// Catch Name of the project to build
	if (WScript.Arguments.Named.Exists("project"))
	{	
		if (WScript.Arguments.Named.Item("project") == "Game02")
			project = "Game02";
		else if (WScript.Arguments.Named.Item("project") == "Game04")
			project = "Game04";
		else
			WScript.Echo("no project was given for ExitOnP4Check using default: "+project);
	}
	
	// Catch whether the code is needed to rebuild
	if (WScript.Arguments.Named.Exists("rebuildCode"))
	{	
		rebuildCode = true;
	}
	
	// Catching whether Build should continue on compilation error
	if (WScript.Arguments.Named.Exists("exitOnCompilingerror"))
	{
		var tempArg = WScript.Arguments.Named.Item("exitOnCompilingerror").toLowerCase();
		if( tempArg == "false")
			exitOnCompilingerror = false;
		else if(tempArg == "true")
			exitOnCompilingerror = true;
		else
			WScript.Echo("no correct boolean statement was given for exitOnCompilingerror. using default: "+exitOnCompilingerror);
	}
	
	// Catch which version of visual studio should be used for compiling
	if (WScript.Arguments.Named.Exists("VS03"))
	{
		vs_Version = 2003;
	}
	
	// Catching the Build Name Extension
	if (WScript.Arguments.Named.Exists("nameExtension"))
	{
		nameExtension = WScript.Arguments.Named.Item("nameExtension");
	}
	
	
	// Option for check of available Changes in Perforce
	if (WScript.Arguments.Named.Exists("ExitOnP4Check"))
	{
		if (WScript.Arguments.Named.Item("ExitOnP4Check") == "true")
			exitIfNocodeChanges = true;
		else if (WScript.Arguments.Named.Item("ExitOnP4Check") == "false")
			exitIfNocodeChanges = false;
		else
			WScript.Echo("no correct boolean statement was given for ExitOnP4Check using default: "+exitIfNocodeChanges);
	}
	
	
	// Additional Text to sent build Emails
	if (WScript.Arguments.Named.Exists("emailAdditions"))
	{
		emailAdditions = WScript.Arguments.Named.Item("emailAdditions");
	}
	// Replacing all "_" through spaces because Arguments cant have them inside
	do
	{
		emailAdditions = emailAdditions.replace("_", " ");
	}
	while(emailAdditions.search("_")!= -1)
	
		
	
	// Get the Label to which the data will be synced
	if (WScript.Arguments.Named.Exists("p4Label"))
	{
		p4Label = "@" + WScript.Arguments.Named.Item("p4Label");
	}
	
	
	// Getting the Buildtype
	if (WScript.Arguments.Named.Exists("buildType"))
		buildType = WScript.Arguments.Named.Item("buildType");
	else
		WScript.Echo("no build type was given, using default buildType: "+buildType);
		
	// Choosing the steps which will be done depending on Buildtype
	if (buildType == "Full")
	{
		buildCode = true;
		buildArt  = true;
	}
	else if (buildType == "Code")
	{
		buildCode = true;
		buildArt  = false;
	}
	else if (buildType == "Art")
	{
		buildCode = false;
		buildArt  = true;
	}
	else
		WScript.Echo("no correct build type was given, using default options.");
		WScript.Echo("buildCode : " + buildCode);
		WScript.Echo("buildArt: " + buildArt);
	
	// Option to enable/disable Incredibuild
	if (WScript.Arguments.Named.Exists("useIncrediBuild"))
	{
		if (WScript.Arguments.Named.Item("useIncrediBuild") == "true")
			useIncrediBuild = true;
		else if(WScript.Arguments.Named.Item("useIncrediBuild") == "false")
			useIncrediBuild = false;
		else
			WScript.Echo("no correct boolean statement was given for useIncrediBuild using default: "+useIncrediBuild);
	}
	
	
	// Option to enable/disable fastBuild
	if (WScript.Arguments.Named.Exists("fastBuild"))
	{
		if (WScript.Arguments.Named.Item("fastBuild") == "false")
			fastBuild = false;
		else if (WScript.Arguments.Named.Item("fastBuild") == "true")
			fastBuild = true;
		else
			WScript.Echo("no correct boolean statement was given for fastBuild using default: "+fastBuild);
	}
	
	// Get the buildConfig 
	if (WScript.Arguments.Named.Exists("buildConfigEditor"))
	{
		buildConfigEditor = WScript.Arguments.Named.Item("buildConfigEditor");
	}
	
	// Get the buildConfig 
	if (WScript.Arguments.Named.Exists("buildConfigEngine"))
	{
		buildConfigEngine = WScript.Arguments.Named.Item("buildConfigEngine");
	}
	
	
	// Get whether this build is a branch Build
	if (WScript.Arguments.Named.Exists("BranchBuild"))
	{
		isBranchBuild = true;
	}
	
	// Get if console code should be compiled
	if (WScript.Arguments.Named.Exists("PS3"))
	{
		PS3 = true;
	}	
	else if (WScript.Arguments.Named.Exists("X360"))
	{
		X360 = true;
	}
	
	
		
	//-------------------------------------------------------------------------------------------------------------------------
	//--------------------------|END|   Process Command-Line parameters   |END|------------------------------------------------
	//-------------------------------------------------------------------------------------------------------------------------




// Give an error if no project was selected
if(project=="")
{
	logFile = FSO.CreateTextFile( scriptLocation + "ERROR.log",true );           
	WScript.Echo( "error: No project was selected!" );
	logFile.WriteLine( "error: No project was selected!" );
	WScript.Quit(1);
}


if(PS3)
	projectExt = "_PS3";
else if (X360)
	projectExt = "_Xbox360";

// Folder where the buildfiles are located
var projectSysFilesLocation = scriptLocation + "\\" + project + projectExt + "\\";

// Define Names of Logs
var buildLog = "AutoCompile.log"
var logFile;
var numLogs = 0;
var p4Log = projectSysFilesLocation + project + "_Perforce.log";
var cppLog = projectSysFilesLocation + project + "_Cpp.log";
var needforceSyncOfCodeFile = projectSysFilesLocation + "NeedforceSyncOfCode.txt";

// Check if the necessary files for the buildprocess are available
if (FSO.FolderExists(projectSysFilesLocation ))
{
	loadedLogFile = FSO.CreateTextFile( projectSysFilesLocation  + buildLog,true );           
}
else
{
	FSO.CreateFolder(projectSysFilesLocation );
	loadedLogFile = FSO.CreateTextFile( projectSysFilesLocation + buildLog,true );           
	Log("error: Unable to load files which are necessary for the compiling e.g. code_changelist_number.txt from " + projectSysFilesLocation );
	WScript.Quit(1);
}

// Create error variables  
var result = 0;
var error = false;
var errorString = "";
var aErrFiles = new Array(projectSysFilesLocation + buildLog);
var aScsFiles = new Array(projectSysFilesLocation + buildLog);

// Which Sever will be used for sending mails
var mailServer= "mail2.INTERN.CRYTEK.DE";
var aEmptyArr = new Array();

// Timings for stopping times how long what takes in the Buildprocess
var startTime,endTime;
var startGetCodeTime,endGetCodeTime;
var startCompileTime,endCompileTime;

// Start Timer for whole buildprocess
startTime = new Date();


// Indicates if project was compiled
var resultOfCompilingProject = "";

// Variables for check of changed data in P4
var newCodeChangelistNumber = 0;
var codeChanges = "";
var foundCodeChanges = true;
var codeChangelistNumberLoad = true;

if(useIncrediBuild) 
	var buildConsole = CheckModule("Xoreax\\IncrediBuild\\buildConsole.exe");

if(vs_Version == 2005)
	var msDevStudio = CheckModule("Microsoft Visual Studio 8\\Common7\\Ide\\devenv.exe");
else if(vs_Version == 2003)
	var msDevStudio = CheckModule("Microsoft Visual Studio .NET 2003\\Common7\\Ide\\devenv.exe");


// Perforce.
var p4_User = "Build";
var p4CodeSrc = "//depot";
var p4AssetSrc = "//data";


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//+++++++++++++++++++++++++|END|  Globals for every project  |END|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//+++++++++++++++++++++++++|START|  *projectspecific Globals*  |START|+++++++++++++++++++++++++++++++++++++++++++++++++++++++
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


//----------------------------------Base variables-------------------------------------------
if(project == "Game02")
{
	if(computerName == "autocompile1")
	{
		// Choose the drives 
		var buildDrive = "E:";
		var branchDrive = "E:";
		
		var p4_Client = "AutoCompile_" +  project;
	}
	
	if(computerName == "8core")
	{
		// Choose the drives 
		var buildDrive = "E:";
		var branchDrive = "E:";
		
		var p4_Client = "AutoCompile_8core_" +  project;
	}
	
	var p4ProjCodeSrc = p4CodeSrc + "/Main/";
	var p4ProjAssetSrc = p4AssetSrc + "/Game02/";
	var p4RCSource = p4CodeSrc + "/Main/Bin32/rc/";
	
	var solutionName = "CryEngine.sln";		
	if(computerName == "8core")
		var solutionName = "CryEngineBuild.sln";		
	
	var buildMailingList = "FP_Build@crytek.de";
}
else if(project == "Game04")
{
	// Choose the drives 
	var buildDrive = "F:";
	var branchDrive = "F:";
	
	var p4_Client = "AutoCompile_" +  project;
	
	var p4ProjCodeSrc = p4CodeSrc + "/Main04/";
	var p4ProjAssetSrc = p4AssetSrc + "/Game04/";
	var p4RCSource = p4CodeSrc + "/Main04/Bin32/rc/";
	
	var solutionName = "CryEngine04.sln";		
	
	var buildMailingList = "G4_BUILD@crytek.de";
}

//---------------------------------------------------------------------------------------------


//----------------------------------Derived variables-----------------------------------------
// for local debugging
if(DEBUG)
	buildDrive = "f:";
else if(isBranchBuild) 
	buildDrive = branchDrive;

// Change source to label if one was given	
if(p4Label!="")
	p4ProjCodeSrc=p4Label;
		
// Necessary build folders 
var buildingFolder = buildDrive+"\\"+project+"_AutoCompile";

if(isBranchBuild)
{
	buildingFolder += "_Branch";
	p4_Client += "_Branch";
	p4ProjCodeSrc = p4CodeSrc;
	p4ProjAssetSrc = p4AssetSrc;
}
	
var codeFolder = buildingFolder+"\\Code";
var bin32Folder = buildingFolder+"\\Bin32";
var bin64Folder = buildingFolder+"\\Bin64";
var toolsFolder = buildingFolder+"\\Tools";
var buildGameDataFolder = buildingFolder+"\\Game";

// P4 sync command line
var p4_cmdLine = "p4" + " -c "+p4_Client + " -u "+p4_User + " sync";

// for local debugging
if(DEBUG)
{
	if(project == "Game02")
		buildingFolder = "f:\\Game02_build";
	else if(project == "Game04")
		buildingFolder = "f:\\Game04_build";
		
	buildMailingList = adminMail;
}
	

var projectCppWorkspace = codeFolder + "\\Solutions\\" + solutionName;
var editorPluginCppWorkspace = codeFolder + "\\Sandbox\\Plugins\\PerforcePlugin\\PerforcePlugin.sln";
var allCppProjects = "*";
var waterMarkDLL = bin32Folder+"\\CrySystem.dll";
var LUACompiler = "\"" + bin32Folder + "\\LuaCompiler.exe\"";
var SSH = "c:\\cygwin\\bin\\ssh.exe"
var SSH_key = projectSysFilesLocation + "key";
var SSH_login = "build@192.168.222.222";
var PS3_buildScript = "/var/build/build_filter.sh"

if(PS3 && !FSO.FileExists(SSH))
	throw new Error(0,"Module " + SSH + " could not be found.")

// Emailadresses where the emails are sent on specific situation
var aSuccessEmail = new Array(buildMailingList);
var aFailEmail = new Array(buildMailingList, adminMail);
var aFailEmailAdmins = new Array(adminMail,admin2Mail,admin3Mail);



//---------------------------------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//+++++++++++++++++++++++++|END|  projectspecific Globals  |END|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////






/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//+++++++++++++++++++++++++|START|  *FUNCTION DEFENITIONS*  |START|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This function will search and check a module at startup (e.g. Visual studio executable)
function CheckModule(modulePath)
{
	var programFilesPathForModule = programFilesPath + "\\" + modulePath;
	var programFilesPathx86on64bitOSForModule = programFilesPathx86on64bitOS + "\\" + modulePath;
	
	if(FSO.FileExists(programFilesPathForModule))
		return(programFilesPathForModule);
	else if (FSO.FileExists(programFilesPathx86on64bitOSForModule))
		return(programFilesPathx86on64bitOSForModule);
	else
		throw new Error(0,"Module \"<programFilesFolder>\\" + modulePath + "\" could not be found.")
}

// +++++++++++++++++++++++++For reading in other jscripts and then including them+++++++++++++++++++++++++
function ReadFile(file, create)
{ 
	var str = "";
	
	Log("Reading file: " + file + ". Create flag is: " + create.toString());
	
	if(!FSO.FileExists(file) && !create)
	{
		Log("Couldn't read file. It doesn't exists!");
		return str;
	}	
	
	try
	{
	  var fileToRead = FSO.OpenTextFile(file, 1, create);
	  if(!fileToRead.AtEndOfstream)
	  	str = fileToRead.ReadAll();
	  	
	  fileToRead.Close();
	  
	  if( str == "")
  		Log("File is empty!");
	}
	catch(e)
	{
		Log("Error while reading file " + e.description + " on file " + file);
	}  
  	
  return str;
}


//++++++++++++++++++++++Prevents this script to be started without a dos window+++++++++++++
function NoGUIApplication()
{  
	var scriptHost = WScript.FullName;
	var regExp = /cscript.exe/i
	if(scriptHost.search(regExp) == "-1")
	{
		WSHSHELL.Popup( "Invalid script Host - This application is made for commandline use only\n"+
	                    "Please start the script with \"cscript\" before the scriptname e.g.: cscript <ScriptName>\n",
	                    0,"Error",0);
	                    
	 	ErrorExitWithMail("Script was started with the wrong host");
	}
}

//+++++++++++++++++++++++++Will add email adresses to error mail recipients.+++++++++++++++++++++++++
function AddToErrorMailRecipients(emailAdress)
{
	var found = false;
	var eMailRegExp = new RegExp(emailAdress,"i");
			
	// Check if user is already in the final array
	for(i in aFailEmail)
	{
		if(aFailEmail[i].search(eMailRegExp) != "-1")
		{
			found = true;
			break;
		}
	}
	
	// Add if email adress is not in the final recipient array
	if(!found)
		aFailEmail.push(emailAdress);
}

//+++++++++++++++++++++++++Will add email adresses of users who checked in sice last compilation to error mail recipients.+++++++++++++++++++++++++
function SearchAndAddErrorRecipients(changes)
{
	Log("Starting to search for users who checked in sice last compilation and add them to error mail recipients.");
	
	var aUsers = new Array();
	var regExpFindUser = /^Change\s\d+\son.+by\s(\w+)@.*/i;
	
	// Split changes in lines
	var aChanges = changes.split("\n");
	
	Log("Searching for users...");
	// Search in every line
	for(nr in aChanges )
	{		
		// if a user was found in a line
		if(aChanges[nr].search(regExpFindUser) != "-1")
		{
			var found = false;
			var p4User = RegExp.$1;
			var p4UserRegExp = new RegExp(p4User,"i");
			
			// Check if user is already in the final array
			for(i in aUsers)
			{
				if(aUsers[i].search(p4UserRegExp) != "-1")
				{
					found = true;
					break;
				}
			}
			
			// Add found user to the final user array
			if(!found)
				aUsers.push( p4User);
		}
	}
	
	Log("Following users checked in since last compilation: " + aUsers.toString());
	
	Log("Getting email addresses from users and adding them to recipients");
	
	// get email of users and add it to the recipients
	for(userNr in aUsers )
	{	
		//-------------Get information about the user which checked in-----------------------------------------
		var cmdline = "p4 user -o " + aUsers[userNr];
		var oExec = WSHSHELL.Exec( cmdline );
		var userInfo = oExec.StdOut.ReadAll();
		//-------------------------find the email adress of user and add him to the recipients------------------------------------
		var email_firstpos = userInfo.lastIndexOf("Email");
		email_firstpos = email_firstpos + 7;
		var email_lastpos = userInfo.lastIndexOf("Update");
		var userMail = userInfo.slice(email_firstpos, email_lastpos);
		
		AddToErrorMailRecipients(userMail);
	}
	Log("All needed users were addeed to the recipients of the error mail.\nCurrent recipients are:\n" + aFailEmail.toString());
}


//+++++++++++++++++++++++++Checking wheter new changes are available in P4 or not+++++++++++++++++++++++++
function CheckForCodeChanges()
{		
		Log("Checking for changes in the Code database...");
		var lastCodeChangelistNumber = ReadChangelistNumberFromFile(projectSysFilesLocation + "code_changelist_number.txt");
		if(lastCodeChangelistNumber!="")
		{
			codeChanges = GetPerforceChanges(p4ProjCodeSrc, lastCodeChangelistNumber);
			if(codeChanges!="")
			{
				// Get the latest changelist number
				var cl_NumberRegExp = /^Change\s(\d+)\son.*/i;
				codeChanges.search(cl_NumberRegExp);
				newCodeChangelistNumber = RegExp.$1;
				
				// Add all who checked in since the last compilation to the recipients of the error mail
				if(!DEBUG)
					SearchAndAddErrorRecipients(codeChanges);
				else
					Log("Skipping AddRecipientsToErrorMail function because you are in debug mode!");
				
				Log("Changes were found in the Code database, starting compiling.");
			}
			else
			{	
				Log("No changes were found in the Code database or maybe the wrong changelistnumber was given.");
				foundCodeChanges = false;
				newCodeChangelistNumber = lastCodeChangelistNumber;
				if (exitIfNocodeChanges)
				{				
					WScript.Quit(0);
				}
			}
		}
		else
		{
			codeChangelistNumberLoad = false;
			aSuccessEmail.push(adminMail);
			emailAdditions += "\r\nCould not load the last changelistnumber from code_changelist_number.txt. Because of this the code_changes.txt was not updated";
			Log("Could not load the last changelistnumber from code_changelist_number.txt");
		}
}

//+++++++++++++++++Execute "P4 changes" with given parameters++++++++++++++++++
function GetPerforceChanges(PerforcePath, ChangelistNumber)
{
		//--check for new changes
		// Execute the command line which will give the changes
		var cmdline = "p4" + " -c "+p4_Client + " -u " + p4_User + " changes -l -t -s submitted " + PerforcePath + "...@" + ChangelistNumber + ",@now";		
		var oExec = WSHSHELL.Exec( cmdline );
		var changeListInfo = oExec.StdOut.ReadAll();
		return(changeListInfo);
}

//++++++++++++++++++++++++++Save Last changelistnumber++++++++++++++++++++++++++
function SaveChangelistNumberToFile(filePath , changelistNumber)
{
	FSO.CreateTextFile( filePath,true)
	var changeListFile = FSO.GetFile( filePath );
	var stream = changeListFile.OpenAsTextstream( forWriting,tristateUseDefault );
	stream.Write(changelistNumber);
	stream.Close();
}

//++++++++++++++++++++++++++Read Last changelistnumber++++++++++++++++++++++++++
function ReadChangelistNumberFromFile( filePath )
{ 
	if(FSO.FileExists( filePath ))
	{	
		//--Read the Last changelistnumber of change which was in the latest build--
		var tempText = ReadFile(filePath, true);
		var output = parseInt(tempText);
		if (isNaN(output))
			output = ""; 
		else // Increment the changelistnumber so only new changes will be shown
			output++;
		
		return(output);
	}	
	else
	{
		return("");
	}
	
}


//+++++++++++++++++++++++++Get build number and create folderds+++++++++++++++++++++++++++++++
function Init()
{
	if(!PS3)
		CheckAllDirLinks();

	// Log when build started.
	startTime = new Date();
	var logBuildStartedLine ="\r\n";
	// Change the loging line depending on kind of build
	if (fastBuild)
	{
		logBuildStartedLine += "Fast ";
	}

	
	if(isBranchBuild)
		logBuildStartedLine +=" Branch";
	
	// Add some Dates to logline
	logBuildStartedLine += " compiling started at " + GetDateString() + ", " + GetTimeString();
	Log(logBuildStartedLine);
		
	
	// Some output for the user of the sources and targets
	Log("\r\nCode Source = "+codeFolder);
	
	if(!PS3)
		// Will check for enough space on all needed drives and free space on the storage drive if needed
		CheckHDSpace(false);

	// Delte the temporary files
	DeleteTemporary();
	
	// Make folders depending on which build is started
	if(!fastBuild && !DEBUG && !PS3)
	{
		MakeFolder( buildingFolder );
		MakeFolder( buildGameDataFolder );
	}
}

// Collection of links to check
function CheckAllDirLinks()
{
	if(!DEBUG)
	{
		if(!CheckLinkToDir(buildingFolder,false))
		{
			Log("ERROR! A major working path does not exists: " + buildingFolder); 
			Log("Changing build type to a NON fastbuild because of that!");
			fastBuild = false;
		}
	}
}

// Will check if link exists and quit if not
function CheckLinkToDir(path,errorExit)
{
	if(!FSO.FolderExists(path))
	{
		if(errorExit)
		{
			ErrorExitWithMail( "ERROR! A major working path does not exists: " + path + ".\n" , aFailEmail , aErrFiles );
			WScript.Quit(1);
		}
		else
			return false;
	}
	else 
		return true;
}



//+++++++++++++++++++++++++Will check for enough space on all needed drives and free space on the storage drive if needed+++++++++++++++++++++++++
function CheckHDSpace(silentMode)
{
	CheckBuildSpace();
}


//++++++++++++++++++++++Is sending mails and will interrupt the build if not enough space++++++++++++++++++++++
function CheckBuildSpace()
{
	// Get the available space
	var driveName = FSO.GetdriveName(buildDrive);
	var oDrive = FSO.GetDrive(driveName);
	var freeMb = Math.round(oDrive.FreeSpace/1024/1024);

	// Check if one gig is free
	if(freeMb < 1024)
	{
		// Check if free space is more than 200 Mb
		if(freeMb > 200)
		{
			// Send notification mail
			var mailMessage = "WARNING: Only " + freeMb + " Mb left on Drive " + driveName + ". Please free some space!";
			SendMail( aFailEmail,mailMessage,"LOW SPACE WARNING on computer " + computerName,aEmptyArr,2 );
		}
		else
		{
			ErrorExitWithMail( "ERROR: Not enough space on drive " + driveName + " ! Couldn't contuniue building.Please free some space!" , aFailEmail , aErrFiles );
		}
	}	 	
}



//+++++++++++++++++++++++++Function to get latest code from perforce+++++++++++++++++++++++++
function PerforceSync(source, force)
{
	var options = "";
	if (force) options += " -f";
	
	
	Log("Start syncing with perforce with following command:");
	var cmdline = p4_cmdLine + options + " " + source + "...";
	Log( cmdline );
	WSHSHELL.Run( cmdline,1,true );
}

//++++++++++++++++++Will set/get whether a force sync is neeeded on next fast build++++++++++++++
function NeedforceSyncOfCode(ForceSyncInNextBuild)
{
	if(ForceSyncInNextBuild==true)
	{
		Log("Setting the flag for force sync of Code on next fast build");
		FSO.CreateTextFile( needforceSyncOfCodeFile,true );  
		var loadedneedforceSyncOfCodeFile = FSO.GetFile( needforceSyncOfCodeFile );   
		var stream = loadedneedforceSyncOfCodeFile.OpenAsTextstream( forWriting,tristateUseDefault );
		stream.Write("yes");
		stream.Close();
	}
	else if(ForceSyncInNextBuild==false)
	{
		Log("Deleting the flag for force sync of Code on next fast build");
		FSO.CreateTextFile( needforceSyncOfCodeFile,true );  
		var loadedneedforceSyncOfCodeFile = FSO.GetFile( needforceSyncOfCodeFile );   
		var stream = loadedneedforceSyncOfCodeFile.OpenAsTextstream( forWriting,tristateUseDefault );
		stream.Write("no");
		stream.Close();
	}
	else if(!ForceSyncInNextBuild)
	{
		if (FSO.FileExists( needforceSyncOfCodeFile ))
		{
			try
			{
				Log("Loading NeedforceSyncOfCode file from: " + needforceSyncOfCodeFile);
				var output = ReadFile(needforceSyncOfCodeFile, false);
				output = output.toLowerCase();
				if(output=="yes")
				{
					return(true);
				}
				else if(output=="no")
				{
					return(false);
				}
				else
				{
					Log("WARNING: Value in File \""+needforceSyncOfCodeFile+"\" is not valid and can't be handlet");
					return(true);
				}
			}
			catch(e)
			{
				Log("WARNING: This problem \"" + e.description + "\" occured during accessing the file \"" + needforceSyncOfCodeFile + "\"");
				return(true);
			}
			
		}
		else
		{
			Log("WARNING:Could not find flag file which says whether a force sync of code is needed from:"+needforceSyncOfCodeFile);
			return(true);
		}
	}
	else
		Log("ERROR: Wrong parameter was given to function NeedforceSyncOfCode. Only alowed values are true, false or no argument");
}


//+++++++++++++++++++++++++will return the errors of a incredibuild generated cpp file+++++++++++++++++++++++++
function ParseErrorLines(errorFile)
{
	var logAsStr = "";
	var foundErrors = "";
	
	logAsStr = ReadFile( errorFile, false );
	if(logAsStr == "")
		return("Can't parse the error lines because the log is empty");
	else
	{
		var aLogs = logAsStr.split("\r\n");
		if(PS3)
			var regExp = /(?:error:|undefined reference)/i;
		else
			var regExp = /error C\d+/i;
			
		for(line in  aLogs)
		{
			if(aLogs[line].search(regExp) != "-1")
			{
				foundErrors += "\r\n" + aLogs[line];
			}
		}
	}
	
	
	if(foundErrors == "")
		return("The error can be found in the attached file Game02_cpp.log");
	else
		return foundErrors;
}


//+++++++++++++++++++++++++Compile project using Incredebuild/MSDevStudio+++++++++++++++++++++++++
function CompileLUAScripts()
{
	Log("Compiling LUA");
	var LUAreturn = "";
	var t0 = new Date();
	
	// Get array of lua files
	var regExp = /.lua$/i;
	var aLUAfiles = FindFiles(buildGameDataFolder + "\\Scripts04",regExp );

	// Compile every file
	for(script in aLUAfiles)
	{
		var cmdLine = LUACompiler + " \"" + aLUAfiles[script] + "\"";
		if(!DEBUG)
		{
			var oExec = WSHSHELL.Exec( cmdLine );
			LUAreturn += oExec.StdErr.ReadAll();
		}
	}
	LogTime( t0 );
	
	if(LUAreturn != "")
	{
		var temp = "\r\nFound error while compiling LUA scripts:";
			
		temp += "\r\n" + LUAreturn;
		
		if(exitOnCompilingerror)
		{			
			if(project=="Game02" && !DEBUG)
			{
				AddToErrorMailRecipients("Timur@crytek.de");
				AddToErrorMailRecipients("Martin@crytek.de");
				AddToErrorMailRecipients("Craig@crytek.de");
				AddToErrorMailRecipients("MarcoK@crytek.de");
			}
			else if(project=="Game04" && !DEBUG)
				AddToErrorMailRecipients("nickh@crytek.de");	
				
			var noAttachment = new Array();
			MailFailure(temp , aFailEmail , noAttachment );
		}
		else
		{
			emailAdditions += "\r\n\r\n" + temp;
		}
	}
	else
		Log("Compiling of LUA was succesful");
}


//+++++++++++++++++++++++++Returns an array of absolute paths of files matching the given regular expression+++++++++++++++++++++++++
function FindFiles(root, searchRegExp)
{
	var aFoundFiles = new Array();
	// make sure directory exists
  if (FSO.FolderExists(root))
  {
  	oFolder = FSO.GetFolder(root);
  	eFiles = new Enumerator(oFolder.files);
  	for (; !eFiles.atEnd(); eFiles.moveNext())
		{
			var tempItem = eFiles.item();
			tempItem += "";
			if(tempItem.search(searchRegExp) != "-1")
		  	aFoundFiles.push(tempItem);
		}
	
		var eSubFolders = new Enumerator(oFolder.SubFolders);
		for (; !eSubFolders.atEnd(); eSubFolders.moveNext())
		{
			tempItem = eSubFolders.item();
			aFoundFiles = aFoundFiles.concat(FindFiles(tempItem, searchRegExp));
		}
  }
  return(aFoundFiles);
}


//+++++++++++++++++++++++++Compile project using Incredebuild/MSDevStudio+++++++++++++++++++++++++
function CompileProject(  workspace , projectToCompile , config , notifyOnExit , rebuildIntern)
{
	resultOfCompilingProject = 0;
	
	Log( "Compiling Solution: " + workspace + " In Configuration: " + config );
	var cmdLine;
	
	if (PS3)
	{
		cmdLine = "\"" + SSH + "\" -i \"" +  SSH_key + "\" " + SSH_login + " " + PS3_buildScript + " " + config + " @" + newCodeChangelistNumber;
		if(rebuildIntern)
			cmdLine += " full";
		else
			cmdLine += " fast";
	}
	else if (useIncrediBuild)
	{
		cmdLine = "\"" + buildConsole + "\" " + workspace + " /Cfg=\"" + config + "\" /Prj=" + projectToCompile + " /Wait /BrowseInfo=OFF /Log=" + cppLog+ " /ALL";
		if(rebuildIntern)
			 cmdLine += " /Rebuild"
			 
		//cmdLine = buildConsole + " "+workspace+" /Cfg=\"" + config + "\" /Prj=* /BrowseInfo=OFF /Log=" + cppLog;
	}
	else
	{
		var buildTypeForVS = "/Build";
		if(rebuildIntern)
			 buildTypeForVS = "/Rebuild";
			 
		cmdLine = "\"" + msDevStudio + "\" \"" + workspace + "\" " + buildTypeForVS + " \""+config + "\" /Out \"" + cppLog + "\"";
	}
	
	//var cmdLine = msDevStudio + " " + workspace + " /MAKE "+project+" - "+config + " /REBUILD /OUT " + cppLog;
	Log( cmdLine );
	// # //c/msdev/common/MsDev98/bin/msdev $CPP_PROJECT /MAKE RELEASE /OUT cppbuild.log
	var t0 = new Date();
	
	if(PS3)
	{
		// Search string for error code
		var regExpErrorCode = /@@returncode:(\d+)/i;
				
		// PS3 compilation
		var oExec = WSHSHELL.Exec( cmdLine );
		// Get output of the compilation
		var compileOutput = oExec.StdOut.ReadAll();
		
		// Write it into the cpplog file
		openedCppLog = FSO.CreateTextFile(  cppLog ,true );
		openedCppLog.Write(compileOutput);
		openedCppLog.Close();
		
		// Search the output for the return code
		if(compileOutput.search(regExpErrorCode) != "-1")
			resultOfCompilingProject = RegExp.$1;
		else
			resultOfCompilingProject = 4;
			
		compileOutput = "";
	}
	else
		resultOfCompilingProject = WSHSHELL.Run( cmdLine,1,true );
		
		
	Log("Exit Code of Compiler: " + resultOfCompilingProject);
	
	if (resultOfCompilingProject != 0 )
	{	
		if(notifyOnExit)
		{	
			var temp = "Error while compiling Workspace: "+ workspace + " In Configuration: " + config;
			
			if(resultOfCompilingProject == 1)
				temp += "\r\nErrors were encountered during the compiliation. Please investigate the Problem and fix it.";
			else if(resultOfCompilingProject == 2)
				temp += "\r\nA fatal build error was encountered (Invalid parameters, input file not found etc.). Please investigate the Problem and fix it.";
			else if(resultOfCompilingProject == 3)
				temp += "\r\nThe operation was stopped by user before completing. Please investigate the Problem and fix it.";
			else if(resultOfCompilingProject == 4)
				temp += "\r\nCouldn't find any return code in the output of the PS3 compilie.";
				
			temp += "\r\n\r\nList of found errors: " + ParseErrorLines(cppLog);
			
			if(workspace==editorPluginCppWorkspace)
			{
				var aCppLog = new Array(cppLog);
				var aPluginErrReciepients = aFailEmail;
				if(!DEBUG)
					aPluginErrReciepients.push("sergiys@crytek.de");		
					
				// Send notification mail
				emailAdditions += temp;
				SendMail( aPluginErrReciepients,temp,"WARNING: The Editor plugin could not be compiled in Configuration: " + config,aCppLog,2 );
			}			
			else if(exitOnCompilingerror)
			{
				if(resultOfCompilingProject == 1)
				{														
					if(project=="Game02" && !DEBUG)
					{
						AddToErrorMailRecipients("Timur@crytek.de");
						AddToErrorMailRecipients("Martin@crytek.de");
						AddToErrorMailRecipients("Craig@crytek.de");
						AddToErrorMailRecipients("MarcoK@crytek.de");
					}
					else if(project=="Game04" && !DEBUG)
						AddToErrorMailRecipients("nickh@crytek.de");
				}
				else
					// reset mail recipients to admins if no compilation error
					aFailEmail = aFailEmailAdmins;
				
				if(PS3)
				{
					AddToErrorMailRecipients("Michaelg@crytek.de");
					AddToErrorMailRecipients("SaschaD@crytek.de");
					AddToErrorMailRecipients("MichaelK@crytek.de");
				}
					
				var aCompileLogFile = new Array(cppLog);
				
				MailFailure(temp , aFailEmail , aCompileLogFile, null,  config );
			}
			else
			{
				emailAdditions += "\r\n\r\n" + temp;
			}
		}
		return false;
	}
	
	LogTime( t0 );
	return true;
}


//+++++++++++++++++++++++++Final Operation e.g logging the timings for the build+++++++++++++++++++++++++
function EndLog()
{
	endTime = new Date();
	
	Log("\r\n-------------------------------------------------------------------------");   	
	Log( "Build ended at " + GetDateString() + ", " + GetTimeString()  );

	if (buildCode)
	{	
		if(!PS3)
			Log( "Code Retrieve Time: "+GettimeDiff(startGetCodeTime,endGetCodeTime) );
			
		Log( "Compile Time: "+GettimeDiff(startCompileTime,endCompileTime) );
	}
	
	
	Log( "Total Build Time: "+GettimeDiff(startTime,endTime) );
	Log("Build succesfully finished.");
	Log("-------------------------------------------------------------------------\r\n");
	
	// Log Success event.
	WSHSHELL.LogEvent( 0, "Automated Build Completed Successfully" );											
}



//+++++++++++++++++++++++++Function for writing to the log+++++++++++++++++++++++++
function Log(str) 
{
	var couldNotLog = "   (Could not write this line to log file)";
	
	if(loadedLogFile != null)
	{
		try
		{
			loadedLogFile.WriteLine( str );
		}
		catch(e)
		{
			str += couldNotLog;
		}
	}
	else 
		str += couldNotLog;
		
	WScript.Echo( str );
}

//+++++++++++++++++++++++++Logs an error and send a mail if something goes wrong+++++++++++++++++++++++++
function ErrorExitWithMail( ErrStr , aErrRecipients , aErrLogs )
{
	errorString =ErrStr;
	error = true;
	Log ( errorString );
	WSHSHELL.LogEvent( 1, "Automated compilation Failed." );
	WSHSHELL.LogEvent( 1,errorString );
	MailFailure(ErrStr , aErrRecipients , aErrLogs );
	ErrorExit(errorString);
}


//+++++++++++++++++++++++++Logs an error and exits if something goes wrong+++++++++++++++++++++++++
function ErrorExit(ErrStr)
{
	WScript.Echo (  ErrStr  );
	WScript.StdErr.Write("<ReturnCode:1>");
	WScript.Quit(1);
}


//+++++++++++++++++++++++++Logs time of operation and elapsed time since start of build.+++++++++++++++++++++++++
function LogTime( t0 )
{
	var tnow = new Date();
	Log( "Done in "+GettimeDiff(t0,tnow) );
	Log( "Elapsed time since build start: "+GettimeDiff(startTime,tnow) );
	Log("");
}


//+++++++++++++++++++++++++Send a mail if the build failes+++++++++++++++++++++++++
function MailFailure( ErrMailStr , aErrMailRecipients , aErrMailLogs , scriptLogObjectForClose, subjectConfigExt)
{
	// Send build failure Message.
	var str = " ";
	
	if(subjectConfigExt == null)
		subjectConfigExt = "";	
	else
		subjectConfigExt = " in config \"" + subjectConfigExt + "\"";
	
	if (fastBuild) str = " fast ";
	var msg = "Automated"+str+"compilation at "+GetDateString()+", "+GetTimeString()+" failed.";
	
	msg += "\r\n"+ErrMailStr;

	if( emailAdditions != "")
	{
		msg += "\r\n\r\nAdditional informations:\r\n" + emailAdditions;
	}
	
	if(subjectConfigExt != "")
		var mailsubject = "Failed to compile " + solutionName + subjectConfigExt;
	else
		var mailsubject = "Failed to complete automated compilation on pc " + computerName;
	
	SendMail( aErrMailRecipients,msg,mailsubject,aErrMailLogs,2 ,scriptLogObjectForClose);
}

//+++++++++++++++++++++++++Mainfunction for sending mails+++++++++++++++++++++++++
function SendMail( recipient,msg,subject,attachmentsArray,importance, scriptLogObjectForClose )
{
	Log( "Sending Mail to "+recipient+",\n With subject: "+subject );
	
	if(scriptLogObjectForClose != null)
		scriptLogObjectForClose.Close();

	var cdoConfig = new ActiveXObject("CDO.Configuration");
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2; //cdoSendUsingPort
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 1; //cdoBasic
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserver") = mailServer;
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = 25;
	cdoConfig.Fields.Update();

	var cdoMessage = new ActiveXObject( "CDO.Message" );
	cdoMessage.Configuration = cdoConfig;

	cdoMessage.subject = subject;
	cdoMessage.From = "Build@crytek.de";
	cdoMessage.To = recipient;
	cdoMessage.TextBody = msg;

	var i;
	for (i = 0; i < attachmentsArray.length; i++)
	{
		if (FSO.FileExists( attachmentsArray[i] ))
		{
			cdoMessage.AddAttachment( attachmentsArray[i] );
		}
	}

	try
	{
		cdoMessage.Send();
	}
	catch(e)
	{
		Log("The following error occured while trying to send a mail:\r\n"+e.description);
		Log("\r\nMail properties:\r\nSubject:\r\n" + subject + "\r\nMessage:\r\n"+msg+"\r\n\Recipient:\r\n"+recipient);
	}
	cdoConfig = null;
	cdoMessage = null;
}

//+++++++++++++++++++++++++Get difference between Time1 and Time2+++++++++++++++++++++++++
function GettimeDiff( t0,t1 )
{
	var timeDiff = t1.getTime() - t0.getTime();
	var secMilli = 1000;
	var minMilli = 1000 * 60;
	var hrMilli = minMilli * 60;
	var dyMilli = hrMilli * 24;
	
	var t,h,m,s;
	t = timeDiff;
	h = Math.floor( t / hrMilli);
	t = timeDiff % hrMilli;
	m = Math.floor( t / minMilli );
	t = t % minMilli;
	s = Math.floor( t / secMilli );
	var str = ""+h+"h:"+m+"m:"+s+"s";
	return str;
}

//+++++++++++++++++++++++++Get date+++++++++++++++++++++++++
function GetDateString(givenDate)
{
	var d = "";
	if(givenDate != null)
		d = givenDate;
	else
		d = new Date();
		
	return d.getDate() + "/" + (d.getMonth()+1)+"/"+d.getYear();
}



//+++++++++++++++++++++++++Get Time function+++++++++++++++++++++++++
function GetTimeString(givenDate)
{
	var d = "";
	var c = ":";
	
	if(givenDate != null)
		d = givenDate;
	else
		d = new Date();
	 
   var s = d.getHours() + c + d.getMinutes() + c + d.getSeconds();
   return(s);
}

//+++++++++++++++++++++++++Function for deleting files+++++++++++++++++++++++++
function DeleteFiles( FileSpec , recursive )
{
	Log( "Delete Files: "+FileSpec );
	var cmdLine ="cmd /c del "+FileSpec+" /F /Q";
	if(recursive)
		cmdLine += " /S";
		
	result = WSHSHELL.Run( cmdLine, 1, true );
	if(result != 0)
		ErrorExitWithMail( "error: Deleting couldn't be finished correctly"  , aFailEmail , aErrFiles );
}

//+++++++++++++++++++++++++Function for making folders+++++++++++++++++++++++++
function MakeFolder( folder )
{
	//WSHSHELL.Run( "cmd /E:ON /C mkdir "+folder,1,true );
	if (FSO.FolderExists(folder) == false)
	{
		Log( "Making Folder: "+folder );
		try
		{
			FSO.CreateFolder(folder);
		}
		catch(e)
		{
			Log("Warning: "+folder+e.description);
		}
	}
}



//+++++++++++++++++++++++++Delete and check if it was succesful+++++++++++++++++++++++++
function DeleteAndCheck(path,isFile) 
{
	if(isFile==true)
	{
		if (FSO.FileExists( path ))
		{
			try
			{
			FSO.DeleteFile( path );
			Log("Successful deleted "+path );
			return true;
			}
			catch(e)
			{
				Log(e.description + " on: " + path);
				return false;
			}
		}
		else
		{
				Log("Could not find file for deleting:"+path);
				return true;
		}
	}
	else if(isFile==false)
	{
		if (FSO.FolderExists( path ))
		{
			try
			{
			FSO.DeleteFolder( path, true );
			Log("Successful deleted "+path );
			return true;
			}
			catch(e)
			{
				Log(e.description + " on: " + path);
				return false;
			}
		}
		else
		{
				Log("Could not find folder for deleting:"+path);
				return true;
		}
	}
	else
		Log("Function \"DeleteAndCheck\"Could not figure out of the argument given if path is an file or a folder")
}
	
//+++++++++++++++++++++++++Delete all temporary files.+++++++++++++++++++++++++
function DeleteTemporary() 
{
	Log("\r\nDeleting Temporary Files");
	DeleteAndCheck(cppLog,true);
		
	if (fastBuild || DEBUG || PS3)
		return;

	if(!DeleteAndCheck(buildingFolder,false))
		ErrorExitWithMail("Could not clean up the compile directory!(" + buildingFolder + ")\r\nThis can have several reasons e.g. a program is accessing the folder. Please solve the problem and restart the build.", aFailEmail , aErrFiles );

	Log("");
  return;
}

//+++++++++++++++++++++++++Function for executing commandlines+++++++++++++++++++++++++
function ExecuteCommandLine( cmdLine ) 
{
	Log( cmdLine );
	var newcmdLine = "cmd /c " + cmdLine;
	WSHSHELL.Run( cmdLine,1,true );
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//+++++++++++++++++++++++++++++|END|  FUNCTION DEFENITIONS  |END|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////






/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//+++++++++++++++++++++++++++++++++++++++++|START|  *MAIN*  |START|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Goto batch mode.
WScript.Interactive = true;

Log("Automated compiling system");
Log("*******************************************");
Log("For bugs and comments: Denis@Crytek.de\r\n\r\n");

if(DEBUG)
	Log("\r\n---You are in DEBUG mode!!!!---\r\n");

if(buildType!="Art" && isBranchBuild == false)
{
	CheckForCodeChanges();
}

Init();

//--------------------------Getting stuff from Perforce--------------------------
if (buildCode && !PS3)
{
	Log("\r\n-------------------------------------------------------------------------");
	startGetCodeTime = new Date();
	
	// Get the flag which says if a force sync is needed
	var forceSyncOfCode = NeedforceSyncOfCode();
	
	// Do a force sync and set the flag to "no sync needed"
	if(!DEBUG)
	{
		if(forceSyncOfCode==true)
		{
			PerforceSync( p4ProjCodeSrc , true);
			NeedforceSyncOfCode(false);
		}
		else
 			PerforceSync( p4ProjCodeSrc, !fastBuild);
	}
	
	endGetCodeTime = new Date();
	Log("-------------------------------------------------------------------------\r\n");	
}

//----------------------------------Compile project------------------------------
if (buildCode)
{
	Log("\r\n-------------------------------------------------------------------------");
	Log("Compiling Code.");
	startCompileTime = new Date();

	if(!DEBUG)
	{		
		if(!PS3 && !X360)
			// Compile Editor plugin in 64 bit		
			CompileProject( editorPluginCppWorkspace, allCppProjects, buildConfigEditor + "|x64" , true, rebuildCode);
		
		if(project == "Game02")
		{
			var defaultBuildConfigEngine = buildConfigEngine + "|x64";
			
			if(PS3)
				defaultBuildConfigEngine = "PS3-debug";
			else if (X360)
				defaultBuildConfigEngine = buildConfigEngine + "|Xbox 360";

				// Compile whole solution in 64 bit by default
				CompileProject( projectCppWorkspace, allCppProjects, defaultBuildConfigEngine , true, rebuildCode);
		}
		else if(project == "Game04")
		{
			// Compile whole solution in 32 bit
			CompileProject( projectCppWorkspace, allCppProjects, buildConfigEngine + "|Win32" , true, rebuildCode);
			
			CompileLUAScripts();
		}
	}
	
	endCompileTime = new Date();
	Log("-------------------------------------------------------------------------\r\n");
}

//---Extrakting and saving of Changelistnumber
if(buildType!="Art" && isBranchBuild==false && !DEBUG)
{
	if(foundCodeChanges)
	{	
		Log("Saving the new code changelistnumber");
		SaveChangelistNumberToFile(projectSysFilesLocation + "code_changelist_number.txt" , newCodeChangelistNumber);
	}
}	


EndLog();

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//+++++++++++++++++++++++++++++++++++++++++|END|  ~MAIN~  |END|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


}
catch(e)
{
	WScript.Echo("error: "+e);
	WScript.Echo("error number: "+e.number & 0xFFFF);
	WScript.Echo("error description: "+e.description);
	errorLogFile = FSO.CreateTextFile(  scriptLocation + "\\" + scriptName + "_ERROR" + projectExt + ".log",true );
	errorLogFile.WriteLine("error: "+e);
	errorLogFile.WriteLine("error number: "+e.number & 0xFFFF);
	errorLogFile.WriteLine("error message: "+e.message);
	errorLogFile.WriteLine("error description: "+e.description);
	errorLogFile.WriteLine("Trying to send out a mail with the log as last step");
	errorLogFile.Close();
	aErrFiles.push(scriptLocation + "\\" + scriptName + "_ERROR" + projectExt + ".log");
	SendMail( aFailEmailAdmins,"Build failed because of an error in build script!","Auto compile failed",aErrFiles,2 ,loadedLogFile);
	ErrorExit("Build failed because of an error in build script!");
}