#include "stdafx.h"
#include "AutoRunCDApp.h"
#include "Utilities.h"
#include "resource.h"



using namespace std;



static bool
IsProgramInstanceAlreadyRunning()
{
	// try to create named mutex, will be used to enforce only on instance of this app
	HANDLE hMutex( CreateMutex( 0, TRUE, _T( "AutoRunCD" ) ) );
	return( hMutex != 0 && ERROR_ALREADY_EXISTS == GetLastError() );
}


static void SetCurrentWorkingDirectory()
{
	TCHAR path[MAX_PATH+1];
	path[MAX_PATH-1] = _T('\0'); path[MAX_PATH] = _T('\0');
	if (GetModuleFileName(0, path, MAX_PATH - 1))
	{
		size_t pathLen(_t_strlen(path));
		bool pathExtracted(false);
		for (TCHAR* p(path + pathLen - 1); p >= path; --p)
		{
			if (*p == _T(':') || *p == _T('/') || *p == _T('\\'))
			{
				if (*p == _T(':'))
				{
					p[1] = _T('\\');
					p[2] = _T('\0');
				}
				else
					p[1] = _T('\0');

				pathExtracted = true;
				break;
			}
		}

		if (pathExtracted)
			SetCurrentDirectory(path);
	}
}


int APIENTRY 
_tWinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
{
	try
	{
		if( false == IsProgramInstanceAlreadyRunning() )
		{
			// app is not already running so run it
			SetCurrentWorkingDirectory();
			CAutoRunCDApp& kAppInstance( CAutoRunCDApp::GetInstance() );		
			kAppInstance.InitInstance( hInstance, nCmdShow );				
			return( kAppInstance.Run() );
		}
		else
		{
			return( 0 );
		}
	}
	catch( const texception& e )
	{
		MessageBox( 0, e.descr().c_str(), GetStringFromResource( hInstance, IDS_APP_TITLE ).c_str(), MB_OK | MB_ICONEXCLAMATION );
		return( -1 );
	}
	catch( ... )
	{
		return( -1 );
	}
}



//#include <vector>
//#include <string>
//#include <winioctl.h>
//
////typedef std::basic_string< TCHAR > tstring;
//typedef std::vector< TCHAR > tvector;
//
//using namespace std;
//
//bool 
//FindFarCryGameCD( tstring& cdDrivePath )
//{
//	bool bRet( false );
//	DWORD nBufferSize( GetLogicalDriveStrings( 0, 0 ) );
//	if( 0 < nBufferSize )
//	{
//		// get list of all available logical drives
//		tvector rawDriveLetters( nBufferSize + 1 );
//		GetLogicalDriveStrings( nBufferSize, &rawDriveLetters[ 0 ] );
//
//		// quickly scan all drives
//		tvector::size_type i( 0 );
//		while( true )
//		{
//			// check if current drive is cd/dvd drive
//			if( DRIVE_CDROM == GetDriveType( &rawDriveLetters[ i ] ) )
//			{			
//				// get volume name
//				tvector cdVolumeName( MAX_VOLUME_ID_SIZE + 1 );
//				if( FALSE != GetVolumeInformation( &rawDriveLetters[ i ], 
//					&cdVolumeName[ 0 ], (DWORD) cdVolumeName.size(), 0, 0, 0, 0, 0 ) )
//				{
//					// check volume name to verify it's Far Cry's game cd/dvd
//					tstring cdVolumeLabel( &cdVolumeName[ 0 ] );
//					tstring farCryDisk1Label( _T( "FARCRY_1" ) );
//					if( cdVolumeLabel == farCryDisk1Label  )
//					{
//						// found Far Cry's game cd/dvd, copy information and bail out
//						cdDrivePath = &rawDriveLetters[ i ];
//						bRet = true;
//						break;
//					}
//				}				
//			}
//
//			// proceed to next drive
//			while( 0 != rawDriveLetters[ i ] )
//			{
//				++i;
//			}
//			++i; // skip null termination of current drive
//
//			// check if we're out of drive letters
//			if( 0 == rawDriveLetters[ i ] )
//			{
//				// double null termination found, bail out
//				break;
//			}	
//		}
//	}
//	return( bRet );
//}