#include "StdAfx.h"
#include "LocalizationTable.h"
#include "LanguageID.h"



CLocalizationTable::CLocalizationTable()
{
}



CLocalizationTable::~CLocalizationTable()
{
}



tstring 
CLocalizationTable::GetButtonText( EButtonID eButtonID )
{
	switch( GetPrimaryLanguageID() )
	{
	case 0x04:
		{
			if( 0x0804 == ( (GetFullLanguageID() >> 16) & 0xFFFF ) )
			{
				return( GetChineseSimplifiedButtonText( eButtonID ) );
			}
			else
			{
				return( GetChineseButtonText( eButtonID ) );
			}
		}
	case 0x05:
		{
			return( GetCzechButtonText( eButtonID ) );
		}
	case 0x07:
		{
			return( GetGermanButtonText( eButtonID ) );
		}		
	case 0x09:
		{
			return( GetEnglishButtonText( eButtonID ) );
		}
	case 0x10:
		{
			return( GetItalianButtonText( eButtonID ) );
		}		
	case 0x11:
		{
			return( GetJapaneseButtonText( eButtonID ) );
		}		
	case 0x15:
		{
			return( GetPolishButtonText( eButtonID ) );
		}
	case 0x0a:
		{
			return( GetSpanishButtonText( eButtonID ) );
		}
	case 0x0c:
		{
			return( GetFrenchButtonText( eButtonID ) );
		}
	case 0x0e:
		{
			return( GetHungarianButtonText( eButtonID ) );
		}
/*	case 0x12:
		{
			return( GetKoreanButtonText( eButtonID ) );
		}
*/	case 0x19:
		{
			return( GetRussianButtonText( eButtonID ) );
		}
/*	case 0x1e:
		{
			return( GetThaiButtonText( eButtonID ) );
		}
*/	case 0x1f:
		{
			return( GetTurkishButtonText( eButtonID ) );
		}	
	default:
		{
			return( GetEnglishButtonText( eButtonID ) );
		}
	}
}



tstring 
CLocalizationTable::GetEnglishButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Install" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Play" ) );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( "Uninstall" ) );
		}*/
	case BID_README:
		{
			return( _T( "Readme" ) );
		}
	/*case BID_MANUAL:
		{
			return( _T( "Manual" ) );
		}*/
	case BID_REGISTER:
		{
			return( _T( "Register" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Quit" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}

#ifdef UNICODE
tstring 
CLocalizationTable::GetChineseButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgQuit[] = { 0x5b89,0x88dd,0x0000 };
			return( c_msgQuit );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgQuit[] = { 0x9032,0x884c,0x904a,0x6232,0x0000 };
			return( c_msgQuit );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( 0x79fb,0x9664,0x0000 ) );
		}*/
	case BID_README:
		{
			const TCHAR c_msgQuit[] = { 0x8b80,0x6211,0x6a94,0x6848,0x0000 };
			return( c_msgQuit );
		}
	/*case BID_MANUAL:
		{
			const TCHAR c_msgQuit[] = { 0x624b,0x518a,0x0000 };
			return( c_msgQuit );
		}*/
	case BID_REGISTER:
		{
			const TCHAR c_msgQuit[] = { 0x8a3b,0x518a,0x0000 };
			return( c_msgQuit );
		}
	case BID_WEB:
		{
			const TCHAR c_msgQuit[] = { 0x7db2,0x7ad9,0x0000 };
			return( c_msgQuit );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x96e2,0x958b,0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif

#ifdef UNICODE
tstring 
CLocalizationTable::GetChineseSimplifiedButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgQuit[] = { 0x5b89,0x88c5,0x0000 };
			return( c_msgQuit );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgQuit[] = {0x8fdb,0x884c,0x6e38,0x620f,0x0000 };
			return( c_msgQuit );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( 0x79fb,0x9664,0x0000 ) );
		}*/
	case BID_README:
		{
			const TCHAR c_msgQuit[] = { 0x81ea,0x8ff0,0x6587,0x6863,0x0000 };
			return( c_msgQuit );
		}
	/*case BID_MANUAL:
		{
			const TCHAR c_msgQuit[] = { 0x624b,0x518a,0x0000 };
			return( c_msgQuit );
		}*/
	case BID_REGISTER:
		{
			const TCHAR c_msgQuit[] = { 0x6ce8,0x518c,0x7a0b,0x5e8f,0x0000 };
			return( c_msgQuit );
		}
	case BID_WEB:
		{
			const TCHAR c_msgQuit[] = { 0x5b98,0x65b9,0x7f51,0x7ad9,0x0000 };
			return( c_msgQuit );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x9000,0x51fa,0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif


#ifdef UNICODE
tstring 
CLocalizationTable::GetTurkishButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgQuit[] = { 0x004B, 0x0075, 0x0072,0x0000 };
			return( c_msgQuit );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgQuit[] = { 0x004f,0x0079,0x006e,0x0061,0x0000 };
			return( c_msgQuit );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( 0x004b,0x0061,0x006c,0x0064,0x0131,0x0072,0x0000 ) );
		}*/
	case BID_README:
		{
			const TCHAR c_msgQuit[] = { 0x004f,0x006b,0x0075,0x0020,0x0062,0x0065,0x006e,0x0069,0x0000 };
			return( c_msgQuit );
		}
	/*case BID_MANUAL:
		{
			const TCHAR c_msgQuit[] = { 0x004b,0x0075,0x006c,0x006c,0x0061,0x006e,0x006d,0x0061,0x0020,0x006b,0x0131,0x006c,0x0061,0x0076,0x0075,0x007a,0x0075,0x0000 };
			return( c_msgQuit );
		}*/
	case BID_REGISTER:
		{
			const TCHAR c_msgQuit[] = { 0x004b,0x0061,0x0079,0x0131,0x0074,0x0020,0x006f,0x006c,0x0000 };
			return( c_msgQuit );
		}
	case BID_WEB:
		{
			const TCHAR c_msgQuit[] = { 0x0057,0x0065,0x0062,0x0000 };
			return( c_msgQuit );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x00c7,0x0131,0x006b,0x0131,0x015f,0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#else
#endif

/*#ifdef UNICODE
tstring 
CLocalizationTable::GetThaiButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgQuit[] = { 0x0e15,0x0e34,0x0e14,0x0e15,0x0e31,0x0e49,0x0e07,0x0000 };
			return( c_msgQuit );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgQuit[] = {0x0e40,0x0e25,0x0e48,0x0e19,0x0000  };
			return( c_msgQuit );
		}

	case BID_README:
		{
			const TCHAR c_msgQuit[] = { 0x0052,0x0065,0x0061,0x0064,0x006d,0x0065,0x0000 };
			return( c_msgQuit );
		}

	case BID_REGISTER:
		{
			const TCHAR c_msgQuit[] = { 0x0e25,0x0e07,0x0e17,0x0e30,0x0e40,0x0e1a,0x0e35,0x0e22,0x0e19,0x0000 };
			return( c_msgQuit );
		}
	case BID_WEB:
		{
			const TCHAR c_msgQuit[] = { 0x0e40,0x0e27,0x0e47,0x0e1a,0x0e44,0x0e0b,0x0e17,0x0e4c,0x0000 };
			return( c_msgQuit );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x0e2d,0x0e2d,0x0e01,0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif
*/

#ifdef UNICODE
tstring 
CLocalizationTable::GetRussianButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgQuit[] = { 0x0423,0x0441,0x0442,0x0430,0x043d,0x043e,0x0432,0x043a,0x0430,0x0000 };
			return( c_msgQuit );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgQuit[] = { 0x0417,0x0430,0x043f,0x0443,0x0441,0x043a,0x0000 };
			return( c_msgQuit );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( 0x0423,0x0434,0x0430,0x043b,0x0435,0x043d,0x0438,0x0435,0x0000 ) );
		}*/
	case BID_README:
		{
			const TCHAR c_msgQuit[] = { 0x0424,0x0430,0x0439,0x043b,0x0020,0x0052,0x0065,0x0061,0x0064,0x006d,0x0065,0x0000 };
			return( c_msgQuit );
		}
	/*case BID_MANUAL:
		{
			const TCHAR c_msgQuit[] = { 0x0420,0x0443,0x043a,0x043e,0x0432,0x043e,0x0434,0x0441,0x0442,0x0432,0x043e,0x0000 };
			return( c_msgQuit );
		}*/
	case BID_REGISTER:
		{
			const TCHAR c_msgQuit[] = { 0x0420,0x0435,0x0433,0x0438,0x0441,0x0442,0x0440,0x0430,0x0446,0x0438,0x044f,0x0000 };
			return( c_msgQuit );
		}
	case BID_WEB:
		{
			const TCHAR c_msgQuit[] = { 0x0412,0x0435,0x0431,0x002d,0x0441,0x0430,0x0439,0x0442,0x0000 };
			return( c_msgQuit );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x0412,0x044b,0x0445,0x043e,0x0434,0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif


/*#ifdef UNICODE
tstring 
CLocalizationTable::GetKoreanButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgQuit[] = { 0xc124,0xce58,0x0000 };
			return( c_msgQuit );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgQuit[] = { 0xd50c,0xb808,0xc774,0x0000 };
			return( c_msgQuit );
		}

	case BID_README:
		{
			const TCHAR c_msgQuit[] = { 0xc77d,0xc5b4,0xbcf4,0xae30,0x0000 };
			return( c_msgQuit );
		}
	//case BID_MANUAL:
	//	{
	//		const TCHAR c_msgQuit[] = { 0xb9e4,0xb274,0xc5bc,0x0000 };
	//		return( c_msgQuit );
	//	}
	case BID_REGISTER:
		{
			const TCHAR c_msgQuit[] = { 0xb4f1,0xb85d,0x0000 };
			return( c_msgQuit );
		}
	case BID_WEB:
		{
			const TCHAR c_msgQuit[] = { 0xc6f9,0x0000 };
			return( c_msgQuit );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0xc885,0xb8cc,0x0000};
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif
*/

#ifdef UNICODE
tstring 
CLocalizationTable::GetHungarianButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgQuit[] = {0x0054,0x0065,0x006c,0x0065,0x0070,0x00ed,0x0074,0x00e9,0x0073,0x0000};
			return( c_msgQuit );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgQuit[] = { 0x004a,0x00e1,0x0074,0x00e9,0x006b,0x0000 };
			return( c_msgQuit );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( 0x0045,0x006c,0x0074,0x00e1,0x0076,0x006f,0x006c,0x00ed,0x0074,0x00e1,0x0073,0x0000 ) );
		}*/
	case BID_README:
		{
			const TCHAR c_msgQuit[] = { 0x004f,0x006c,0x0076,0x0061,0x0073,0x0073,0x0065,0x006c,0x0020,0x0066,0x00e1,0x006a,0x006c,0x0000 };
			return( c_msgQuit );
		}
	//case BID_MANUAL:
	//	{
	//		const TCHAR c_msgQuit[] = { 0x004b,0x00e9,0x007a,0x0069,0x006b,0x00f6,0x006e,0x0079,0x0076,0x0000 };
	//		return( c_msgQuit );
	//	}
	case BID_REGISTER:
		{
			const TCHAR c_msgQuit[] = { 0x0052,0x0065,0x0067,0x0069,0x0073,0x007a,0x0074,0x0072,0x00e1,0x0063,0x0069,0x00f3,0x0000 };
			return( c_msgQuit );
		}
	case BID_WEB:
		{
			const TCHAR c_msgQuit[] = { 0x0057,0x0065,0x0062,0x0000 };
			return( c_msgQuit );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x004b,0x0069,0x006c,0x00e9,0x0070,0x00e9,0x0073,0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif

#ifdef UNICODE
tstring 
CLocalizationTable::GetCzechButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgQuit[] = { 0x0049,0x006e,0x0073,0x0074,0x0061,0x006c,0x006f,0x0076,0x0061,0x0074,0x0000 };
			return( c_msgQuit );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgQuit[] = { 0x0048,0x0072,0x00e1,0x0074,0x0000 };
			return( c_msgQuit );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( 0x004f,0x0064,0x0069,0x006e,0x0073,0x0074,0x0061,0x006c,0x006f,0x0076,0x0061,0x0074,0x0000 ) );
		}*/
	case BID_README:
		{
			const TCHAR c_msgQuit[] = { 0x010c,0x0074,0x0069,0x0020,0x006d,0x006e,0x0065,0x0000 };
			return( c_msgQuit );
		}
	/*case BID_MANUAL:
		{
			const TCHAR c_msgQuit[] = { 0x0050,0x0159,0x00ed,0x0072,0x0075,0x010d,0x006b,0x0061,0x0000 };
			return( c_msgQuit );
		}*/
	case BID_REGISTER:
		{
			const TCHAR c_msgQuit[] = { 0x0052,0x0065,0x0067,0x0069,0x0073,0x0074,0x0072,0x006f,0x0076,0x0061,0x0074,0x0000 };
			return( c_msgQuit );
		}
	case BID_WEB:
		{
			const TCHAR c_msgQuit[] = { 0x0057,0x0065,0x0062,0x0000 };
			return( c_msgQuit );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x004f,0x0064,0x0065,0x006a,0x00ed,0x0074,0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif


tstring 
CLocalizationTable::GetGermanButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Installieren" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Spielen" ) );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( "Deinstallieren" ) );
		}*/
	case BID_README:
		{
			return( _T( "Readme anzeigen" ) );
		}
	/*case BID_MANUAL:
		{
			return( _T( "Handbuch" ) );
		}*/
	case BID_REGISTER:
		{
			return( _T( "Registrieren" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Ende" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}



tstring 
CLocalizationTable::GetFrenchButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Installer" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Jouer" ) );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( "Dsinstaller" ) );
		}*/
	case BID_README:
		{
			return( _T( "Lisez-moi" ) );
		}
	/*case BID_MANUAL:
		{
			return( _T( "Manuel" ) );
		}*/
	case BID_REGISTER:
		{
			return( _T( "Enregistrement" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Quitter" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}



tstring 
CLocalizationTable::GetSpanishButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Instalar" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Jugar" ) );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( "Desinstalar" ) );
		}*/
	case BID_README:
		{
			return( _T( "Leme" ) );
		}
	/*case BID_MANUAL:
		{
			return( _T( "Manual" ) );
		}*/
	case BID_REGISTER:
		{
			return( _T( "Registro" ) );
		}
	case BID_WEB:
		{
			return( _T( "Pgina web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Salir" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}



tstring 
CLocalizationTable::GetItalianButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Installa" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Gioca" ) );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( "Disinstalla" ) );
		}*/
	case BID_README:
		{
			return( _T( "Leggimi" ) );
		}
	/*case BID_MANUAL:
		{
			return( _T( "Manuale" ) );
		}*/
	case BID_REGISTER:
		{
			return( _T( "Registrati" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Esci" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}


#ifdef UNICODE
tstring 
CLocalizationTable::GetJapaneseButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgInstall[] = { 0x30a4,0x30f3,0x30b9,0x30c8,0x30fc,0x30eb,0x0000 };
			return( c_msgInstall );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgPlay[] = { 0x30d7,0x30ec,0x30a4,0x0000 };
			return( c_msgPlay );
		}
/*	case BID_UNINSTALL:
		{
			const TCHAR c_msgUninstall[] = { 0x30a2,0x30f3,0x30a4,0x30f3,0x30b9,0x30c8,0x30fc,0x30eb,0x0000 };
			return( c_msgUninstall );
		}*/
	case BID_README:
		{
			return( _T( "Readme" ) );
		}
	/*case BID_MANUAL:
		{
			const TCHAR c_msgManual[] = { 0x30de,0x30cb,0x30e5,0x30a2,0x30eb,0x0000 };
			return( c_msgManual );
		}*/
	case BID_REGISTER:
		{
			const TCHAR c_msgRegister[] = { 0x767b,0x9332,0x0000 };
			return( c_msgRegister );
		}
	case BID_WEB:
		{
			const TCHAR c_msgRegister[] = { 0x30a6,0x30a7,0x30d6,0x30b5,0x30a4,0x30c8,0x0000 };
			return( c_msgRegister );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x7d42,0x4e86,0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#else
tstring 
CLocalizationTable::GetJapaneseButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "CXg[" ) );
		}
	case BID_PLAY:
		{
			return( _T( "vC" ) );
		}
	/*case BID_UNINSTALL:
		{
			return( _T( "ACXg[" ) );
		}*/
	case BID_README:
		{
			return( _T( "Readme" ) );
		}
	/*case BID_MANUAL:
		{
			return( _T( "}jA" ) );
		}*/
	case BID_REGISTER:
		{
			return( _T( "ICo^" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "I" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif


#ifdef UNICODE
tstring 
CLocalizationTable::GetPolishButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Instaluj" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Graj" ) );
		}
/*	case BID_UNINSTALL:
		{
			return( _T( "Usu" ) );
		}*/
	case BID_README:
		{
			return( _T( "Przeczytaj" ) );
		}
	/*case BID_MANUAL:
		{
			return( _T( "Instrukcja" ) );
		}*/
	case BID_REGISTER:
		{
			return( _T( "Zarejestruj" ) );
		}
	case BID_WEB:
		{
			const TCHAR c_msgWeb[] = { 0x0053,0x0069,0x0065,0x0107,0x0000 };
			return( c_msgWeb );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x0057,0x0079,0x006a,0x0064,0x017a,0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif