#include "StdAfx.h"
#include "ProductRegistry.h"
#include "LanguageID.h"
#include "Utilities.h"

#include <vector>



// product code of the game
const TCHAR c_pcProductCode[] = _T( "{3F425F12-3A1B-4511-97B2-E2BB4701B745}" );


// key and value of the game
const TCHAR c_pcInstallRegKey[] = _T( "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" )
									   _T( "{3F425F12-3A1B-4511-97B2-E2BB4701B745}" );



const TCHAR c_pcInstallRegValue[] = _T( "InstallLocation" );


const TCHAR c_pcCdKey[] = _T( "SOFTWARE\\Electronic Arts\\Electronic Arts\\CrysisWars\\ergc" );


const unsigned int c_wow64Flags[] = 
{
	KEY_WOW64_64KEY,
	0
};



using namespace std;



static bool
Is64BitWindows()
{
	OSVERSIONINFOEX sOsVersionInfoEx;

	ZeroMemory( &sOsVersionInfoEx,  sizeof( OSVERSIONINFOEX ) );
	sOsVersionInfoEx.dwOSVersionInfoSize = sizeof( OSVERSIONINFOEX );

	BOOL bOsVersionInfoEx( GetVersionEx ( (OSVERSIONINFO*) &sOsVersionInfoEx ) );
	if( FALSE == bOsVersionInfoEx )
	{
		sOsVersionInfoEx.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );
		if( FALSE == GetVersionEx( (OSVERSIONINFO*) &sOsVersionInfoEx ) ) 
		{
			// both win32 calls to get os version info have failed!
			return( false );
		}
	}
	return( 5 <= sOsVersionInfoEx.dwMajorVersion && 2 <= sOsVersionInfoEx.dwMinorVersion );
}



bool 
ProductRegistry::IsInstalled()
{
	// check registry if Far Cry's has been installed already
	bool bRet( false );	
	HKEY hKey;

	for( int i( 0 ); false == bRet && i < sizeof( c_wow64Flags ) / sizeof( c_wow64Flags[ 0 ] ); ++i )
	{
		if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_LOCAL_MACHINE, c_pcInstallRegKey, 0, c_wow64Flags[ i ] | KEY_READ, &hKey ) )
		{
			bRet = true;
			RegCloseKey( hKey );
		}
	}
	return( bRet );
}



bool 
ProductRegistry::GetProductInstallationFolder( tstring& strInstallationFolder )
{
	bool bRet( false );	
	HKEY hKey;

	for( int i( 0 ); false == bRet && i < sizeof( c_wow64Flags ) / sizeof( c_wow64Flags[ 0 ] ); ++i )
	{
		if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_LOCAL_MACHINE, c_pcInstallRegKey, 0, c_wow64Flags[ i ] | KEY_READ, &hKey ) )
		{
			DWORD dwSizeStr( 0 );
			DWORD dwRegType( REG_SZ );
			if( ERROR_SUCCESS == RegQueryValueEx( hKey, c_pcInstallRegValue, 0, &dwRegType, 0, &dwSizeStr ) )
			{
				vector< unsigned char > colInstallLocation( dwSizeStr );
				if( ERROR_SUCCESS == RegQueryValueEx( hKey, c_pcInstallRegValue, 0, &dwRegType, &colInstallLocation[ 0 ], &dwSizeStr ) )
				{
					strInstallationFolder = (TCHAR*) &colInstallLocation[ 0 ];				

					bRet = true;
				}						
				RegCloseKey( hKey );
			}
		}
	}
	return( bRet );
}


bool
ProductRegistry::GetCDKey( tstring& strCDKey )
{
	bool bRet( false );	
	HKEY hKey;

	for( int i( 0 ); false == bRet && i < sizeof( c_wow64Flags ) / sizeof( c_wow64Flags[ 0 ] ); ++i )
	{
		if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_LOCAL_MACHINE, c_pcCdKey, 0, c_wow64Flags[ i ] | KEY_READ, &hKey ) )
		{
			DWORD dwSizeStr( 0 );
			DWORD dwRegType( REG_SZ );
			if( ERROR_SUCCESS == RegQueryValueEx( hKey, 0, 0, &dwRegType, 0, &dwSizeStr ) )
			{
				vector< unsigned char > colCDKey( dwSizeStr );
				if( ERROR_SUCCESS == RegQueryValueEx( hKey, 0, 0, &dwRegType, &colCDKey[ 0 ], &dwSizeStr ) )
				{
					strCDKey = (TCHAR*) &colCDKey[ 0 ];				

					bRet = true;
				}						
				RegCloseKey( hKey );
			}
		}
	}
	return( bRet );
}


/*bool 
ProductRegistry::GetIDriverFilePath( tstring& strIDriverFilePath )
{
	bool bRet( false );
	HKEY hKey;

	for( int i( 0 ); false == bRet && i < sizeof( c_wow64Flags ) / sizeof( c_wow64Flags[ 0 ] ); ++i )
	{
		if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_CLASSES_ROOT, c_pcIDriverRegValue, 0, c_wow64Flags[ i ] | KEY_READ, &hKey ) )
		{
			DWORD dwSizeStr( 0 );
			DWORD dwRegType( REG_SZ );
			if( ERROR_SUCCESS == RegQueryValueEx( hKey, 0, 0, &dwRegType, 0, &dwSizeStr ) )
			{
				vector< unsigned char > colIDriverFilePath( dwSizeStr );
				if( ERROR_SUCCESS == RegQueryValueEx( hKey, 0, 0, &dwRegType, &colIDriverFilePath[ 0 ], &dwSizeStr ) )
				{
					strIDriverFilePath = (TCHAR*) &colIDriverFilePath[ 0 ];				

					bRet = true;
				}						
				RegCloseKey( hKey );
			}
		}
	}
	return( bRet );
}*/



bool 
ProductRegistry::GetInstallCmd( tstring& strInstallCmd )
{
	// assume that AutoRunCD is in the same directory on CD/DVD as setup.exe 
	if( false == Is64BitWindows() )
	{
		strInstallCmd = _T( "Crysis Wars setup.exe" );
	}
	else
	{
		strInstallCmd = _T( "Crysis Wars setup.exe" );
	}		
	return( true );
}



bool
ProductRegistry::GetLaunchCmd( tstring& strLaunchCmd, tstring& strLaunchWorkingDir )
{
	bool bRet( false );
	if( false != GetProductInstallationFolder( strLaunchWorkingDir ) )
	{
		strLaunchWorkingDir +=_T( "\\");
		if( false == Is64BitWindows() )
		{
			strLaunchCmd = _T( "Bin32\\CrysisWars.exe" );
		}
		else
		{
			strLaunchCmd = _T( "Bin64\\CrysisWars.exe" );
		}		
		if( false != FindFile( strLaunchWorkingDir + strLaunchCmd ) )
		{
			bRet = true;
		}
	}
	return( bRet );
}



/*bool
ProductRegistry::GetUninstallCmd( tstring& strUninstallCmd, tstring& strUninstallParam1 )
{
	bool bRet( false );

	// get file path for IDriver.exe
	if( false != GetIDriverFilePath( strUninstallCmd ) )
	{
		// set uninstall parameters
		strUninstallParam1 = tstring( _T( "/M" ) ) + tstring( c_pcProductCode );
		bRet = true;
	}
	return( bRet );
}*/



bool 
ProductRegistry::GetReadmePath( tstring& strReadmePath )
{
	/*TCHAR c_readmeRelPath[]( _T( "Support\\Readme.txt" ) );

	bool bSearchOnCD( true );
	if( false != IsInstalled() && false != GetProductInstallationFolder( strReadmePath ) )
	{
		// game is installed, search for readme in game folder
		strReadmePath += c_readmeRelPath;
		if( false != FindFile( strReadmePath ) )
		{			
			bSearchOnCD = false;
		}
	}

	// readme not found, try CD/DVD
	if( false != bSearchOnCD )
	{*/
	TCHAR c_readmeRelPathCZ[]( _T( "Support\\Readme.czech.txt" ) );
	TCHAR c_readmeRelPathDE[]( _T( "Support\\Readme.german.txt" ) );
	TCHAR c_readmeRelPathES[]( _T( "Support\\Readme.spanish.txt" ) );
	TCHAR c_readmeRelPathFR[]( _T( "Support\\Readme.french.txt" ) );
	TCHAR c_readmeRelPathHU[]( _T( "Support\\Readme.hungarian.txt" ) );
	TCHAR c_readmeRelPathIT[]( _T( "Support\\Readme.italian.txt" ) );
	TCHAR c_readmeRelPathJP[]( _T( "Support\\Readme.japanese.txt" ) );
	//TCHAR c_readmeRelPathKO[]( _T( "Support\\Readme..txt" ) );
	TCHAR c_readmeRelPathPL[]( _T( "Support\\Readme.polish.txt" ) );
	TCHAR c_readmeRelPathRU[]( _T( "Support\\Readme.russian.txt" ) );
	//TCHAR c_readmeRelPathTH[]( _T( "Support\\Readme..txt" ) );
	TCHAR c_readmeRelPathTR[]( _T( "Support\\Readme.turkish.txt" ) );
	//TCHAR c_readmeRelPathUK[]( _T( "Support\\Readme..txt" ) );
	TCHAR c_readmeRelPathUS[]( _T( "Support\\Readme.english.txt" ) );
	TCHAR c_readmeRelPathZH_TW[]( _T( "Support\\Readme.Chinese (Taiwan).txt" ) );
	TCHAR c_readmeRelPathZH_CN[]( _T( "Support\\Readme.Chinese (PRC).txt" ) );

	switch( GetPrimaryLanguageID() )
	{	
		case 0x04:
		{
			if( 0x0804 == ( (GetFullLanguageID() >> 16) & 0xFFFF ) )
			{
				strReadmePath = c_readmeRelPathZH_CN;
				break;
			}
			else
			{
				strReadmePath = c_readmeRelPathZH_TW;
				break;
			}
		}
		case 0x05:
			{
				strReadmePath = c_readmeRelPathCZ;
				break;
			}
		case 0x07:
			{
				strReadmePath = c_readmeRelPathDE;
				break;
			}		
		case 0x09:
			{
				/*if( 0x0809 == ( GetFullLanguageID() & 0xFFFF ) )
				{
					strReadmePath = c_readmeRelPathUK;
				}
				else
				{*/
					strReadmePath = c_readmeRelPathUS;
				//}				
				break;
			}
		case 0x10:
			{
				strReadmePath = c_readmeRelPathIT;
				break;
			}		
		case 0x11:
			{
				strReadmePath = c_readmeRelPathJP;
				break;
			}		
		case 0x15:
			{
				strReadmePath = c_readmeRelPathPL;
				break;
			}
		case 0x0a:
			{
				strReadmePath = c_readmeRelPathES;
				break;
			}
		case 0x0c:
			{
				strReadmePath = c_readmeRelPathFR;
				break;
			}
		case 0x0e:
			{
				strReadmePath = c_readmeRelPathHU;
				break;
			}
/*		case 0x12:
			{
				strReadmePath = c_readmeRelPathKO;
				break;
			}
*/		case 0x19:
			{
				strReadmePath = c_readmeRelPathRU;
				break;
			}
/*		case 0x1e:
			{
				strReadmePath = c_readmeRelPathTH;
				break;
			}
*/		case 0x1f:
			{
				strReadmePath = c_readmeRelPathTR;
				break;
			}
		default:
			{
				strReadmePath = c_readmeRelPathUS;
			}
	}				
	//}
	return( true );
}



//bool 
//ProductRegistry::GetManualPath( tstring& strManualPath )
//{
//	/*TCHAR c_manualRelPath[]( _T( "Support\\Manual\\Crysis User Manual.pdf" ) );
//
//	bool bSearchOnCD( true );
//	if( false != IsInstalled() && false != GetProductInstallationFolder( strManualPath ) )
//	{
//		// game is installed, search for manual in game folder
//		strManualPath += c_manualRelPath;
//		if( false != FindFile( strManualPath ) )
//		{
//			bSearchOnCD = false;
//		}
//	}
//
//	// manual not found, try CD/DVD
//	if( false != bSearchOnCD )
//	{*/
//	TCHAR c_manualRelPathCZ[]( _T( "Support\\Manual\\Crysis User Manual (CZ).pdf" ) );
//	TCHAR c_manualRelPathDE[]( _T( "Support\\Manual\\Crysis User Manual (DE).pdf" ) );
//	TCHAR c_manualRelPathES[]( _T( "Support\\Manual\\Crysis User Manual (ES).pdf" ) );
//	TCHAR c_manualRelPathFR[]( _T( "Support\\Manual\\Crysis User Manual (FR).pdf" ) );
//	TCHAR c_manualRelPathHU[]( _T( "Support\\Manual\\Crysis User Manual (HU).pdf" ) );
//	TCHAR c_manualRelPathIT[]( _T( "Support\\Manual\\Crysis User Manual (IT).pdf" ) );
//	TCHAR c_manualRelPathJP[]( _T( "Support\\Manual\\Crysis User Manual (JP).pdf" ) );
//	TCHAR c_manualRelPathKO[]( _T( "Support\\Manual\\Crysis User Manual (KO).pdf" ) );
//	TCHAR c_manualRelPathPL[]( _T( "Support\\Manual\\Crysis User Manual (PL).pdf" ) );
//	TCHAR c_manualRelPathRU[]( _T( "Support\\Manual\\Crysis User Manual (RU).pdf" ) );
//	TCHAR c_manualRelPathTH[]( _T( "Support\\Manual\\Crysis User Manual (TH).pdf" ) );
//	TCHAR c_manualRelPathTR[]( _T( "Support\\Manual\\Crysis User Manual (TR).pdf" ) );
//	TCHAR c_manualRelPathUK[]( _T( "Support\\Manual\\Crysis User Manual (UK).pdf" ) );
//	TCHAR c_manualRelPathUS[]( _T( "Support\\Manual\\Crysis User Manual (US).pdf" ) );
//	TCHAR c_manualRelPathZH[]( _T( "Support\\Manual\\Crysis User Manual (ZH).pdf" ) );
//	
//
//	switch( GetPrimaryLanguageID() )
//	{
//	case 0x04:
//		{
//			strManualPath = c_manualRelPathZH;
//			break;
//		}
//	case 0x05:
//		{
//			strManualPath = c_manualRelPathCZ;
//			break;
//		}
//	case 0x07:
//		{
//			strManualPath = c_manualRelPathDE;
//			break;
//		}		
//	case 0x09:
//		{
//			if( 0x0809 == ( GetFullLanguageID() & 0xFFFF ) )
//			{
//				strManualPath = c_manualRelPathUK;
//			}
//			else
//			{
//				strManualPath = c_manualRelPathUS;
//			}				
//			break;
//		}
//	case 0x10:
//		{
//			strManualPath = c_manualRelPathIT;
//			break;
//		}		
//	case 0x11:
//		{
//			strManualPath = c_manualRelPathJP;
//			break;
//		}		
//	case 0x15:
//		{
//			strManualPath = c_manualRelPathPL;
//			break;
//		}
//	case 0x0a:
//		{
//			strManualPath = c_manualRelPathES;
//			break;
//		}
//	case 0x0c:
//		{
//			strManualPath = c_manualRelPathFR;
//			break;
//		}
//	case 0x0e:
//		{
//			strManualPath = c_manualRelPathHU;
//			break;
//		}
//	case 0x12:
//		{
//			strManualPath = c_manualRelPathKO;
//			break;
//		}
//	case 0x19:
//		{
//			strManualPath = c_manualRelPathRU;
//			break;
//		}
//	case 0x1e:
//		{
//			strManualPath = c_manualRelPathTH;
//			break;
//		}
//	case 0x1f:
//		{
//			strManualPath = c_manualRelPathTR;
//			break;
//		}
//		default:
//		{
//			strManualPath = c_manualRelPathUS;
//			break;
//		}
//
//	}				
//	//}
//	return( true );
//}



bool 
ProductRegistry::GetRegWebLink( tstring& strRegisterLink)
{
	tstring strCDKey;
	if(GetCDKey( strCDKey ))
	{
		const TCHAR* pCDKey = strCDKey.c_str();
		strRegisterLink = _T( "https://account.ea.com/reg/entry/subscribe-entry.jsp?ipath=12&prodId=OREG&skin=oreg&pr_platform=PC&pr_game=GAME-CRYSIS&pr_selpg=adef");

		switch( GetPrimaryLanguageID() )
		{
			case 0x04:
			{
				if( 0x0804 == ( (GetFullLanguageID() >> 16) & 0xFFFF ) )
				{
					strRegisterLink += _T( "&locale=zh_CN&site=eaco" );
				}
				else
				{
					strRegisterLink += _T( "&locale=zh_TW&site=eaco" );
				}
				break;
			}
			case 0x05:
			{
				strRegisterLink += _T( "&locale=cs&site=eaeu" );
				break;
			}
			case 0x07:
			{
				strRegisterLink += _T( "&locale=de&site=eaeu" );
				break;
			}		
			case 0x09:
			{
				if( 0x0809 == ( GetFullLanguageID() & 0xFFFF ) )
				{
					strRegisterLink += _T( "&locale=en_UK&site=eaeu" );
				}
				else
				{
					strRegisterLink += _T( "&locale=en_US&site=eaco" );
				}				
				break;
			}
			case 0x10:
			{
				strRegisterLink += _T( "&locale=it&site=eaeu" );
				break;
			}		
			case 0x11:
			{
				strRegisterLink += _T( "&locale=ja&site=eaco" );
				break;
			}		
			case 0x15:
			{
				strRegisterLink += _T( "&locale=pl&site=eaeu" );
				break;
			}
			case 0x0a:
			{
				strRegisterLink += _T( "&locale=es&site=eaeu" );
				break;
			}
			case 0x0c:
			{
				strRegisterLink += _T( "&locale=fr_FR&site=eaeu" );
				break;
			}
			case 0x0e:
			{
				strRegisterLink += _T( "&locale=hu&site=eaeu" );
				break;
			}
			case 0x12:
			{
				strRegisterLink += _T( "&locale=ko&site=eaco" );
				break;
			}
			case 0x19:
			{
				strRegisterLink += _T( "&locale=en_US&site=eaco" );
				break;
			}
			case 0x1e:
			{
				strRegisterLink += _T( "&locale=th&site=eaco" );
				break;
			}
			case 0x1f:
			{
				strRegisterLink += _T( "&locale=TR&site=eaco" );
				break;
			}
			default:
			{
				strRegisterLink += _T( "&locale=en_US&site=eaco" );
				break;
			}
		}

		strRegisterLink += _T( "&pr_regcode=" )  + strCDKey;
	}
	else
	{
		strRegisterLink = _T( "http://www.ea.com/crysis" );
	}

	return( true );


}




bool 
ProductRegistry::GetWebLinkPath( tstring& strWeblinkPath )
{
	switch( GetPrimaryLanguageID() )
		{
			case 0x0c:
			{
				strWeblinkPath = _T( "http://www.electronicarts.fr/games/8514,pccd/" );
				break;
			}
			default:
			{
				strWeblinkPath = _T( "http://www.ea.com/crysis" );
				break;
			}
	}

	/*TCHAR c_weblinkRelPath[]( _T( "Support\\Crysis.url" ) );

	bool bSearchOnCD( true );
	if( false != IsInstalled() && false != GetProductInstallationFolder( strWeblinkPath ) )
	{
		// game is installed, search for web link in game folder
		strWeblinkPath += c_weblinkRelPath;
		if( false != FindFile( strWeblinkPath ) )
		{			
			bSearchOnCD = false;
		}
	}

	// web link not found, try CD/DVD
	if( false != bSearchOnCD )
	{

		strWeblinkPath = _T( "Support\\Crysis.url" );
		TCHAR c_webLinkRelPathUS[]( _T( "Support\\Crysis (US).url" ) );		
		TCHAR c_webLinkRelPathUK[]( _T( "Support\\Crysis (UK).url" ) );
		TCHAR c_webLinkRelPathFR[]( _T( "Support\\Crysis (FR).url" ) );
		TCHAR c_webLinkRelPathDE[]( _T( "Support\\Crysis (DE).url" ) );
		TCHAR c_webLinkRelPathIT[]( _T( "Support\\Crysis (IT).url" ) );
		TCHAR c_webLinkRelPathJP[]( _T( "Support\\Crysis (JP).url" ) );
		TCHAR c_webLinkRelPathES[]( _T( "Support\\Crysis (ES).url" ) );
		TCHAR c_webLinkRelPathPL[]( _T( "Support\\Crysis (PL).url" ) );

		switch( GetPrimaryLanguageID() )
		{
		case 0x07:
			{
				strWeblinkPath = c_webLinkRelPathDE;
				break;
			}		
		case 0x09:
			{
				if( 0x0809 == ( GetFullLanguageID() & 0xFFFF ) )
				{
					strWeblinkPath = c_webLinkRelPathUK;
				}
				else
				{
					strWeblinkPath = c_webLinkRelPathUS;
				}				
				break;
			}
		case 0x0c:
			{
				strWeblinkPath = c_webLinkRelPathFR;
				break;
			}		
		case 0x0a:
			{
				strWeblinkPath = c_webLinkRelPathES;
				break;
			}		
		case 0x10:
			{
				strWeblinkPath = c_webLinkRelPathIT;
				break;
			}		
		case 0x11:
			{
				strWeblinkPath = c_webLinkRelPathJP;
				break;
			}		
		case 0x15:
			{
				strWeblinkPath = c_webLinkRelPathPL;
				break;
			}		
		default:
			{
				strWeblinkPath = c_webLinkRelPathUS;
				break;
			}			
		}

		if( false == FindFile( strWeblinkPath ) )
		{
			strWeblinkPath = _T( "http://www.ea.com/crysis" );
		}
	}*/

	

	return( true );
}
