#ifndef DATARANGE_H
#define DATARANGE_H

#include "bstream.h"
#include <list>

class CDataRange
{
public:
	CDataRange() : m_start(0), m_end(0) {}
	CDataRange( unsigned start, unsigned end ) : m_start(start), m_end(end) 
	{
		if (m_start > m_end)
			throw std::runtime_error("Invalid data range");
	}
	CDataRange( unsigned start ) : m_start(start), m_end(start+1) {}

	unsigned Start() const { return m_start; }
	unsigned End() const { return m_end; }

	void Swap( CDataRange& a )
	{
		std::swap( a.m_start, m_start );
		std::swap( a.m_end, m_end );
	}

private:
	unsigned m_start;
	unsigned m_end;
};

inline bool Mergable( CDataRange a, CDataRange b )
{
	if (a.Start() > b.Start())
		a.Swap(b);
	return a.End() >= b.Start();
}

inline BOutputStream& operator<<( BOutputStream& out, const CDataRange& range )
{
	return out << range.Start() << range.End();
}
inline BInputStream& operator>>( BInputStream& in, CDataRange& range )
{
	unsigned start, end;
	in >> start >> end;
	range = CDataRange(start, end);
	return in;
}

#endif
