#ifndef HASHCACHE_H
#define HASHCACHE_H

#include <string>
#include <map>
#include "hash.h"
#include "mutex.h"

class CHashCache
{
public:
	CHash operator()( const std::string& filename, IHashProgressCallback * pProgress );

private:
	struct SFileInfo
	{
		SFileInfo() {}
		SFileInfo( const std::string& filename );
		FILETIME time;
		DWORD sizeLow;
		DWORD sizeHigh;
		bool operator==(const SFileInfo& rhs) const { return time.dwHighDateTime==rhs.time.dwHighDateTime && time.dwLowDateTime==rhs.time.dwLowDateTime && sizeLow==rhs.sizeLow && sizeHigh==rhs.sizeHigh; }
		bool operator!=(const SFileInfo& rhs) const { return !operator==(rhs); }
	};

	struct SCacheEntry
	{
		SCacheEntry() {}
		SCacheEntry( const std::string& filename, IHashProgressCallback * pProgress ) : hash(CFile(filename, true), pProgress), info(filename) {}
		CHash hash;
		SFileInfo info;
	};

	CMutex m_mutex;
	typedef std::map<std::string, SCacheEntry> TMap;
	TMap m_cache;

	CHash NewHash( const std::string& filename, IHashProgressCallback * pProgress );
};

extern CHashCache GetHash;

#endif
