// LegendWindow.cpp : implementation file
//

#include "stdafx.h"
#include "ChartViewer.h"
#include "LegendWindow.h"
#include "windowsx.h"


#include "ChartViewerView.h"					// CChartViewerView
#include "ChartViewerDoc.h"						// CChartViewerDoc


DWORD SwapRGB( const DWORD indwValue )
{
	DWORD dwRet=((indwValue & 0x0000ff)<<16)
				| (indwValue & 0x00ff00)
				| ((indwValue & 0xff0000)>>16);

	return(dwRet);
}


// CLegendWindow dialog

IMPLEMENT_DYNAMIC(CLegendWindow, CDialog)
CLegendWindow::CLegendWindow(CWnd* pParent /*=NULL*/)
	: CDialog(CLegendWindow::IDD, pParent)
{
	m_pConnection=0;
}

CLegendWindow::~CLegendWindow()
{
}

void CLegendWindow::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TREE1, m_LegendTree);
}

//! set connection to the view
void CLegendWindow::SetConnectionAndRefresh( CChartViewerView *inpPtr )
{
	m_pConnection=inpPtr;

	CChartViewerDoc *doc=m_pConnection->GetDocument();			assert(doc);
	CChartData *data=doc->GetDocumentDataPtr();							assert(data);


	if(inpPtr->m_iSelectionIndex==-1)				// nothing selected
	{
		SetWindowText("All Samples in ms: Average, Min, Max, Name");
	}
	else														// there is a selection
	{
		char str[256];

		sprintf(str,"Sample %d in ms: Avg, Sum, %%, Name(count) in ms",inpPtr->m_iSelectionIndex);
		SetWindowText(str);
	}

	if(!m_LegendTree.GetSafeHwnd())return;

	m_LegendTree.DeleteAllItems();

	int iCursorIndex = m_pConnection->GetCursorIndex();

	float fSumInMS=data->GetSumInMicroSecAt(iCursorIndex)*0.001f;

//	OutputDebugString("SetConnectionAndRefresh: \n");
	int iLayerIndex=0;
	while(CChartData::CChartLayer *pLayer=data->GetLayerNo(iLayerIndex))
	{
		string str;
		
		if(iCursorIndex==-1)				// there is a cursor
			str=pLayer->GetNameAndStats();
		 else
			str=pLayer->GetNameAndStatsAtIndex(iCursorIndex,fSumInMS);

		HTREEITEM item=m_LegendTree.InsertItem(TVIF_PARAM|TVIF_TEXT,str.c_str(),0,0,0,0,iLayerIndex,0,0);
/*
		OutputDebugString(" - ");
		OutputDebugString(pLayer->GetName().c_str());
		OutputDebugString("\n");
*/
		m_LegendTree.SetCheck(item,!pLayer->GetHidden());	// Baustelle

		iLayerIndex++;
	}
}




BEGIN_MESSAGE_MAP(CLegendWindow, CDialog)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE1, OnTvnSelchangedTree1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_TREE1, OnNMCustomdrawTree1)
	ON_NOTIFY(TVN_KEYDOWN, IDC_TREE1, OnTvnKeydownTree1)
	ON_NOTIFY(NM_CLICK, IDC_TREE1, OnNMClickTree1)
	ON_WM_SIZE()
	ON_NOTIFY(NM_RCLICK, IDC_TREE1, OnNMRclickTree1)
END_MESSAGE_MAP()


// CLegendWindow message handlers

void CLegendWindow::OnTvnSelchangedTree1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;
}

void CLegendWindow::OnNMCustomdrawTree1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);

	if(pNMHDR->code==NM_CUSTOMDRAW)
	switch(pNMCD->dwDrawStage)
	{
		case CDDS_PREPAINT:
			// Need to process this case and set pResult to CDRF_NOTIFYITEMDRAW, 
			// otherwise parent will never receive CDDS_ITEMPREPAINT notification. (GGH) 
			*pResult = CDRF_NOTIFYITEMDRAW;
			return;

		case CDDS_ITEMPREPAINT:
			{
				LPNMTVCUSTOMDRAW pCustomDraw = (LPNMTVCUSTOMDRAW)pNMHDR;
/*
				switch (pCustomDraw->iLevel)
				{
					// painting all 0-level items blue,
					// and all 1-level items red (GGH)
				case 0:
					if (pCustomDraw->nmcd.uItemState == (CDIS_FOCUS | CDIS_SELECTED)) // selected
						pCustomDraw->clrText = RGB(255, 255, 255);
					else	
						pCustomDraw->clrText = RGB(0, 0, 255);
					break;
				case 1:
					if (pCustomDraw->nmcd.uItemState == (CDIS_FOCUS | CDIS_SELECTED)) // selected
						pCustomDraw->clrText = RGB(255, 255, 255);
					else	
						pCustomDraw->clrText = RGB(255, 0, 0);
					break;
				}
*/

				pCustomDraw->clrText = RGB(0, 0, 0);

				CChartViewerDoc *doc=m_pConnection->GetDocument();			assert(doc);
				CChartData *data=doc->GetDocumentDataPtr();							assert(data);
				CChartData::CChartLayer *pLayer=data->GetLayerNo((DWORD)(pNMCD->lItemlParam));			assert(pLayer);

				DWORD dwBGR=pLayer->GetColor();
				DWORD dwRGB=((dwBGR&0xff)<<16) | (dwBGR&0xff00) | ((dwBGR&0xff0000)>>16);

				if(pLayer->GetHidden())dwRGB=0xffffff;

				HTREEITEM    hItem = (HTREEITEM)( pNMCD->dwItemSpec );

				CString text=m_LegendTree.GetItemText(hItem);


				int tabs[5]={ 40,100,160,170};		// right side of avg, right side of min, right side of max, left side of name

				char str[1024],*_str=str,*src=text.GetBuffer();

				while(*src!=0 && *src!='\t')*_str++=*src++;
				if(*src=='\t')*_str++=*src++;
				while(*src!=0 && *src!='\t')*_str++=*src++;
				if(*src=='\t')*_str++=*src++;
				while(*src!=0 && *src!='\t')*_str++=*src++;
				if(*src=='\t')src++;
				*_str=0;

				SetTextAlign(pCustomDraw->nmcd.hdc,TA_RIGHT);
				SetTextColor(pCustomDraw->nmcd.hdc,0);

				SetBkColor(pCustomDraw->nmcd.hdc,0xffffff);
				TabbedTextOut(pCustomDraw->nmcd.hdc,pCustomDraw->nmcd.rc.left+tabs[0],pCustomDraw->nmcd.rc.top,str,(int)strlen(str),5-1,&tabs[1],0);

				SetTextAlign(pCustomDraw->nmcd.hdc,TA_LEFT);

				SetBkColor(pCustomDraw->nmcd.hdc,dwRGB);
				TextOut(pCustomDraw->nmcd.hdc,pCustomDraw->nmcd.rc.left+tabs[3],pCustomDraw->nmcd.rc.top,src,(int)strlen(src));

//				*pResult = CDRF_DODEFAULT;
				*pResult = CDRF_SKIPDEFAULT;


			}
			return;
	}

*pResult = 0;
}

void CLegendWindow::OnTvnKeydownTree1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTVKEYDOWN pTVKeyDown = reinterpret_cast<LPNMTVKEYDOWN>(pNMHDR);
	// TODO: Add your control notification handler code here

	*pResult = 0;
}


DWORD CLegendWindow::GetItemNo( NMHDR *pNMHDR ) const
{
	DWORD dw = GetMessagePos();                   // retrieve mouse cursor position when msg was sent
	CPoint p(GET_X_LPARAM(dw), GET_Y_LPARAM(dw)); // ..and put into point structure
	m_LegendTree.ScreenToClient(&p);                    // make coords local to tree client area

	UINT htFlags = 0;
	HTREEITEM it = m_LegendTree.HitTest(p, &htFlags);   // See where the click was on

	if(it != NULL) 
	{   
		return (DWORD)m_LegendTree.GetItemData(it);

		// the check box was hit.
		// we just post a message
//		PostMessage(UWM_TV_CHECKBOX, pNMHDR->idFrom, (LPARAM) it);
	}

	return(0xffffffff);
}



void CLegendWindow::OnNMClickTree1(NMHDR *pNMHDR, LRESULT *pResult)
{
	DWORD dwIndex=GetItemNo(pNMHDR);

	if(dwIndex!=0xffffffff)
	{   
		CChartViewerDoc *doc=m_pConnection->GetDocument();			assert(doc);
		CChartData *data=doc->GetDocumentDataPtr();							assert(data);
		CChartData::CChartLayer *pLayer=data->GetLayerNo(dwIndex);			assert(pLayer);

		pLayer->SetHidden(!pLayer->GetHidden());
	}

	m_pConnection->RedrawWindow();
	m_LegendTree.RedrawWindow();
		
	*pResult = 0;
}


void CLegendWindow::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	if(cx==0 || cy==0)return;
	if(!m_LegendTree.GetSafeHwnd())return;

	RECT rec;

	rec.left=0;
	rec.top=0;
	rec.right=cx;
	rec.bottom=cy;
	m_LegendTree.MoveWindow(&rec,true);
}

void CLegendWindow::OnNMRclickTree1(NMHDR *pNMHDR, LRESULT *pResult)
{
	DWORD dwIndex=GetItemNo(pNMHDR);

	if(dwIndex!=0xffffffff)
	{   
		CChartViewerDoc *doc=m_pConnection->GetDocument();			assert(doc);
		CChartData *data=doc->GetDocumentDataPtr();							assert(data);
		CChartData::CChartLayer *pLayer=data->GetLayerNo(dwIndex);			assert(pLayer);

		pLayer->SetHidden(false);
		pLayer->CycleColor();
	}

	m_pConnection->RedrawWindow();
	m_LegendTree.RedrawWindow();
		
	*pResult = 0;
}
