/*****************************************************************************
 ** osr_types.h - osr os data types
 **
 ** Copyright (C) 2002 Rodrigo OSORIO. All rights reserved.
 **
 ** Redistribution and use in source and binary forms, with
 ** or  without  modification, are permitted  provided that 
 ** the following conditions are met:
 **
 ** 1. Redistributions of source code must retain the above 
 **    copyright notice, this  list of  conditions  and the 
 **    following disclaimer. 
 **    
 ** 2. Redistributions in binary  form  must reproduce  the
 **    above copyright  notice, this list of conditions and
 **    the following disclaimer in the documentation and/or
 **    other materials provided with the distribution. 
 **
 ** 3. Neither the name of this application nor the names of
 **    its  contributors may be used to  endorse or  promote 
 **    products derived from this software without  specific
 **    prior written permission. 
 **
 ** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 ** CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 ** INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 ** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 ** DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 ** CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 ** NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 ** LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 ** CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 ** OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 ** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *****************************************************************************/

// Prevent header redefinition
//*****************************
#ifndef FILE_OSR_TYPES_H
#define FILE_OSR_TYPES_H

#include <stdio.h>
/*
 * Osr errors
 *****************************************************************************/
typedef enum _OSR_ERROR
{
	// Common error codes
	//***************************************
	OSR_SUCCESS =0,                   //    0
	OSR_PROBLEM,                      //    1
	OSR_INVALID_PARAMETER,            //    2
	OSR_INVALID_ACCESS,               //    3
	OSR_NOT_SUPORTED,                 //    4
	OSR_INVALID_STATE,                //    5
	OSR_NO_MEMORY,                    //    6
	OSR_CANNOT_ACCESS_RESSOURCE,      //    7
	OSR_SECURITY_VIOLATION,           //    8
	OSR_SYSTEM_ERROR,                 //    9
	OSR_FAILURE,                      //   10
	OSR_TIMEOUT,                      //   11
	OSR_BAD_HANDLE,                   //   12
	OSR_BAD_VERSION,                  //   13
	OSR_NO_INTERFACE,                 //   14
	OSR_OUT_OF_RANGE,                 //   15
	OSR_PARAMETER_MISSING,            //   16
	OSR_BUFFER_TOO_SHORT,             //   17
	OSR_UNINITIALIZED,                //   18
	OSR_NO_SUCH_ENTRY,                //   19
	OSR_OS_ERROR,                     //   20
	OSR_NULL_POINTER_ERROR,           //   21
	OSR_UNINITIALIZED_HANDLE,         //   22
	OSR_STATEMENT_OVERRUN,            //   23
	OSR_EOF,                          //   24
	OSR_INVALID_HANDLE,               //   25
	OSR_CORRUPTED_DATAS,              //   26
	OSR_SUCCESS_WITH_INFORMATIONS,    //   27
	OSR_ACCEPTABLE_ERROR,             //   28
	OSR_UNKNOWN_ERROR,                //   29
	//***************************************

	// Communication errors
	//***************************************
	OSR_COMM_ERROR = 100,             //  100
	OSR_COMM_UNINITIALIZED,           //  101
	OSR_COMM_UNSUPORTED_MODE,         //  102
	OSR_COMM_UNKNOWN_PROTOCOL,        //  103
	OSR_COMM_INVALID_HANDLE,          //  104
	OSR_COMM_BIND_ERROR,              //  105
	OSR_COMM_CONNECT_ERROR,           //  106
	OSR_COMM_IOCTL_ERROR,             //  107
	OSR_COMM_INVALID_STATE,           //  108
	OSR_COMM_ACCEPT_ERROR,            //  109
	//***************************************

} OSR_ERROR;


/*
 * String buffer usage
 *****************************************************************************/
#define STR_CHAR8                  9         // buffer size including the 0 limit
#define STR_CHAR16                17         // buffer size including the 0 limit
#define STR_CHAR32                33         // buffer size including the 0 limit
#define STR_CHAR64                65         // buffer size including the 0 limit
#define STR_CHAR8_ZERO             8         // zero position in a 8 bytes string
#define STR_CHAR16_ZERO           16         // zero position in a 16 bytes string
#define STR_CHAR32_ZERO           32         // zero position in a 32 bytes string
#define STR_CHAR64_ZERO           64         // zero position in a 32 bytes string


/*
 * Little and big endian conversion functions
 *****************************************************************************/
// Little to big endian short
#define LITTLE_TO_BIG16(A)  ((((A) & 0xff00) >> 8)|(((A) & 0x00ff) << 8))
// Little to big endian long
#define LITTLE_TO_BIG32(A)  ((((A) & 0xff000000) >> 24) | (((A) & 0x00ff0000) >> 8) | \
                   (((A) & 0x0000ff00) << 8) |  (((A) & 0x000000ff) << 24))
// Big to little endian short
#define BIG_TO_LITTLE16  LITTLE_TO_BIG16
// Big to little endian long
#define BIG_TO_LITTHE32  LITTLE_TO_BIG32


#define OS_BIG_ENDIAN              0
#define OS_LITTLE_ENDIAN           1

/*
 * Win32 data types definition
 *****************************************************************************/
#ifdef _WIN32

	#include <windows.h>
/*
 * Visual C++ definition	
 *****************************************************************************/
#ifdef __cplusplus	
	#define OSR_DLL_EXPORT   extern "C" __declspec( dllexport )
	#define OSR_DLL_IMPORT   extern "C" __declspec( dllimport )
#else
	#define OSR_DLL_EXPORT   extern __declspec( dllexport )
	#define OSR_DLL_IMPORT   extern __declspec( dllimport )
#endif
	#define OSR_CALL __cdecl
			
    #define OSR_VAR_GLOBAL   extern
	#define OSR_INVALID_SEM_VALUE    NULL
	#define OSR_INVALID_HANDLE_VALUE 0

    /*
	 * Data types
	 *************************************************************************/
	typedef unsigned char       UCHAR;      // 8 bit data type
	typedef unsigned short int  U16BIT;     //unsigned 16 bit data type
	typedef short int           S16BIT;     //signed   16 bit data type
	typedef unsigned long int   U32BIT;     //unsigned 32 bit data type
	typedef unsigned long int   S32BIT;     //signed   32 bit data type
	typedef double              S64BIT;     //signed   64 bit data type

	typedef UCHAR               OSR_FLAG;   //Flag (TRUE or FALSE)
//	typedef Socket              OSR_SOCKET; //Socket

/*
 * Add here the other supported OSs
 ******************************************************************************/
#else
#error   OSR ERROR : Unknown operating system
#endif

/*
 * If they aren't, define the TRUE and FALSE values
 *****************************************************************************/
#ifndef TRUE
  #define TRUE 1
#endif
#ifndef FALSE
  #define FALSE 0
#endif

/*
 * LOG_ERROR function
 ******************************************************************************/

OSR_VAR_GLOBAL UCHAR OsrErrorMessage[1024];

void OSR_CALL OsrLogError(int state,int error,char * comment,char * file,int line,int WinError);

#define LOG_ERROR(state,error) OsrLogError(state,error,(char *)OsrErrorMessage,__FILE__,__LINE__,GetLastError());
#define SET_ERROR_MSG(message) strncpy_s((char *)OsrErrorMessage, 1024,(char *)message,1023); OsrErrorMessage[1023] = 0;

#endif