#ifndef DJS_CLIENT_H
#define DJS_CLIENT_H

#include "../Common/Zockets/net.h"

//Debug stuffs:
//#define				EMULATION_ENABLED		1																			//Enable to emulate a client without needed to run the server

#define				MAX_WORKERTHREAD_NUMBER	16										//The maximum number of the used cpus in one client

class cDJS_WorkerThread;

/*
Cache-ed directly from the job servers. Different version - different info
*/
struct SJobServerInfoEx
{
	char									m_szName[1024];										//the name of the job server
	bool									m_bExclusiveMode;									//is needed to run alone - no other servers can run at all.
	int										m_nMaxThread;											//the max number
	int										m_nMinMemoryPerThread;						//the neccessary (estimated) memory needed for the thread
	int										m_nCurrentNumberOfRunningThread;	//the number of running thread of this server
};

/*
	Worker thread info
*/
struct SWorkerInfo
{
	cDJS_WorkerThread*		m_pThread;												//worker thread...
	FixedString						m_Command;												//The command
	double								m_StartTime;											//when the thread started
	int										m_nJobServerID;										//the index of the job server
	bool                  m_bExclusiveMode;
};

/*
	DJS_Client the client application.
*/
class CDistributedJobService_Client
{
public:

	int									Init(const bool bSmallInfo,const int nFreeMemoryMB);					//Init
	int									Run();																												//Run
	int									Done();																												//Done

private:
	void								ShowInfo();																										//Show an info screen
	int									CheckForFreeWorker();																					//Search a free worker thread
	int									InitWorker( const FixedString* pCommand, const int nWorkerID );		//Create a new worker thread
	int									ManageWorkers();																							//Manage the worker threads (check which alive..)
	void                StopWorkers();                                                //Stop all worker threads
	void                StopWorker( const char *sJob );
	SJobServerInfoEx*		GetServerInfo( const char* szJobServerName );									//Search a job server info
	void                Update();

	int							m_nFreeMemoryMB;																									//The size of memory i can use..
	int							m_nAllocatedMemoryMB;																							//The allocated memory i allready used
	int							m_nNumberOfUsableWorkerThread;																		//Number of CPU
	SWorkerInfo			m_Workers[MAX_WORKERTHREAD_NUMBER];																//Worker threads...
	int							m_nJobServerInfoNumber;																						//job server info number
	SJobServerInfoEx*	m_JobServerInfos;																								//the job server infos													
	double					m_dLastInfoTime;																									//last time in sec when the info updated
	double					m_dLastWorkingTime;																									//last time in sec when the info updated
	const char*			m_szClientName;																										//the name of the computer for info screen
	bool						m_bSmallInfo;																											//for file logging.
};



#endif//DJS_CLIENT_H