// stdafx.h : include file for standard system include files,
// or project specific include files that are used frequently, but
// are changed infrequently
//

#pragma once

#include <stdio.h>
#include <tchar.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <vector>
#include <math.h>
#include <ctype.h>

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include <mmsystem.h>
#include <time.h>
#include <conio.h>
#include <winsock.h>
#include <wsipx.h>

#ifndef SOCKET_CLOSE
#define SOCKET_CLOSE        closesocket
#endif

#ifndef SOCKET_IOCTL
#define SOCKET_IOCTL		ioctlsocket
#endif

#ifndef SOCKET_WOULD_BLOCK
#define SOCKET_WOULD_BLOCK  WSAEWOULDBLOCK
#endif

#ifndef SOCKET_LAST_ERROR
#define	SOCKET_LAST_ERROR	WSAGetLastError()
#endif

#ifndef INIT_SYSTEM
#define	INIT_SYSTEM         initWinSock()
#endif

#pragma comment(lib,"wsock32.lib")
#pragma comment(lib,"winmm.lib")

#else
#include <sys/time.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <termios.h>
#include <unistd.h>

#include "netdb.h"
#include "unistd.h"
#include "signal.h"
#ifdef sgi
#include "bstring.h"
#endif
#include "sys/types.h"
#include "sys/time.h"
#include "sys/socket.h"
#include "sys/ioctl.h"
#include "netinet/in.h"
#include "arpa/inet.h"
#include "sys/termios.h"
#include "minmax.h"
#ifdef bsdi
#include "errno.h"
#include "netinet/tcp.h"
#endif

#define SOCKET_CLOSE		::close
#define SOCKET_IOCTL		::ioctl
#define SOCKET_WOULD_BLOCK  EINPROGRESS
#define	SOCKET_LAST_ERROR   errno
#define SOCKET_ERROR        (-1)

#define	INIT_SYSTEM         (1)
#endif

#ifdef WIN32
#define DJS_LoadLibrary( DLLName ) ::LoadLibraryA( DLLName )
#define DJS_GetProcAddress( DLLName, ProcName ) ::GetProcAddress( DLLName, ProcName );
#define DJS_FreeLibrary( DLLName )	::FreeLibrary( DLLName );
#endif

extern HMODULE DJS_GetAndLoadLibrary( const char *sLib );

// TODO: reference additional headers your program requires here
