/*
	Small test JobServer - it exec a "job" on windows
*/

#include "stdafx.h"
#include "..\Common\IJobServer.h"

#ifdef UNICODE
	#undef  UNICODE
#endif
#include <shellapi.h>

#include <windows.h>
#include <tlhelp32.h>
#include <shlobj.h>
#include <Shlwapi.h>
#include <winuser.h>


#pragma comment(lib, "winmm.lib")
#pragma comment( lib, "Shlwapi.lib")  
#pragma comment( lib, "user32.lib")  



#ifdef _MANAGED
#pragma managed(push, off)
#endif

#ifdef WIN32

BOOL APIENTRY DllMain( HMODULE hModule,
											DWORD  ul_reason_for_call,
											LPVOID lpReserved
											)
{
	return TRUE;
}
#endif //WIN32


class CExecJobServer : public IJobServer
{
public:
	virtual JobServerResult Init( const char* sJob,const char *sWorkPath )
	{
		SHELLEXECUTEINFOA ExecInfo;

		ZeroMemory(&ExecInfo,sizeof(ExecInfo));
		ExecInfo.cbSize = sizeof(ExecInfo);
		ExecInfo.hwnd = NULL;

		strcpy_s( m_sText, 1024, sJob );
		m_sDir = m_sText;
		m_sFile = strchr( m_sText, ' ' );
		if( m_sFile )
		{
			*m_sFile++ = 0;
			m_sParameters = strchr( m_sFile, ' ' );
			if( m_sParameters )
				*m_sParameters++ = 0;
		}
		else
			m_sParameters = NULL;
		
		char szFullPath[MAX_PATH];
		strcpy_s( szFullPath, MAX_PATH, m_sDir );
		strcat_s( szFullPath, MAX_PATH, "\\" );
		if( m_sFile ) 
			strcat_s( szFullPath, MAX_PATH, m_sFile );

		ExecInfo.lpFile = szFullPath;
		ExecInfo.lpParameters = m_sParameters;
		ExecInfo.lpDirectory =m_sDir;
		ExecInfo.nShow = SW_HIDE;
		ExecInfo.hInstApp = 0;
		ExecInfo.fMask = SEE_MASK_CONNECTNETDRV | SEE_MASK_NOCLOSEPROCESS;

		if( false == ShellExecuteExA( &ExecInfo ) )
				return JSRESULT_DATA_ERROR;

		CloseHandle( ExecInfo.hProcess );

		return JSRESULT_OK;
	}

	virtual JobServerResult Tick()
	{
		HANDLE hSnapshot = CreateToolhelp32Snapshot(TH32CS_SNAPALL,0);
		if( INVALID_HANDLE_VALUE == hSnapshot ) 
			return JSRESULT_INTERNAL_ERROR;

		PROCESSENTRY32 PE;
		ZeroMemory(&PE, sizeof(PROCESSENTRY32) );
		PE.dwSize = sizeof( PROCESSENTRY32 );

		DWORD dwRet = Process32First(hSnapshot,&PE);
		while( dwRet )
		{		
			if( _stricmp( PE.szExeFile, m_sFile ) == 0 )
			{
				CloseHandle(hSnapshot);
				Sleep(500);
				return JSRESULT_OK;
			}

			ZeroMemory( &PE,sizeof( PROCESSENTRY32 ) );
			PE.dwSize = sizeof( PROCESSENTRY32 );
			dwRet = Process32Next(hSnapshot,&PE);
		}

		CloseHandle(hSnapshot);
		return JSRESULT_FINISHED;
	}

	virtual JobServerResult Done()
	{
		return JSRESULT_OK;
	}

	virtual int GetUsedMemoryMB()
	{
		return 0;
	}

	virtual int GetPercent()
	{
		return 0;
	}

protected:
	char			m_sText[1024];
	char*			m_sDir;
	char*			m_sFile;
	char*			m_sParameters;
};


extern "C"
{
	JOBSERVER_API void DeleteJobServer( IJobServer* pJobServer )
	{
		if( pJobServer )
			delete pJobServer;
	}

	JOBSERVER_API IJobServer* CreateJobServer( int nThreadID, JobServerPlatform ePlatform, const int nIJobServerVersion )
	{
		if( nThreadID != 0 || IJOBSERVERVERSION != nIJobServerVersion )
			return NULL;

		return new CExecJobServer;
	}

	JOBSERVER_API void GetJobServerInfo( SJobServerInfo* pInfo )
	{
		if( pInfo )
		{
				pInfo->m_nMaxThread = 1;
//				pInfo->m_nMinMemoryPerThread = 0;
		}
	}
};

#ifdef _MANAGED
#pragma managed(pop)
#endif

