#ifndef DJS_SERVER_H
#define DJS_SERVER_H

#include "stdafx.h"
#include "JobQuelleManager.h"
#include "../Common/Zockets/net.h"


class CDistributedJobService_Server
{
public:
	CDistributedJobService_Server():m_szClientName(NULL)
	{}

	int																	Init( bool bUpdateMode );															//Init
	void																Run();																								//Run
	void																Done();																								//Done

private:
	void																ShowInfo();																						//update the info screen
	void																ReciveJobs();																					//recive the jobs form commanders
	void																DistributeJobs();																			//distribute the jobs to the clients
	void																Command_ClearJobList();																//RPC command: clear job list
	void                                SendServerStatus();
	int                                 GetNotDoneCommandsCount();
	void                                JobFinished( int nCommandIndex,const char *reason );

	CJobQuelleManager										QuelleManager;
	double															m_dLastInfoTime;																			//last time when the info screen was updated
	double															m_dLastServerStatusTime;															//last time when the server status was sent to clients.
	double															m_dLastSendJobTime;															      //last time when the server send job to clients.
	const char*													m_szClientName;																				//the name of the host for info screen
	bool m_bUpdateMode;
};



#endif//DJS_SERVER_H