#ifndef JOBQUELLEMANAGER_H
#define JOBQUELLEMANAGER_H

#include "stdafx.h"
#include "../Common/Zockets/net.h"

// A job queue for a Commander
class CJobQuelle
{
public:
	void							InsertJob( CommandInfo& Command );						//Insert an job to the waiting job queue
	void							JobFinished( CommandInfo& Command);					//An job come back from a client, the job can be successed or not..
	bool							GetTheNextJobToSent( CommandInfo** pInfo,bool bGetPending=false );				//Give back the next job, if it found..
	bool							IsEmpty() const;										//no more jobs in the queues
	int								GetPendingJobNumber() const;							//Give back the number of pending jobs
	int								GetLeftJobNumber() const;							//Give back the number of jobs left in the quelle

	struct CompareJobs
	{
		inline bool operator()( const CommandInfo& fs1, const CommandInfo& fs2 ) const
		{
			return (fs1.guid > fs2.guid);
		}
	};

	void							SetCommanderGUID( const int nCommanderGUID  ) { m_CommanderGUID = nCommanderGUID; }
	void							SetPriority( const int nPriority ) { m_nPriority =  m_nPriority; }
	int								GetCommanderGUID() const { return m_CommanderGUID; }
	int								GetPriority() const { return m_nPriority; }
protected:
	void							SortJobs();									//sort the jobs based on GUID

	int								m_nPriority;								//the priority of this queue
	int								m_CommanderGUID;							//the commander GUID of this queue
	std::vector<CommandInfo>		m_Jobs;										//the waiting jobs
	std::vector<CommandInfo>		m_PendingJobs;								//the jobs which sent to the clients
};


// The manager class
class CJobQuelleManager
{
public:
	CJobQuelleManager() : m_GUID(0)
	{}

	void		InsertNotRegisteredJob( const FixedString* pCommand );			//Insert an new job which wasn't in the queue...
	void		JobFinished( CommandInfo &Command );							//An job come back from a client, the job can be successed or not..
	bool		GetTheNextJobToSent( CommandInfo** pInfo,bool bGetPending=false );						//Give back the next job, if it found..


	void		ClearAllJob();													//Remove all jobs from the queues.
	int			GetPendingJobNumber() const;									//Give back the number of pending jobs
	int			GetLeftJobNumber() const;							//Give back the number of jobs left in the quelle
	void		ShowDebugInfo() {};												//It needed to give back debug info to the console, not implemented yet. (the old one's showed the pending commands )

protected:
	void		SortQuelles();													//Short the quelles based on priority/CommanderGUID

	std::vector<CJobQuelle>	m_Quelles;											//The quelles per Commander
	int			m_GUID;															//guid for the new jobs

	struct CompareQuelles
	{
		inline bool operator()( const CJobQuelle& jq1, const CJobQuelle& jq2 ) const
		{
			return (jq1.GetPriority() > jq2.GetPriority());
		}
	};


};

#endif//JOBQUELLEMANAGER_H