#include "stdafx.h"
#include <assert.h>

#include "../Common/IJobServer.h"

extern "C"
{
	JOBSERVER_API void DeleteJobServer( IJobServer* pJobServer );
	JOBSERVER_API IJobServer* CreateJobServer( int nThreadID, JobServerPlatform ePlatform, const int nIJobServerVersion );
	JOBSERVER_API void GetJobServerInfo( SJobServerInfo* pInfo );
};

typedef IJobServer * (*PFNCREATEJOBSERVER)(int nThreadID, JobServerPlatform ePlatform, const int nIJobServerVersion);

int main(int argc, char* argv[])
{
  HMODULE hLib = ::LoadLibraryA("DJS_ShaderPrecacheJobServer.dll");
  assert(hLib);
  if (!hLib)
    return 0;
  PFNCREATEJOBSERVER pfnCreateJobServer;
  pfnCreateJobServer = (PFNCREATEJOBSERVER)::GetProcAddress(hLib, "CreateJobServer");

	IJobServer *pJobServer = pfnCreateJobServer(0,JSP_WINDOWS,IJOBSERVERVERSION);
  assert(pJobServer);

  char szCommand[1024];
  strcpy(szCommand, argv[1]);
  for (int i=2; i<argc; i++)
  {
    strcat(szCommand, " ");
    strcat(szCommand, argv[i]);
  }
//	JobServerResult res = pJobServer->Init("\"D:/Programming/Main/Game/Levels/__RAM_testy/RAM_testy.cry\"");			assert(res==JSRESULT_OK);
	JobServerResult res = pJobServer->Init(szCommand);
  assert(res==JSRESULT_OK);

	for(;;)
	{
		JobServerResult res = pJobServer->Tick();
		
		if(res==JSRESULT_FINISHED)
			break;

		assert(res==JSRESULT_OK);	
	}

	pJobServer->Done();

	delete pJobServer;

  ::FreeLibrary(hLib);

	return 0;
}

