#include <winsock.h>
#include <stdio.h>

void Output( const char * msg )
{
	puts(msg);

	FILE * fout = fopen("\\distributed_log.txt", "at");
	if (fout)
	{
		fputs(msg, fout);
		fputc('\n', fout);
		fclose(fout);
	}
}

void ShowBuffer( sockaddr_in addr, const char * text )
{
	char addrText[4096];
	int nChars = sprintf( addrText, "%d.%d.%d.%d:%d", addr.sin_addr.S_un.S_un_b.s_b1, addr.sin_addr.S_un.S_un_b.s_b2, addr.sin_addr.S_un.S_un_b.s_b3, addr.sin_addr.S_un.S_un_b.s_b4, ntohs(addr.sin_port) );
	for (int i=nChars; i<22; i++)
		addrText[i] = ' ';
	addrText[22] = 0;
	
	const char * begin = text;
	while (true)
	{
		switch (*text)
		{
		case '\n':
			if (begin != text)
			{
				memcpy(addrText+22, begin, text-begin);
				addrText[22 + (text-begin)] = 0;
				Output(addrText);
			}
			text++;
			begin = text;
			break;
		case 0:
			if (begin != text)
			{
				memcpy(addrText+22, begin, text-begin);
				addrText[22 + (text-begin)] = 0;
				Output(addrText);
			}
			return;
		default:
			text++;
			break;
		}
	}
}

int main(void)
{
	printf("Distributed log receiver\n");

	unsigned short wVersionRequested;
	WSADATA wsaData;
	int err;
	// WARNING :use a later version require a change in the multicast code with 
	//			a WS2's specific one
	//			not compatible with other platforms
	wVersionRequested = MAKEWORD(1, 1);

	err = WSAStartup(wVersionRequested, &wsaData);
	if (err != 0)
		return 1;

	if (LOBYTE(wsaData.wVersion) != 1 ||
		HIBYTE(wsaData.wVersion) != 1)
		return 1;

	SOCKET sock = socket( AF_INET, SOCK_DGRAM, IPPROTO_UDP );
	if (sock == INVALID_SOCKET)
		return 1;

	sockaddr_in saddr;
	memset( &saddr, 0, sizeof(saddr) );

	saddr.sin_family = AF_INET;
	saddr.sin_port = htons(0xf109);
	saddr.sin_addr.S_un.S_addr = htonl(0);

	if (0 != bind( sock, (sockaddr*)&saddr, sizeof(saddr) ))
		return 1;

	char buffer[4096];
	while (true)
	{
		fd_set fds;
		FD_ZERO(&fds);
		FD_SET(sock, &fds);
		// not portable to *nix
		int n = select(SOCKET(0), &fds, NULL, NULL, NULL);

		if (n)
		{
			sockaddr_in from;
			int fromlen = sizeof(from);
			int r = recvfrom( sock, buffer, 4096, 0, (sockaddr*)&from, &fromlen );
			if (r >= 1)
			{
				switch (buffer[0])
				{
				case '?':
					buffer[0] = '!';
					sendto( sock, buffer, 1, 0, (sockaddr*)&from, fromlen );
					break;
				case '*':
					buffer[r] = 0;
					ShowBuffer( from, buffer+1 );
					break;
				}
			}
		}
	}
}
