#!/usr/bin/perl

#*************************************************************************
#Crytek Source File.
#Copyright (C), Crytek Studios, 2001-2007.
#-------------------------------------------------------------------------
#$Id$
#$DateTime$
#Description: Update the local Twiki files from the server
#
#-------------------------------------------------------------------------
#History:
#- 07:03:2007: Created by Mathieu Pinard
#
#************************************************************************/ 
use ToolsConfig qw($TwikiLocalPath $TwikiPath PrepareDirectory);
use File::Copy;
use File::Path;

sub CopyAttachments
{
	my $topicname = shift;
	my $filename = $ToolsConfig::TwikiLocalPath."Data\\".$1.".txt";
	
	print "! CopyAttachments ".$topicname." |\n";
	
	open(IN, $filename) || die "open: $!";
	
	while ($line = <IN>)
	{
		if ($line =~ /\%META:FILEATTACHMENT/)
		{
			if ($line =~ /name=\"([\w\.]+)\"/)
			{
				my $attachfile = $1;
				
				if ($attachfile =~ /\.jpg/ or $attachfile =~ /\.gif/ or $attachfile =~ /\.png/ or $attachfile =~ /\.bmp/)
				{
					my $sourcefile = $ToolsConfig::TwikiPath."pub\\".$topicname."\\".$attachfile;
					
					$topicname =~ /\\[\w]+\\(%.*?)/;
					my $destinationfile = $ToolsConfig::TwikiLocalPath."Attachments\\".$topicname."\_".$attachfile;
					
					print STDOUT $destinationfile."\n";
					
					ToolsConfig::PrepareDirectory($destinationfile);
					copy($sourcefile, $destinationfile);
				}
			}
		}
	}
	
	close(IN) || die "close: $!";
}

ToolsConfig::PrepareDirectory($ToolsConfig::TwikiLocalPath."Data\\");

while ($line = <>)
{
	if ($line =~ /\.dtx$/ and $line =~ /Twiki/)
	{
		#print STDOUT $line;
		$line =~ /\\Twiki\\Data\\([\w\\]+).dtx$/;
		
		my $topic = $1;
		my $sourcefile = $ToolsConfig::TwikiPath."Data\\".$topic.".txt";
		my $destinationfile = $ToolsConfig::TwikiLocalPath."Data\\".$topic.".txt";
		
		print STDOUT $destinationfile."\n";
		
		ToolsConfig::PrepareDirectory($destinationfile);
		copy($sourcefile, $destinationfile);
		
		CopyAttachments($topic);
	}
}
