////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   CommandPlayerFmodEx400.cpp
//  Version:     v1.00
//  Created:     8/11/2006 by Tomas
//  Compilers:   Visual Studio.NET
//  Description: FmodEx 4.00 Implementation of a CommandPlayer for Playback
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <map>
#include <string>

#		pragma message (">>> include lib: ../../../CryEngine/CrySoundSystem/FmodEx/lib/fmodexL_vc.lib")
#		pragma comment(lib,"../../../CryEngine/CrySoundSystem/FmodEx/lib/fmodexL_vc.lib")
#		pragma message (">>> include lib: ../../../CryEngine/CrySoundSystem/FmodEx/lib/fmod_eventL.lib")
#		pragma comment(lib,"../../../CryEngine/CrySoundSystem/FmodEx/lib/fmod_eventL.lib")
#		pragma message (">>> include lib: ../../../CryEngine/CrySoundSystem/FmodEx/lib/fmod_event_netL.lib")
#		pragma comment(lib,"../../../CryEngine/CrySoundSystem/FmodEx/lib/fmod_event_netL.lib")


#include "ProcessorClock.h"
#include "TimeValue.h"

#include "TinyXML/tinyxml.h"

#include "..\..\..\CryEngine\CrySoundSystem\CommandPlayerFmodEx400.h"

CProcessorClock clock;
FMOD::EventSystem* g_pEventSystem = 0;
FMOD::System* g_pSystem = 0;

std::map<uint32, void *> m_IndexToPtr;


bool ParseAndPlayCommand(TiXmlElement* pCommand)
{
	if (!pCommand)
		return false;

	int command = 0;
	FMOD_RESULT Result = FMOD_OK;

	pCommand->QueryIntAttribute("ID", &command);
	//pCommand->QueryIntAttribute("T", (int *)&nMilliSecs);

	switch (command)
	{
	case CCommandPlayerFmodEx400::SYSTEM_:
		break;
	case CCommandPlayerFmodEx400::SYSTEM_SETOUTPUT:
		{
			printf("SYSTEM_SETOUTPUT...");

			int Output = 0;

			pCommand->QueryIntAttribute("Output", &Output);

			Result = g_pSystem->setOutput((FMOD_OUTPUTTYPE)Output);

			break;
		}
	case CCommandPlayerFmodEx400::SYSTEM_SETDRIVER:
		{
			printf("SYSTEM_SETDRIVER...");

			int Driver = 0;

			pCommand->QueryIntAttribute("Driver", &Driver);

			Result = g_pSystem->setDriver(Driver);

			break;
		}
	case CCommandPlayerFmodEx400::SYSTEM_SETRECORDDRIVER:
		{
			printf("SYSTEM_SETRECORDDRIVER...");

			int Record= 0;

			pCommand->QueryIntAttribute("Record", &Record);
			
			Result = g_pSystem->setRecordDriver(Record);

			break;
		}
	case CCommandPlayerFmodEx400::SYSTEM_SETHARDWARECHANNELS:
		{
			printf("SYSTEM_SETHARDWARECHANNELS...");

			int Min2D = 0;
			int Max2D = 0;
			int Min3D = 0;
			int Max3D = 0;

			pCommand->QueryIntAttribute("Min2D", &Min2D);
			pCommand->QueryIntAttribute("Max2D", &Max2D);
			pCommand->QueryIntAttribute("Min3D", &Min3D);
			pCommand->QueryIntAttribute("Max3D", &Max3D);

			Result = g_pSystem->setHardwareChannels(Min2D, Max2D, Min3D, Max3D);

			break;
		}
	case CCommandPlayerFmodEx400::SYSTEM_SETSPEAKERMODE:
		{
			printf("SYSTEM_SETSPEAKERMODE...");

			int Speaker = 0;

			pCommand->QueryIntAttribute("Speaker", &Speaker);

			Result = g_pSystem->setSpeakerMode((FMOD_SPEAKERMODE)Speaker);

			break;
		}
	case CCommandPlayerFmodEx400::SYSTEM_SET3DSETTINGS:
		{
			printf("SYSTEM_SET3DSETTINGS...");

			float Doppler = 0.0f;
			float Distance = 0.0f;
			float Rolloff = 0.0f;

			pCommand->QueryDoubleAttribute("Doppler", &Doppler);
			pCommand->QueryDoubleAttribute("Distance", &Distance);
			pCommand->QueryDoubleAttribute("Rolloff", &Rolloff);

			Result = g_pSystem->set3DSettings(Doppler, Distance, Rolloff);
	
			break;
		}
	case CCommandPlayerFmodEx400::EVENTSYSTEM_CREATE: 
		{
			printf("EVENTSYSTEM_CREATE...\n");

			//int pESystem = 0;
			//pCommand->QueryIntAttribute("pESystem", &pESystem);
			//m_IndexToPtr[pESystem] = pEventSystem;
			break;
		}
	case CCommandPlayerFmodEx400::EVENTSYSTEM_INIT: 
		{
			printf("EVENTSYSTEM_INIT...");

			int Channels = 0;
			int Flags = 0;
			int Extra = 0;
			int EventFlags = 0;

			pCommand->QueryIntAttribute("Channels", &Channels);
			pCommand->QueryIntAttribute("Flags", &Flags);
			pCommand->QueryIntAttribute("Extra", &Extra);
			pCommand->QueryIntAttribute("EventFlags", &EventFlags);

			Result = g_pEventSystem->init(Channels, Flags, (void*) Extra, EventFlags);

			break;	
		}
	case CCommandPlayerFmodEx400::EVENTSYSTEM_UPDATE:
		{
			printf("EVENTSYSTEM_UPDATE...");

			Result = g_pEventSystem->update();

			break;
		}
	case CCommandPlayerFmodEx400::EVENTSYSTEM_SET3DNUMLISTENERS:
		{
			printf("EVENTSYSTEM_SET3DNUMLISTENERS...");

			int NumList = 0;

			pCommand->QueryIntAttribute("NumList", &NumList);

			Result = g_pEventSystem->set3DNumListeners(NumList);

			break;
		}
	case CCommandPlayerFmodEx400::EVENTSYSTEM_SET3DLISTENERSATTRIBUTES:
		{
			printf("EVENTSYSTEM_SET3DLISTENERSATTRIBUTES...");

			int ListID = 0;
			FMOD_VECTOR Pos;
			FMOD_VECTOR Vel;
			FMOD_VECTOR Forward;
			FMOD_VECTOR Top;

			pCommand->QueryIntAttribute("ListID", &ListID);
			pCommand->QueryDoubleAttribute("PosX", &Pos.x);
			pCommand->QueryDoubleAttribute("PosY", &Pos.y);
			pCommand->QueryDoubleAttribute("PosZ", &Pos.z);
			pCommand->QueryDoubleAttribute("VelX", &Vel.x);
			pCommand->QueryDoubleAttribute("VelY", &Vel.y);
			pCommand->QueryDoubleAttribute("VelZ", &Vel.z);
			pCommand->QueryDoubleAttribute("ForwardX", &Forward.x);
			pCommand->QueryDoubleAttribute("ForwardY", &Forward.y);
			pCommand->QueryDoubleAttribute("ForwardZ", &Forward.z);
			pCommand->QueryDoubleAttribute("TopX", &Top.x);
			pCommand->QueryDoubleAttribute("TopY", &Top.y);
			pCommand->QueryDoubleAttribute("TopZ", &Top.z);
			
			Result = g_pEventSystem->set3DListenerAttributes(ListID, &Pos, &Vel, &Forward, &Top);

			break;
		}
	case CCommandPlayerFmodEx400::EVENTSYSTEM_LOAD:
		{
			printf("EVENTSYSTEM_LOAD...");

			int iProject = 0;
			FMOD::EventProject *pProject = 0;

			pCommand->QueryIntAttribute("iProject", &iProject);
			const char * sProject = pCommand->Attribute("sProject");
			
			Result = g_pEventSystem->load(sProject, 0, &pProject);

			m_IndexToPtr[iProject] = pProject;

			break;
		}
	case CCommandPlayerFmodEx400::EVENTSYSTEM_UNLOAD:
		break;
	case CCommandPlayerFmodEx400::EVENTSYSTEM_RELEASE:
		break;
	case CCommandPlayerFmodEx400::EVENTSYSTEM_GETSYSTEMOBJECT:
		{
			//FMOD::System* pSystem = 0;
			//FMOD::EventSystem* pESys = 0;
			//int pESystem = 0;
			//int pAPI = 0;

			//pCommand->QueryIntAttribute("pESystem", &pESystem);
			//pCommand->QueryIntAttribute("pAPI", &pAPI);
			//pESys = (FMOD::EventSystem*) m_IndexToPtr[pESystem];

			//Result = pEventSystem->getSystemObject(&pSystem);
			//m_IndexToPtr[pAPI] = pSystem;
			break;
	}
	case CCommandPlayerFmodEx400::EVENTSYSTEM_SETMEDIAPATH:
		{
			printf("EVENTSYSTEM_SETMEDIAPATH...");

			const char * sMediaPath = pCommand->Attribute("sMediaPath");
			
			Result = g_pEventSystem->setMediaPath(sMediaPath);
			
			break;	
		}
	case CCommandPlayerFmodEx400::PROJECT_GETGROUP:
		{
			printf("PROJECT_GETGROUP...");

			int iProject = 0;
			int Cache = 0;
			int iGroup = 0;
			FMOD::EventGroup* pGroup = 0;
			FMOD::EventProject* pProject = 0;

			pCommand->QueryIntAttribute("iProject", &iProject);
			const char * sGroup = pCommand->Attribute("sGroup");
			pCommand->QueryIntAttribute("Cache", &Cache);
			pCommand->QueryIntAttribute("iGroup", &iGroup);

			pProject = (FMOD::EventProject*)m_IndexToPtr[iProject];

			if (pProject)
				Result = pProject->getGroup(sGroup, (Cache!=0), &pGroup);

			m_IndexToPtr[iGroup] = pGroup;
			
			break;
		}
	case CCommandPlayerFmodEx400::GROUP_GETEVENT:
		{
			printf("GROUP_GETEVENT...");

			int iGroup = 0;
			int Mode = 0;
			int iEvent = 0;
			FMOD::EventGroup* pGroup = 0;
			FMOD::Event* pEvent = 0;

			pCommand->QueryIntAttribute("iGroup", &iGroup);
			const char * sEvent = pCommand->Attribute("sEvent");
			pCommand->QueryIntAttribute("Mode", &Mode);
			pCommand->QueryIntAttribute("iEvent", &iEvent);

			pGroup = (FMOD::EventGroup*)m_IndexToPtr[iGroup];

			if (pGroup)
				Result = pGroup->getEvent(sEvent, Mode, &pEvent);

			m_IndexToPtr[iEvent] = pEvent;

			break;
		}
	case CCommandPlayerFmodEx400::GROUP_FREEDATA:
		{
			printf("GROUP_FREEDATA...");

			int iGroup = 0;
			FMOD::EventGroup* pGroup = 0;

			pCommand->QueryIntAttribute("iGroup", &iGroup);

			pGroup = (FMOD::EventGroup*)m_IndexToPtr[iGroup];

			if (pGroup)
				Result = pGroup->freeEventData();

			break;
		}
	case CCommandPlayerFmodEx400::GROUP_FREEEVENTDATA:
		{
			printf("GROUP_FREEEVENTDATA...");

			int iGroup = 0;
			int Idx = 0;
			FMOD::EventGroup* pGroup = 0;
			FMOD::Event* pEvent = 0;

			pCommand->QueryIntAttribute("iGroup", &iGroup);
			pCommand->QueryIntAttribute("Idx", &Idx);

			pGroup = (FMOD::EventGroup*)m_IndexToPtr[iGroup];

			if (pGroup)
			{
				Result = pGroup->getEventByIndex(Idx, EVENT_INFOONLY, &pEvent);
				Result = pGroup->freeEventData(pEvent);
			}

			break;
		}
	case CCommandPlayerFmodEx400::EVENT_PLAY:
		{
			printf("EVENT_PLAY...");

			int iEvent = 0;
			FMOD::Event* pEvent = 0;

			pCommand->QueryIntAttribute("iEvent", &iEvent);

			pEvent = (FMOD::Event*)m_IndexToPtr[iEvent];

			if (pEvent)
				Result = pEvent->start();

			break;
		}
	case CCommandPlayerFmodEx400::EVENT_STOP:
		{
			printf("EVENT_STOP...");

			int iEvent = 0;
			FMOD::Event* pEvent = 0;

			pCommand->QueryIntAttribute("iEvent", &iEvent);

			pEvent = (FMOD::Event*)m_IndexToPtr[iEvent];

			if (pEvent)
				Result = pEvent->stop();

			break;
		}
	case CCommandPlayerFmodEx400::EVENT_SETPAUSED:
		{
			printf("EVENT_SETPAUSED...");

			int iEvent = 0;
			int Paused = 0;
			FMOD::Event* pEvent = 0;

			pCommand->QueryIntAttribute("iEvent", &iEvent);
			pCommand->QueryIntAttribute("Paused", &Paused);

			pEvent = (FMOD::Event*)m_IndexToPtr[iEvent];

			if (pEvent)
				Result = pEvent->setPaused( (Paused!=0) );

			break;
		}
	case CCommandPlayerFmodEx400::EVENT_SETVOLUME:
		{
			printf("EVENT_SETVOLUME...");

			int iEvent = 0;
			float Val = 0.0f;
			FMOD::Event* pEvent = 0;

			pCommand->QueryIntAttribute("iEvent", &iEvent);
			pCommand->QueryDoubleAttribute("Val", &Val);

			pEvent = (FMOD::Event*)m_IndexToPtr[iEvent];

			if (pEvent)
				Result = pEvent->setVolume(Val);

			break;
		}
	case CCommandPlayerFmodEx400::EVENT_SET3DATTRIBUTES:
		{
			printf("EVENT_SET3DATTRIBUTES...");

			int iEvent = 0;
			FMOD_VECTOR Pos;
			FMOD_VECTOR Vel;
			FMOD::Event* pEvent = 0;

			pCommand->QueryIntAttribute("iEvent", &iEvent);
			pCommand->QueryDoubleAttribute("PosX", &Pos.x);
			pCommand->QueryDoubleAttribute("PosY", &Pos.y);
			pCommand->QueryDoubleAttribute("PosZ", &Pos.z);
			pCommand->QueryDoubleAttribute("VelX", &Vel.x);
			pCommand->QueryDoubleAttribute("VelY", &Vel.y);
			pCommand->QueryDoubleAttribute("VelZ", &Vel.z);

			pEvent = (FMOD::Event*)m_IndexToPtr[iEvent];

			if (pEvent)
				Result = pEvent->set3DAttributes(&Pos, &Vel);

			break;
		}
	case CCommandPlayerFmodEx400::EVENT_GETPARAMETER:
		{
			printf("EVENT_GETPARAMETER...");

			int iEvent = 0;
			int iParam = 0;
			FMOD::Event* pEvent = 0;
			FMOD::EventParameter* pParam = 0;

			pCommand->QueryIntAttribute("iEvent", &iEvent);
			const char * sParam = pCommand->Attribute("sParam");
			pCommand->QueryIntAttribute("iParam", &iParam);

			pEvent = (FMOD::Event*)m_IndexToPtr[iEvent];

			if (pEvent)
				Result = pEvent->getParameter(sParam, &pParam);

			m_IndexToPtr[iParam] = pParam;

			break;
		}
	case CCommandPlayerFmodEx400::PARAMETER_SETVALUE:
		{
			printf("PARAMETER_SETVALUE...");

			int iParam = 0;
			float Val = 0.0f;
			FMOD::EventParameter* pParam = 0;

			pCommand->QueryIntAttribute("iParam", &iParam);
			pCommand->QueryDoubleAttribute("Val", &Val);

			pParam = (FMOD::EventParameter*)m_IndexToPtr[iParam];

			if (pParam)
				Result = pParam->setValue(Val);

			break;
		}
	default:
		{
			printf("COMMAND %d not found...\n", command);
			int a = 0;
			return false;
			break;
		}
	}

	if (Result == FMOD_OK)
		printf("done!\n");

	//fputs(m_sCommand, m_pFile);
	//fflush(m_pFile);

	return true;

}

//int _tmain(int argc, _TCHAR* argv[])
int main(int argc, char *argv[])
{
	CCommandPlayerFmodEx400 m_Player;
	TiXmlDocument m_xml;

	int pEvent = 0;
	int pGroup = 0;
	float fValue = 0.0f;

	clock.Init();



	int nTimeMS2 = clock.GetActualTime().GetMS();

	std::string sFile;
	bool bFoundArg = false;

	for (int i=0; i < argc; i++)
	{
		sFile = argv[i];
		//printf("ARG %s \n", sFile.c_str());

		int nPos = sFile.find(".xml", 0);
		if (nPos >= 0)
		{
			bFoundArg = true;
			break;
		}
	}
	char moduleName[_MAX_PATH];
	GetModuleFileNameA( NULL, moduleName, _MAX_PATH );//retrieves the PATH for the current module
	//printf("PATH %s!\n", moduleName);
	
	CHAR Buffer[256];
	GetCurrentDirectoryA(256, Buffer);
	printf("current directory is %s!\n", Buffer);
	SetCurrentDirectoryA("../");
	GetCurrentDirectoryA(256, Buffer);
	printf("changing directory now to %s!\n", Buffer);

	if (!bFoundArg)
		sFile = "SoundCommands.xml";

	bool bResult = m_xml.LoadFile(sFile.c_str());
	TiXmlElement* m_pCursor = m_xml.FirstChildElement("CommandPlayer");

	if (!m_pCursor)
	{
		printf("File %s not found!\n", sFile.c_str());
		Sleep(5000);
		return 0;
	}

	printf("File %s found!\n", sFile.c_str());
	
	//GetCurrentDirectoryA(256, Buffer);
	//printf("DIR %s!\n", Buffer);
	SetCurrentDirectoryA("./Game");
	GetCurrentDirectoryA(256, Buffer);
	printf("changing directory now to %s!\n", Buffer);

	printf("Waiting now for 10 secs. to attach Debugger...\n");
	Sleep(10000);

	FMOD_RESULT Result = FMOD::EventSystem_Create(&g_pEventSystem);
	if (g_pEventSystem)
		Result = g_pEventSystem->getSystemObject(&g_pSystem);

	m_pCursor = m_pCursor->FirstChildElement("Command");
	
	while (m_pCursor)
	{
		int nTime = 0;
		m_pCursor->QueryIntAttribute("T", &nTime);

		int nNow = clock.GetActualTime().GetMS();
		
		while (nNow < nTime)
		{
			Sleep(1);
			nNow = clock.GetActualTime().GetMS();
		}

		ParseAndPlayCommand(m_pCursor);

		m_pCursor = m_pCursor->NextSiblingElement("Command");
	}


	return 1;
}



