#pragma once

#include "types.h"

class CTimeValue
{
public:
	//! default constructor
	CTimeValue()
	{
		m_TimeValue=0;
	}
/*
	//! constructor
	CTimeValue( const sint32 iValue )
	{
		m_TimeValue=(sint64)iValue;
	}
*/

	//! \param iValue in ms
	void SetMS( const sint32 iValue )
	{
		m_TimeValue=(sint32)(iValue*1024);
	}

	float GetSeconds() const
	{
		return (float)((double)(m_TimeValue) / (1000.0*1024.0));
	}

	//!
	void SetRaw( const sint64 Value )
	{
		m_TimeValue=Value;
	}

	//!
	sint64 GetRaw()
	{
		return m_TimeValue;
	}

	//!
	sint32 GetMS() const
	{
		return (sint32)(m_TimeValue/1024);
	}

	CTimeValue &operator+=( const CTimeValue &inRhs )
	{
		m_TimeValue += inRhs.m_TimeValue;
		return *this;
	}

	CTimeValue &operator-=( const CTimeValue &inRhs )
	{
		m_TimeValue -= inRhs.m_TimeValue;
		return *this;
	}

	CTimeValue operator+( const CTimeValue &inRhs ) const
	{
		CTimeValue ret;

		ret.m_TimeValue = m_TimeValue + inRhs.m_TimeValue;

		return ret;
	}

	CTimeValue operator-( const CTimeValue &inRhs ) const
	{
		CTimeValue ret;

		ret.m_TimeValue = m_TimeValue - inRhs.m_TimeValue;

		return ret;
	}

	template <class T>
	CTimeValue operator/( const T inRhs ) const
	{
		CTimeValue ret=*this;

		ret.m_TimeValue/=inRhs;

		return ret;
	}

	// comparison operators ----------------------------

	bool operator<( const CTimeValue &inRhs ) const	{	return m_TimeValue<inRhs.m_TimeValue;	}
	bool operator>( const CTimeValue &inRhs ) const	{	return m_TimeValue>inRhs.m_TimeValue;	}
	bool operator<=( const CTimeValue &inRhs ) const	{	return m_TimeValue<=inRhs.m_TimeValue;	}
	bool operator>=( const CTimeValue &inRhs ) const	{	return m_TimeValue>=inRhs.m_TimeValue;	}
	bool operator==( const CTimeValue &inRhs ) const	{	return m_TimeValue==inRhs.m_TimeValue;	}
	bool operator!=( const CTimeValue &inRhs ) const	{	return m_TimeValue!=inRhs.m_TimeValue;	}

private: // ------------------------------------------

	sint64			m_TimeValue;			//!< in 1/1024ms
};



