
#include "stdafx.h"
#include "FaceAnim.h"
#include "FaceAnimDoc.h"
#include "FaceAnimView.h"
#include "CalibrationAVI4.h"

//////////////////////////////////////////////////////////////////////////
void on_mouse2( int event, int x, int y, int flags, void* param )
{
	
	CFaceAnimDoc *pDoc=(CFaceAnimDoc *)param;
	if ( !pDoc || !pDoc->m_bEditMode )
		return;

	pDoc->EditMarkers2(x,y,event);
}

//////////////////////////////////////////////////////////////////////////
void CFaceAnimDoc::EditMarkers2(int x,int y,int event)
{
	if (event==CV_EVENT_LBUTTONDOWN)
	{
		if ((x>(m_pFace->face.x+m_pFace->face.width)) || (x<(m_pFace->face.x)))
		{
			m_bScaleOperationX=true;
		}
		else
		if ((y>(m_pFace->face.y+m_pFace->face.height)) || (y<(m_pFace->face.y)))
		{
			m_bScaleOperationY=true;
		}
		else
			m_bMoveOperation=true;
	}
	else
	if (event==CV_EVENT_LBUTTONUP)
	{
		m_bScaleOperationX=m_bScaleOperationY=false;
		m_bMoveOperation=false;
		for (int k=0;k<m_pFace->nNumVertices;k++)
		{
			vector3f vPos=m_pFace->lst_vModel_3D[k];			
			vPos.Magnitude(m_pFace->vScale);
			vPos+=m_pFace->vOffset;
			m_pFace->lst_vModel_3D[k]=vPos;
		}
		for (int k=0;k<FA_NUM_MARKERS;k++)
		{
			vector3f vPos=m_pFace->lst_ref_Markers[k].v3DPos;			
			vPos.Magnitude(m_pFace->vScale);
			vPos+=m_pFace->vOffset;
			m_pFace->lst_ref_Markers[k].v3DPos=vPos;
		}
		m_pFace->vScale.Set(1,1,1);				
		m_pFace->vOffset.Set(0,0,0);
	}
	else
	if (event==CV_EVENT_MOUSEMOVE)
	{
		if (m_bScaleOperationX)
		{
			ftype fScale;
			if (x>m_pFace->face_center.x)
				fScale=(ftype)(x-m_pFace->face_center.x)/(ftype)(m_pFace->face.width/2);
			else
				fScale=(ftype)(m_pFace->face_center.x-x)/(ftype)(m_pFace->face.width/2);
			m_pFace->vScale.x=fScale;
		}
		if (m_bScaleOperationY)
		{
			ftype fScale;
			if (y>m_pFace->face_center.y)
				fScale=(ftype)(y-m_pFace->face_center.y)/(ftype)(m_pFace->face.height/2);
			else
				fScale=(ftype)(m_pFace->face_center.y-y)/(ftype)(m_pFace->face.height/2);
			m_pFace->vScale.y=fScale;
		}
		if (m_bMoveOperation)
		{
			m_pFace->vOffset.x=(x-m_pFace->face_center.x)*0.01;
			m_pFace->vOffset.y=-(y-m_pFace->face_center.y)*0.01;
		}
	}
}

//////////////////////////////////////////////////////////////////////////
bool CFaceAnimDoc::CreateFace(const char *szFilename)
{
	m_bEditMode=false;
	m_bScaleOperationX=m_bScaleOperationY=false;
	m_bMoveOperation=false;

	IplImage	*pFrame=cvLoadImage(szFilename);
	if (!pFrame)
		return (false);

	IplImage *pFrameDraw=cvCloneImage(pFrame);

	CvSize frame_size;
	int w=frame_size.width =pFrame->width;
	int h=frame_size.height =pFrame->height;		

	tFaceDetect	tFace;	
	m_pFace=&tFace;

	//////////////////////////////////////////////////////////////////////////
	tFace.storage = cvCreateMemStorage(0);

	const char *cascadeface_name = "Data/haarcascades/haarcascade_frontalface_alt2.xml";
	//sprintf(szFilename,"%s/%s",szFolder,cascadeface_name);
	tFace.cascadeface = (CvHaarClassifierCascade*)cvLoad( cascadeface_name, 0, 0, 0 );	

	//const char *cascadeeyes_name = "Data/haarcascades/parojos.xml";
	//sprintf(szFilename,"%s/%s",szFolder,cascadeeyes_name);
	//CvHaarClassifierCascade*cascadeeyes = (CvHaarClassifierCascade*)cvLoad( szFilename, 0, 0, 0 );	

	const char *cascade_righteye_name = "Data/haarcascades/ojoD.xml";
	//sprintf(szFilename,"%s/%s",szFolder,cascade_righteye_name);
	tFace.cascade_righteye = (CvHaarClassifierCascade*)cvLoad( cascade_righteye_name , 0, 0, 0 );	

	const char *cascade_lefteye_name = "Data/haarcascades/ojoI.xml";
	//sprintf(szFilename,"%s/%s",szFolder,cascade_lefteye_name);
	tFace.cascade_lefteye = (CvHaarClassifierCascade*)cvLoad( cascade_lefteye_name , 0, 0, 0 );	

	const char *cascade_mouth_name = "Data/haarcascades/boca.xml";
	//const char *cascade_mouth_name = "Data/haarcascades/haarcascade_profileface.xml";
	//sprintf(szFilename,"%s/%s",szFolder,cascade_mouth_name);
	tFace.cascade_mouth = (CvHaarClassifierCascade*)cvLoad( cascade_mouth_name, 0, 0, 0 );	
		
	strcpy(tFace.lst_ref_Markers[FA_LT_EYEBROW_LT].szName,"left_eyebrow_left");
	strcpy(tFace.lst_ref_Markers[FA_LT_EYEBROW_RT].szName,"left_eyebrow_right");
	strcpy(tFace.lst_ref_Markers[FA_RT_EYEBROW_LT].szName,"right_eyebrow_left");
	strcpy(tFace.lst_ref_Markers[FA_RT_EYEBROW_RT].szName,"right_eyebrow_right");	
	strcpy(tFace.lst_ref_Markers[FA_LT_CHEEK].szName,"left_cheek");
	strcpy(tFace.lst_ref_Markers[FA_RT_CHEEK].szName,"right_cheek");
	strcpy(tFace.lst_ref_Markers[FA_MOUTH_LT].szName,"left_mouthcorner");
	strcpy(tFace.lst_ref_Markers[FA_MOUTH_RT].szName,"right_mouthcorner");
	strcpy(tFace.lst_ref_Markers[FA_LT_LIP_TOP].szName,"left_lip_top");
	strcpy(tFace.lst_ref_Markers[FA_RT_LIP_TOP].szName,"right_lip_top");
	//strcpy(tFace.lst_ref_Markers[FA_LT_LIP_BOTTOM].szName,"left_lip_bottom");
	//strcpy(tFace.lst_ref_Markers[FA_RT_LIP_BOTTOM].szName,"right_lip_bottom");
	strcpy(tFace.lst_ref_Markers[FA_LT_NOSE].szName,"left_nose");
	strcpy(tFace.lst_ref_Markers[FA_RT_NOSE].szName,"right_nose");
	strcpy(tFace.lst_ref_Markers[FA_CHIN].szName,"chin");
	strcpy(tFace.lst_ref_Markers[FA_NOSE].szName,"nose");

	CvFont font1;
	cvInitFont( &font1, CV_FONT_HERSHEY_SIMPLEX, 0.35, 0.35);  		
	cvNamedWindow("FaceCreation", CV_WINDOW_AUTOSIZE);
	cvSetMouseCallback( "FaceCreation", on_mouse2, this );
	
	CvScalar colors[] = 
	{
		{{0,0,255}},
		{{0,128,255}},
		{{0,255,255}},
		{{0,255,0}},
		{{255,128,0}},
		{{255,255,0}},
		{{255,0,0}},
		{{255,0,255}}
	};

	char szText[256];
	sprintf(szText,"%s","Test");
	cvPutText( pFrameDraw, szText,cvPoint(10,20), &font1, cvScalar(255,0,0) );
	
	MyOutputDebugString("Attempting to load faceaa.obj\n");
	if (!LoadOBJ("faceaa.obj",&tFace))
	{
		MyError("Cannot load obj") ;
	}

	IplImage *frame1_1C= cvCreateImage(frame_size,8,1);	
	cvConvertImage(pFrame, frame1_1C, 0);				
	// equalize for face detection etc.
	cvEqualizeHist( frame1_1C, frame1_1C );
	cvClearMemStorage( tFace.storage );
	//cvShowImage("FaceCreation", frame1_1C);
	//cvWaitKey(0);

	//////////////////////////////////////////////////////////////////////////
	// face
	double t = (double)cvGetTickCount();
	CvSeq* faces = cvHaarDetectObjects( frame1_1C, tFace.cascadeface, tFace.storage,
		//1.1, 2, 0/*CV_HAAR_DO_CANNY_PRUNING*/,
		1.1, 3, 0/*CV_HAAR_DO_CANNY_PRUNING*/
		//,cvSize(30, 30) );
		//,cvSize(20, 20) );
		);

	bool bFaceFound=false;
	if (faces && faces->total==1)
	{		
		bFaceFound=true;

		float scale=1.0f;
		//for(int i = 0; i < (faces ? faces->total : 0); i++ )

		CvRect* r = (CvRect*)cvGetSeqElem( faces, 0 );
		// copy cos its sharing data pointers
		CvRect	face_rect=cvRect(r->x,r->y,r->width,r->height);		

		tFace.face_center.x = cvRound((r->x + r->width*0.5));
		tFace.face_center.y = cvRound((r->y + r->height*0.5));
		tFace.radius = cvRound((r->width + r->height)*0.25);

		//cvCircle( pFrameDraw, tFace.face_center, tFace.radius, colors[0], 3, 8, 0 );
		//cvDrawRect(pFrameDraw,cvPoint(r->x,r->y),cvPoint(r->x+r->width,r->y+r->height),colors[0]);
		tFace.face=cvRect(r->x,r->y,r->width,r->height);
		
		CvSize face_size;
		face_size.width=r->width;
		face_size.height=r->height;
		IplImage *pTemp=cvCreateImage( face_size, 8, 1 );			
		cvGetRectSubPix(frame1_1C,pTemp,cvPoint2D32f(tFace.face_center.x,tFace.face_center.y));

		//////////////////////////////////////////////////////////////////////////
		// left eye

		cvClearMemStorage( tFace.storage );
		t = (double)cvGetTickCount();
		CvSeq* eyeL = cvHaarDetectObjects( pTemp, tFace.cascade_lefteye, tFace.storage,
			//1.1, 2, 0//CV_HAAR_DO_CANNY_PRUNING,
			1.1, 3, 0//CV_HAAR_DO_CANNY_PRUNING
			//,cvSize(30, 30) );
			//,cvSize(20, 20) );
			);

		CvRect	eye_bestL;
		int		bestyposL=-1000;		
		for(int i = 0; i < (eyeL ? eyeL->total : 0); i++ )
		{			
			CvRect* r2 = (CvRect*)cvGetSeqElem( eyeL, i );

			CvPoint eye_center;				
			eye_center.x = face_rect.x+cvRound((r2->x + r2->width*0.5));
			eye_center.y = face_rect.y+cvRound((r2->y + r2->height*0.5));
			//if (eye_center.y>face_center.y)
			//	continue; // mouth or nose

			if (face_rect.y+r2->y+r2->height>(tFace.face_center.y+4))
				continue; // mouth or nose

			if (eye_center.x>tFace.face_center.x)
				continue; // right eye

			// copy cos its sharing data pointers
			CvRect	eyeRect=cvRect(r2->x,r2->y,r2->width,r2->height);
			if (eye_center.y>bestyposL)
			{
				eye_bestL=eyeRect;
				bestyposL=eye_center.y;
			}			
			tFace.bEyeLDetected=true;
		} //i

		if (tFace.bEyeLDetected)
		{	
			//cvDrawRect(pFrameDraw,cvPoint(face_rect.x+eye_bestL.x,face_rect.y+eye_bestL.y),cvPoint(face_rect.x+eye_bestL.x+eye_bestL.width,face_rect.y+eye_bestL.y+eye_bestL.height),colors[1]);
			tFace.eye_left=cvRect(face_rect.x+eye_bestL.x,face_rect.y+eye_bestL.y,eye_bestL.width,eye_bestL.height);
		}

		//////////////////////////////////////////////////////////////////////////
		// right eye

		cvClearMemStorage( tFace.storage );
		t = (double)cvGetTickCount();
		CvSeq* eyeR = cvHaarDetectObjects( pTemp, tFace.cascade_righteye, tFace.storage,
			//1.1, 2, 0//CV_HAAR_DO_CANNY_PRUNING,
			1.1, 3, 0//CV_HAAR_DO_CANNY_PRUNING
			//,cvSize(30, 30) );
			//,cvSize(20, 20) );
			);

		CvRect	eye_bestR;
		int		bestyposR=-1000;
		//int		nBestSize=0;		

		for(int i = 0; i < (eyeR ? eyeR->total : 0); i++ )
		{			
			CvRect* r2 = (CvRect*)cvGetSeqElem( eyeR, i );

			//cvDrawRect(frame1,cvPoint(face_rect.x+r2->x,face_rect.y+r2->y),cvPoint(face_rect.x+r2->x+r2->width,face_rect.y+r2->y+r2->height),colors[2]);

			CvPoint eye_center;				
			eye_center.x = face_rect.x+cvRound((r2->x + r2->width*0.5));
			eye_center.y = face_rect.y+cvRound((r2->y + r2->height*0.5));
			//if (eye_center.y>face_center.y)
			if (face_rect.y+r2->y+r2->height>(tFace.face_center.y+4))
				continue; // mouth or nose

			if (eye_center.x<tFace.face_center.x)
				continue; // left eye

			// copy cos its sharing data pointers
			CvRect	eyeRect=cvRect(r2->x,r2->y,r2->width,r2->height);				
			if (eye_center.y>bestyposR)
			{
				eye_bestR=eyeRect;
				bestyposR=eye_center.y;
				//nBestSize=nSize;
			}			
			tFace.bEyeRDetected=true;				
		} //i

		if (tFace.bEyeRDetected)
		{	
			//cvDrawRect(pFrameDraw,cvPoint(face_rect.x+eye_bestR.x,face_rect.y+eye_bestR.y),cvPoint(face_rect.x+eye_bestR.x+eye_bestR.width,face_rect.y+eye_bestR.y+eye_bestR.height),colors[2]);
			tFace.eye_right=cvRect(face_rect.x+eye_bestR.x,face_rect.y+eye_bestR.y,eye_bestR.width,eye_bestR.height);
		}

		//////////////////////////////////////////////////////////////////////////
		// mouth

		cvClearMemStorage( tFace.storage );
		t = (double)cvGetTickCount();
		CvSeq* mouth = cvHaarDetectObjects( pTemp, tFace.cascade_mouth, tFace.storage,
			//1.1, 2, 0//CV_HAAR_DO_CANNY_PRUNING,
			1.1, 3, 0//CV_HAAR_DO_CANNY_PRUNING
			//,cvSize(30, 30) );
			//,cvSize(20, 20) );
			);

		CvRect	mouth_best;
		int		bestypos_mouth=-1000;		

		for(int i = 0; i < (mouth ? mouth->total : 0); i++ )
		{			
			CvRect* r2 = (CvRect*)cvGetSeqElem( mouth, i );

			CvPoint mouth_center;				
			mouth_center.x = face_rect.x+cvRound((r2->x + r2->width*0.5));
			mouth_center.y = face_rect.y+cvRound((r2->y + r2->height*0.5));				

			//cvDrawRect(frame1,cvPoint(face_rect.x+r2->x,face_rect.y+r2->y),cvPoint(face_rect.x+r2->x+r2->width,face_rect.y+r2->y+r2->height),colors[5]);

			//if (mouth_center.y<face_center.y)
			if (face_rect.y+r2->y<tFace.face_center.y)
				continue; // nose

			// copy cos its sharing data pointers
			CvRect	mouthRect=cvRect(r2->x,r2->y,r2->width,r2->height);
			if (mouth_center.y>bestypos_mouth)
			{
				mouth_best=mouthRect;
				bestypos_mouth=mouth_center.y;
			}			
			tFace.bMouthDetected=true;				
		} //i

		if (tFace.bMouthDetected)
		{	
			//cvDrawRect(pFrameDraw,cvPoint(face_rect.x+mouth_best.x,face_rect.y+mouth_best.y),cvPoint(face_rect.x+mouth_best.x+mouth_best.width,face_rect.y+mouth_best.y+mouth_best.height),colors[4]);
			tFace.mouth=cvRect(face_rect.x+mouth_best.x,face_rect.y+mouth_best.y,mouth_best.width,mouth_best.height);
		}

		cvReleaseImage(&pTemp);
	
		//////////////////////////////////////////////////////////////////////////
		// camera
		tFace.mProjMatrix.Identity();
		ftype fZMin=0.15f;
		ftype fZMax=20.0f;

		tFace.nViewport[0]=0;tFace.nViewport[2]=w;
		tFace.nViewport[1]=0;tFace.nViewport[3]=h;

		MyPerspective3(60.0,(ftype)(w)/(ftype)(h),fZMin,fZMax,tFace.mProjMatrix);

		// view matrix		
		tFace.mViewMatrix.Identity();		
		//mat.RotateMatrixf(180.0,1.0,0,0);//rot+=1.0;		
		//mat.MultMatrixf(&m_Orig.m_Tvalues[0][0]);
		//mat.TranslateMatrix(-m_vPos);

		// cached MyProject matrix
		double m[16];
		matmul2(m,&tFace.mProjMatrix.m_Tvalues[0][0],&tFace.mViewMatrix.m_Tvalues[0][0]);				
		memcpy(&tFace.mMatrix.m_Tvalues[0][0],m,sizeof(double)*16);				

		// cached MyUnProject matrix
		invert_matrix(&tFace.mMatrix.m_Tvalues[0][0], m);
		memcpy(&tFace.mInvertedViewMatrix.m_Tvalues[0][0],m,sizeof(CMatrixf));

		vector3f vMins,vMaxs;
		vMins.SetMax();vMaxs.SetMin();		
		vector3f vCorners2D[4],vCorners3D[4];
		vCorners2D[0].Set(tFace.face.x,tFace.face.y,0.99);
		vCorners2D[1].Set(tFace.face.x+tFace.face.width,tFace.face.y,0.99);
		vCorners2D[2].Set(tFace.face.x+tFace.face.width,tFace.face.y+tFace.face.height,0.99);
		vCorners2D[3].Set(tFace.face.x,tFace.face.y+tFace.face.height,0.99);
		vector3f vCenter(0,0,0);
		for (int j=0;j<4;j++)		
		{
			tFace.UnProjectFromScreen(vCorners2D[j],vCorners3D[j]);
			vMins.CheckMin(vCorners3D[j]);
			vMaxs.CheckMax(vCorners3D[j]);
			tFace.ProjectToScreen(vCorners3D[j],vCorners2D[j]);
			vCenter+=vCorners3D[j];
		}
		vCenter/=4.0;		


		// flip all
		for (int k=0;k<FA_NUM_MARKERS;k++)
		{
			vector3f vPos=tFace.lst_ref_Markers[k].v3DPos;
			vPos.y=-vPos.y;
			tFace.lst_ref_Markers[k].v3DPos=vPos;			
		} //k

		tFace.v3DMins.SetMax();
		tFace.v3DMaxs.SetMin();
		tFace.vRef_3DCenter.Clear();
		for (int k=0;k<tFace.nNumVertices;k++)
		{
			vector3f vPos=tFace.lst_vModel_3D[k];
			vPos.y=-vPos.y;
			tFace.lst_vModel_3D[k]=vPos;
			tFace.v3DMins.CheckMin(tFace.lst_vModel_3D[k]);
			tFace.v3DMaxs.CheckMax(tFace.lst_vModel_3D[k]);
			tFace.vRef_3DCenter+=tFace.lst_vModel_3D[k];
		} //k
		tFace.vRef_3DCenter/=(ftype)(tFace.nNumVertices);
				
		//ftype	fScaleX=(vMaxs.x-vMins.x)/(tFace.v3DMaxs.x-tFace.v3DMins.x);
		//ftype	fScaleY=(vMaxs.y-vMins.y)/(tFace.v3DMaxs.y-tFace.v3DMins.y);

		vector3f vDest;		
		vector3f v1,v2,v3;
		vDest.Set(tFace.eye_left.x,tFace.eye_left.y,0.99);
		tFace.UnProjectFromScreen(vDest,v1);
		vDest.Set(tFace.eye_right.x,tFace.eye_right.y,0.99);
		tFace.UnProjectFromScreen(vDest,v2);
		v3=(v1+v2)*0.5f; // middle eye brows, nose
		ftype	fDist1=v1.Distance(v2);
		v1=(tFace.lst_ref_Markers[FA_LT_EYEBROW_LT].v3DPos+tFace.lst_ref_Markers[FA_LT_EYEBROW_RT].v3DPos)*0.5f;
		v2=(tFace.lst_ref_Markers[FA_RT_EYEBROW_LT].v3DPos+tFace.lst_ref_Markers[FA_RT_EYEBROW_RT].v3DPos)*0.5f;
		ftype	fDist2=v1.Distance(v2);
		ftype fScaleX=fDist1/fDist2;

		vDest.Set(tFace.mouth.x+tFace.mouth.width/2,tFace.mouth.y+tFace.mouth.height/2,0.99);
		tFace.UnProjectFromScreen(vDest,v1);
		fDist1=v3.Distance(v1);		

		v3=(tFace.lst_ref_Markers[FA_LT_EYEBROW_RT].v3DPos+tFace.lst_ref_Markers[FA_RT_EYEBROW_LT].v3DPos)*0.5f;
		v1=(tFace.lst_ref_Markers[FA_MOUTH_LT].v3DPos+tFace.lst_ref_Markers[FA_MOUTH_RT].v3DPos)*0.5f;
		fDist2=v3.Distance(v1);
		ftype fScaleY=fDist1/fDist2;
		
		ftype	fScaleZ=max(fScaleX,fScaleY);
		vector3f vScale(fScaleX,fScaleY,fScaleZ);
		vector3f vModelCenter=tFace.vRef_3DCenter;
		vModelCenter.Magnitude(vScale);
		vector3f vOff=vCenter-vModelCenter;		

		tFace.vScale=vScale;
		tFace.vOffset=vOff;
		for (int k=0;k<tFace.nNumVertices;k++)
		{
			vector3f vPos=tFace.lst_vModel_3D[k];			
			vPos.Magnitude(tFace.vScale);
			vPos+=tFace.vOffset;
			tFace.lst_vModel_3D[k]=vPos;
		}
		for (int k=0;k<FA_NUM_MARKERS;k++)
		{
			vector3f vPos=tFace.lst_ref_Markers[k].v3DPos;			
			vPos.Magnitude(tFace.vScale);
			vPos+=tFace.vOffset;
			tFace.lst_ref_Markers[k].v3DPos=vPos;
		}
		vScale.Set(1,1,1);		
		vOff.Set(0,0,0);

		tFace.vScale=vScale;
		tFace.vOffset=vOff;
		tFace.pRefFrame=pFrame;
		tFace.pRefFrame2=pFrameDraw;
		m_bEditMode=true;

		while (1)
		{		
			cvConvertImage(pFrame,pFrameDraw);

			for (int k=0;k<tFace.nNumVertices;k++)
			{
				vector3f vPos=tFace.lst_vModel_3D[k];			
				vPos.Magnitude(tFace.vScale);
				vPos+=tFace.vOffset;
				tFace.ProjectToScreen(vPos,vDest);
				DrawRectangle(pFrameDraw,vDest-vector3f(0,0,0),vDest+vector3f(0,0,0),colors[3]);
			} //k
					
			for (int k=0;k<FA_NUM_MARKERS;k++)
			{
				vector3f vPos=tFace.lst_ref_Markers[k].v3DPos;			
				vPos.Magnitude(tFace.vScale);
				vPos+=tFace.vOffset;
				tFace.ProjectToScreen(vPos,vDest);

				if (strstr(tFace.lst_ref_Markers[k].szName,"eye"))
					DrawRectangle(pFrameDraw,vDest-vector3f(1,1,1),vDest+vector3f(1,1,1),colors[0]);
				else
					DrawRectangle(pFrameDraw,vDest-vector3f(1,1,1),vDest+vector3f(1,1,1),colors[1]);
			} //k		

			cvDrawRect(pFrameDraw,cvPoint((int)(vCorners2D[0].x),(int)(vCorners2D[0].y)),cvPoint((int)(vCorners2D[2].x),(int)(vCorners2D[2].y)),colors[4]);
			cvShowImage("FaceCreation", pFrameDraw);
			int key_pressed=cvWaitKey(1);

			if (key_pressed=='E' || key_pressed=='e')
			{
				FILE *fp=fopen("faceexport.mtl","wt");
				fprintf(fp,"newmtl test1\n");
				fprintf(fp,"	Ns 0\n");
				fprintf(fp,"	d 1\n");
				fprintf(fp,"	illum 2\n");
				fprintf(fp,"	Kd 0.8 0.8 0.8\n");
				fprintf(fp,"	Ks 0 0 0\n");
				fprintf(fp,"	Ks 0.225 0.225 0.225\n");
				fprintf(fp,"	map_Kd faceexport.jpg\n");
				
				fclose(fp);

				fp=fopen("faceexport.obj","wt");
				fprintf(fp,"mtllib faceexport.mtl\n");
				// export obj
				for (int k=0;k<tFace.nNumVertices;k++)
				{
					vector3f vPos=tFace.lst_vModel_3D[k];
					fprintf(fp,"v %0.6f %0.6f %0.6f\n",vPos.x,vPos.y,vPos.z);
				} //k
				fprintf(fp,"\n");
				for (int k=0;k<tFace.nNumVertices;k++)
				{
					vector3f vPos=tFace.lst_vModel_3D[k];
					tFace.ProjectToScreen(vPos,vDest);
					vDest.x/=(ftype)(w);
					vDest.y=(h-vDest.y-1)/(ftype)(h);
					fprintf(fp,"vt %0.6f %0.6f\n",vDest.x,vDest.y);
				} //k
				fprintf(fp,"\n");
				fprintf(fp,"usemtl Test1\n");
				fprintf(fp,"g Group1\n");
				for (int k=0;k<tFace.nNumTris;k++)
				{
					int i1,i2,i3;
					i1=tFace.lst_Tris[k*3+2];
					i2=tFace.lst_Tris[k*3+1];
					i3=tFace.lst_Tris[k*3+0];
					int i4=1;
					fprintf(fp,"f %d/%d %d/%d %d/%d\n",i1,i1,i2,i2,i3,i3);
				} //k
				fprintf(fp,"\n");
				fclose(fp);
				MyOutputDebugString("Obj exported\n");
			}
		}

	}	

	//cvShowImage("FaceCreation", pFrameDraw);
	//cvWaitKey(0);

	cvReleaseImage(&pFrame);
	cvReleaseImage(&pFrameDraw);	
	
	cvvDestroyWindow("FaceCreation");	

	cvReleaseHaarClassifierCascade(&tFace.cascade_lefteye);
	cvReleaseHaarClassifierCascade(&tFace.cascade_righteye);
	cvReleaseHaarClassifierCascade(&tFace.cascade_mouth);
	cvReleaseHaarClassifierCascade(&tFace.cascadeface);
	cvReleaseMemStorage(&tFace.storage);

	return (true);
}