#include "stdafx.h"
#include "ConfigComboBox.h"
#include "Helpers.h"

// include resource IDs of english version, for all other languages the IDs MUST BE THE SAME!!!
#include "..\FarCryConfigEng\resource.h"



IMPLEMENT_DYNAMIC( CConfigComboBox, CComboBox )



CConfigComboBox::CConfigComboBox()
: CComboBox()
{
}



CConfigComboBox::~CConfigComboBox()
{
}



BEGIN_MESSAGE_MAP( CConfigComboBox, CComboBox )
END_MESSAGE_MAP()



void 
CConfigComboBox::DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct )
{
	ASSERT( ODT_COMBOBOX == lpDrawItemStruct->CtlType );   

	// attach to dc
	CDC dc;
	dc.Attach( lpDrawItemStruct->hDC );

	// save old dc values
	COLORREF crOldTextColor( dc.GetTextColor() );
	COLORREF crOldBkColor( dc.GetBkColor() );

	// fill item's background
	if( 0 != ( lpDrawItemStruct->itemState  & ODS_SELECTED ) || 0 != ( lpDrawItemStruct->itemAction  & ODA_FOCUS ) )
	{
		dc.SetTextColor( ::GetSysColor( COLOR_HIGHLIGHTTEXT ) );
		dc.SetBkColor( ::GetSysColor( COLOR_HIGHLIGHT ) );
		dc.FillSolidRect( &lpDrawItemStruct->rcItem, ::GetSysColor( COLOR_HIGHLIGHT ) );
		dc.DrawFocusRect( &lpDrawItemStruct->rcItem );
	}
	else
	{
		dc.FillSolidRect( &lpDrawItemStruct->rcItem, crOldBkColor );
	}

	// draw item text
	CRect textRect( lpDrawItemStruct->rcItem );
	textRect.InflateRect( -2, 0, -2, 0 );

	CString strItemText;
	if( -1 == lpDrawItemStruct->itemID ) 
	{
		// special case for null item (i.e. nothing selected)
		strItemText = LoadString( IDS_CUSTOM );
	}
	else
	{
		GetLBText( lpDrawItemStruct->itemID, strItemText );
	}

	dc.DrawText( strItemText, textRect, DT_SINGLELINE | DT_VCENTER );

	// reset dc
	dc.SetTextColor( crOldTextColor );
	dc.SetBkColor( crOldBkColor );
	dc.Detach();
}



int 
CConfigComboBox::CompareItem( LPCOMPAREITEMSTRUCT lpCompareItemStruct ) 
{
	ASSERT( ODT_COMBOBOX == lpCompareItemStruct->CtlType );   
	LPCTSTR lpszTextLhs( (LPCTSTR) lpCompareItemStruct->itemData1 );
	ASSERT( 0 != lpszTextLhs );   
	LPCTSTR lpszTextRhs( (LPCTSTR) lpCompareItemStruct->itemData2 );
	ASSERT( 0 != lpszTextRhs );

	// sort lexicographically
#ifdef UNICODE
	return( wcscmp( lpszTextLhs, lpszTextRhs ) );
#else
	return( strcmp( lpszTextLhs, lpszTextRhs ) );
#endif
}



void 
CConfigComboBox::MeasureItem( LPMEASUREITEMSTRUCT lpMeasureItemStruct )
{
	ASSERT( ODT_COMBOBOX == lpMeasureItemStruct->CtlType );
	if( -1 == lpMeasureItemStruct->itemID )
	{
		LPCTSTR lpszText( (LPCTSTR) lpMeasureItemStruct->itemData );
		ASSERT( 0 != lpszText );

		CDC* pDC( GetDC() );
		CSize size( pDC->GetTextExtent( lpszText ) );
		ReleaseDC( pDC );

		lpMeasureItemStruct->itemHeight = size.cy;
	}
}