#pragma once



class CSystemConfiguration;

class CGameOptionsPage;
class CVideoOptionsPage;
class CVideoAdvOptionsPage;
class CSoundOptionsPage;



class CFarCryConfiguratorDlg : public CPropertySheet
{
public:
	CFarCryConfiguratorDlg( CSystemConfiguration& kSysConfig, bool bGrayCancel, CWnd* pParent = 0 );
	virtual ~CFarCryConfiguratorDlg();
	virtual INT_PTR DoModal();

protected:
	enum EConfigPages
	{
		CPG_GAME,
		CPG_VIDEO,
		CPG_VIDEOADV,
		CPG_SOUND,

		NUM_CONFIGPAGES,

		CPG_START = CPG_GAME
	};

protected:
	virtual void DoDataExchange( CDataExchange* pDX );
	virtual BOOL OnInitDialog();

	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();

	DECLARE_MESSAGE_MAP()

	void MoveWindowElement( HWND hWnd );

private:
	void InitSystemConfiguration();
	void CreatePages();	

protected:
	CPropertyPage* m_pkConfigPage[ NUM_CONFIGPAGES ];
	HICON m_hIcon;	
	CSystemConfiguration& m_kSysConfig;	
	bool m_bGrayCancel;
};
