#include "stdafx.h"
#include "FarCryConfigurator.h"
#include "VideoAdvOptionsPage.h"
#include "SystemConfiguration.h"
#include "SystemAnalysis.h"
#include "VideoAdvCustomEditDlg.h"
#include "Helpers.h"

// include resource IDs of english version, for all other languages the IDs MUST BE THE SAME!!!
#include "..\FarCryConfigEng\resource.h"



IMPLEMENT_DYNAMIC( CVideoAdvOptionsPage, CPropertyPage )



CVideoAdvOptionsPage::CVideoAdvOptionsPage( CSystemConfiguration& kSysConfig )
: CPropertyPage( IDD_VIDEOADV )
, m_kSysConfig( kSysConfig )
, m_kTextureQualityCtrl()
, m_kTextureFilterQualityCtrl()
, m_kAnisotropicFilteringLevelCtrl()
, m_kParticleCountCtrl()
, m_kSpecialEffectsQualityCtrl()
, m_kEnvironmentQualityCtrl()
, m_kShadowQualityCtrl()
, m_kWaterQualityCtrl()
, m_kLightingQualityCtrl()
{
}



CVideoAdvOptionsPage::~CVideoAdvOptionsPage()
{
}



void 
CVideoAdvOptionsPage::DoDataExchange( CDataExchange* pDX )
{
	CPropertyPage::DoDataExchange( pDX );

	DDX_Control( pDX, IDC_TEXTUREQUALITY, m_kTextureQualityCtrl );
	DDX_Control( pDX, IDC_TEXTUREFILTERQUALITY, m_kTextureFilterQualityCtrl );
	DDX_Control( pDX, IDC_ANISOTROPICFILTERINGLEVEL, m_kAnisotropicFilteringLevelCtrl );
	DDX_Control( pDX, IDC_PARTICLECOUNT, m_kParticleCountCtrl );
	DDX_Control( pDX, IDC_SPECIALEFFECTSQUALITY, m_kSpecialEffectsQualityCtrl );
	DDX_Control( pDX, IDC_ENVIRONMENTQUALITY, m_kEnvironmentQualityCtrl );
	DDX_Control( pDX, IDC_SHADOWQUALITY, m_kShadowQualityCtrl );
	DDX_Control( pDX, IDC_WATERQUALITY, m_kWaterQualityCtrl );
	DDX_Control( pDX, IDC_LIGHTINGQUALITY, m_kLightingQualityCtrl );
}



BEGIN_MESSAGE_MAP( CVideoAdvOptionsPage, CPropertyPage )
	ON_BN_CLICKED( IDC_AUTODETECT, OnBnClickedAutoDetect )
	ON_BN_CLICKED( IDC_VERYHIGH, OnBnClickedVeryHigh )
	ON_BN_CLICKED( IDC_HIGH, OnBnClickedHigh )
	ON_BN_CLICKED( IDC_MEDIUM, OnBnClickedMedium )
	ON_BN_CLICKED( IDC_LOW, OnBnClickedLow )
	ON_BN_CLICKED( IDC_CUSTOMIZE, OnBnClickedCustomize )
END_MESSAGE_MAP()



BOOL 
CVideoAdvOptionsPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// initialize all combo boxes except "Texture Filter Quality" and "Anisotropic Filtering Level"
	CComboBox* equBoxes[] = { &m_kTextureQualityCtrl, &m_kParticleCountCtrl, &m_kSpecialEffectsQualityCtrl, 
		&m_kEnvironmentQualityCtrl, &m_kShadowQualityCtrl, &m_kWaterQualityCtrl, &m_kLightingQualityCtrl };

	for( int i( 0 ); i < sizeof( equBoxes ) / sizeof( equBoxes[ 0 ] ); ++i )
	{
		equBoxes[ i ]->AddString( LoadString( IDS_LOW ) );
		equBoxes[ i ]->AddString( LoadString( IDS_MEDIUM ) );
		equBoxes[ i ]->AddString( LoadString( IDS_HIGH ) );
		equBoxes[ i ]->AddString( LoadString( IDS_VERYHIGH ) );
	}
	m_kWaterQualityCtrl.AddString( LoadString( IDS_ULTRAHIGH ) );

	// initialize "Texture Filter Quality" combo box
	m_kTextureFilterQualityCtrl.AddString( LoadString( IDS_BILINEAR ) );
	m_kTextureFilterQualityCtrl.AddString( LoadString( IDS_TRILINEAR ) );

	// initialize "Anisotropic Filtering Level" combo box
	m_kAnisotropicFilteringLevelCtrl.AddString( _T( "1" ) );
	m_kAnisotropicFilteringLevelCtrl.AddString( _T( "2" ) );
	m_kAnisotropicFilteringLevelCtrl.AddString( _T( "4" ) );

	// detect configuration for all groups
	DetectConfigs();

	// if needed, perform auto detection of optimal settings
	if( false != m_kSysConfig.IsInitialConfig() )
	{
		OnBnClickedAutoDetect();
	}

	return( TRUE );
}



void
CVideoAdvOptionsPage::DetectConfigs()
{
	// setup initial texture quality value
	SysConfigValue r_TexResolution( m_kSysConfig.GetValue( "r_TexResolution" ) );
	SysConfigValue r_TexSkyResolution( m_kSysConfig.GetValue( "r_TexSkyResolution" ) );
	SysConfigValue r_TexBumpResolution( m_kSysConfig.GetValue( "r_TexBumpResolution" ) );
	SysConfigValue e_detail_texture_quality( m_kSysConfig.GetValue( "e_detail_texture_quality" ) );
	SysConfigValue r_DetailTextures( m_kSysConfig.GetValue( "r_DetailTextures" ) );
	SysConfigValue r_DetailNumLayers( m_kSysConfig.GetValue( "r_DetailNumLayers" ) );
	SysConfigValue r_DetailDistance( m_kSysConfig.GetValue( "r_DetailDistance" ) );

	if( false != IsEqual( r_TexResolution, 2 ) &&
		false != IsEqual( r_TexSkyResolution, 2 ) && 
		false != IsEqual( r_TexBumpResolution, 2 ) && 
		false != IsEqual( e_detail_texture_quality, 0 ) && 
		false != IsEqual( r_DetailTextures, 0 ) && 
		false != IsEqual( r_DetailNumLayers, 0 ) && 
		false != IsEqual( r_DetailDistance, 0 ) )
	{
		m_kTextureQualityCtrl.SetCurSel( 0 ); // low spec
	}
	else if( false != IsEqual( r_TexResolution, 1 ) &&
			 false != IsEqual( r_TexSkyResolution, 1 ) && 
			 false != IsEqual( r_TexBumpResolution, 1 ) && 
			 false != IsEqual( e_detail_texture_quality, 1 ) && 
			 false != IsEqual( r_DetailTextures, 1 ) && 
			 false != IsEqual( r_DetailNumLayers, 1 ) && 
			 false != IsEqual( r_DetailDistance, 4 ) )
	{
		m_kTextureQualityCtrl.SetCurSel( 1 ); // medium spec
	}
	else if( false != IsEqual( r_TexResolution, 0 ) &&
			 false != IsEqual( r_TexSkyResolution, 0 ) && 
			 false != IsEqual( r_TexBumpResolution, 0 ) && 
			 false != IsEqual( e_detail_texture_quality, 1 ) && 
			 false != IsEqual( r_DetailTextures, 1 ) && 
			 false != IsEqual( r_DetailNumLayers, 1 ) && 
			 false != IsEqual( r_DetailDistance, 8 ) )
	{
		m_kTextureQualityCtrl.SetCurSel( 2 ); // high spec
	}
	else if( false != IsEqual( r_TexResolution, 0 ) &&
			 false != IsEqual( r_TexSkyResolution, 0 ) && 
			 false != IsEqual( r_TexBumpResolution, 0 ) && 
			 false != IsEqual( e_detail_texture_quality, 1 ) && 
			 false != IsEqual( r_DetailTextures, 1 ) && 
			 false != IsEqual( r_DetailNumLayers, 2 ) && 
			 false != IsEqual( r_DetailDistance, 16 ) )
	{
		m_kTextureQualityCtrl.SetCurSel( 3 ); // very high spec
	}
	else
	{
		m_kTextureQualityCtrl.SetCurSel( -1 ); // custom
	}

	// setup initial texture filter quality value
	SysConfigValue d3d9_TextureFilter( m_kSysConfig.GetValue( "d3d9_TextureFilter" ) );
	SysConfigValue GL_TextureFilter( m_kSysConfig.GetValue( "GL_TextureFilter" ) );

	if( false != IsEqual( d3d9_TextureFilter, "BILINEAR" ) && // can use AND here as both cvar will always be defined, unlike in the game
		false != IsEqual( GL_TextureFilter, "GL_LINEAR_MIPMAP_NEAREST" ) )
	{
		m_kTextureFilterQualityCtrl.SetCurSel( 0 );
	}
	else if( false != IsEqual( d3d9_TextureFilter, "TRILINEAR" ) && // can use AND here as both cvar will always be defined, unlike in the game
			 false != IsEqual( GL_TextureFilter, "GL_LINEAR_MIPMAP_LINEAR" ) )
	{
		m_kTextureFilterQualityCtrl.SetCurSel( 1 );
	}
	else
	{
		m_kTextureFilterQualityCtrl.SetCurSel( -1 ); // custom
	}

	// setup initial anisotropic filtering level
	SysConfigValue r_Texture_Anisotropic_Level( m_kSysConfig.GetValue( "r_Texture_Anisotropic_Level" ) );

	if( false != IsEqual( r_Texture_Anisotropic_Level, 1 ) )
	{
		m_kAnisotropicFilteringLevelCtrl.SetCurSel( 0 );
	}
	else if( false != IsEqual( r_Texture_Anisotropic_Level, 2 ) )
	{
		m_kAnisotropicFilteringLevelCtrl.SetCurSel( 1 );
	}
	else if( false != IsEqual( r_Texture_Anisotropic_Level, 4 ) )
	{
		m_kAnisotropicFilteringLevelCtrl.SetCurSel( 2 );
	}
	else
	{
		m_kAnisotropicFilteringLevelCtrl.SetCurSel( -1 ); // custom
	}

	// setup initial partcile count value
	SysConfigValue e_particles_max_count( m_kSysConfig.GetValue( "e_particles_max_count" ) );
	SysConfigValue e_particles_lod( m_kSysConfig.GetValue( "e_particles_lod" ) );

	if( false != IsEqual( e_particles_max_count, 512 ) &&
		false != IsEqual( e_particles_lod, 0.5 ) )
	{
		m_kParticleCountCtrl.SetCurSel( 0 ); // low spec
	}
	else if( false != IsEqual( e_particles_max_count, 2048 ) &&
			 false != IsEqual( e_particles_lod, 0.75 ) )
	{
		m_kParticleCountCtrl.SetCurSel( 1 ); // medium spec
	}
	else if( false != IsEqual( e_particles_max_count, 4096 ) &&
			 false != IsEqual( e_particles_lod, 1.0 ) )
	{
		m_kParticleCountCtrl.SetCurSel( 2 ); // high spec
	}
	else if( false != IsEqual( e_particles_max_count, 8192 ) &&
			 false != IsEqual( e_particles_lod, 1.0 ) )
	{
		m_kParticleCountCtrl.SetCurSel( 3 ); // very high spec
	}
	else
	{
		m_kParticleCountCtrl.SetCurSel( -1 ); // custom
	}

	// setup initial special effects quality value
	SysConfigValue r_MotionBlur( m_kSysConfig.GetValue( "r_MotionBlur" ) );
	SysConfigValue r_Glare( m_kSysConfig.GetValue( "r_Glare" ) );
	SysConfigValue r_GlareQuality( m_kSysConfig.GetValue( "r_GlareQuality" ) );
	SysConfigValue r_Flares( m_kSysConfig.GetValue( "r_Flares" ) );
	SysConfigValue r_checkSunVis( m_kSysConfig.GetValue( "r_checkSunVis" ) );
	SysConfigValue r_Coronas( m_kSysConfig.GetValue( "r_Coronas" ) );
	SysConfigValue r_CoronaFade( m_kSysConfig.GetValue( "r_CoronaFade" ) );
	SysConfigValue r_HeatHaze( m_kSysConfig.GetValue( "r_HeatHaze" ) );
	SysConfigValue r_ScopeLens_fx( m_kSysConfig.GetValue( "r_ScopeLens_fx" ) );
	SysConfigValue r_ProcFlares( m_kSysConfig.GetValue( "r_ProcFlares" ) );
	SysConfigValue r_CryvisionType( m_kSysConfig.GetValue( "r_CryvisionType" ) );
	SysConfigValue r_DisableSfx( m_kSysConfig.GetValue( "r_DisableSfx" ) );
	SysConfigValue r_Beams( m_kSysConfig.GetValue( "r_Beams" ) );
	SysConfigValue es_EnableCloth( m_kSysConfig.GetValue( "es_EnableCloth" ) );

	if( false != IsEqual( r_MotionBlur, 0 ) &&
		false != IsEqual( r_Glare, 0 ) && 
		false != IsEqual( r_GlareQuality, 0 ) && 
		false != IsEqual( r_Flares, 0 ) && 
		false != IsEqual( r_checkSunVis, 0 ) && 
		false != IsEqual( r_Coronas, 0 ) && 
		false != IsEqual( r_CoronaFade, 0 ) && 
		false != IsEqual( r_HeatHaze, 0 ) && 
		false != IsEqual( r_ScopeLens_fx, 0 ) &&
		false != IsEqual( r_ProcFlares, 0 ) && 
		false != IsEqual( r_CryvisionType, 2 ) && 
		false != IsEqual( r_DisableSfx, 1 ) && 
		false != IsEqual( r_Beams, 0 ) &&
		false != IsEqual( es_EnableCloth, 0 ) )
	{
		m_kSpecialEffectsQualityCtrl.SetCurSel( 0 ); // low spec
	}
	else if( false != IsEqual( r_MotionBlur, 0 ) &&
			 false != IsEqual( r_Glare, 0 ) && 
			 false != IsEqual( r_GlareQuality, 1 ) && 
			 false != IsEqual( r_Flares, 1 ) && 
			 false != IsEqual( r_checkSunVis, 1 ) && 
			 false != IsEqual( r_Coronas, 1 ) && 
			 false != IsEqual( r_CoronaFade, 0.2 ) && 
			 false != IsEqual( r_HeatHaze, 0 ) && 
			 false != IsEqual( r_ScopeLens_fx, 0 ) &&
			 false != IsEqual( r_ProcFlares, 1 ) && 
			 false != IsEqual( r_CryvisionType, 1 ) && 
			 false != IsEqual( r_DisableSfx, 0 ) && 
			 false != IsEqual( r_Beams, 1 ) &&
			 false != IsEqual( es_EnableCloth, 1 ) )
	{
		m_kSpecialEffectsQualityCtrl.SetCurSel( 1 ); // medium spec
	}
	else if( false != IsEqual( r_MotionBlur, 1 ) &&
			 false != IsBigger( r_Glare, 0 ) && 
			 false != IsEqual( r_GlareQuality, 2 ) && 
			 false != IsEqual( r_Flares, 1 ) && 
			 false != IsEqual( r_checkSunVis, 2 ) && 
			 false != IsEqual( r_Coronas, 1 ) && 
			 false != IsEqual( r_CoronaFade, 0.1625 ) && 
			 false != IsEqual( r_HeatHaze, 1 ) && 
			 false != IsEqual( r_ScopeLens_fx, 1 ) &&
			 false != IsEqual( r_ProcFlares, 1 ) && 
			 false != IsEqual( r_CryvisionType, 0 ) && 
			 false != IsEqual( r_DisableSfx, 0 ) && 
			 false != IsEqual( r_Beams, 1 ) &&
			 false != IsEqual( es_EnableCloth, 1 ) )
	{
		m_kSpecialEffectsQualityCtrl.SetCurSel( 2 ); // high spec
	}
	else if( false != IsEqual( r_MotionBlur, 1 ) &&
			 false != IsBigger( r_Glare, 0 ) && 
			 false != IsEqual( r_GlareQuality, 2 ) && 
			 false != IsEqual( r_Flares, 1 ) && 
			 false != IsEqual( r_checkSunVis, 2 ) && 
			 false != IsEqual( r_Coronas, 1 ) && 
			 false != IsEqual( r_CoronaFade, 0.125 ) && 
			 false != IsEqual( r_HeatHaze, 1 ) && 
			 false != IsEqual( r_ScopeLens_fx, 1 ) &&
			 false != IsEqual( r_ProcFlares, 1 ) && 
			 false != IsEqual( r_CryvisionType, 0 ) && 
			 false != IsEqual( r_DisableSfx, 0 ) && 
			 false != IsEqual( r_Beams, 1 ) &&
			 false != IsEqual( es_EnableCloth, 1 ) )
	{
		m_kSpecialEffectsQualityCtrl.SetCurSel( 3 ); // very high spec
	}
	else
	{
		m_kSpecialEffectsQualityCtrl.SetCurSel( -1 ); // custom
	}

	// setup initial environment quality value
	SysConfigValue r_VolumetricFog( m_kSysConfig.GetValue( "r_VolumetricFog" ) );
	SysConfigValue r_EnvCMResolution( m_kSysConfig.GetValue( "r_EnvCMResolution" ) );
	SysConfigValue r_EnvCMupdateInterval( m_kSysConfig.GetValue( "r_EnvCMupdateInterval" ) );
	SysConfigValue r_EnvTexResolution( m_kSysConfig.GetValue( "r_EnvTexResolution" ) );
	SysConfigValue r_EnvTexUpdateInterval( m_kSysConfig.GetValue( "r_EnvTexUpdateInterval" ) );
	SysConfigValue e_decals( m_kSysConfig.GetValue( "e_decals" ) );
	SysConfigValue e_decals_life_time_scale( m_kSysConfig.GetValue( "e_decals_life_time_scale" ) );
	SysConfigValue ca_EnableDecals( m_kSysConfig.GetValue( "ca_EnableDecals" ) );
	SysConfigValue e_overlay_geometry( m_kSysConfig.GetValue( "e_overlay_geometry" ) );
	SysConfigValue e_obj_lod_ratio( m_kSysConfig.GetValue( "e_obj_lod_ratio" ) );
	SysConfigValue e_vegetation_sprites_distance_ratio( m_kSysConfig.GetValue( "e_vegetation_sprites_distance_ratio" ) );
	SysConfigValue e_cgf_load_lods( m_kSysConfig.GetValue( "e_cgf_load_lods" ) );
	SysConfigValue e_vegetation_min_size( m_kSysConfig.GetValue( "e_vegetation_min_size" ) );
	SysConfigValue e_flocks( m_kSysConfig.GetValue( "e_flocks" ) );
	SysConfigValue e_EntitySuppressionLevel( m_kSysConfig.GetValue( "e_EntitySuppressionLevel" ) );
	SysConfigValue sys_skiponlowspec( m_kSysConfig.GetValue( "sys_skiponlowspec" ) );

	if( false != IsEqual( r_VolumetricFog, 0 ) &&
		false != IsEqual( r_EnvCMResolution, 1 ) && 
		false != IsEqual( r_EnvCMupdateInterval, 0.2 ) && 
		false != IsEqual( r_EnvTexResolution, 1 ) && 
		false != IsEqual( r_EnvTexUpdateInterval, 0.1 ) && 
		false != IsEqual( e_decals, 0 ) && 
		false != IsEqual( e_decals_life_time_scale, 0.5 ) && 
		false != IsEqual( ca_EnableDecals, 0 ) && 
		false != IsEqual( e_overlay_geometry, 0 ) &&
		false != IsEqual( e_obj_lod_ratio, 5 ) && 
		false != IsEqual( e_vegetation_sprites_distance_ratio, 0.9 ) && 
		false != IsEqual( e_cgf_load_lods, 1 ) &&
		false != IsEqual( e_vegetation_min_size, 2.2 ) && 
		false != IsEqual( e_flocks, 0 ) &&
		false != IsEqual( e_EntitySuppressionLevel, 2 ) &&
		false != IsEqual( sys_skiponlowspec, 1 ) )
	{
		m_kEnvironmentQualityCtrl.SetCurSel( 0 ); // low spec
	}
	else if( false != IsEqual( r_VolumetricFog, 1 ) &&
			 false != IsEqual( r_EnvCMResolution, 1 ) && 
			 false != IsEqual( r_EnvCMupdateInterval, 0.15 ) && 
			 false != IsEqual( r_EnvTexResolution, 2 ) && 
			 false != IsEqual( r_EnvTexUpdateInterval, 0.075 ) && 
			 false != IsEqual( e_decals, 1 ) && 
			 false != IsEqual( e_decals_life_time_scale, 1.0 ) && 
			 false != IsEqual( ca_EnableDecals, 1 ) && 
			 false != IsEqual( e_overlay_geometry, 1 ) &&
			 false != IsEqual( e_obj_lod_ratio, 5 ) && 
			 false != IsEqual( e_vegetation_sprites_distance_ratio, 0.9 ) && 
			 false != IsEqual( e_cgf_load_lods, 1 ) &&
			 false != IsEqual( e_vegetation_min_size, 2.2 ) && 
			 false != IsEqual( e_flocks, 0 ) &&
			 false != IsEqual( e_EntitySuppressionLevel, 2 ) &&
			 false != IsEqual( sys_skiponlowspec, 0 ) )
	{
		m_kEnvironmentQualityCtrl.SetCurSel( 1 ); // medium spec
	}
	else if( false != IsEqual( r_VolumetricFog, 1 ) &&
			 false != IsEqual( r_EnvCMResolution, 2 ) && 
			 false != IsEqual( r_EnvCMupdateInterval, 0.1 ) && 
			 false != IsEqual( r_EnvTexResolution, 3 ) && 
			 false != IsEqual( r_EnvTexUpdateInterval, 0.05 ) && 
			 false != IsEqual( e_decals, 1 ) && 
			 false != IsEqual( e_decals_life_time_scale, 2.0 ) && 
			 false != IsEqual( ca_EnableDecals, 1 ) && 
			 false != IsEqual( e_overlay_geometry, 1 ) &&
			 false != IsEqual( e_obj_lod_ratio, 10 ) && 
			 false != IsEqual( e_vegetation_sprites_distance_ratio, 1.0 ) && 
			 false != IsEqual( e_cgf_load_lods, 1 ) &&
			 false != IsEqual( e_vegetation_min_size, 0 ) && 
			 false != IsEqual( e_flocks, 1 ) &&
			 false != IsEqual( e_EntitySuppressionLevel, 0 ) &&
			 false != IsEqual( sys_skiponlowspec, 0 ) )
	{
		m_kEnvironmentQualityCtrl.SetCurSel( 2 ); // high spec
	}
	else if( false != IsEqual( r_VolumetricFog, 1 ) &&
			 false != IsEqual( r_EnvCMResolution, 2 ) && 
			 false != IsEqual( r_EnvCMupdateInterval, 0.05 ) && 
			 false != IsEqual( r_EnvTexResolution, 3 ) && 
			 false != IsEqual( r_EnvTexUpdateInterval, 0.001 ) && 
			 false != IsEqual( e_decals, 1 ) && 
			 false != IsEqual( e_decals_life_time_scale, 3.0 ) && 
			 false != IsEqual( ca_EnableDecals, 1 ) && 
			 false != IsEqual( e_overlay_geometry, 1 ) &&
			 false != IsEqual( e_obj_lod_ratio, 10 ) && 
			 false != IsEqual( e_vegetation_sprites_distance_ratio, 1.0 ) && 
			 false != IsEqual( e_cgf_load_lods, 0 ) &&
			 false != IsEqual( e_vegetation_min_size, 0 ) && 
			 false != IsEqual( e_flocks, 1 ) &&
			 false != IsEqual( e_EntitySuppressionLevel, 0 ) &&
			 false != IsEqual( sys_skiponlowspec, 0 ) )
	{
		m_kEnvironmentQualityCtrl.SetCurSel( 3 ); // very high spec
	}
	else
	{
		m_kEnvironmentQualityCtrl.SetCurSel( -1 ); // custom
	}

	// setup initial shadow quality value
	SysConfigValue e_stencil_shadows( m_kSysConfig.GetValue( "e_stencil_shadows" ) );
	SysConfigValue e_shadow_maps( m_kSysConfig.GetValue( "e_shadow_maps" ) );
	SysConfigValue e_active_shadow_maps_receving( m_kSysConfig.GetValue( "e_active_shadow_maps_receving" ) );
	SysConfigValue r_ShadowBlur( m_kSysConfig.GetValue( "r_ShadowBlur" ) );
	SysConfigValue r_SelfShadow( m_kSysConfig.GetValue( "r_SelfShadow" ) );
	SysConfigValue e_shadow_maps_view_dist_ratio( m_kSysConfig.GetValue( "e_shadow_maps_view_dist_ratio" ) );

	if( false != IsEqual( e_stencil_shadows, 0 ) &&
		false != IsEqual( e_shadow_maps, 0 ) && 
		false != IsEqual( e_active_shadow_maps_receving, 0 ) && 
		false != IsEqual( r_ShadowBlur, 0 ) && 
		//false != IsEqual( r_SelfShadow, 0 ) && 
		false != IsEqual( e_shadow_maps_view_dist_ratio, 10 ) )
	{
		m_kShadowQualityCtrl.SetCurSel( 0 ); // low spec
	}
	else if( false != IsEqual( e_stencil_shadows, 1 ) &&
			 false != IsEqual( e_shadow_maps, 0 ) && 
			 false != IsEqual( e_active_shadow_maps_receving, 0 ) && 
			 false != IsEqual( r_ShadowBlur, 0 ) && 
			 //false != IsEqual( r_SelfShadow, 0 ) && 
			 false != IsEqual( e_shadow_maps_view_dist_ratio, 10 ) )
	{
		m_kShadowQualityCtrl.SetCurSel( 1 ); // medium spec
	}
	else if( false != IsEqual( e_stencil_shadows, 1 ) &&
			 false != IsEqual( e_shadow_maps, 1 ) && 
			 false != IsEqual( e_active_shadow_maps_receving, 1 ) && 
			 false != IsEqual( r_ShadowBlur, 1 ) && 
			 //false != IsEqual( r_SelfShadow, 0 ) && 
			 false != IsEqual( e_shadow_maps_view_dist_ratio, 15 ) )
	{
		m_kShadowQualityCtrl.SetCurSel( 2 ); // high spec
	}
	else if( false != IsEqual( e_stencil_shadows, 1 ) &&
			 false != IsEqual( e_shadow_maps, 1 ) && 
			 false != IsEqual( e_active_shadow_maps_receving, 2 ) && 
			 false != IsEqual( r_ShadowBlur, 2 ) && 
			 //false != IsEqual( r_SelfShadow, 1 ) && 
			 false != IsEqual( e_shadow_maps_view_dist_ratio, 20 ) )
	{
		m_kShadowQualityCtrl.SetCurSel( 3 ); // very high spec
	}
	else
	{
		m_kShadowQualityCtrl.SetCurSel( -1 ); // custom
	}

	// setup initial water quality value
	SysConfigValue r_WaterRefractions( m_kSysConfig.GetValue( "r_WaterRefractions" ) );
	SysConfigValue r_WaterReflections( m_kSysConfig.GetValue( "r_WaterReflections" ) );
	SysConfigValue r_WaterUpdateFactor( m_kSysConfig.GetValue( "r_WaterUpdateFactor" ) );
	SysConfigValue r_Quality_Reflection( m_kSysConfig.GetValue( "r_Quality_Reflection" ) );
	SysConfigValue e_beach( m_kSysConfig.GetValue( "e_beach" ) );
	SysConfigValue e_use_global_fog_in_fog_volumes( m_kSysConfig.GetValue( "e_use_global_fog_in_fog_volumes" ) );

	if( false != IsEqual( r_WaterRefractions, 0 ) &&
		false != IsEqual( r_WaterReflections, 0 ) && 
		false != IsEqual( r_WaterUpdateFactor, 0.02 ) && 
		false != IsEqual( r_Quality_Reflection, 0 ) && 
		false != IsEqual( e_beach, 0 ) && 
		false != IsEqual( e_use_global_fog_in_fog_volumes, 1 ) )
	{
		m_kWaterQualityCtrl.SetCurSel( 0 ); // low spec
	}
	else if( false != IsEqual( r_WaterRefractions, 0 ) &&
			 false != IsEqual( r_WaterReflections, 1 ) && 
			 false != IsEqual( r_WaterUpdateFactor, 0.015 ) && 
			 false != IsEqual( r_Quality_Reflection, 0 ) && 
			 false != IsEqual( e_beach, 1 ) && 
			 false != IsEqual( e_use_global_fog_in_fog_volumes, 0 ) )
	{
		m_kWaterQualityCtrl.SetCurSel( 1 ); // medium spec
	}
	else if( false != IsEqual( r_WaterRefractions, 1 ) &&
			 false != IsEqual( r_WaterReflections, 1 ) && 
			 false != IsEqual( r_WaterUpdateFactor, 0.01 ) && 
			 false != IsEqual( r_Quality_Reflection, 0 ) && 
			 false != IsEqual( e_beach, 1 ) && 
			 false != IsEqual( e_use_global_fog_in_fog_volumes, 0 ) )
	{
		m_kWaterQualityCtrl.SetCurSel( 2 ); // high spec
	}
	else if( false != IsEqual( r_WaterRefractions, 1 ) &&
			 false != IsEqual( r_WaterReflections, 1 ) && 
			 false != IsEqual( r_WaterUpdateFactor, 0.001 ) && 
			 false != IsEqual( r_Quality_Reflection, 0 ) && 
			 false != IsEqual( e_beach, 1 ) && 
			 false != IsEqual( e_use_global_fog_in_fog_volumes, 0 ) )
	{
		m_kWaterQualityCtrl.SetCurSel( 3 ); // very high spec
	}
	else if( false != IsEqual( r_WaterRefractions, 1 ) &&
			 false != IsEqual( r_WaterReflections, 1 ) && 
			 false != IsEqual( r_WaterUpdateFactor, 0.001 ) && 
			 false != IsEqual( r_Quality_Reflection, 1 ) && 
			 false != IsEqual( e_beach, 1 ) && 
			 false != IsEqual( e_use_global_fog_in_fog_volumes, 0 ) )
	{
		m_kWaterQualityCtrl.SetCurSel( 4 ); // ultra high spec
	}
	else
	{
		m_kWaterQualityCtrl.SetCurSel( -1 ); // custom
	}

	// setup initial lighting quality value
	SysConfigValue r_Quality_BumpMapping( m_kSysConfig.GetValue( "r_Quality_BumpMapping" ) );
	SysConfigValue r_Vegetation_PerpixelLight( m_kSysConfig.GetValue( "r_Vegetation_PerpixelLight" ) );
	SysConfigValue e_light_maps_quality( m_kSysConfig.GetValue( "e_light_maps_quality" ) );
	SysConfigValue ca_ambient_light_intensity( m_kSysConfig.GetValue( "ca_ambient_light_intensity" ) );
	SysConfigValue ca_ambient_light_range( m_kSysConfig.GetValue( "ca_ambient_light_range" ) );

	SysConfigValue e_max_entity_lights( m_kSysConfig.GetValue( "e_max_entity_lights" ) );
	SysConfigValue e_stencil_shadows_only_from_strongest_light( m_kSysConfig.GetValue( "e_stencil_shadows_only_from_strongest_light" ) );
	SysConfigValue p_lightrange( m_kSysConfig.GetValue( "p_lightrange" ) );
	SysConfigValue r_EnvLightCMSize( m_kSysConfig.GetValue( "r_EnvLightCMSize" ) );
	SysConfigValue r_EnvLCMupdateInterval( m_kSysConfig.GetValue( "r_EnvLCMupdateInterval" ) );
	SysConfigValue cl_projectile_light( m_kSysConfig.GetValue( "cl_projectile_light" ) );
	SysConfigValue cl_weapon_light( m_kSysConfig.GetValue( "cl_weapon_light" ) );

	if( false != IsEqual( r_Quality_BumpMapping, 0 ) &&
		false != IsEqual( r_Vegetation_PerpixelLight, 0 ) &&
		false != IsEqual( e_light_maps_quality, 0 ) && 
		false != IsEqual( ca_ambient_light_intensity, 0.2 ) && 
		false != IsEqual( ca_ambient_light_range, 0 ) && 
		false != IsEqual( e_max_entity_lights, 2 ) &&
		false != IsEqual( e_stencil_shadows_only_from_strongest_light, 1 ) && 
		false != IsEqual( p_lightrange, 8 ) && 
		false != IsEqual( r_EnvLightCMSize, 8 ) && 
		false != IsEqual( r_EnvLCMupdateInterval, 0.1 ) &&
		false != IsEqual( cl_projectile_light, 0 ) &&
		false != IsEqual( cl_weapon_light, 0 ) )
	{
		m_kLightingQualityCtrl.SetCurSel( 0 ); // low spec
	}
	else if( false != IsEqual( r_Quality_BumpMapping, 1 ) &&
			 false != IsEqual( r_Vegetation_PerpixelLight, 0 ) &&
			 false != IsEqual( e_light_maps_quality, 1 ) && 
			 false != IsEqual( ca_ambient_light_intensity, 0.2 ) && 
			 false != IsEqual( ca_ambient_light_range, 10 ) && 
			 false != IsEqual( e_max_entity_lights, 2 ) &&
			 false != IsEqual( e_stencil_shadows_only_from_strongest_light, 1 ) && 
			 false != IsEqual( p_lightrange, 10 ) && 
			 false != IsEqual( r_EnvLightCMSize, 8 ) && 
			 false != IsEqual( r_EnvLCMupdateInterval, 0.1 ) &&
			 false != IsEqual( cl_projectile_light, 0 ) &&
			 false != IsEqual( cl_weapon_light, 0 ) )
	{
		m_kLightingQualityCtrl.SetCurSel( 1 ); // medium spec
	}
	else if( false != IsEqual( r_Quality_BumpMapping, 2 ) &&
			 false != IsEqual( r_Vegetation_PerpixelLight, 1 ) &&
			 false != IsEqual( e_light_maps_quality, 2 ) && 
			 false != IsEqual( ca_ambient_light_intensity, 0.2 ) && 
			 false != IsEqual( ca_ambient_light_range, 10 ) && 
			 false != IsEqual( e_max_entity_lights, 3 ) &&
			 false != IsEqual( e_stencil_shadows_only_from_strongest_light, 0 ) && 
			 false != IsEqual( p_lightrange, 15 ) && 
			 false != IsEqual( r_EnvLightCMSize, 8 ) && 
			 false != IsEqual( r_EnvLCMupdateInterval, 0.1 ) &&
			 false != IsEqual( cl_projectile_light, 1 ) &&
			 false != IsEqual( cl_weapon_light, 1 ) )
	{
		m_kLightingQualityCtrl.SetCurSel( 2 ); // high spec
	}
	else if( ( false != IsEqual( r_Quality_BumpMapping, 3 ) || false == IsPS20Supported() ) &&
			 false != IsEqual( r_Vegetation_PerpixelLight, 1 ) &&
			 false != IsEqual( e_light_maps_quality, 2 ) && 
			 false != IsEqual( ca_ambient_light_intensity, 0.2 ) && 
			 false != IsEqual( ca_ambient_light_range, 10 ) && 
			 false != IsEqual( e_max_entity_lights, 4 ) &&
			 false != IsEqual( e_stencil_shadows_only_from_strongest_light, 0 ) && 
			 false != IsEqual( p_lightrange, 15 ) && 
			 false != IsEqual( r_EnvLightCMSize, 16 ) && 
			 false != IsEqual( r_EnvLCMupdateInterval, 0.05 ) &&
			 false != IsEqual( cl_projectile_light, 1 ) &&
			 false != IsEqual( cl_weapon_light, 2 ) )
	{
		m_kLightingQualityCtrl.SetCurSel( 3 ); // very high spec
	}
	else
	{
		m_kLightingQualityCtrl.SetCurSel( -1 ); // custom
	}
}


void 
CVideoAdvOptionsPage::OnBnClickedAutoDetect()
{
	// set auto detect for texture quality
	m_kTextureQualityCtrl.SetCurSel( DetermineMachineSpec( false, true, false, true ) );
	
	// set auto detect for texture filter quality
	int index( DetermineMachineSpec( false, true, false, false ) );
	if( index > 1 )	
	{
		index = 1;
	}
	m_kTextureFilterQualityCtrl.SetCurSel( index );

	// set auto detect for anisotropic fitering level
	m_kAnisotropicFilteringLevelCtrl.SetCurSel( 0 );

	// set auto detect for particle count
	m_kParticleCountCtrl.SetCurSel( DetermineMachineSpec( true, true, false, false ) );

	// set auto detect for special effects quality
	m_kSpecialEffectsQualityCtrl.SetCurSel( DetermineMachineSpec( true, true, false, false ) );

	// set auto detect for environment quality
	m_kEnvironmentQualityCtrl.SetCurSel( DetermineMachineSpec( true, true, false, false ) );

	// set auto detect for shadow quality
	m_kShadowQualityCtrl.SetCurSel( DetermineMachineSpec( true, true, false, false ) );

	// set auto detect for water quality
	m_kWaterQualityCtrl.SetCurSel( DetermineMachineSpec( false, true, false, false ) );

	// set auto detect for lighting quality
	m_kLightingQualityCtrl.SetCurSel( DetermineMachineSpec( true, true, false, false ) );
}



void 
CVideoAdvOptionsPage::OnBnClickedVeryHigh()
{
	// set all combo boxes except "Texture Filter Quality" and "Anisotropic Filtering Level" to very high
	CComboBox* equBoxes[] = { &m_kTextureQualityCtrl, &m_kParticleCountCtrl, &m_kSpecialEffectsQualityCtrl, 
		&m_kEnvironmentQualityCtrl, &m_kShadowQualityCtrl, &m_kWaterQualityCtrl, &m_kLightingQualityCtrl };

	for( int i( 0 ); i < sizeof( equBoxes ) / sizeof( equBoxes[ 0 ] ); ++i )
	{
		equBoxes[ i ]->SetCurSel( 3 );
	}

	// set "Texture Filter Quality" to "Trilinear"
	m_kTextureFilterQualityCtrl.SetCurSel( 1 );

	// set "Anisotropic Filtering Level" to "1"
	m_kAnisotropicFilteringLevelCtrl.SetCurSel( 0 );
}



void 
CVideoAdvOptionsPage::OnBnClickedHigh()
{
	// set all combo boxes except "Texture Filter Quality" and "Anisotropic Filtering Level" to high
	CComboBox* equBoxes[] = { &m_kTextureQualityCtrl, &m_kParticleCountCtrl, &m_kSpecialEffectsQualityCtrl, 
		&m_kEnvironmentQualityCtrl, &m_kShadowQualityCtrl, &m_kWaterQualityCtrl, &m_kLightingQualityCtrl };

	for( int i( 0 ); i < sizeof( equBoxes ) / sizeof( equBoxes[ 0 ] ); ++i )
	{
		equBoxes[ i ]->SetCurSel( 2 );
	}

	// set "Texture Filter Quality" to "Trilinear"
	m_kTextureFilterQualityCtrl.SetCurSel( 1 );

	// set "Anisotropic Filtering Level" to "1"
	m_kAnisotropicFilteringLevelCtrl.SetCurSel( 0 );
}



void 
CVideoAdvOptionsPage::OnBnClickedMedium()
{
	// set all combo boxes except "Texture Filter Quality" and "Anisotropic Filtering Level" to medium
	CComboBox* equBoxes[] = { &m_kTextureQualityCtrl, &m_kParticleCountCtrl, &m_kSpecialEffectsQualityCtrl, 
		&m_kEnvironmentQualityCtrl, &m_kShadowQualityCtrl, &m_kWaterQualityCtrl, &m_kLightingQualityCtrl };

	for( int i( 0 ); i < sizeof( equBoxes ) / sizeof( equBoxes[ 0 ] ); ++i )
	{
		equBoxes[ i ]->SetCurSel( 1 );
	}

	// set "Texture Filter Quality" to "Trilinear"
	m_kTextureFilterQualityCtrl.SetCurSel( 1 );

	// set "Anisotropic Filtering Level" to "1"
	m_kAnisotropicFilteringLevelCtrl.SetCurSel( 0 );
}



void 
CVideoAdvOptionsPage::OnBnClickedLow()
{
	// set all combo boxes except "Texture Filter Quality" and "Anisotropic Filtering Level" to low
	CComboBox* equBoxes[] = { &m_kTextureQualityCtrl, &m_kParticleCountCtrl, &m_kSpecialEffectsQualityCtrl, 
		&m_kEnvironmentQualityCtrl, &m_kShadowQualityCtrl, &m_kWaterQualityCtrl, &m_kLightingQualityCtrl };

	for( int i( 0 ); i < sizeof( equBoxes ) / sizeof( equBoxes[ 0 ] ); ++i )
	{
		equBoxes[ i ]->SetCurSel( 0 );
	}

	// set "Texture Filter Quality" to "Bilinear"
	m_kTextureFilterQualityCtrl.SetCurSel( 0 );

	// set "Anisotropic Filtering Level" to "1"
	m_kAnisotropicFilteringLevelCtrl.SetCurSel( 0 );
}



void 
CVideoAdvOptionsPage::OnBnClickedCustomize()
{
	// update system config to be able to edit the proper values for any spec chosen so far
	UpdateSystemConfig();

	// open editor
	CVideoAdvCustomEditDlg kDlg( m_kSysConfig );
	if( IDOK == kDlg.DoModal() )
	{
		// write values modified in editor back to system config
		kDlg.UpdateSystemConfig();

		// reinitialize dialog to reflect possible changes
		DetectConfigs();
	}
}



void 
CVideoAdvOptionsPage::UpdateSystemConfig()
{
	// update cvars for texture quality
	int index( m_kTextureQualityCtrl.GetCurSel() );
	if( index >= 0 && index < 4 )
	{
		switch( index )
		{
		case 0: // low spec
			{
				m_kSysConfig.SetValue( "r_TexResolution", "2" );
				m_kSysConfig.SetValue( "r_TexSkyResolution", "2" );
				m_kSysConfig.SetValue( "r_TexBumpResolution", "2" );
				m_kSysConfig.SetValue( "e_detail_texture_quality", "0" );
				m_kSysConfig.SetValue( "r_DetailTextures", "0" );
				m_kSysConfig.SetValue( "r_DetailNumLayers", "0" );
				m_kSysConfig.SetValue( "r_DetailDistance", "0" );
				break;
			}
		case 1: // medium spec
			{
				m_kSysConfig.SetValue( "r_TexResolution", "1" );
				m_kSysConfig.SetValue( "r_TexSkyResolution", "1" );
				m_kSysConfig.SetValue( "r_TexBumpResolution", "1" );
				m_kSysConfig.SetValue( "e_detail_texture_quality", "1" );
				m_kSysConfig.SetValue( "r_DetailTextures", "1" );
				m_kSysConfig.SetValue( "r_DetailNumLayers", "1" );
				m_kSysConfig.SetValue( "r_DetailDistance", "4" );
				break;
			}
		case 2: // high spec
			{
				m_kSysConfig.SetValue( "r_TexResolution", "0" );
				m_kSysConfig.SetValue( "r_TexSkyResolution", "0" );
				m_kSysConfig.SetValue( "r_TexBumpResolution", "0" );
				m_kSysConfig.SetValue( "e_detail_texture_quality", "1" );
				m_kSysConfig.SetValue( "r_DetailTextures", "1" );
				m_kSysConfig.SetValue( "r_DetailNumLayers", "1" );
				m_kSysConfig.SetValue( "r_DetailDistance", "8" );
				break;
			}
		case 3: // very high spec
			{
				m_kSysConfig.SetValue( "r_TexResolution", "0" );
				m_kSysConfig.SetValue( "r_TexSkyResolution", "0" );
				m_kSysConfig.SetValue( "r_TexBumpResolution", "0" );
				m_kSysConfig.SetValue( "e_detail_texture_quality", "1" );
				m_kSysConfig.SetValue( "r_DetailTextures", "1" );
				m_kSysConfig.SetValue( "r_DetailNumLayers", "2" );
				m_kSysConfig.SetValue( "r_DetailDistance", "16" );
				break;
			}
		}
	}

	// update cvars for texture filter quality
	index = m_kTextureFilterQualityCtrl.GetCurSel();
	if( index >= 0 && index < 2 )
	{
		switch( index )
		{
		case 0: // bilinear
			{
				m_kSysConfig.SetValue( "d3d9_TextureFilter", "BILINEAR" );
				m_kSysConfig.SetValue( "GL_TextureFilter", "GL_LINEAR_MIPMAP_NEAREST" );				
				break;
			}
		case 1: // trilinear
			{
				m_kSysConfig.SetValue( "d3d9_TextureFilter", "TRILINEAR" );
				m_kSysConfig.SetValue( "GL_TextureFilter", "GL_LINEAR_MIPMAP_LINEAR" );				
				break;
			}
		}
	}

	// update cvars for anisotropic filtering level
	index = m_kAnisotropicFilteringLevelCtrl.GetCurSel();
	if( index >= 0 && index < 3 )
	{
		switch( index )
		{
		case 0: // 1
			{
				m_kSysConfig.SetValue( "r_Texture_Anisotropic_Level", "1" );
				break;
			}
		case 1: // 2
			{
				m_kSysConfig.SetValue( "r_Texture_Anisotropic_Level", "2" );
				break;
			}
		case 2: // 4
			{
				m_kSysConfig.SetValue( "r_Texture_Anisotropic_Level", "4" );
				break;
			}
		}
	}

	// update cvars for particle count
	index = m_kParticleCountCtrl.GetCurSel();
	if( index >= 0 && index < 4 )
	{
		switch( index )
		{
		case 0: // low spec
			{
				m_kSysConfig.SetValue( "e_particles_max_count", "512" );
				m_kSysConfig.SetValue( "e_particles_lod", "0.5" );
				break;
			}
		case 1: // medium spec
			{
				m_kSysConfig.SetValue( "e_particles_max_count", "2048" );
				m_kSysConfig.SetValue( "e_particles_lod", "0.75" );
				break;
			}
		case 2: // high spec
			{
				m_kSysConfig.SetValue( "e_particles_max_count", "4096" );
				m_kSysConfig.SetValue( "e_particles_lod", "1.0" );
				break;
			}
		case 3: // very high spec
			{
				m_kSysConfig.SetValue( "e_particles_max_count", "8192" );
				m_kSysConfig.SetValue( "e_particles_lod", "1.0" );
				break;
			}
		}
	}

	// update cvars for special effects quality
	index = m_kSpecialEffectsQualityCtrl.GetCurSel();
	if( index >= 0 && index < 4 )
	{
		switch( index )
		{
		case 0: // low spec
			{
				m_kSysConfig.SetValue( "r_MotionBlur", "0" );
				m_kSysConfig.SetValue( "r_Glare", "0" );
				m_kSysConfig.SetValue( "r_RenderMode", "0" ); // additionally set render mode to "Normal" as r_Glare is set to "0"
				m_kSysConfig.SetValue( "r_GlareQuality", "0" );
				m_kSysConfig.SetValue( "r_Flares", "0" );
				m_kSysConfig.SetValue( "r_checkSunVis", "0" );
				m_kSysConfig.SetValue( "r_Coronas", "0" );
				m_kSysConfig.SetValue( "r_CoronaFade", "0.0" );
				m_kSysConfig.SetValue( "r_HeatHaze", "0" );
				m_kSysConfig.SetValue( "r_ScopeLens_fx", "0" );
				m_kSysConfig.SetValue( "r_ProcFlares", "0" );
				m_kSysConfig.SetValue( "r_CryvisionType", "2" );
				m_kSysConfig.SetValue( "r_DisableSfx", "1" );
				m_kSysConfig.SetValue( "r_Beams", "0" );
				m_kSysConfig.SetValue( "es_EnableCloth", "0" );
				break;
			}
		case 1: // medium spec
			{
				m_kSysConfig.SetValue( "r_MotionBlur", "0" );
				m_kSysConfig.SetValue( "r_Glare", "0" );
				m_kSysConfig.SetValue( "r_RenderMode", "0" ); // additionally set render mode to "Normal" as r_Glare is set to "0"
				m_kSysConfig.SetValue( "r_GlareQuality", "1" );
				m_kSysConfig.SetValue( "r_Flares", "1" );
				m_kSysConfig.SetValue( "r_checkSunVis", "1" );
				m_kSysConfig.SetValue( "r_Coronas", "1" );
				m_kSysConfig.SetValue( "r_CoronaFade", "0.2" );
				m_kSysConfig.SetValue( "r_HeatHaze", "0" );
				m_kSysConfig.SetValue( "r_ScopeLens_fx", "0" );
				m_kSysConfig.SetValue( "r_ProcFlares", "1" );
				m_kSysConfig.SetValue( "r_CryvisionType", "1" );
				m_kSysConfig.SetValue( "r_DisableSfx", "0" );
				m_kSysConfig.SetValue( "r_Beams", "1" );
				m_kSysConfig.SetValue( "es_EnableCloth", "1" );
				break;
			}
		case 2: // high spec
			{
				m_kSysConfig.SetValue( "r_MotionBlur", "1" );
				m_kSysConfig.SetValue( "r_Glare", "1" );
				m_kSysConfig.SetValue( "r_GlareQuality", "2" );
				m_kSysConfig.SetValue( "r_Flares", "1" );
				m_kSysConfig.SetValue( "r_checkSunVis", "2" );
				m_kSysConfig.SetValue( "r_Coronas", "1" );
				m_kSysConfig.SetValue( "r_CoronaFade", "0.1625" );
				m_kSysConfig.SetValue( "r_HeatHaze", "1" );
				m_kSysConfig.SetValue( "r_ScopeLens_fx", "1" );
				m_kSysConfig.SetValue( "r_ProcFlares", "1" );
				m_kSysConfig.SetValue( "r_CryvisionType", "0" );
				m_kSysConfig.SetValue( "r_DisableSfx", "0" );
				m_kSysConfig.SetValue( "r_Beams", "1" );
				m_kSysConfig.SetValue( "es_EnableCloth", "1" );
				break;
			}
		case 3: // very high spec
			{
				m_kSysConfig.SetValue( "r_MotionBlur", "1" );
				m_kSysConfig.SetValue( "r_Glare", "1" );
				m_kSysConfig.SetValue( "r_GlareQuality", "2" );
				m_kSysConfig.SetValue( "r_Flares", "1" );
				m_kSysConfig.SetValue( "r_checkSunVis", "2" );
				m_kSysConfig.SetValue( "r_Coronas", "1" );
				m_kSysConfig.SetValue( "r_CoronaFade", "0.125" );
				m_kSysConfig.SetValue( "r_HeatHaze", "1" );
				m_kSysConfig.SetValue( "r_ScopeLens_fx", "1" );
				m_kSysConfig.SetValue( "r_ProcFlares", "1" );
				m_kSysConfig.SetValue( "r_CryvisionType", "0" );
				m_kSysConfig.SetValue( "r_DisableSfx", "0" );
				m_kSysConfig.SetValue( "r_Beams", "1" );
				m_kSysConfig.SetValue( "es_EnableCloth", "1" );
				break;
			}
		}
	}

	// update cvars for environment quality
	index = m_kEnvironmentQualityCtrl.GetCurSel();
	if( index >= 0 && index < 4 )
	{
		switch( index )
		{
		case 0: // low spec
			{
				m_kSysConfig.SetValue( "r_VolumetricFog", "0" );
				m_kSysConfig.SetValue( "r_EnvCMResolution", "1" );
				m_kSysConfig.SetValue( "r_EnvCMupdateInterval", "0.2" );
				m_kSysConfig.SetValue( "r_EnvTexResolution", "1" );
				m_kSysConfig.SetValue( "r_EnvTexUpdateInterval", "0.1" );
				m_kSysConfig.SetValue( "e_decals", "0" );
				m_kSysConfig.SetValue( "e_decals_life_time_scale", "0.5" );
				m_kSysConfig.SetValue( "ca_EnableDecals", "0" );
				m_kSysConfig.SetValue( "e_overlay_geometry", "0" );
				m_kSysConfig.SetValue( "e_obj_lod_ratio", "5" );
				m_kSysConfig.SetValue( "e_vegetation_sprites_distance_ratio", "0.9" );
				m_kSysConfig.SetValue( "e_cgf_load_lods", "1" );
				m_kSysConfig.SetValue( "e_vegetation_min_size", "2.2" );
				m_kSysConfig.SetValue( "e_flocks", "0" );
				m_kSysConfig.SetValue( "e_EntitySuppressionLevel", "2" );
				m_kSysConfig.SetValue( "sys_skiponlowspec", "1" );
				break;
			}
		case 1: // medium spec
			{
				m_kSysConfig.SetValue( "r_VolumetricFog", "1" );
				m_kSysConfig.SetValue( "r_EnvCMResolution", "1" );
				m_kSysConfig.SetValue( "r_EnvCMupdateInterval", "0.15" );
				m_kSysConfig.SetValue( "r_EnvTexResolution", "2" );
				m_kSysConfig.SetValue( "r_EnvTexUpdateInterval", "0.075" );
				m_kSysConfig.SetValue( "e_decals", "1" );
				m_kSysConfig.SetValue( "e_decals_life_time_scale", "1.0" );
				m_kSysConfig.SetValue( "ca_EnableDecals", "1" );
				m_kSysConfig.SetValue( "e_overlay_geometry", "1" );
				m_kSysConfig.SetValue( "e_obj_lod_ratio", "5" );
				m_kSysConfig.SetValue( "e_vegetation_sprites_distance_ratio", "0.9" );
				m_kSysConfig.SetValue( "e_cgf_load_lods", "1" );
				m_kSysConfig.SetValue( "e_vegetation_min_size", "2.2" );
				m_kSysConfig.SetValue( "e_flocks", "0" );
				m_kSysConfig.SetValue( "e_EntitySuppressionLevel", "2" );
				m_kSysConfig.SetValue( "sys_skiponlowspec", "0" );
				break;
			}
		case 2: // high spec
			{
				m_kSysConfig.SetValue( "r_VolumetricFog", "1" );
				m_kSysConfig.SetValue( "r_EnvCMResolution", "2" );
				m_kSysConfig.SetValue( "r_EnvCMupdateInterval", "0.1" );
				m_kSysConfig.SetValue( "r_EnvTexResolution", "3" );
				m_kSysConfig.SetValue( "r_EnvTexUpdateInterval", "0.05" );
				m_kSysConfig.SetValue( "e_decals", "1" );
				m_kSysConfig.SetValue( "e_decals_life_time_scale", "2.0" );
				m_kSysConfig.SetValue( "ca_EnableDecals", "1" );
				m_kSysConfig.SetValue( "e_overlay_geometry", "1" );
				m_kSysConfig.SetValue( "e_obj_lod_ratio", "10" );
				m_kSysConfig.SetValue( "e_vegetation_sprites_distance_ratio", "1.0" );
				m_kSysConfig.SetValue( "e_cgf_load_lods", "1" );
				m_kSysConfig.SetValue( "e_vegetation_min_size", "0" );
				m_kSysConfig.SetValue( "e_flocks", "1" );
				m_kSysConfig.SetValue( "e_EntitySuppressionLevel", "0" );
				m_kSysConfig.SetValue( "sys_skiponlowspec", "0" );
				break;
			}
		case 3: // very high spec
			{
				m_kSysConfig.SetValue( "r_VolumetricFog", "1" );
				m_kSysConfig.SetValue( "r_EnvCMResolution", "2" );
				m_kSysConfig.SetValue( "r_EnvCMupdateInterval", "0.05" );
				m_kSysConfig.SetValue( "r_EnvTexResolution", "3" );
				m_kSysConfig.SetValue( "r_EnvTexUpdateInterval", "0.001" );
				m_kSysConfig.SetValue( "e_decals", "1" );
				m_kSysConfig.SetValue( "e_decals_life_time_scale", "3.0" );
				m_kSysConfig.SetValue( "ca_EnableDecals", "1" );
				m_kSysConfig.SetValue( "e_overlay_geometry", "1" );
				m_kSysConfig.SetValue( "e_obj_lod_ratio", "10" );
				m_kSysConfig.SetValue( "e_vegetation_sprites_distance_ratio", "1.0" );
				m_kSysConfig.SetValue( "e_cgf_load_lods", "0" );
				m_kSysConfig.SetValue( "e_vegetation_min_size", "0" );
				m_kSysConfig.SetValue( "e_flocks", "1" );
				m_kSysConfig.SetValue( "e_EntitySuppressionLevel", "0" );
				m_kSysConfig.SetValue( "sys_skiponlowspec", "0" );
				break;
			}
		}
	}

	// update cvars for shadow quality
	index = m_kShadowQualityCtrl.GetCurSel();
	if( index >= 0 && index < 4 )
	{
		switch( index )
		{
		case 0: // low spec
			{
				m_kSysConfig.SetValue( "e_stencil_shadows", "0" );
				m_kSysConfig.SetValue( "e_shadow_maps", "0" );
				m_kSysConfig.SetValue( "e_active_shadow_maps_receving", "0" );
				m_kSysConfig.SetValue( "r_ShadowBlur", "0" );
				//m_kSysConfig.SetValue( "r_SelfShadow", "0" );
				m_kSysConfig.SetValue( "e_shadow_maps_view_dist_ratio", "10" );
				break;
			}
		case 1: // medium spec
			{
				m_kSysConfig.SetValue( "e_stencil_shadows", "1" );
				m_kSysConfig.SetValue( "e_shadow_maps", "0" );
				m_kSysConfig.SetValue( "e_active_shadow_maps_receving", "0" );
				m_kSysConfig.SetValue( "r_ShadowBlur", "0" );
				//m_kSysConfig.SetValue( "r_SelfShadow", "0" );
				m_kSysConfig.SetValue( "e_shadow_maps_view_dist_ratio", "10" );
				break;
			}
		case 2: // high spec
			{
				m_kSysConfig.SetValue( "e_stencil_shadows", "1" );
				m_kSysConfig.SetValue( "e_shadow_maps", "1" );
				m_kSysConfig.SetValue( "e_active_shadow_maps_receving", "1" );
				m_kSysConfig.SetValue( "r_ShadowBlur", "1" );
				//m_kSysConfig.SetValue( "r_SelfShadow", "0" );
				m_kSysConfig.SetValue( "e_shadow_maps_view_dist_ratio", "15" );
				break;
			}
		case 3: // very high spec
			{
				m_kSysConfig.SetValue( "e_stencil_shadows", "1" );
				m_kSysConfig.SetValue( "e_shadow_maps", "1" );
				m_kSysConfig.SetValue( "e_active_shadow_maps_receving", "2" );
				m_kSysConfig.SetValue( "r_ShadowBlur", "2" );
				//m_kSysConfig.SetValue( "r_SelfShadow", "1" );
				m_kSysConfig.SetValue( "e_shadow_maps_view_dist_ratio", "20" );
				break;
			}
		}
	}

	// update cvars for water quality
	index = m_kWaterQualityCtrl.GetCurSel();
	if( index >= 0 && index < 5 )
	{
		switch( index )
		{
		case 0: // low spec
			{
				m_kSysConfig.SetValue( "r_WaterRefractions", "0" );
				m_kSysConfig.SetValue( "r_WaterReflections", "0" );
				m_kSysConfig.SetValue( "r_WaterUpdateFactor", "0.02" );
				m_kSysConfig.SetValue( "r_Quality_Reflection", "0" );
				m_kSysConfig.SetValue( "e_beach", "0" );
				m_kSysConfig.SetValue( "e_use_global_fog_in_fog_volumes", "1" );
				break;
			}
		case 1: // medium spec
			{
				m_kSysConfig.SetValue( "r_WaterRefractions", "0" );
				m_kSysConfig.SetValue( "r_WaterReflections", "1" );
				m_kSysConfig.SetValue( "r_WaterUpdateFactor", "0.015" );
				m_kSysConfig.SetValue( "r_Quality_Reflection", "0" );
				m_kSysConfig.SetValue( "e_beach", "1" );
				m_kSysConfig.SetValue( "e_use_global_fog_in_fog_volumes", "0" );
				break;
			}
		case 2: // high spec
			{
				m_kSysConfig.SetValue( "r_WaterRefractions", "1" );
				m_kSysConfig.SetValue( "r_WaterReflections", "1" );
				m_kSysConfig.SetValue( "r_WaterUpdateFactor", "0.01" );
				m_kSysConfig.SetValue( "r_Quality_Reflection", "0" );
				m_kSysConfig.SetValue( "e_beach", "1" );
				m_kSysConfig.SetValue( "e_use_global_fog_in_fog_volumes", "0" );
				break;
			}
		case 3: // very high spec
			{
				m_kSysConfig.SetValue( "r_WaterRefractions", "1" );
				m_kSysConfig.SetValue( "r_WaterReflections", "1" );
				m_kSysConfig.SetValue( "r_WaterUpdateFactor", "0.001" );
				m_kSysConfig.SetValue( "r_Quality_Reflection", "0" );
				m_kSysConfig.SetValue( "e_beach", "1" );
				m_kSysConfig.SetValue( "e_use_global_fog_in_fog_volumes", "0" );
				break;
			}
		case 4: // ultra high spec
			{
				m_kSysConfig.SetValue( "r_WaterRefractions", "1" );
				m_kSysConfig.SetValue( "r_WaterReflections", "1" );
				m_kSysConfig.SetValue( "r_WaterUpdateFactor", "0.001" );
				m_kSysConfig.SetValue( "r_Quality_Reflection", "1" );
				m_kSysConfig.SetValue( "e_beach", "1" );
				m_kSysConfig.SetValue( "e_use_global_fog_in_fog_volumes", "0" );
				break;
			}
		}
	}


	// update cvars for lighing quality
	index = m_kLightingQualityCtrl.GetCurSel();
	if( index >= 0 && index < 4 )
	{
		switch( index )
		{
		case 0: // low spec
			{
				m_kSysConfig.SetValue( "r_Quality_BumpMapping", "0" );
				m_kSysConfig.SetValue( "r_Vegetation_PerpixelLight", "0" );
				m_kSysConfig.SetValue( "e_light_maps_quality", "0" );
				m_kSysConfig.SetValue( "ca_ambient_light_intensity", "0.2" );
				m_kSysConfig.SetValue( "ca_ambient_light_range", "0" );
				m_kSysConfig.SetValue( "e_max_entity_lights", "2" );
				m_kSysConfig.SetValue( "e_stencil_shadows_only_from_strongest_light", "1" );
				m_kSysConfig.SetValue( "p_lightrange", "8" );
				m_kSysConfig.SetValue( "r_EnvLightCMSize", "8" );
				m_kSysConfig.SetValue( "r_EnvLCMupdateInterval", "0.1" );
				m_kSysConfig.SetValue( "cl_projectile_light", "0" );
				m_kSysConfig.SetValue( "cl_weapon_light", "0" );
				break;
			}
		case 1: // medium spec
			{
				m_kSysConfig.SetValue( "r_Quality_BumpMapping", "1" );
				m_kSysConfig.SetValue( "r_Vegetation_PerpixelLight", "0" );
				m_kSysConfig.SetValue( "e_light_maps_quality", "1" );
				m_kSysConfig.SetValue( "ca_ambient_light_intensity", "0.2" );
				m_kSysConfig.SetValue( "ca_ambient_light_range", "10" );
				m_kSysConfig.SetValue( "e_max_entity_lights", "2" );
				m_kSysConfig.SetValue( "e_stencil_shadows_only_from_strongest_light", "1" );
				m_kSysConfig.SetValue( "p_lightrange", "10" );
				m_kSysConfig.SetValue( "r_EnvLightCMSize", "8" );
				m_kSysConfig.SetValue( "r_EnvLCMupdateInterval", "0.1" );
				m_kSysConfig.SetValue( "cl_projectile_light", "0" );
				m_kSysConfig.SetValue( "cl_weapon_light", "0" );
				break;
			}
		case 2: // high spec
			{
				m_kSysConfig.SetValue( "r_Quality_BumpMapping", "2" );
				m_kSysConfig.SetValue( "r_Vegetation_PerpixelLight", "1" );
				m_kSysConfig.SetValue( "e_light_maps_quality", "2" );
				m_kSysConfig.SetValue( "ca_ambient_light_intensity", "0.2" );
				m_kSysConfig.SetValue( "ca_ambient_light_range", "10" );
				m_kSysConfig.SetValue( "e_max_entity_lights", "3" );
				m_kSysConfig.SetValue( "e_stencil_shadows_only_from_strongest_light", "0" );
				m_kSysConfig.SetValue( "p_lightrange", "15" );
				m_kSysConfig.SetValue( "r_EnvLightCMSize", "8" );
				m_kSysConfig.SetValue( "r_EnvLCMupdateInterval", "0.1" );
				m_kSysConfig.SetValue( "cl_projectile_light", "1" );
				m_kSysConfig.SetValue( "cl_weapon_light", "1" );
				break;
			}
		case 3: // very high spec
			{
				m_kSysConfig.SetValue( "r_Quality_BumpMapping", "3" );
				m_kSysConfig.SetValue( "r_Vegetation_PerpixelLight", "1" );
				m_kSysConfig.SetValue( "e_light_maps_quality", "2" );
				m_kSysConfig.SetValue( "ca_ambient_light_intensity", "0.2" );
				m_kSysConfig.SetValue( "ca_ambient_light_range", "10" );
				m_kSysConfig.SetValue( "e_max_entity_lights", "4" );
				m_kSysConfig.SetValue( "e_stencil_shadows_only_from_strongest_light", "0" );
				m_kSysConfig.SetValue( "p_lightrange", "15" );
				m_kSysConfig.SetValue( "r_EnvLightCMSize", "16" );
				m_kSysConfig.SetValue( "r_EnvLCMupdateInterval", "0.05" );
				m_kSysConfig.SetValue( "cl_projectile_light", "1" );
				m_kSysConfig.SetValue( "cl_weapon_light", "2" );
				break;
			}
		}
	}
}



void 
CVideoAdvOptionsPage::OnOK()
{
	CPropertyPage::OnOK();
	UpdateSystemConfig();
}
