#include "stdafx.h"
#include "FarCryConfigurator.h"
#include "VideoOptionsPage.h"
#include "SystemConfiguration.h"
#include "Helpers.h"

// include resource IDs of english version, for all other languages the IDs MUST BE THE SAME!!!
#include "..\FarCryConfigEng\resource.h"



IMPLEMENT_DYNAMIC( CVideoOptionsPage, CPropertyPage )



CVideoOptionsPage::CVideoOptionsPage( CSystemConfiguration& kSysConfig )
: CPropertyPage( IDD_VIDEO )
, m_kSysConfig( kSysConfig )
, m_kRendererCtrl()
, m_kResolutionCtrl()
, m_kAntiAliasingCtrl()
, m_kFullscreenCtrl()
, m_kVSyncCtrl()
, m_colDispModes()
{
}



CVideoOptionsPage::~CVideoOptionsPage()
{
}



void 
CVideoOptionsPage::DoDataExchange( CDataExchange* pDX )
{
	CPropertyPage::DoDataExchange( pDX );

	DDX_Control( pDX, IDC_RENDERER, m_kRendererCtrl );
	DDX_Control( pDX, IDC_RESOLUTION, m_kResolutionCtrl );
	DDX_Control( pDX, IDC_ANTIALIASING, m_kAntiAliasingCtrl );
	DDX_Control( pDX, IDC_FULLSCREEN, m_kFullscreenCtrl );
	DDX_Control( pDX, IDC_VSYNC, m_kVSyncCtrl );
}



BEGIN_MESSAGE_MAP( CVideoOptionsPage, CPropertyPage )
END_MESSAGE_MAP()



BOOL 
CVideoOptionsPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// setup initial renderer value
	m_kRendererCtrl.AddString( LoadString( IDS_DIRECT3D9 ) );
	m_kRendererCtrl.AddString( LoadString( IDS_OPENGL ) );

	//SysConfigValue r_Driver( m_kSysConfig.GetValue( "r_Driver" ) );
	//if( false != IsEqual( r_Driver, "Direct3D9" ) )
	//{
	//	m_kRendererCtrl.SetCurSel( 0 );
	//}
	//else if( false != IsEqual( r_Driver, "OpenGL" ) )
	//{
	//	m_kRendererCtrl.SetCurSel( 1 );
	//}

	m_kRendererCtrl.SetCurSel( 0 );
	m_kRendererCtrl.EnableWindow( FALSE );

	// setup initial resolution value
	SysConfigValue r_Width( m_kSysConfig.GetValue( "r_Width" ) );
	SysConfigValue r_Height( m_kSysConfig.GetValue( "r_Height" ) );
	SysConfigValue r_ColorBits( m_kSysConfig.GetValue( "r_ColorBits" ) );

	GetDisplayModes( m_colDispModes );
	
	int index( -1 );
	for( DispModesCol::size_type i( 0 ); i < m_colDispModes.size(); ++i )
	{
		TCHAR szMode[ 64 ];
		_stprintf( szMode, _T( "%dx%dx%d" ), m_colDispModes[ i ].m_xRes, m_colDispModes[ i ].m_yRes, m_colDispModes[ i ].m_bpp );
		m_kResolutionCtrl.AddString( szMode );

		if( false != IsEqual( r_Width, m_colDispModes[ i ].m_xRes ) &&
			false != IsEqual( r_Height, m_colDispModes[ i ].m_yRes ) && 
			false != IsEqual( r_ColorBits, m_colDispModes[ i ].m_bpp ) )
		{
			index = (int) i;
		}
	}

	if( -1 != index )
	{
		m_kResolutionCtrl.SetCurSel( index );
	}	

	// setup initial anti aliasing value
	m_kAntiAliasingCtrl.AddString( LoadString( IDS_NONE ) );
	m_kAntiAliasingCtrl.AddString( LoadString( IDS_LOW ) );
	m_kAntiAliasingCtrl.AddString( LoadString( IDS_MEDIUM ) );
	m_kAntiAliasingCtrl.AddString( LoadString( IDS_HIGH ) );
	
	SysConfigValue r_FSAA( m_kSysConfig.GetValue( "r_FSAA" ) );
	SysConfigValue r_FSAA_samples( m_kSysConfig.GetValue( "r_FSAA_samples" ) );
	if( false != IsEqual( r_FSAA, 0 ) )
	{
		m_kAntiAliasingCtrl.SetCurSel( 0 );
	}
	else
	{
		if( false != IsBiggerEqual( r_FSAA_samples, 6 ) )
		{
			m_kAntiAliasingCtrl.SetCurSel( 3 );
		}
		else if( false != IsBiggerEqual( r_FSAA_samples, 4 ) )
		{
			m_kAntiAliasingCtrl.SetCurSel( 2 );
		}
		else
		{
			m_kAntiAliasingCtrl.SetCurSel( 1 );
		}
	}

	// setup initial full screen value
	SysConfigValue r_Fullscreen( m_kSysConfig.GetValue( "r_Fullscreen" ) );
	m_kFullscreenCtrl.SetCheck( false != IsEqual( r_Fullscreen, 0 ) ? 0 : 1 );

	// setup initial vsync value
	SysConfigValue r_VSync( m_kSysConfig.GetValue( "r_VSync" ) );
	m_kVSyncCtrl.SetCheck( false != IsEqual( r_VSync, 0 ) ? 0 : 1 );

	return( TRUE );  
}



void 
CVideoOptionsPage::UpdateSystemConfig()
{
	// write new renderer value
	int index( m_kRendererCtrl.GetCurSel() );
	if( index >= 0 && index < 2 )
	{
		switch( index )
		{
		case 0:
			{
				m_kSysConfig.SetValue( "r_Driver", "Direct3D9" );
				break;
			}
		case 1:
			{
				m_kSysConfig.SetValue( "r_Driver", "OpenGL" );
				break;
			}
		}
	}	

	// write new resolution value
	index = m_kResolutionCtrl.GetCurSel();
	if( index >= 0 && index < (int) m_colDispModes.size() )
	{
		char szData[ 64 ];
		sprintf( szData, "%d", m_colDispModes[ index ].m_xRes );
		m_kSysConfig.SetValue( "r_Width", SysConfigValue( szData ) );

		sprintf( szData, "%d", m_colDispModes[ index ].m_yRes );
		m_kSysConfig.SetValue( "r_Height", SysConfigValue( szData ) );

		sprintf( szData, "%d", m_colDispModes[ index ].m_bpp );
		m_kSysConfig.SetValue( "r_ColorBits", SysConfigValue( szData ) );
	}

	// write new anti aliasing value
	index = m_kAntiAliasingCtrl.GetCurSel();
	if( index >= 0 && index < 4 )
	{
		switch( index )
		{
		case 0:
			{
				m_kSysConfig.SetValue( "r_FSAA", "0" );
				m_kSysConfig.SetValue( "r_FSAA_samples", "1" );
				break;
			}
		case 1:
			{
				m_kSysConfig.SetValue( "r_FSAA", "1" );
				m_kSysConfig.SetValue( "r_FSAA_samples", "2" );
				break;
			}
		case 2:
			{
				m_kSysConfig.SetValue( "r_FSAA", "1" );
				m_kSysConfig.SetValue( "r_FSAA_samples", "4" );
				break;
			}
		case 3:
			{
				m_kSysConfig.SetValue( "r_FSAA", "1" );
				m_kSysConfig.SetValue( "r_FSAA_samples", "6" );
				break;
			}
		}
	}

	// write new full screen value
	m_kSysConfig.SetValue( "r_Fullscreen", ( FALSE != m_kFullscreenCtrl.GetCheck() ) ? "1" : "0" );
	
	// write new vsync value
	m_kSysConfig.SetValue( "r_VSync", ( FALSE != m_kVSyncCtrl.GetCheck() ) ? "1" : "0" );
}



void 
CVideoOptionsPage::OnOK()
{
	CPropertyPage::OnOK();
	UpdateSystemConfig();
}
