#include "stdafx.h"
#include "FarCryInstallJobs.h"

#include <io.h>



static void 
RemoveDirectoryRecusively( const tstring& baseDir )
{
	tstring searchPath( baseDir + _T( "*.*" ) );
	__tfinddata64_t fileInfo;

	// remove all files of current directory
	intptr_t hFile( _tfindfirst64( (TCHAR*) searchPath.c_str(), &fileInfo ) );
	if( -1L != hFile )
	{
		do
		{			
			if( 0 == ( fileInfo.attrib & _A_SUBDIR ) )
			{
				tstring filePath( baseDir + fileInfo.name );
				SetFileAttributes( filePath.c_str(), FILE_ATTRIBUTE_ARCHIVE );
				DeleteFile( filePath.c_str() );
			}
		} while( 0 == _tfindnext64( hFile, &fileInfo ) );
		_findclose( hFile );
	}

	// recursively remove all sub directories
	hFile = _tfindfirst64( (TCHAR*) searchPath.c_str(), &fileInfo );
	if( -1L != hFile )
	{
		do
		{
			if( 0 != ( fileInfo.attrib & _A_SUBDIR ) )
			{
				if( _T( '.' ) != fileInfo.name[ 0 ] )
				{
					tstring subDir( baseDir + tstring( fileInfo.name ) + _T( "\\" ) );					
					RemoveDirectoryRecusively( subDir );
				}
			}
		} while( 0 == _tfindnext64( hFile, &fileInfo ) );
		_findclose( hFile );
	}

	// remove current directory
	SetFileAttributes( baseDir.c_str(), FILE_ATTRIBUTE_ARCHIVE );
	RemoveDirectory( baseDir.c_str() );
}



static void
RemoveMasterCDFolder( TCHAR* pFarCryInstallFolder, bool keepSaveGames )
{
	if( 0 != pFarCryInstallFolder )
	{
		if( false != keepSaveGames )
		{
			tstring farCryInstallFolder( pFarCryInstallFolder );
			tstring searchPath( farCryInstallFolder + _T( "*.*" ) );
			__tfinddata64_t fileInfo;

			// go through all sub folders of MasterCD
			intptr_t hFile( _tfindfirst64( (TCHAR*) searchPath.c_str(), &fileInfo ) );
			if( -1L != hFile )
			{
				do
				{
					if( 0 != ( fileInfo.attrib & _A_SUBDIR ) )
					{
						// remove all sub folders except "\Profiles"
						if( _T( '.' ) != fileInfo.name[ 0 ] && tstring( fileInfo.name ) != tstring( _T( "Profiles" ) ) )
						{
							tstring subFolder( farCryInstallFolder + tstring( fileInfo.name ) + _T( "\\" ) );
							RemoveDirectoryRecusively( subFolder );
						}						
					}
				} while( 0 == _tfindnext64( hFile, &fileInfo ) );
				_findclose( hFile );
			}

			// remove files in MasterCD folder
			hFile = _tfindfirst64( (TCHAR*) searchPath.c_str(), &fileInfo );
			if( -1L != hFile )
			{
				do
				{
					if( 0 == ( fileInfo.attrib & _A_SUBDIR ) )
					{
						tstring filePath( farCryInstallFolder + fileInfo.name );
						SetFileAttributes( filePath.c_str(), FILE_ATTRIBUTE_ARCHIVE );
						DeleteFile( filePath.c_str() );
					}
				} while( 0 == _tfindnext64( hFile, &fileInfo ) );
				_findclose( hFile );
			}
		}
		else
		{
			// remove entire MasterCD folder
			RemoveDirectoryRecusively( pFarCryInstallFolder );
		}
	}
}



static void
RegDeleteKeyRecursively( HKEY baseKey, const tstring& subKey )
{
	const unsigned int c_wow64Flags[] = 
	{
		KEY_WOW64_64KEY,
		0
	};

	for( int i( 0 ); i < sizeof( c_wow64Flags ) / sizeof( c_wow64Flags[ 0 ] ); ++i )
	{
		// open current key
		HKEY key;
		if( ERROR_SUCCESS == RegOpenKeyEx( baseKey, subKey.c_str(), 0, c_wow64Flags[ i ] | KEY_ALL_ACCESS, &key ) )
		{

#ifdef _DEBUG
			TCHAR pcDbgOutput[ 128 ];
			_stprintf( pcDbgOutput, _T( "%s %d" ), 
				subKey.c_str(), i );
			::MessageBox( 0, pcDbgOutput, _T( "In debug build only!" ), MB_OK );
#endif

			// query info about key
			DWORD numSubKeys( 0 );
			DWORD maxSubKeyLength( 0 );
			RegQueryInfoKey( key, 0, 0, 0, &numSubKeys, &maxSubKeyLength, 0, 0, 0, 0, 0, 0 );

			// iterate over all sub keys
			for( DWORD i( 0 ); i < numSubKeys; ++i )
			{
				// recursively remove all sub keys
				tvector subKeyName( maxSubKeyLength + 1 );
				RegEnumKey( key, i, &subKeyName[ 0 ], maxSubKeyLength + 1 );
				RegDeleteKeyRecursively( baseKey, subKey + tstring( _T( "\\" ) + tstring( &subKeyName[ 0 ] ) ) );
			}

			// close and remove current key
			RegCloseKey( key );
			RegDeleteKey( baseKey, subKey.c_str() );
		}	
	}
}



static void
RemoveRegistryEntries()
{
	RegDeleteKeyRecursively( HKEY_LOCAL_MACHINE, _T( "SOFTWARE\\Crytek\\FarCry" ) );
	RegDeleteKeyRecursively( HKEY_LOCAL_MACHINE, _T( "SOFTWARE\\Crytek\\Far Cry" ) );
	RegDeleteKeyRecursively( HKEY_LOCAL_MACHINE, _T( "SOFTWARE\\Crytek\\Sandbox" ) );

	RegDeleteKeyRecursively( HKEY_CURRENT_USER, _T( "SOFTWARE\\Crytek\\FarCry" ) );
	RegDeleteKeyRecursively( HKEY_CURRENT_USER, _T( "SOFTWARE\\Crytek\\Far Cry" ) );
	RegDeleteKeyRecursively( HKEY_CURRENT_USER, _T( "SOFTWARE\\Crytek\\Sandbox" ) );
}



FARCRYINSTALLJOBS_API BOOL
FinalCleanup( TCHAR* pcFarCryInstallFolder, BOOL bKeepSaveGames )
{
#ifdef _DEBUG
	TCHAR pcDbgOutput[ 128 ];
	_stprintf( pcDbgOutput, _T( "FarCryInsatllJobs::FinalCleanup...\n%s\n%d" ), 
		pcFarCryInstallFolder, bKeepSaveGames );
	::MessageBox( 0, pcDbgOutput, _T( "In debug build only!" ), MB_OK );
#endif

	RemoveMasterCDFolder( pcFarCryInstallFolder, FALSE != bKeepSaveGames );
	RemoveRegistryEntries();

	return( TRUE );
}
