#pragma once

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

#include <windows.h>

#include <stdio.h>
#include <tchar.h>
#include <assert.h>

#include <dxdiag.h>
#include <ddraw.h>

#include <vector>
#include <string>



template< typename T >
inline void 
SafeRelease( T*& pInterface )
{
	if( 0 != pInterface )
	{
		pInterface->Release();
		pInterface = 0;
	}
}



// some types and defines for easy multi byte / unicode compilation
typedef std::basic_string< TCHAR > tstring;
typedef std::vector< TCHAR > tvector;



#ifdef UNICODE		
#	define tsystem				_wsystem
#	define _tfindfirst64		_wfindfirst64
#	define _tfindnext64			_wfindnext64
#	define __tfinddata64_t		__wfinddata64_t
#else
#	define tsystem				system
#	define _tfindfirst64		_findfirst64
#	define _tfindnext64			_findnext64
#	define __tfinddata64_t		__finddata64_t
#endif
