#include "stdafx.h"
#include "ColorImage.h"
#include <assert.h>
#include "ImageVerifier.h"				// CImageVerifier
#include "ASCIIFile.h"						// CASCIIFile
#include <ddraw.h>								// DDSURFACEDESC2
#include <dxerr.h>								// 
#include "NVDXT/dxtlib.h"



// e.g. "c:/temp/test.ini" results in ".ini"
const char *GetExtension( const char *sIn )
{
	const char *pRet=sIn;

	while(*sIn)
	{
		if(*sIn=='.')
			pRet=sIn+1;

		++sIn;
	}

	return pRet;
}


/*
#define D3DFMT_3DC (MAKEFOURCC('A', 'T', 'I', '2'))

bool IsCompressed( const D3DFORMAT format )
{
	return format==D3DFMT_DXT1 
			|| format==D3DFMT_DXT2
			|| format==D3DFMT_DXT3
			|| format==D3DFMT_DXT4
			|| format==D3DFMT_DXT5
			|| format==D3DFMT_3DC;
}

uint32 ComputePitch( const uint32 dwWidth, const D3DFORMAT format, const uint32 dwBitsPerPixel )
{
	if(IsCompressed(format))
		return ((dwWidth+3)/4)*dwBitsPerPixel*2;
	
	return dwWidth * dwBitsPerPixel/8;
}
*/

struct SMemBlock
{
	char *		m_pFileMemory;
	uint32		m_dwFileSize;
};

static SMemBlock memblock;

NV_ERROR_CODE DXTReadCallback_CColorImage(void *buffer, size_t count, void * userData)
{
//	SMemBlock &rMemBlock = *(SMemBlock *)userData;
	SMemBlock &rMemBlock = memblock;

//	if(rMemBlock.m_dwFileSize<count)
//		return NV_FAIL;

	memcpy(buffer,rMemBlock.m_pFileMemory,count);
	rMemBlock.m_pFileMemory+=count;
//	rMemBlock.m_dwFileSize-=count;

	return NV_OK;
}


CColorImage::CColorImage( CImageVerifier &rIV, const char *szFilename, const bool bMips ) :m_dwWidth(0), m_dwHeight(0)
{
	assert(szFilename);

	m_sFilename=szFilename;

	CASCIIFile file;

	if(!file.IO_LoadASCIIFile(szFilename))
		return;

	uint8 *pFileMemory = (uint8 *)file.GetDataPtr();
	uint32 dwFileSize = file.GetDataSize();

	const char *szExt = GetExtension(szFilename);

	bool bRet=false;

	if(stricmp(szExt,"dds")==0)
		bRet=LoadDDS(pFileMemory,dwFileSize);
	else if(stricmp(szExt,"bmp")==0)
		bRet=LoadBmp(pFileMemory,dwFileSize);

	assert(bRet);
}

bool CColorImage::LoadBmp( uint8 *pFileMemory, const uint32 dwFileSize )
{
	if(dwFileSize<sizeof(BITMAPINFOHEADER)+sizeof(BITMAPFILEHEADER))
		return false;

	BITMAPFILEHEADER *pBitmapFileHeader = (BITMAPFILEHEADER *)pFileMemory;

	if(pBitmapFileHeader->bfType !=0x4D42)
		return false;

	BITMAPINFOHEADER *pBitmapInfoHeader = (BITMAPINFOHEADER *)(pFileMemory+sizeof(BITMAPFILEHEADER));

	pFileMemory+=pBitmapFileHeader->bfOffBits;

	Alloc(pBitmapInfoHeader->biWidth,pBitmapInfoHeader->biHeight);

	uint32 *pDst = &m_Data[0];		// high ARGB low

	if(pBitmapInfoHeader->biBitCount==32)
	{
		for(uint32 dwY=0;dwY<m_dwHeight;++dwY,pFileMemory+=pBitmapInfoHeader->biWidth*4)
			memcpy(&pDst[(m_dwHeight-dwY-1)*m_dwWidth],pFileMemory,pBitmapInfoHeader->biWidth*4);
	}
	else if(pBitmapInfoHeader->biBitCount==24)
	{
		uint32 dwPitch = ((m_dwWidth*3)+3) & ~3;

		for(uint32 dwY=0;dwY<m_dwHeight;++dwY)
		{
			uint8 *pLine = &pFileMemory[(m_dwHeight-1-dwY)*dwPitch];

			for(uint32 dwX=0;dwX<m_dwWidth;++dwX,pLine+=3)
				*pDst++ = (((uint32)pLine[2])<<16) | (((uint32)pLine[1])<<8) | ((uint32)pLine[0]);	// [0]=blue [1]=green  [2]=red
		}
	}
	else
	{
		assert(0);
		FreeData();
		return false;
	}

	return true;
}



bool CColorImage::LoadDDS( uint8 *pFileMemory, const uint32 dwFileSize )
{
	if(dwFileSize<4+sizeof(DDSURFACEDESC2))
		return false;

	uint32 *pMagic=(uint32 *)pFileMemory;
	DDSURFACEDESC2 *pDesc=(DDSURFACEDESC2 *)(pFileMemory+4);

	if(*pMagic!=' SDD' || pDesc->dwSize!=(uint32)sizeof(DDSURFACEDESC2))		// DDS
		return false;

	{
		nvImageContainer img;

		memblock.m_pFileMemory=(char *)pFileMemory;
		memblock.m_dwFileSize=dwFileSize;
		int mipmapCount=pDesc->dwMipMapCount;

 		NV_ERROR_CODE err = nvDDS::nvDXTdecompress(img,PF_RGBA,mipmapCount,DXTReadCallback_CColorImage,0);

		uint32 dwFinalWidth = (uint32)img.rgbaMIPImage.width()*2*2;		// include space for mips and alpha

		Alloc(dwFinalWidth,(uint32)(img.rgbaMIPImage.height()));

		uint32 dwStartX=0;

		for(uint32 dwMip=0;dwMip<img.rgbaMIPImage.numMIPMaps();++dwMip)
		{
			uint32 dwLocalWidth = (uint32)(img.rgbaMIPImage.width())>>dwMip;
			uint32 dwLocalHeight = (uint32)(img.rgbaMIPImage.height())>>dwMip;

			for(uint32 dwY=0;dwY<dwLocalHeight;++dwY)
			{
				// RGB
				{
					uint8 *pDst = (uint8 *)(&m_Data[dwStartX+dwFinalWidth*dwY]);
					uint8 *pSrc = (uint8 *)(img.rgbaMIPImage[dwMip].pixels() + dwY*img.rgbaMIPImage[dwMip].width());

					for(uint32 dwX=0;dwX<dwLocalWidth;++dwX,pSrc+=4)
					{
						*pDst++=pSrc[2];	// blue
						*pDst++=pSrc[1];	// green
						*pDst++=pSrc[0];	// red
						*pDst++=0;
					}
				}

				// Alpha
				{
					uint8 *pDst = (uint8 *)(&m_Data[dwStartX+dwFinalWidth*dwY+dwFinalWidth/2]);
					uint8 *pSrc = (uint8 *)(img.rgbaMIPImage[dwMip].pixels() + dwY*img.rgbaMIPImage[dwMip].width())+3;

					for(uint32 dwX=0;dwX<dwLocalWidth;++dwX,pSrc+=4)
					{
						*pDst++=*pSrc;		// alpha
						*pDst++=*pSrc;		// alpha
						*pDst++=*pSrc;		// alpha
						*pDst++=0;
					}
				}
			}

			dwStartX += dwLocalWidth;
		}
	}

	return true;
}

void CColorImage::FreeData()
{
	m_Data.resize(0);
	m_Data.clear();

	m_dwWidth=0;
	m_dwHeight=0;
}

bool CColorImage::Alloc( const uint32 dwWidth, const uint32 dwHeight )
{
	m_Data.resize(dwWidth*dwHeight*4,0x303030);		// grey background
	m_dwWidth=dwWidth;
	m_dwHeight=dwHeight;

	return true;
}



bool CColorImage::IsValid() const
{
	return !m_Data.empty();
}


uint32 &CColorImage::At( const int iX, const int iY )
{
	assert(iX>=0 && iX<(int)m_dwWidth);
	assert(iY>=0 && iY<(int)m_dwHeight);

	return m_Data[iX+iY*m_dwWidth];
}



bool CColorImage::SaveBmp( const char *szFilename )
{
	FILE *out = fopen(szFilename,"wb");

	if(!out)
		return false;

	BITMAPFILEHEADER pHeader;
	BITMAPINFOHEADER pInfoHeader;

	memset(&pHeader, 0, sizeof(BITMAPFILEHEADER));
	memset(&pInfoHeader, 0, sizeof(BITMAPINFOHEADER));

	uint32 dwPitch = (m_dwWidth*3+3) & ~3;

	pHeader.bfType = 0x4D42;
	pHeader.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + dwPitch * m_dwHeight;
	pHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	pInfoHeader.biSize = sizeof(BITMAPINFOHEADER);
	pInfoHeader.biWidth = m_dwWidth;
	pInfoHeader.biHeight = m_dwHeight;
	pInfoHeader.biPlanes = 1;
	pInfoHeader.biBitCount = 24;
	pInfoHeader.biCompression = 0;
	pInfoHeader.biSizeImage = dwPitch * m_dwHeight;
	pInfoHeader.biXPelsPerMeter=2834;
	pInfoHeader.biYPelsPerMeter=2834;

	fwrite(&pHeader, 1, sizeof(BITMAPFILEHEADER), out);
	fwrite(&pInfoHeader, 1, sizeof(BITMAPINFOHEADER), out);

	for(uint32 dwY=0;dwY<m_dwHeight;++dwY)
	{
		for(uint32 dwX=0;dwX<m_dwWidth;++dwX)
			fwrite(&m_Data[dwX+(m_dwHeight-dwY-1)*m_dwWidth],3,1,out);

		if(dwPitch!=m_dwWidth*3)
		{
			char tab[4]={0};

			fwrite(tab,dwPitch-m_dwWidth*3,1,out);
		}
	}	

	fclose(out);

	return true;
}