#include "types.h"			// uint32
#include <vector>			// STL vector<>
#include <string>			// STL string

class CImageVerifier;

class CColorImage
{
public:

	// default constructor
	CColorImage() :m_dwWidth(0), m_dwHeight(0) {}

	// constructor
	CColorImage( CImageVerifier &rIV, const char *szFilename, const bool bMips );

	bool Alloc( const uint32 dwWidth, const uint32 dwHeight );

	bool IsValid() const;

	uint32 GetWidth() const { return m_dwWidth; }
	uint32 GetHeight() const { return m_dwHeight; }

	uint32 &At( const int iX, const int iY );

	void FreeData();

	bool LoadDDS( uint8 *pFileMemory, const uint32 dwFileSize );

	bool LoadBmp( uint8 *pFileMemory, const uint32 dwFileSize );

	bool SaveBmp( const char *szFilename );

private: // ---------------------------------------------------

	uint32													m_dwWidth;						//
	uint32													m_dwHeight;						//
	std::string											m_sFilename;					//
	std::vector<uint32>							m_Data;								//
};