#include "stdafx.h"
#include "HTMLWriter.h"
#include <assert.h>						// assert()
#include "ColorImage.h"				// CColorImage
#include <Windows.h>					// CreateDirectory()


CHTMLWriter::CHTMLWriter( const char *szFolderName, const char *szResourceName ) :m_dwImageCount(0)
{
	assert(szResourceName);
	assert(strstr(szResourceName,".")==0);		// no extension

	m_sResourceName=szResourceName;
	m_sFolderName=szFolderName;
	CreateDirectoryA(szFolderName,0);
}


CHTMLWriter::~CHTMLWriter()
{
}

bool CHTMLWriter::SaveHTML( const char *szFilename, const char *szTitle )
{
	FILE *hHTMLFile = fopen(szFilename,"wb");

	if(!hHTMLFile)
		return false;

	fprintf(hHTMLFile,"<HTML><HEAD><BODY bgcolor=#898989 alink=#ffffff link=#ffffff vlink=#ffffff text=#000000>\n");

	fprintf(hHTMLFile,"<TITLE>");
	fprintf(hHTMLFile,szTitle);
	fprintf(hHTMLFile,"</TITLE><br>\n\n");

	fprintf(hHTMLFile,m_sHTMLData.c_str());

	fprintf(hHTMLFile,"</BODY></HTML>\n");
	fclose(hHTMLFile);

	return true;
}

void CHTMLWriter::Add( const CHTMLWriter &rhs )
{
	m_sHTMLData+=rhs.m_sHTMLData;
}


void CHTMLWriter::AddHeadline( const char *szText )
{
	assert(szText);

	m_sHTMLData+="<H1>";
	m_sHTMLData+=szText;
	m_sHTMLData+="</H1><br>\n\n";
}


void CHTMLWriter::AddLine( const char *szText, ... )
{
	va_list		arglist;
	char		buf[1024];
	va_start(arglist, szText);
	vsnprintf(buf,sizeof(buf),szText, arglist);
	va_end(arglist);	
	m_sHTMLData+=buf;
	m_sHTMLData+="<br>\n";
}

void CHTMLWriter::Add( const char *szText, ... )
{
	va_list		arglist;
	char		buf[1024];
	va_start(arglist, szText);
	vsnprintf(buf,sizeof(buf),szText, arglist);
	va_end(arglist);	
	m_sHTMLData+=buf;
}

void CHTMLWriter::AddImage( CColorImage &rImg, const char *szName, const char *szHyperlink )
{
	assert(szName);

	char str[1024];


	char szFilename[4*256];

	sprintf(szFilename,"%s/%s%d.bmp",m_sFolderName.c_str(),m_sResourceName.c_str(),m_dwImageCount++);

	if(szHyperlink)
		sprintf(str,"<A HREF=\"%s\">",szHyperlink);
	 else
		sprintf(str,"<A HREF=\"%s\">",szFilename);

	m_sHTMLData+=str;


	rImg.SaveBmp(szFilename);

	sprintf(str,"<IMG BORDER=0 ALT=\"%s\" TITLE=\"%s\" SRC=\"%s",szName,szName,szFilename);
	m_sHTMLData+=str;

	int iScale=1;		// n times smaller

	while(rImg.GetWidth()/iScale>256 || rImg.GetHeight()/iScale>256)
		iScale++;

	sprintf(str,"\" WIDTH=%d HEIGHT=%d />",(rImg.GetWidth()+iScale-1)/iScale,(rImg.GetHeight()+iScale-1)/iScale);
	m_sHTMLData+=str;

	m_sHTMLData+="</A>\n";
}
