#include "stdafx.h"
#include <assert.h>
#include "ColorImage.h"						// CColorImage
#include "ImageVerifier.h"



CImageVerifier::CImageVerifier() 
	:m_pSource(0), m_pReference(0), m_dwUniqueId(0)
{
}


void CImageVerifier::Setup( const char *szReference, const char *szSource )
{
	assert(szSource);
	assert(szReference);

	m_pSource = new CColorImage(*this,szSource,true);
	if(!m_pSource->IsValid())	{ delete m_pSource;m_pSource=0; }

	m_pReference = new CColorImage(*this,szReference,true);
	if(!m_pReference->IsValid()){ delete m_pReference;m_pReference=0; }
}



CImageVerifier::~CImageVerifier()
{
	if(m_pReference)delete m_pReference;m_pReference=0;
	if(m_pSource)delete m_pSource;m_pSource=0;
}



// return 0..255*3
uint32 ColorDifference( const uint32 dwA, const uint32 dwB )
{
	int diff=0;

	for(int i=0;i<4;++i)
	{
		int a = (int)((dwA>>(i*8))&0xff);
		int b = (int)((dwB>>(i*8))&0xff);

		if(a>b)diff+=a-b;
			else diff+=b-a;
	}

	return diff;
}


// \param dwV 0..255
// \return ARGB
uint32 ColorRamp( uint32 dwV )
{
	if(dwV==0)	return 0;
	if(dwV<64)	return (32+(dwV*(255-32))/63)<<16;
	dwV=((dwV-64)*255)/(255-64);
	if(dwV<128)	return 0xff0000 | (dwV<<9);
	dwV=((dwV-128)*255)/(255-128);
	return 0xffff00 | dwV;
}


void CImageVerifier::ImageDifference( CColorImage &rDiff, CResult &result )
{
	assert(m_pSource);
	assert(m_pReference);

	bool bBad=false;

	rDiff.FreeData();

	if(m_pSource->GetWidth()!=m_pReference->GetWidth())
	{
		char str[256];
		sprintf_s(str,sizeof(str),"width=%d doesn't match (reference:%d)",m_pSource->GetWidth(),m_pReference->GetWidth());

		result.AddError(str);
		bBad=true;
	}

	if(m_pSource->GetHeight()!=m_pReference->GetHeight())
	{
		char str[256];
		sprintf_s(str,sizeof(str),"height=%d doesn't match (reference:%d)",m_pSource->GetHeight(),m_pReference->GetHeight());

		result.AddError(str);
		bBad=true;
	}

	if(bBad)
		return;

	uint32 dwWidth=m_pSource->GetWidth();
	uint32 dwHeight=m_pSource->GetHeight();

	if(!rDiff.Alloc(dwWidth,dwHeight))
	{
		result.AddError("out of memory when allocating difference image");
		return;
	}

	result.m_fDifference=0;

	if(dwWidth!=0 && dwHeight!=0)
	{
		for(uint32 dwY=0;dwY<dwHeight;++dwY)
		for(uint32 dwX=0;dwX<dwWidth;++dwX)
		{
			uint32 dwR = m_pReference->At(dwX,dwY);
			uint32 dwS = m_pSource->At(dwX,dwY);

			uint32 dwDiff = ColorDifference(dwR,dwS);

			rDiff.At(dwX,dwY) = ColorRamp((dwDiff+2)/3);
	//		rDiff.At(dwX,dwY) = ColorRamp(dwY);

			result.m_fDifference += dwDiff;
		}
		result.m_fDifference = (float)((double)result.m_fDifference / (double)(255*dwHeight*dwWidth));
	}
}
