#include <string>								// STL string
#include <stdarg.h>
#include "types.h"							// uint32


class CColorImage;
struct IDirect3D9;
struct IDirect3DDevice9;

class CResult
{
public:

	CResult() :m_fDifference(0) {}

	void AddError( const char *szLine, ... ) 
	{ 
		va_list		arglist;
		char		buf[1024];
		va_start(arglist, szLine);
		vsnprintf(buf,sizeof(buf),szLine, arglist);
		va_end(arglist);	
		m_sErrors+=buf;m_sErrors+="; "; 
	}

	bool IsError() { return !m_sErrors.empty(); }

	const char *GetErrors() { return m_sErrors.c_str(); }

	// ---------------------------------------------------------

	float							m_fDifference;

private: // ---------------------------------------------------

	std::string				m_sErrors;
};


class CImageVerifier
{
public:

	// constructor
	CImageVerifier();
	// destructor
	~CImageVerifier();

	void Setup( const char *szReference, const char *szSource );

	void ImageDifference( CColorImage &rDiff, CResult &result );

	CColorImage *GetSrc() { return m_pSource; }
	CColorImage *GetRef() { return m_pReference; }

	uint32 GetUniqueId() { return m_dwUniqueId++; }

private: // -----------------------------------------------

	uint32											m_dwUniqueId;						//
	CColorImage	*								m_pSource;							//
	CColorImage *								m_pReference;						//

	friend class CColorImage;
};