// Adapter.h : Declaration of the CAdapter

#pragma once
#include "resource.h"       // main symbols
#include "Iphlpapi.h"
#pragma comment (lib , "Iphlpapi.lib")

// IAdapter
[
	object,
	uuid("66890FF6-E0C1-4679-9A36-FCBB8051ACED"),
	dual,	helpstring("IAdapter Interface"),
	pointer_default(unique)
]
__interface IAdapter : IDispatch
{
	[propget, id(1), helpstring("property name")] HRESULT name([out, retval] BSTR* pVal);
	[propget, id(2), helpstring("property IPAddress")] HRESULT IPAddress([out, retval] BSTR* pVal);
};



// CAdapter

[
	coclass,
	threading("single"),
	support_error_info("IAdapter"),
	aggregatable("never"),
	vi_progid("NetSim.Adapter"),
	progid("NetSim.Adapter.1"),
	version(1.0),
	uuid("5A6401ED-53C6-424F-AD22-EB4716C6B7ED"),
	helpstring("Adapter Class")
]
class ATL_NO_VTABLE CAdapter : 
	public IAdapter
{
public:
	CAdapter()
	{
	}


	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}
	
	void FinalRelease() 
	{
	}
	
public:
	void SetAdapter(IP_ADAPTER_INFO &ai){m_Adapter=ai;}
private:
	IP_ADAPTER_INFO m_Adapter;
public:
	STDMETHOD(get_name)(BSTR* pVal);
	STDMETHOD(get_IPAddress)(BSTR* pVal);
};

_COM_SMARTPTR_TYPEDEF(IAdapter,__uuidof(IAdapter));

