#include <stdafx.h>
#include "LevelStats.h"				// CLevelStats








CLevelStats::CLevelStats() :m_bCreated(false)
{
}

bool CLevelStats::Load( const char *szFilename )
{
	bool bRet = m_Doc.LoadFile(szFilename);

	if(bRet)
		m_bCreated=true;

	return bRet;
}


bool CLevelStats::Save( const char *szFilename )
{
	return m_Doc.SaveFile(szFilename);
}

bool CLevelStats::CopyAndClean( const CLevelStats &rhs )
{
	m_Doc = rhs.m_Doc;

	TiXmlNode *nodeWorkbook = m_Doc.FirstChild("Workbook");				
	
	if(!nodeWorkbook)
		return false;

	for(TiXmlNode *nodeWorksheet=nodeWorkbook->FirstChild("Worksheet"); nodeWorksheet; )
	{
		TiXmlNode *nodeNext = nodeWorksheet->NextSibling();
		nodeWorkbook->RemoveChild(nodeWorksheet);

		nodeWorksheet=nodeNext;
	}

	m_bCreated=true;
	return true;
}

void CLevelStats::CreateWorksheet( const char *szName )
{
	assert(szName);

	TiXmlElement elWorkSheet("Worksheet");
	elWorkSheet.SetAttribute("ss:Name",szName);
	
	TiXmlNode *nodeWorkbook = m_Doc.FirstChild("Workbook");				assert(nodeWorkbook);

	TiXmlNode *node = nodeWorkbook->InsertEndChild(elWorkSheet);
	TiXmlElement elTable("Table");

	node->InsertEndChild(elTable);
}




TiXmlNode *CLevelStats::WorksheetRef( const char *szName )
{
	TiXmlNode *nodeWorkbook = m_Doc.FirstChild("Workbook");

	if(!nodeWorkbook)
	{
		assert(0);
		return 0;
	}

	for(TiXmlNode *nodeWorksheet=nodeWorkbook->FirstChild("Worksheet"); nodeWorksheet; nodeWorksheet=nodeWorksheet->NextSibling())
	{
		const char *szAtt = nodeWorksheet->ToElement()->Attribute("ss:Name");

		if(!szAtt)
			continue;

		TiXmlNode *nodeTableWorksheet = nodeWorksheet->FirstChild("Table");

		if(!nodeTableWorksheet)
			continue;

		if(stricmp(szName,szAtt)==0)
			return nodeTableWorksheet;
	}

	return 0;
}













