#include "stdafx.h"
#include "LevelStatsProcessor.h"					// CLevelStatsProcessor
#include "ExcelWorksheetRef.h"						// CExcelWorksheetRef
#include <map>														// STL map<>

CLevelStatsProcessor::CLevelStatsProcessor( const char *szDestFile )
	:m_sDestFile(szDestFile), m_dwDestX(0xffffffff)
{
}


CLevelStatsProcessor::~CLevelStatsProcessor()
{
	if(!m_Dest.Save(m_sDestFile.c_str()))
		printf("ERROR: Failed to update destination file (opened by another application?)\n");
}

std::string CLevelStatsProcessor::GetWords( const std::string sIn, const uint32 dwStartId, const uint32 dwEndId, const char cSeparator )
{
	std::string sRet;
	const char *p = sIn.c_str();

	uint32 dwWord = 0;

	while(*p)
	{
		if(*p==cSeparator)
			++dwWord;
		else if(dwWord>=dwStartId && dwWord<=dwEndId)
			sRet += *p;

		++p;
	}

	return sRet;
}

float GetFloat( const char *szString )
{
	assert(szString);

	float fRet=0;

	if(sscanf(szString,"%f",&fRet)==1)
		return fRet;
	else
	{
		assert(0);
		return 0.0f;
	}
}

#include <windows.h>	// OutputDebugString()

// remove data in brackets and space before, can be further improved
std::string CleanupName( const std::string &sIn )
{
	std::string sRet;
	const char *pStart = sIn.c_str();
	const char *pLastKnownEnd = pStart;
	const char *p = pStart;

	while(*p)
	{
		if(*p=='(')
			break;

		if(*p!=' ')
			pLastKnownEnd=p;

		++p;
	}

	sRet = sIn;

	sRet.resize(pLastKnownEnd+1-pStart);
/*
	OutputDebugString("'");
	OutputDebugString(sIn.c_str());
	OutputDebugString("' - '");
	OutputDebugString(sRet.c_str());
	OutputDebugString("'\n");
*/
	return sRet;
}


extern bool g_bCombineLevels;


void CLevelStatsProcessor::AddHeader( CExcelWorksheetRef &rWorksheet, const uint32 dwX, const uint32 dwBuild )
{
	const char *szStyleBuild="s21";			// s21:bold+left aligned, s25:green background+bold,
	const char *szStyleHeader="s25";			//

	if(g_bCombineLevels)
	{
		uint32 dwY = rWorksheet.FindLineBasedOnKey("Level","Module",szStyleHeader);
		rWorksheet.SetValueAt(dwX,dwY,(float)dwBuild,szStyleHeader);
	}
	else
	{
		uint32 dwY = rWorksheet.FindLineBasedOnKey("","Build",szStyleBuild);
		rWorksheet.SetValueAt(dwX,dwY,(float)dwBuild,szStyleBuild);
	}
}


void CLevelStatsProcessor::ProcessLevelWorksheet( const char *szSourceFile, SSourceRef &SourceRef, const uint32 dwX )
{
	assert(CleanupName("test (aa) (bb)")==std::string("test"));
	assert(CleanupName("test(aa)")==std::string("test"));
	assert(CleanupName("test (aa)")==std::string("test"));
	assert(CleanupName("test")==std::string("test"));

	std::string sLevelKey;

	std::string sVersion = GetWords(SourceRef.m_excelSrcSummary.GetValueAt(0,0),2,2);		// e.g. 1.1.1.4324
	std::string sBuild = GetWords(sVersion,3,3,'.');
	uint32 dwBuild = (uint32)GetFloat(sBuild.c_str());

	std::string sLevel = GetWords(SourceRef.m_excelSrcSummary.GetValueAt(0,1),1,1);

	bool bExtended=true;

	if(g_bCombineLevels)
	{
		bExtended=false;
		sLevelKey=sLevel;
	}

	// destination worksheets -------------------------------------

	CreateDestWorksheet(m_Dest,m_excelDstSummary,"Summary");
	CreateDestWorksheet(m_Dest,m_excelDstTimeDemo,"TimeDemo");

	if(bExtended)
		CreateDestWorksheet(m_Dest,m_excelDstProfiler,"Profiler.SelfTime");

	// --------------------------------------------------------------------------
	// m_excelDstSummary
	// --------------------------------------------------------------------------

	m_excelDstSummary.SetColumWidth(0,170);

	if(g_bCombineLevels)
	{
		m_excelDstSummary.SetColumWidth(1,170);
		m_excelDstTimeDemo.SetColumWidth(1,170);
		m_excelDstProfiler.SetColumWidth(1,170);
	}


	uint32 dwY=0;

	std::string sBits = GetWords(SourceRef.m_excelSrcSummary.GetValueAt(0,2),2,2);

	AddHeader(m_excelDstSummary,dwX,dwBuild);

	if(bExtended)
	{
		dwY = m_excelDstSummary.FindLineBasedOnKey(sLevelKey,"File");
		if(dwY!=0xffffffff)m_excelDstSummary.SetStringValueAt(dwX,dwY,szSourceFile);
	}

	// -------------------

	if(bExtended)
	{
		dwY = m_excelDstSummary.FindLineBasedOnKey(sLevelKey,"Level");
		if(dwY!=0xffffffff)m_excelDstSummary.SetStringValueAt(dwX,dwY,sLevel.c_str());
	}

	if(bExtended)
	{
		dwY = m_excelDstSummary.FindLineBasedOnKey(sLevelKey,"sBits");
		if(dwY!=0xffffffff)m_excelDstSummary.SetStringValueAt(dwX,dwY,sBits.c_str());
	}

	dwY = m_excelDstSummary.FindLineBasedOnKey(sLevelKey,SourceRef.m_excelSrcSummary.GetValueAt(0,3));
	if(dwY!=0xffffffff)m_excelDstSummary.SetValueAt(dwX,dwY,GetFloat(SourceRef.m_excelSrcSummary.GetValueAt(1,3).c_str()));

	// -------------------
	if(bExtended)
		m_excelDstSummary.ExtendByOneLine();					// separator if we write the file the first time

	SourceRef.m_excelSrcSummary.ComputeExtend();
	SourceRef.m_excelSrcModulesMemoryInfo.ComputeExtend();

	uint32 dwSummaryExtendX=SourceRef.m_excelSrcSummary.GetWidth(),dwSummaryExtendY=SourceRef.m_excelSrcSummary.GetHeight();
	uint32 dwNextSectionLine=4;

	for(uint32 dwInputY=dwNextSectionLine;dwInputY<dwSummaryExtendY;++dwInputY)
	{
		uint32 dwStartY=dwInputY;

		std::string sPreTable = CleanupName(SourceRef.m_excelSrcSummary.GetValueAt(0,dwInputY));

		if(sPreTable=="Resource Type")
		{
			for(;;)
			{
				++dwInputY;

				std::string sLineStart = SourceRef.m_excelSrcSummary.GetValueAt(0,dwInputY);

				if(sLineStart.empty())
					break;

				dwNextSectionLine = dwInputY+1;

				sLineStart = CleanupName(sLineStart);

				assert(dwInputY<dwSummaryExtendY);

				for(uint32 dwInputX=1;dwInputX<dwSummaryExtendX;++dwInputX)
				{
					std::string sValue = SourceRef.m_excelSrcSummary.GetValueAt(dwInputX,dwInputY);

					if(!sValue.empty())
					{
						std::string sColStart = SourceRef.m_excelSrcSummary.GetValueAt(dwInputX,dwStartY);

						sColStart = CleanupName(sColStart);

						dwY = m_excelDstSummary.FindLineBasedOnKey(sLevelKey,sLineStart+"."+sColStart);

						if(dwY!=0xffffffff)
							m_excelDstSummary.SetValueAt(dwX,dwY,GetFloat(sValue.c_str()));
					}
				}

			}
		}
	}

	// -------------------
	if(bExtended)
		m_excelDstSummary.ExtendByOneLine();					// separator if we write the file the first time

	{
		std::string sEntry;

		for(uint32 dwInputY=dwNextSectionLine;dwInputY<dwSummaryExtendY;++dwInputY)
		{
			sEntry = SourceRef.m_excelSrcSummary.GetValueAt(0,dwInputY);

			if(sEntry.empty())
				continue;

			sEntry = CleanupName(sEntry);

			dwY = m_excelDstSummary.FindLineBasedOnKey(sLevelKey,sEntry);
			if(dwY!=0xffffffff)m_excelDstSummary.SetValueAt(dwX,dwY,GetFloat(SourceRef.m_excelSrcSummary.GetValueAt(1,dwInputY).c_str()));
		}
	}

	// -------------------------------------------------------------------------
	if(bExtended)
		m_excelDstSummary.ExtendByOneLine();					// separator if we write the file the first time

	// DLL memory
	{
		std::string sEntry;

		for(uint32 dwInputY=2;dwInputY<=SourceRef.m_excelSrcModulesMemoryInfo.GetHeight();++dwInputY)
		{
			sEntry = SourceRef.m_excelSrcModulesMemoryInfo.GetValueAt(0,dwInputY);

			if(sEntry.empty())			// stops processing on first empty line - the stuff below is on summary already
				break;

			sEntry = CleanupName(sEntry);

			dwY = m_excelDstSummary.FindLineBasedOnKey(sLevelKey,sEntry);
			if(dwY!=0xffffffff)m_excelDstSummary.SetValueAt(dwX,dwY,GetFloat(SourceRef.m_excelSrcModulesMemoryInfo.GetValueAt(1,dwInputY).c_str()));
		}
	}

	// -------------------
	if(bExtended)
		m_excelDstSummary.ExtendByOneLine();					// separator if we write the file the first time

	// --------------------------------------------------------------------------
	// m_excelDstTimeDemo
	// --------------------------------------------------------------------------

	if(SourceRef.m_excelSrcTimeDemo)
	{
		m_excelDstTimeDemo.SetColumWidth(0,170);

		AddHeader(m_excelDstTimeDemo,dwX,dwBuild);
//		dwY = m_excelDstTimeDemo.FindLineBasedOnKey("Level","Module",szStyleHeader);
//		m_excelDstTimeDemo.SetValueAt(dwX,dwY,iBuild,szStyleHeader);

		for(uint32 dwSrcLine=0;dwSrcLine<8;++dwSrcLine)
		{
			dwY = m_excelDstTimeDemo.FindLineBasedOnKey(sLevelKey,SourceRef.m_excelSrcTimeDemo.GetValueAt(0,dwSrcLine));
			if(dwY!=0xffffffff)m_excelDstTimeDemo.SetValueAt(dwX,dwY,GetFloat(SourceRef.m_excelSrcTimeDemo.GetValueAt(1,dwSrcLine).c_str()));
		}

		if(bExtended)
			m_excelDstTimeDemo.ExtendByOneLine();					// separator if we write the file the first time
	}

	// --------------------------------------------------------------------------
	// m_excelDstProfiler
	// --------------------------------------------------------------------------

	if(bExtended)
	if(SourceRef.m_excelSrcProfiler)
	{
		SourceRef.m_excelSrcProfiler.ComputeExtend();

		uint32 dwLines = SourceRef.m_excelSrcProfiler.GetHeight();
		uint32 dwColumnName = SourceRef.m_excelSrcProfiler.FindColumn("Name");
		uint32 dwColumnSelfTime = SourceRef.m_excelSrcProfiler.FindColumn("Self Time");

		if(dwColumnName!=0xffffffff)
		if(dwColumnSelfTime!=0xffffffff)
		{
			// test for uniqueness - a key should not be used multiple times - source code changes needed
			{
				std::map<std::string,int> Keys;

				for(uint32 dwLine=1;dwLine<dwLines;++dwLine)
				{
					std::string sVal = SourceRef.m_excelSrcProfiler.GetValueAt(dwColumnName,dwLine);

					if(!sVal.empty())
					{
						std::map<std::string,int>::iterator it = Keys.find(sVal);

						if(it==Keys.end())
							Keys[sVal]=1;
						else
						{
							if(it->second==1)			// print error it only once - even if used multiple times 
							{
								printf("    ERROR: Key '%s' was used multiple times\n",sVal.c_str());
//							assert(0 && "a key was used multiple times - source code changes needed");
							}

							++Keys[sVal];
						}

					}
				}
			}

			m_excelDstProfiler.SetColumWidth(0,170);

			AddHeader(m_excelDstProfiler,dwX,dwBuild);
//			dwY = m_excelDstProfiler.FindLineBasedOnKey(sLevelKey,"Build");			assert(dwY==0);
//			if(dwY!=0xffffffff)m_excelDstProfiler.SetValueAt(dwX,dwY,iBuild,szStyleHeader);

			for(uint32 dwSrcLine=1;dwSrcLine<dwLines;++dwSrcLine)
			{
				dwY = m_excelDstProfiler.FindLineBasedOnKey(sLevelKey,SourceRef.m_excelSrcProfiler.GetValueAt(dwColumnName,dwSrcLine));
				if(dwY!=0xffffffff)m_excelDstProfiler.SetValueAt(dwX,dwY,GetFloat(SourceRef.m_excelSrcProfiler.GetValueAt(dwColumnSelfTime,dwSrcLine).c_str()));
			}
		}
	}
}




void CLevelStatsProcessor::ProcessFile( const char *szSourceFile )
{
	CLevelStats Source;

	if(!Source.Load(szSourceFile))
	{
		printf("ERROR: Failed to load source file\n");
		assert(0);
		return;
	}

	if(!m_Dest.IsCreated())
	{
//		if(!m_Dest.Load(m_sDestFile.c_str()))
			if(!m_Dest.CopyAndClean(Source))
			{
				printf("ERROR: input file (no excel file?)\n");
//				assert(0);
				return;
			}
	}

	// source worksheets -------------------------------------

	SSourceRef SourceRef;

	TiXmlNode *nodeSrcSummary = Source.WorksheetRef("Summary");

	if(!nodeSrcSummary)
		nodeSrcSummary = Source.WorksheetRef("Sumary");			// fallback to typo

	if(!nodeSrcSummary)
	{
		assert(0);
		return;
	}

	SourceRef.m_excelSrcSummary.SetRef(nodeSrcSummary);
	SourceRef.m_excelSrcModulesMemoryInfo.SetRef(Source.WorksheetRef("Modules Memory Info"));
	SourceRef.m_excelSrcTimeDemo.SetRef(Source.WorksheetRef("TimeDemo"));
	SourceRef.m_excelSrcProfiler.SetRef(Source.WorksheetRef("Profiler"));

	// process -------------------------------------

	ProcessLevelWorksheet(szSourceFile,SourceRef,GetDestX());
}

void CLevelStatsProcessor::IncreaseDestX()
{
	GetDestX();

	++m_dwDestX;
}

uint32 CLevelStatsProcessor::GetDestX()
{
	if(m_dwDestX!=0xffffffff)
		return m_dwDestX;

	uint32 dwStartX=1;

	if(g_bCombineLevels)
		dwStartX=2;

	m_dwDestX = max(dwStartX,m_excelDstSummary.GetWidth());		// start to write data at m_dwDestX

	return m_dwDestX;
}

void CLevelStatsProcessor::CreateDestWorksheet( CLevelStats &Dest, CExcelWorksheetRef &ref, const char *szWorksheetName )
{
	TiXmlNode *pRef = Dest.WorksheetRef(szWorksheetName);

	if(pRef)
	{
		ref.SetRef(pRef);
//		ref.ComputeExtend();
//		ref.ReadLineAssignments();
	}
	else
	{
		Dest.CreateWorksheet(szWorksheetName);
		pRef = Dest.WorksheetRef(szWorksheetName);
		ref.SetRef(pRef);
	}
}

