#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Wed Jun 27, 2007
## Description: GNU-make based build system
#############################################################################

# This file is included by the PS3 architecure files to add support for shared
# linking.  Shared linking on PS3 is _always_ based on the PRX framework.

ifeq ($(OPTION_MODULE_LINKMODE),shared)
 ARCH_CFLAGS += -mprx
 ARCHOPTION_STUBLIBS := 1

 COMPILE_MODULE_NAME_shared = $(addsuffix .compiled,$(1))
 LINK_MODULE_NAME_shared = $(addsuffix .prx,$(1))
 LINK_STUBLIB_NAME = $(patsubst %,lib%_stub.a,$(1))

 ifeq ($(MKOPTION_PS3_PRXFASTLINK),1)
  # The function 'module_to_stublib' is used internally to convert a compiled
  # module name ('%.compiled') into a matching stub-library name
  # ('lib%_stub.a').  Required for fast stub linking.
  module_to_stublib = \
  	$(dir $(1))/$(patsubst %.compiled,lib%_stub.a,$(notdir $(1)))
 endif # MKOPTION_PS3_PRXFASTLINK == 1

 COMPILE_MODULE_NAME = $(COMPILE_MODULE_NAME_shared)
 LINK_MODULE_NAME = $(LINK_MODULE_NAME_shared)

 link_prx := $(PERL) "$(MAKE_ROOT)/Tools/link_prx.pl"
 ifeq ($(MKOPTION_VERBOSE),1)
  link_prx += -v
 endif
 ifeq ($(OPTION_PS3_NOPRXEXPORTPICKUP),1)
  link_prx += -n
 endif
 ifeq ($(HOST_SYSTEM),Windows)
   link_prx += -c
   ifdef CYGWIN_BASEDIR
     link_prx += -b '$(CYGWIN_BASEDIR)'
   endif
 endif
 link_prx += -G '$(GCC_LIBDIR)' -C '$(CELL_SDK)'

 ifeq ($(MKOPTION_PS3_PRXFASTLINK),1)
  COMPILE_MODULE = \
	$(SHELL) \
	  -c "\
	  if [ ! -f '$(call module_to_stublib,$(1))' ]; then \
	    $(link_prx) -s -d '$(dir $(1))' -- $(2) \
	      && echo compiled >'$(1)'; \
	  else \
	    :; \
	  fi"
 else
  COMPILE_MODULE = \
	$(link_prx) -s -d '$(dir $(1))' -- $(2) && echo compiled >'$(1)';
 endif
 LINK_MODULE = $(link_prx) -o '$(1)' \
	-- $(2) $(PROJECT_LDFLAGS) $(PROJECT_LDLIBS)
endif

# Arch/PRX.mk
# vim:ts=8:sw=8

