#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Stage makefile for the 'scan' stage.

# This file is included only for the actual per-project make invocation
# (_exec_target_$(TARGET)).

# The 'scan' stage supports the following build operations:
# - Scanning source files into translation unit CCG file.
# - Combining translation unit CCG files into index CCG file.  (Not
#   implemented yet.)
#
# One common step is the extraction of the source file list from the VC
# project files.  The location of the VC project file (if any) is defined by
# the project makefile through the variable $(PROJECT_VCPROJ) (relative to the
# project code directory $(PROJECT_CODE)).

# Add compile stage specific build-wrapper options.
BUILDTOOL += -i $(MAKE_ROOT)/Stage/scan.ignore
ifdef BUILD_STRIP_PREFIX
 BUILDTOOL += -p $(BUILD_STRIP_PREFIX)/
endif

include $(MAKE_ROOT)/Lib/prepare.mk

ifneq ($(strip $(PROJECT_VCPROJ)),)
 $(eval $(call prepare_compile,\
	$(PROJECT_CODE)/$(PROJECT_VCPROJ),PROJECT_,Files.mk))
else
 PROJECT_SOURCE_DIRS := .
endif

include $(MAKE_ROOT)/Lib/setfiles.mk

# For the scan phase, an explicit override for the per-project file lists.
# Note that this override may be empty, indicating that no files should be
# scanned.
ifeq ($(MKOPTION_PS3_SCANALL),1)
 ifdef PROJECT_SCAN_CPP
  PROJECT_SOURCES_CPP := $(PROJECT_SCAN_CPP)
 endif
 ifdef PROJECT_SCAN_C
  PROJECT_SOURCES_C := $(PROJECT_SCAN_C)
 endif
else
 PROJECT_SOURCES_CPP := $(PROJECT_SCAN_CPP)
 PROJECT_SOURCES_C := $(PROJECT_SCAN_C)
endif

# Tag messages for the compile stage operations.
ifneq ($(MKOPTION_COMPACT),1)
 tag_c := SCAN/C
 tag_cxx := SCAN/C++
 tag_link := SCAN/INDEX
else
 tag_c :=
 tag_cxx :=
 tag_link :=
endif

.PHONY: _prepare
_prepare: $(PREPARE_DEPS)
	$(SILENT) mkdir -p "$(PROJECT_BUILD)"

# Convert a source file name into a CCG file name.
scan_object_cpp = \
  $(subst /../,/,$(PROJECT_BUILD)/scan/$(patsubst %.cpp,%.$(EXT_CCG),$(1)))
scan_tmpfiles_cpp = \
  $(subst /../,/,$(PROJECT_BUILD)/scan/$(patsubst %.cpp,%.s,$(1)))
scan_object_c = \
  $(subst /../,/,$(PROJECT_BUILD)/scan/$(patsubst %.c,%.$(EXT_CCG),$(1)))
scan_tmpfiles_c = \
  $(subst /../,/,$(PROJECT_BUILD)/scan/$(patsubst %.c,%.s,$(1)))

# Set the compile and link flags.
include $(MAKE_ROOT)/Lib/setcflags.mk
FLAGS_SUFFIX := _SCAN
include $(MAKE_ROOT)/Lib/setcflags.mk
FLAGS_SUFFIX :=

define cppfile_template
-include $(PROJECT_BUILD)/scan/$(patsubst %.cpp,%.d,$(1))
xflags_vn := PROJECT_XFLAGS_SCAN_$(subst /,_,$(subst -,_,$(subst .,_,$(1))))
object_ccg := $(call scan_object_cpp,$(1))
$$(object_ccg): xflags := $$($$(xflags_vn))
$$(object_ccg): $(1)
	$(SILENT) mkdir -p "$$(dir $$@)"
	$(BUILD_ECHO) $(tag_cxx) $($(TARGET)_CODE)/$(1)
	$(BUILD_SILENT) $(RM) $$@
	$(SILENT) if [ -n "$$(xflags)" ]; then \
	  echo "$(1) (scan): extra flags $$(xflags)"; \
	  $(_BUILD) $$(call SCAN_CXX,$(1),$$<,$$@,$$(xflags)); \
	else \
	  $(_BUILD) $$(call SCAN_CXX,$(1),$$<,$$@,$$(XFLAGS_SCAN)); \
	fi
PROJECT_OBJECTS_CCG += $$(object_ccg)
endef

define cfile_template
-include $(PROJECT_BUILD)/scan/$(patsubst %.c,%.d,$(1))
xflags_vn := PROJECT_XFLAGS_SCAN_$(subst /,_,$(subst -,_,$(subst .,_,$(1))))
object_ccg := $(call scan_object_c,$(1))
$$(object_ccg): xflags := $$($$(xflags_vn))
$$(object_ccg): $(1)
	$(SILENT) mkdir -p "$$(dir $$@)"
	$(BUILD_ECHO) $(tag_c) $($(TARGET)_CODE)/$(1)
	$(BUILD_SILENT) $(RM) $$@
	$(SILENT) if [ -n "$$(xflags)" ]; then \
	  echo "$(1) (scan): extra flags $$(xflags)"; \
	  $(_BUILD) $$(call SCAN_C,$(1),$$<,$$@,$$(xflags)); \
	else \
	  $(_BUILD) $$(call SCAN_C,$(1),$$<,$$@,$$(XFLAGS_SCAN)); \
	fi
PROJECT_OBJECTS_CCG += $$(object_ccg)
endef

SCAN_CLEAN_$(TARGET) += \
	$(foreach cppfile,\
	  $(PROJECT_SOURCES_CPP),\
	  $(call scan_object_cpp,$(cppfile)) \
	  $(call scan_tmpfiles_cpp,$(cppfile))) \
	$(foreach cfile,\
	  $(PROJECT_SOURCES_C),\
	  $(call scan_object_c,$(cfile)) \
	  $(call scan_tmpfiles_c,$(cfile)))

whole_project_scan_cpp = $(PROJECT_BUILD)/scan/WholeProject_cpp.cpp
$(whole_project_scan_cpp): $(FILES_MK)
	$(SILENT) mkdir -p $(dir $@)
	$(BUILD_SILENT) rm -f $@
ifeq ($(strip $(PROJECT_SOURCES_CPP)),)
ifeq ($(MKOPTION_VERBOSE),1)
	$(SILENT) echo 'no C++ files for project $(TARGET)'
endif
	$(SILENT) echo '/* no files */' >$@
else
ifeq ($(MKOPTION_VERBOSE),1)
	$(SILENT) echo 'generating whole project C++ scan file for $(TARGET)'
endif
	$(SILENT) echo '/* whole project $(TARGET) */' >$@
	$(SILENT) for cpp_file in $(PROJECT_SOURCES_CPP); do \
	  echo "#include \"$$cpp_file\"" >>$@; \
	done
endif

whole_project_scan_c = $(PROJECT_BUILD)/scan/WholeProject_c.c
$(whole_project_scan_c): $(FILES_MK)
	$(SILENT) mkdir -p $(dir $@)
	$(BUILD_SILENT) rm -f $@
ifeq ($(strip $(PROJECT_SOURCES_CPP)),)
ifeq ($(MKOPTION_VERBOSE),1)
	$(SILENT) echo 'no C files for project $(TARGET)'
endif
	$(SILENT) echo '/* no files */' >$@
else
ifeq ($(MKOPTION_VERBOSE),1)
	$(SILENT) echo 'generating whole project C scan file for $(TARGET)'
endif
	$(SILENT) echo '/* whole project $(TARGET) */' >$@
	$(SILENT) for c_file in $(PROJECT_SOURCES_C); do \
	  echo "#include \"$$c_file\"" >>$@; \
	done
endif

whole_project_scan_cpp_ccg = \
	$(patsubst %.cpp,%.$(EXT_CCG),$(whole_project_scan_cpp))
-include $(patsubst %.cpp,%.d,$(whole_project_scan_cpp))
$(whole_project_scan_cpp_ccg): $(whole_project_scan_cpp)
	$(BUILD_ECHO) scan whole project $(TARGET) / C++
	$(BUILD_SILENT) rm -f $@
	$(BUILD) $(call SCAN_CXX,scan whole project,$<,$@,$(XFLAGS_SCAN))

whole_project_scan_c_ccg = \
	$(patsubst %.c,%.$(EXT_CCG),$(whole_project_scan_c))
-include $(patsubst %.c,%.d,$(whole_project_scan_c))
$(whole_project_scan_c_ccg): $(whole_project_scan_c)
	$(BUILD_ECHO) scan whole project $(TARGET) / C
	$(BUILD_SILENT) rm -f $@
	$(BUILD) $(call SCAN_C,scan whole project,$<,$@,$(XFLAGS_SCAN))

SCAN_CLEAN_$(TARGET) += \
	$(whole_project_scan_cpp) \
	$(whole_project_scan_c) \
	$(whole_project_scan_cpp_ccg) \
	$(whole_project_scan_c_ccg)

PROJECT_OBJECTS_CCG :=

ifneq ($(OPTION_WHOLE_PROJECT),1)

 # Single file compilation mode.
 ifneq ($(strip $(PROJECT_SOURCES_CPP)),)
  $(foreach cppfile,\
	$(PROJECT_SOURCES_CPP),\
	$(eval $(call cppfile_template,$(cppfile))))
 endif # PROJECT_SOURCES_CPP
 ifneq ($(strip $(PROJECT_SOURCES_C)),)
  $(foreach cfile,\
	$(PROJECT_SOURCES_C),\
	$(eval $(call cfile_template,$(cfile))))
 endif # PROJECT_SOURCES_C

else # OPTION_WHOLE_PROJECT != 1

  # Whole project compilation mode.
 ifneq ($(strip $(PROJECT_SOURCES_CPP)),)
  PROJECT_OBJECTS_CCG += $(whole_project_scan_cpp_ccg)
 endif
 ifneq ($(strip $(PROJECT_SOURCES_C)),)
  ifeq ($(OPTION_WHOLE_PROJECT_C),1)
   PROJECT_OBJECTS_CCG += $(whole_project_scan_c_ccg)
  else
   $(foreach cfile,\
	$(PROJECT_SOURCES_C),\
	$(eval $(call cfile_template,$(cfile))))
  endif
 endif

endif # else OPTION_WHOLE_PROJECT != 1

ifeq ($(PROJECT_TYPE),module)
 # Modules are linked to index files.  A module _always_ compiles to a single
 # index file in the $(BUILD_ROOT)/Lib directory.  The name of the index file
 # is derived from the project name as define in the architecure specific
 # function SCANINDEX_NAME.

 PROJECT_OUTPUT := $(BUILD_ROOT)/Lib/$(call SCAN_MODULE_NAME,$(TARGET))

 SCAN_CLEAN_$(TARGET) += \
	$(addprefix $(BUILD_ROOT)/Lib/,$(call SCAN_MODULE_CLEAN,$(TARGET)))

# Module output rule.
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_CCG)
	$(SILENT) mkdir -p "$(BUILD_ROOT)/Lib"
	$(BUILD_ECHO) $(tag_link) $(call SCAN_MODULE_NAME,$(TARGET))
	$(BUILD_SILENT) $(RM) $@
	$(BUILD_LINK) $(call SCANINDEX_MODULE,$@,$^)
# End of module output rule.

endif # PROJECT_TYPE == module

ifeq ($(PROJECT_TYPE),program)

 PROJECT_DEPMODULES ?= $(PROJECT_LINKMODULES)
 PROJECT_OBJECTS_DEP := $(PROJECT_OBJECTS_CCG)
 PROJECT_OBJECTS_LINK := $(PROJECT_OBJECTS_CCG)

 PROJECT_OBJECTS_LINK += \
	$(foreach module,$(PROJECT_LINKMODULES),\
	  $(BUILD_ROOT)/Lib/$(call SCAN_MODULE_NAME,$(module)))
 PROJECT_OBJECTS_DEP += \
	$(foreach module,$(PROJECT_DEPMODULES),\
	  $(BUILD_ROOT)/Lib/$(call SCAN_MODULE_NAME,$(module)))

 PROJECT_OUTPUT := $(BUILD_ROOT)/Lib/$(call SCAN_PROGRAM_NAME,$(TARGET))

 SCAN_CLEAN_$(TARGET) += \
	$(addprefix $(BUILD_ROOT)/Lib/,$(call SCAN_PROGRAM_CLEAN,$(TARGET)))

# Program output rule.
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_DEP)
	$(SILENT) mkdir -p "$(BUILD_ROOT)/Lib"
	$(BUILD_ECHO) $(tag_link) $(call SCAN_PROGRAM_NAME,$(TARGET))
	$(BUILD_SILENT) $(RM) $@
	$(BUILD_LINK) $(call SCANINDEX_PROGRAM,$@,$(PROJECT_OBJECTS_LINK))
# End of program output rule.

endif # PROJECT_TYPE == program

.PHONY: __command_scan
__command_scan: $(PROJECT_OUTPUT)
	$(SILENT) :

.PHONY: _command_default
_command_default: __command_scan
ifdef PROJECT_POSTSCAN
	+$(PROJECT_POSTSCAN)
else
	$(SILENT) :
endif

.PHONY: _command_post
_command_post:
ifdef PROJECT_POSTSCAN
	+$(PROJECT_POSTSCAN)
else
	$(SILENT) :
endif

.PHONY: _command_clean
_command_clean:
	$(BUILD_SILENT) $(RM) $(SCAN_CLEAN_$(TARGET))

# Stage/compile.mk
# vim:ts=8:sw=2

