/* SCE CONFIDENTIAL
 * PLAYSTATION(R)3 Programmer Tool Runtime Library 154.001
 *                Copyright (C) 2007 Sony Computer Entertainment Inc.
 *                                               All Rights Reserved.
 */


/*
 * External PSGL header.  Contains enums, structs, and function declarations
 * relating to PSGL setup, displays, contexts, and related stuff.
 */

#ifndef _PSGL_h
#define _PSGL_h

#include <stdlib.h>
#include <PSGL/export.h>
#include <GLES/gl.h>
#include <GLES/glext.h>
#include <Cg/cg.h>
#include <Cg/cgGL.h>
#include <PSGL/report.h>

#ifdef __cplusplus
extern "C"
{
#endif

    typedef struct PSGLdevice PSGLdevice;
    typedef struct PSGLcontext PSGLcontext;

    typedef enum PSGLtvStandard
    {
        PSGL_TV_STANDARD_NONE,
        PSGL_TV_STANDARD_NTSC_M,
        PSGL_TV_STANDARD_NTSC_J,
        PSGL_TV_STANDARD_PAL_M,
        PSGL_TV_STANDARD_PAL_B,
        PSGL_TV_STANDARD_PAL_D,
        PSGL_TV_STANDARD_PAL_G,
        PSGL_TV_STANDARD_PAL_H,
        PSGL_TV_STANDARD_PAL_I,
        PSGL_TV_STANDARD_PAL_N,
        PSGL_TV_STANDARD_PAL_NC,
        PSGL_TV_STANDARD_HD480I,
        PSGL_TV_STANDARD_HD480P,
        PSGL_TV_STANDARD_HD576I,
        PSGL_TV_STANDARD_HD576P,
        PSGL_TV_STANDARD_HD720P,
        PSGL_TV_STANDARD_HD1080I,
        PSGL_TV_STANDARD_HD1080P,
        PSGL_TV_STANDARD_1280x720_ON_VESA_1280x768 = 128,
        PSGL_TV_STANDARD_1280x720_ON_VESA_1280x1024,
        PSGL_TV_STANDARD_1920x1080_ON_VESA_1920x1200,
    } PSGLtvStandard;

    typedef enum PSGLbufferingMode
    {
        PSGL_BUFFERING_MODE_SINGLE = 1,
        PSGL_BUFFERING_MODE_DOUBLE = 2,
        PSGL_BUFFERING_MODE_TRIPLE = 3,
    } PSGLbufferingMode;

    typedef enum PSGLdeviceConnector
    {
        PSGL_DEVICE_CONNECTOR_NONE,
        PSGL_DEVICE_CONNECTOR_VGA,
        PSGL_DEVICE_CONNECTOR_DVI,
        PSGL_DEVICE_CONNECTOR_HDMI,
        PSGL_DEVICE_CONNECTOR_COMPOSITE,
        PSGL_DEVICE_CONNECTOR_SVIDEO,
        PSGL_DEVICE_CONNECTOR_COMPONENT,
    } PSGLdeviceConnector;

    typedef enum RescRatioMode
    {
        RESC_RATIO_MODE_FULLSCREEN,
        RESC_RATIO_MODE_LETTERBOX,  // default
        RESC_RATIO_MODE_PANSCAN,
    } RescRatioMode;

    typedef enum RescPalTemporalMode
    {
        RESC_PAL_TEMPORAL_MODE_50_NONE,  // default - no conversion
        RESC_PAL_TEMPORAL_MODE_60_DROP,
        RESC_PAL_TEMPORAL_MODE_60_INTERPOLATE,
        RESC_PAL_TEMPORAL_MODE_60_INTERPOLATE_30_DROP,
        RESC_PAL_TEMPORAL_MODE_60_INTERPOLATE_DROP_FLEXIBLE,
    } RescPalTemporalMode;

    typedef enum RescInterlaceMode
    {
        RESC_INTERLACE_MODE_NORMAL_BILINEAR,
        RESC_INTERLACE_MODE_INTERLACE_FILTER,
    } RescInterlaceMode;

#define PSGL_DEVICE_PARAMETERS_COLOR_FORMAT             0x0001
#define PSGL_DEVICE_PARAMETERS_DEPTH_FORMAT             0x0002
#define PSGL_DEVICE_PARAMETERS_MULTISAMPLING_MODE       0x0004
#define PSGL_DEVICE_PARAMETERS_TV_STANDARD              0x0008
#define PSGL_DEVICE_PARAMETERS_CONNECTOR                0x0010
#define PSGL_DEVICE_PARAMETERS_BUFFERING_MODE           0x0020
#define PSGL_DEVICE_PARAMETERS_WIDTH_HEIGHT             0x0040
#define PSGL_DEVICE_PARAMETERS_RESC_RENDER_WIDTH_HEIGHT 0x0080
#define PSGL_DEVICE_PARAMETERS_RESC_RATIO_MODE          0x0100
#define PSGL_DEVICE_PARAMETERS_RESC_PAL_TEMPORAL_MODE   0x0200
#define PSGL_DEVICE_PARAMETERS_RESC_INTERLACE_MODE      0x0400
#define PSGL_DEVICE_PARAMETERS_RESC_ADJUST_ASPECT_RATIO 0x0800

    typedef struct
    {
        GLuint enable;
        GLenum colorFormat;
        GLenum depthFormat;
        GLenum multisamplingMode;
        PSGLtvStandard TVStandard;
        PSGLdeviceConnector connector;
        PSGLbufferingMode bufferingMode;
        GLuint width;   // dimensions of display device (scanout buffer)
        GLuint height;

        // dimensions of render buffer. Only set explicitly if the render target buffer
        // needs to be different size than display scanout buffer (resolution scaling required).
        // These can only be set if PSGL_DEVICE_PARAMETERS_RESC_RENDER_WIDTH_HEIGHT is set in the "enable" mask,
        // otherwise, render buffer dimensions are set to device dimensions (width/height).
        GLuint renderWidth;
        GLuint renderHeight;

        RescRatioMode rescRatioMode;             // RESC aspect ratio rescaling mode: full screen, letterbox, or pan & scan
        RescPalTemporalMode rescPalTemporalMode; // RESC pal frame rate conversion mode: none, drop frame, interpolate
        RescInterlaceMode rescInterlaceMode;     // RESC interlace filter mode: normal bilinear or use the anti-flicker interlace filter

        // horizontal and vertical scaling to adjust for the difference in overscan rates for each SD/HD mode or TV
        GLfloat horizontalScale;
        GLfloat verticalScale;
    }
    PSGLdeviceParameters;

#define	PSGL_INIT_MAX_SPUS				0x0001
#define	PSGL_INIT_INITIALIZE_SPUS			0x0002
#define	PSGL_INIT_PERSISTENT_MEMORY_SIZE	0x0004
#define	PSGL_INIT_TRANSIENT_MEMORY_SIZE	0x0008
#define	PSGL_INIT_ERROR_CONSOLE			0x0010
#define	PSGL_INIT_FIFO_SIZE				0x0020
#define	PSGL_INIT_HOST_MEMORY_SIZE			0x0040
#define PSGL_INIT_USE_PMQUERIES           0x0080

    typedef struct PSGLinitOptions
    {
        GLuint			enable;	// bitfield of options to set
        GLuint 			maxSPUs;
        GLboolean		initializeSPUs;
        GLuint			persistentMemorySize;
        GLuint			transientMemorySize;
        int				errorConsole;
        GLuint			fifoSize;
        GLuint			hostMemorySize;
    }
    PSGLinitOptions;

    typedef unsigned long long int PSGLuint64;

    typedef void*( *PSGLmallocFunc )( size_t LSize );		// expected to return 16-byte aligned
    typedef void*( *PSGLmemalignFunc )( size_t align, size_t LSize );
    typedef void*( *PSGLreallocFunc )( void* LBlock, size_t LSize );
    typedef void( *PSGLfreeFunc )( void* LBlock );

    extern PSGL_EXPORT void	psglInit( PSGLinitOptions* options );
    extern PSGL_EXPORT void	psglExit();

    PSGL_EXPORT PSGLdevice*	psglCreateDeviceAuto( GLenum colorFormat, GLenum depthFormat, GLenum multisamplingMode );
    PSGL_EXPORT PSGLdevice*	psglCreateDeviceExtended( const PSGLdeviceParameters *parameters );
    PSGL_EXPORT GLfloat psglGetDeviceAspectRatio( const PSGLdevice * device );
    PSGL_EXPORT void psglGetDeviceDimensions( const PSGLdevice * device, GLuint *width, GLuint *height );
    PSGL_EXPORT void psglGetRenderBufferDimensions( const PSGLdevice * device, GLuint *width, GLuint *height );
    PSGL_EXPORT void psglDestroyDevice( PSGLdevice* device );

    PSGL_EXPORT void psglMakeCurrent( PSGLcontext* context, PSGLdevice* device );
    PSGL_EXPORT PSGLcontext* psglCreateContext();
    PSGL_EXPORT void psglDestroyContext( PSGLcontext* LContext );
    PSGL_EXPORT void psglResetCurrentContext();
    PSGL_EXPORT PSGLcontext* psglGetCurrentContext();
    PSGL_EXPORT PSGLdevice* psglGetCurrentDevice();
    PSGL_EXPORT void psglSwap( void );

    PSGL_EXPORT void psglLoadShaderLibrary( const char *filename );

    PSGL_EXPORT PSGLuint64 psglGetSystemTime();
    PSGL_EXPORT PSGLuint64 psglGetLastFlipTime();
    PSGL_EXPORT void* psglGetSPUInitData( void );
    PSGL_EXPORT void psglSetFlipHandler( void( *handler )( const GLuint head ) );

    PSGL_EXPORT GLboolean psglSetAllocatorFuncs( PSGLmallocFunc mallocFunc, PSGLmemalignFunc memalignFunc, PSGLreallocFunc reallocFunc, PSGLfreeFunc freeFunc );

    PSGL_EXPORT void psglSetBounceBufferSize( GLsizei size );
    PSGL_EXPORT GLsizei psglGetBounceBufferSize();

#ifdef __cplusplus
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif
